import requests
import random
import json
import time
from pymongo import MongoClient


def get_headers():
    user_agents = ['Mozilla/5.0 (Windows NT 6.1; rv:2.0.1) Gecko/20100101 Firefox/4.0.1',
                   'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-us) AppleWebKit/534.50 (KHTML, like Gecko) Version/5.1 Safari/534.50',
                   'Opera/9.80 (Windows NT 6.1; U; en) Presto/2.8.131 Version/11.11']
    headers = {'User-Agent': random.choice(user_agents)}
    return headers


conn = MongoClient('127.0.0.1', 27017)
db = conn.neutron_changes_db
changes_set = db.changes_set_14
changes_comments_set = db.changes_comments_set_14

query_url = 'https://review.opendev.org/changes/{change_id}/comments'

for i in range(0, 5):
    skip_num = 0 + 100 * i # change here

    num = 1
    for change_item in changes_set.find().limit(100).skip(skip_num):
        change_id = change_item['id']
        request_url = query_url.replace('{change_id}', change_id)

        res = requests.get(request_url, headers=get_headers())
        json_content = json.loads(res.content[4:])
        for key in json_content.keys():
            for comment_msg in json_content[key]:
                comment_msg['change_id'] = change_item['id']
                comment_msg['file_url'] = key
                changes_comments_set.insert_one(comment_msg)
        print('%d.%s  Over for id { %s },  request url { %s }' % (
            num, time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()), change_item['_id'], request_url))
        num += 1
        time.sleep(random.randint(0, 3))

    print("=======================" * 50)
    print("\n\n")
    time.sleep(3 * 60)
