import requests
import json
import time
from pymongo import MongoClient

conn = MongoClient('127.0.0.1', 27017)
db = conn.nova_changes_db
changes_set = db.changes_set_14

base_url = 'https://review.opendev.org/changes/?q=status:closed project:openstack/neutron ' \
           'after:2014-01-01 before:2015-01-01'
res = requests.get(base_url)
json_content = json.loads(res.content[4:])

for change_item in json_content:
    changes_set.insert_one(change_item)

item_len = len(json_content)
iter_num = 1
while '_more_changes' in json_content[item_len - 1].keys():
    print('there are more changes!!!')

    skip_num = iter_num * 500
    changes_url = base_url + '&S=' + str(skip_num)
    print(changes_url)
    res = requests.get(changes_url)
    json_content = json.loads(res.content[4:])

    num = 0
    for change_item in json_content:
        changes_set.insert_one(change_item)
        num += 1

    iter_num += 1
    item_len = len(json_content)

    print('=' * 200)
    time.sleep(2)
