From iris.algebra Require Import auth gmap excl.
From iris_monotone Require Import monotone.
From aneris.aneris_lang Require Import network resources proofmode.
From aneris.aneris_lang.lib Require Import list lock.
From aneris_examples.ccddb.spec Require Import base time events resources.

Import Network.

(** Specifications for read and write operations.  *)

Section Specification.
  Context `{!anerisG Σ, !DB_params, !DB_time, !Maximals_Computing,
            !DB_events, !DB_resources Σ}.

  (** General specifications for read & write *)

  Definition read_spec
       (rd : base_lang.val) (i: nat) (z : socket_address) : iProp Σ :=
    Eval simpl in
    □ (∀ (k : Key) (s : lhst),
        ⌜DB_addresses !! i = Some z⌝ -∗
          {{{ Seen i s }}}
          rd #k @[ip_of_address z]
          {{{ vo, RET vo;
              ∃ (s': lhst), ⌜s ⊆ s'⌝ ∗ Seen i s' ∗
                ((⌜vo = NONEV⌝ ∗ ⌜restrict_key k s' = ∅⌝) ∨
                 (∃ (v: base_lang.val) (e : ae),
                     ⌜vo = SOMEV v⌝ ∗ ⌜e.(AE_val) = v⌝ ∗
                     ⌜e ∈ Maximals (restrict_key k s')⌝ ∗
                     OwnMemSnapshot k {[erasure e]} ∗
                     ⌜e = Observe (restrict_key k s')⌝))
          }}})%I.

  Definition write_spec
      (wr : base_lang.val) (i: nat) (z : socket_address)  : iProp Σ :=
    Eval simpl in
    □ (∀ (E : coPset) (k : Key) (v : SerializableVal) (s: lhst)
         (P : iProp Σ) (Q : ae → gmem → lhst → iProp Σ),
        ⌜DB_addresses !! i = Some z⌝ -∗
        ⌜↑DB_InvName ⊆ E⌝ -∗
        □ (∀ (s1: lhst) (e: ae),
            let s' := s1 ∪ {[ e ]} in
            ⌜s ⊆ s1⌝ → ⌜e ∉ s1⌝ →
            ⌜e.(AE_key) = k⌝ → ⌜e.(AE_val) = v⌝ →
            P ={⊤, E}=∗
            ∀ (h : gmem),
             let a  := erasure e in
             let h' := h ∪ {[ a ]} in
             ⌜a ∉ h⌝ →
             ⌜a ∈ Maximals h'⌝ →
             ⌜Maximum s' = Some e⌝ →
             Seen i s'  -∗
             k ↦ₛ h
             ={E∖↑DB_InvName}=∗ k ↦ₛ h' ∗ |={E, ⊤}=> Q e h s1) -∗
        {{{ ⌜k ∈ DB_keys⌝ ∗ P ∗ Seen i s }}}
          wr #k v @[ip_of_address z]
        {{{ RET #();
              ∃ (h: gmem) (s1: lhst) (e: ae), ⌜s ⊆ s1⌝ ∗ Q e h s1 }}})%I.

  Definition init_spec (init : base_lang.val) : iProp Σ :=
    □ ∀ (A : gset socket_address) (i : nat) (z : socket_address)
        (v : base_lang.val),
        ⌜list_coh (map (λ x : socket_address, #x) DB_addresses) v⌝ →
        ⌜DB_addresses !! i = Some z⌝ →
        ⌜z ∈ A⌝ →
        {{{ fixed A ∗
             ([∗ list] i ↦ z ∈ DB_addresses, z ⤇ DB_socket_proto) ∗
            free_ports (ip_of_address z) {[port_of_address z]} ∗
            init_token i}}}
          init v #i @[ip_of_address z]
        {{{ rd wr, RET (rd, wr);
            Seen i ∅ ∗ read_spec rd i z ∗ write_spec wr i z}}}.

End Specification.

(** Modular specification for causal memory
    vector-clock based implementation. *)

Class DBG `{!DB_time, !DB_events} Σ := {
  DBG_Global_mem_excl :> inG Σ (authUR (gmapUR Key (exclR (gsetO we))));
  DBG_Global_mem_mono :> inG Σ (authUR (gmapUR Key (gsetUR we)));
  DBG_local_history_mono :> inG Σ (authUR (monotoneUR seen_relation));
  DBG_local_history_gset :> inG Σ (authUR (gsetUR ae));
  DBG_lockG :> lockG Σ;
}.

Definition DBΣ `{!DB_time, !DB_events} : gFunctors :=
  #[GFunctor (authUR (gmapUR Key (exclR (gsetO we))));
    GFunctor (authUR (gmapUR Key (gsetUR we)));
    GFunctor (authUR (monotoneUR seen_relation));
    GFunctor (authUR (gsetUR ae));
    lockΣ].

Instance subG_DBΣ `{!DB_time, !DB_events} {Σ} : subG DBΣ Σ → DBG Σ.
Proof. solve_inG. Qed.

Class DB_init_function := { init : base_lang.val }.

Section Init.
  Context `{!anerisG Σ, !DB_params, !DB_time, !Maximals_Computing,
            !DB_events, !DBG Σ, !DB_init_function}.

  Class DB_init := {
    DB_init_time :> DB_time;
    DB_init_events :> DB_events;

    DB_init_setup E :
        True ⊢ |={E}=> ∃ (DBRS : DB_resources Σ),
      GlobalInv ∗
      ([∗ list] i ↦ _ ∈ DB_addresses, init_token i) ∗
      ([∗ set] k ∈ DB_keys, OwnMemUser k ∅) ∗
      init_spec init;
  }.

End Init.
