From RecordUpdate Require Import RecordSet.
From aneris.aneris_lang Require Import network resources.
From aneris.aneris_lang.lib.serialization Require Import serialization.

Import Network.

Definition Key := string.

(** Arguments that user supplies to the interface *)

Class DB_params := {
  DB_addresses : list socket_address;
  DB_addresses_NoDup : NoDup DB_addresses;
  DB_keys : gset Key;
  DB_InvName : namespace;
  DB_serialization : serialization;
}.

Notation DB_Serializable v := (Serializable DB_serialization v).

Record SerializableVal `{!DB_params} :=
  SerVal {SV_val : base_lang.val;
          SV_ser : DB_Serializable SV_val }.

Coercion SV_val : SerializableVal >-> base_lang.val.

Existing Instance SV_ser.

Arguments SerVal {_} _ {_}.
