(** Realisation of the DB_resources interface *)
From iris.algebra Require Import agree auth excl gmap.
From iris_monotone Require Import monotone.
From iris.base_logic Require Import invariants.
From aneris.aneris_lang Require Import lang network notation tactics proofmode lifting.
From aneris.aneris_lang.lib Require Import dictionary vector_clock lock.
From aneris_examples.ccddb.spec Require Import base.
From aneris_examples.ccddb.model Require Import model_lst model_spec.
From aneris_examples.ccddb.resources Require Import
     base resources_gmem resources_lhst.

Import Network.

Section Local_invariant.
  Context `{anerisG Σ, !DB_params, !internal_DBG Σ}.
  Context (γGauth γGsnap γGkeep : gname) (γLs : list (gname * gname)).

  Definition InQueue_of_write_events ip Q lq vq : iProp Σ :=
    Q ↦[ip] vq ∗
    ⌜list_coh (map write_event_to_val lq) vq⌝ ∗
    ([∗ list] a ∈ lq, own_mem_snapshot γGsnap a.(we_key) {[a]}).

  Definition OutQueue_of_write_events i ip Q lq vq : iProp Σ :=
    Q ↦[ip] vq ∗
    ⌜list_coh (map write_event_to_val lq) vq⌝ ∗
    ([∗ list] a ∈ lq, ⌜DB_Serializable a.(we_val)⌝ ∗
                      ⌜a.(we_key) ∈ DB_keys⌝ ∗
                      ⌜a.(we_orig) = i⌝ ∗
                      own_mem_snapshot γGsnap a.(we_key) {[a]})%I.

  Definition local_inv_def (i : nat) (DB T IQ OQ : loc) : iProp Σ:=
    ∃ (vd vt viq voq : base_lang.val) (d : gmap Key base_lang.val)
      (t: vector_clock) (liq loq: list write_event) (s: gset apply_event)
      (ip : ip_address),
      ⌜ip_of_address <$> DB_addresses !! i = Some ip⌝ ∗
      DB ↦[ip] vd ∗ T ↦[ip] vt ∗
      InQueue_of_write_events ip IQ liq viq ∗
      OutQueue_of_write_events i ip OQ loq voq ∗
      ⌜is_dictionary_str vd d⌝ ∗ ⌜is_vc vt t⌝ ∗
      local_history_Local_inv γLs i s ∗
      ⌜DBM_Lst_valid i {| Lst_mem := d; Lst_time := t; Lst_hst := s|}⌝.

  Definition local_invariant
             (i : nat) (DB T InQueue OutQueue : loc) (lk : base_lang.val)
             (γlk : gname) (z : socket_address) : iProp Σ :=
    is_lock (nroot.@"lk") (ip_of_address z) γlk lk
            (local_inv_def i DB T InQueue OutQueue).

  Instance local_invariant_persistent i DB IQ OQ T lk γLk z :
    Persistent (local_invariant i DB T IQ OQ lk γLk z).
  Proof. apply _. Qed.

End Local_invariant.
