From iris.algebra Require Import excl.
From iris.base_logic.lib Require Import invariants.
From iris.proofmode Require Import tactics.
From aneris.aneris_lang Require Import
     lang network notation tactics proofmode.
From aneris.aneris_lang.program_logic Require Import aneris_adequacy.
From iris_string_ident Require Import ltac2_string_ident.
From aneris.aneris_lang.lib.serialization Require Import serialization.
From aneris_examples.ccddb.spec Require Import spec.
From aneris.aneris_lang.lib Require Import util.
From aneris_examples.ccddb Require Import spec_util.
From aneris_examples.ccddb.examples Require Import lib.
From aneris_examples.ccddb.examples.message_passing Require Import prog.
From aneris_examples.ccddb.examples.message_passing Require Import
     proof_resources proof_of_node0 proof_of_node1 proof_of_main.

Import Network.

Definition init_state :=
  {|
    state_heaps := {[ "system" := ∅ ]};
    state_sockets := {[ "system" := ∅ ]};
    state_ports_in_use :=
      <["0.0.0.0" := ∅ ]> $ <["0.0.0.1" := ∅ ]> $ ∅;
    state_ms := ∅;
  |}.

Definition fixed_dom : gset socket_address := {[ z0; z1 ]}.

From aneris_examples.ccddb.instantiation Require Import proof.

Theorem adequacy : aneris_adequate main "system" init_state (λ _, True).
Proof.
 set (Σ := #[anerisΣ; mpΣ; DBΣ]).
  eapply (@adequacy Σ _ ips fixed_dom); try done; last first.
  { set_solver. }
  { intros i. rewrite /ips !elem_of_union !elem_of_singleton.
    intros [|]; subst; simpl; set_solver. }
  { rewrite /ips /= !dom_insert_L dom_empty_L right_id_L //. }
  iIntros (Hdg) "".
  iPoseProof (main_spec fixed_dom) as "Hmain"; [set_solver|set_solver|].
  iMod "Hmain" as (dbr) "Hmain".
  iModIntro.
  iExists (λ _, DB_socket_proto).
  iIntros "Hfx Hproto Hips".
  iDestruct (big_sepS_delete _ _ z0 with "Hproto") as "[Hz0 Hproto]";
    first set_solver.
  iDestruct (big_sepS_delete _ _ z1 with "Hproto") as "[Hz1 _]";
    first set_solver.
  iApply ("Hmain" with "[$Hz0 $Hz1 //] Hfx Hips").
Qed.
