# WhatIsRiskMarket Analysis Script

rm(list=ls()) # Clears memory
graphics.off() # Clears graphs
if (!require("pacman")) install.packages("pacman") #Installs package for package installation
pacman::p_load("reshape","PerformanceAnalytics","xlsx","MASS","texreg","plm","zTree","reshape2","Hmisc","car","devtools")
library("devtools") #Loads necessary package
install_github("stpalan/SPTools") #Installs necessary package
library("SPTools")


##### Parameters

#~~~ Specify full path and file name of source files ~~~#
SourceFiles<-list.files("FilesForAnalysis2Assets/.",pattern="[0-9]{6}_[0-9]{4}.xls",full.names=T,recursive=F)
QSourceFiles<-list.files("FilesForAnalysis2Assets/.",pattern="[0-9]{6}_[0-9]{4}.sbj",full.names=T,recursive=F)
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#
Tables<-c("globals","returns","subjects","transactions","offers","timelog","session")
RemovePracticePeriodTables<-Tables[!Tables=="session"] # Subset of tables which have life < session
ShowPlots<-T # Should plots be shown on screen or only written to disk?
RemovePracticePeriods<-T
RemoveOutliers<-F    #Should outliers be removed?
UpdateData<-F

NumPeriods<-6
NumSubjects<-8
Distributions<-c(6,7)

source("GIMS_DataPreparation_2Assets.r")    #Creates the file if it does not

Data$subjects$RiskPerception<-Data$subjects$RiskPerception+1    #Recodes RiskPerception to run from 1 to 7 instead of from 0 to 6


############## WhatIsRiskMarket ##########################

R.WRM.Lookup<-merge(Lookup["R.PeriodID"],Data$globals[,c("R.PeriodID","Distribution","StartTime","StartTimeCDA")])[,-1] # Generates matrix containing R.PeriodID and several variables from the globals table
R.WRM.transactions<-merge(Data$transactions,R.WRM.Lookup) # Generates matrix containing transaction data with Distribution information
R.WRM.transactions<-cbind(R.WRM.transactions, R.TradeTime=R.WRM.transactions$Time-(R.WRM.transactions$StartTimeCDA-R.WRM.transactions$StartTime)) # Adds precise timing for trades
NumDistributions<-max(R.WRM.transactions[,"Distribution"])
NumSessions<-max(as.numeric(R.WRM.transactions[,"R.Session"]))
DistributionText<-c("NORMAL","NegSKEWNESS","PosSKEWNESS","BigLOSS","WIDER","FrequentLOSS","NoLOSS","KURTOSIS")
R.WRM.subjects<-merge(Data$subjects,R.WRM.Lookup) # Generates subjects table with Distribution information

SessionPeriods<-list()
for (Session in 1:NumSessions){    #Generates variable to list the periods per session that are in the data
    SessionPeriods[[Session]]<-Data$globals$Period[Data$globals$R.Session==Session]
}



# ### Calculates characteristic measures of distributions
Returns<-matrix(NA,nrow=300,ncol=NumDistributions) # Creates empty matrix for returns
for (Distribution in 1:NumDistributions) {
    if(Distribution %in% Distributions){
        Returns[,Distribution]<-RawData$returns$Return[RawData$returns$Treatment==2&RawData$returns$Distribution==Distribution&RawData$returns$Date==RawData$returns$Date[1]] # Fills it
    }
}

SummaryStats<-c("Mean","StdDev","Semivar", "PLoss", "ELoss", "Skewness","Kurtosis","MinReturn","MaxReturn")
# Defines matrix columns
DistributionCharacteristics<-matrix(rep(NA,length(c("Distribution",SummaryStats))*NumDistributions),nrow=NumDistributions) # Creates matrix
dimnames(DistributionCharacteristics)<-list(1:NumDistributions,c("Distribution",SummaryStats)) # Names columns
# Fills matrix
DistributionCharacteristics[,1]<-1:NumDistributions
DistributionCharacteristics[,2]<-apply(Returns,2,mean)
DistributionCharacteristics[,3]<-apply(Returns,2,sd)*(nrow(Returns)-1)/nrow(Returns)
DistributionCharacteristics[,4]<-apply(Returns,2,SemiVariance)
DistributionCharacteristics[,5]<-apply(Returns,2,function(x) sum(x<0)/nrow(Returns))
DistributionCharacteristics[,6]<-apply(Returns,2,function(x) sum(x[x<0]/nrow(Returns)))
DistributionCharacteristics[,7]<-apply(Returns,2,skewness)
DistributionCharacteristics[,8]<-apply(Returns,2,kurtosis)
DistributionCharacteristics[,9]<-apply(Returns,2,min)
DistributionCharacteristics[,10]<-apply(Returns,2,max)

### Prepares regression datasets

Data$subjects<-merge(Data$subjects,Data$globals[,c("R.Session","Period","Distribution")],by=c("R.Session","Period"))
Data$transactions<-merge(Data$transactions,Data$globals[,c("R.Session","Period","Distribution")],by=c("R.Session","Period"))

# Prepares matrix of market prices merged with regressor data
MeanPrices<-data.frame(R.Session=rep(1:9,each=6),Period=rep(1:6,9))
MeanPrices<-merge(MeanPrices,Data$globals[,c("R.Session","Period","Distribution")],by=c("R.Session","Period"))
MeanPrices<-cbind(MeanPrices,matrix(rep(NA,7*nrow(MeanPrices)),nrow=nrow(MeanPrices)))
dimnames(MeanPrices)<-list(1:nrow(MeanPrices),c("R.Session","Period","Distribution","AvgPrice","AvgPriceLast60","AvgRiskPerception","Volume","VolumeLast60","MedianPrice","MedianPriceLast60"))



CurrentRow<-0
for (Session in 1:NumSessions){
    for(Period in 1:6){
        #Note: Order of distributions changes in raw data, so distribution 6 is sometimes being used in periods 1-3, sometimes in 4-6.

        print(paste("---",Session,Distribution,Period))
        CurrentRow<-(1:nrow(MeanPrices))[MeanPrices$R.Session==Session&MeanPrices$Period==Period]
        MeanPrices[CurrentRow,"AvgPrice"]<-mean(Data$transactions$Price[Data$transactions$R.Session==Session&Data$transactions$Period==Period],na.rm=T)
        MeanPrices[CurrentRow,"AvgPriceLast60"]<-mean(Data$transactions$Price[Data$transactions$R.Session==Session&Data$transactions$Period==Period&Data$transactions$Time>120],na.rm=T)
        MeanPrices[CurrentRow,"AvgRiskPerception"]<-mean(Data$subjects$RiskPerception[Data$subjects$R.Session==Session&Data$subjects$Period==Period],na.rm=T)
        MeanPrices[CurrentRow,"Volume"]<-sum(Data$transactions$Volume[Data$transactions$R.Session==Session&&Data$transactions$Period==Period],na.rm=T)
        MeanPrices[CurrentRow,"VolumeLast60"]<-sum(Data$transactions$Volume[Data$transactions$R.Session==Session&Data$transactions$Period==Period&Data$transactions$Time>120],na.rm=T)
        MeanPrices[CurrentRow,"MedianPrice"]<-median(Data$transactions$Price[Data$transactions$R.Session==Session&Data$transactions$Period==Period],na.rm=T)
        MeanPrices[CurrentRow,"MedianPriceLast60"]<-median(Data$transactions$Price[Data$transactions$R.Session==Session&Data$transactions$Period==Period&Data$transactions$Time>120],na.rm=T)
    }
}
MeanPrices<-merge(MeanPrices,DistributionCharacteristics,by="Distribution") # Merges in regressor data
if(RemoveOutliers){MeanPrices<-MeanPrices[!is.na(MeanPrices$AvgPrice),]} #Removes outlier




#2Assets_R13
# Table C.6 ---------------------------------------------------------------

MeanPrices$IsNoLoss<-ifelse(MeanPrices$Distribution==7,1,0) #Adds dummy variable
MeanPrices$Period.inDistribution<-((MeanPrices$Period-1) %% 3)+1 #Adds period ID within the three periods of trading the same distribution
MeanPrices$SecondBlock<-ifelse(MeanPrices$Period<=3,0,1) #Defines variable to indicate second block of three periods

summary(MAvgPrice.1a<-lm(AvgPrice~IsNoLoss, data=MeanPrices))
summary(MAvgPrice.1b<-lm(AvgPrice~IsNoLoss+Period.inDistribution, data=MeanPrices))
summary(MAvgPrice.1c<-lm(AvgPrice~IsNoLoss+SecondBlock*Period.inDistribution, data=MeanPrices))
MAvgPrice.Models<-list(MAvgPrice.1a,MAvgPrice.1b,MAvgPrice.1c)
RegressionOutput4.LaTeX <-
    texreg(
        MAvgPrice.Models,
        file="WhatIsRiskMarket_2Assets_Regression_Reg.tex",
        stars = c(0.01, 0.05, 0.1),
        custom.model.names=paste("M",1:length(MAvgPrice.Models),sep=""),
        custom.note="%stars. Standard errors in parentheses.",
        digits=3,
        custom.coef.map=list("(Intercept)"="Intercept","IsNoLoss"="NoLOSS","Period.inDistribution"="Period in block","SecondBlock"="Second block","SecondBlock:Period.inDistribution"="Period in block $\\times$ Second block"),
        caption="Regressions of AvgPrice (per period) on a dummy variable for the NoLOSS distribution, a period id variable within the block of three periods of trading the same distribution, a dummy variable for the block being the second to be traded, and the interaction between the latter two variables.",
        label="tab:2Assets_Regression3",
        booktabs=TRUE, dcolumn=TRUE, sideways=F, longtable=FALSE, float.pos="ht!", use.packages=F
        ) #Creates LaTeX table from regression model