% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.data.R
\name{example.data}
\alias{example.data}
\title{Generate example TDM input data}
\usage{
example.data(type = "timestamp")
}
\arguments{
\item{type}{Character string, indicating whether the example data should be
displayed with a timestamp (default = \code{“timestamp”})
or separate year, day of day (\code{“doy”}).}
}
\value{
A \code{data.frame} containing TDM measurements according to a specific type.
}
\description{
This function returns a \code{data.frame} containing standard TDM (thermal dissipation method)
 measurements provided in two different formats. The data is obtained from \code{tdm.data}
 where \eqn{\Delta V} measurements are given for Norway spruce (\emph{Picea abies} Karts.)
 growing in a valley in the Swiss Alps. See \code{\link{tdm.data}} for additional details.
}
\details{
This dataset can be applied for testing the functions provided in \code{TREX}.
}
\examples{

# get example data
input_data <- example.data(type = "timestamp")
input_data <- example.data(type = "doy")
head(input_data)

}
