% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.steps.R
\name{dt.steps}
\alias{dt.steps}
\title{Determine temporal resolution}
\usage{
dt.steps(input, start,
       end, time.int = 10, max.gap = 60,
       decimals = 10, df = FALSE)
}
\arguments{
\item{input}{An \code{\link{is.trex}}-compliant (output) object}

\item{start}{Character string providing the start time for the series.
Format has to be provided in "UTC" (e.g., "2012-05-28 00:00" or
Year-Month-Day Hour:Minute). Starting time should not be earlier
than the start of the series.}

\item{end}{Character string providing the start time for the series.
Format has to be provided in "UTC" (e.g., "2012-06-28 00:50" or
Year-Month-Day Hour:Minute). End time should be earlier than
the end time and not later than that of the series.}

\item{time.int}{Numeric value providing the number of minutes for the
minimum time step. When \code{time.int} is smaller than the minimum time step
of the series, a linear interpolation is applied. If \code{time.int} is
larger than the minimum time step of the series values are averaged to the chosen
value of \code{time.int} (after performing a linear interpolation
 to obtain a one-minute resolution).}

\item{max.gap}{Numeric value providing the maximum size of a gap in minutes,
which can be filled by performing a linear interpolation.}

\item{decimals}{Integer value defining the number of decimals of the output
(default = 10).}

\item{df}{Logical; if \code{TRUE}, output is provided in a \code{data.frame}
format with a timestamp and a value (\eqn{\Delta T} or \eqn{\Delta V}) column.
If \code{FALSE}, output is provided as a \code{zoo} object (default = FALSE).}
}
\value{
A \code{zoo} object or \code{data.frame} in the appropriate
format for further processing.
}
\description{
Performs minimum time step standardization,
gap filling and start/end time selection. This function
provides the option to select the minimum temporal step size of an
\code{\link{is.trex}} object. Additionally, the user can define the
start and end time of the series and select the minimum size under
which gaps should be filled, using linear interpolation.

Time series have different temporal resolutions.
This function provides the option to standardize the minimum time step by
either performing a linear interpolation when the requested time step
is smaller than the minimum time step of the series or average values when
the requested time step is larger than the minimum time step of the series.
Before this process, the entire time series is converted to a one-minute time
step by applying a linear interpolation (excluding gap \eqn{periods > \code{max.gap}}).
}
\examples{
input <- is.trex(example.data(type="doy"),
           tz="GMT",time.format="\%H:\%M", solar.time=TRUE,
           long.deg=7.7459,ref.add=FALSE)
in.ts <- dt.steps(input=input,start='2012-06-28 00:00',end='2012-07-28 00:00',
                   time.int=60,max.gap=120,decimals=6,df=FALSE)
plot(in.ts)
head(in.ts)

}
