% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg.data.R
\name{agg.data}
\alias{agg.data}
\title{Aggregation of time-series data}
\usage{
agg.data(input,
 time.agg = 60*24,
 start = "2012-07-28 00:00",
 end = "2012-10-29 00:00",
 FUN = "mean",
 unit = 60,
 na.rm = TRUE,
 df = FALSE)
}
\arguments{
\item{input}{An \code{\link{is.trex}}-compliant time series from \code{tdm_cal.sfd} outputs
(e.g., \code{X$sfd.mw$sfd}).}

\item{time.agg}{Numeric, the aggregation time in minutes (default = 60).}

\item{start}{Character string, the start time for the series. Format has
to be provided in "UTC" (e.g. "2012-05-28 00:00" or Year-Month-Day Hour:Minute).
Starting time should not be earlier than the start of the series.
If not provided the entire series is considered.}

\item{end}{character string, the end time for the series.
Format has to be provided in "UTC" (e.g. "2012-06-28 00:50" or Year-Month-Day Hour:Minute).
Starting time should be earlier than the end time and the end time should not exceed the
length of the series.  If not provided the entire series is considered.}

\item{FUN}{Quoted function name to compute the summary statistics which can be
applied to all data subsets (see aggregate; including "sum", "mean",
 "median", "sd", "se", "min", "max").}

\item{unit}{Numeric, the minutes in which a velocity unity is provided
(e.g., \eqn{cm^3 cm^{-2} h^{-1} = 60}{cm3 cm-2 h-1 = 60}) for summation (\code{FUN = “sum”}; default = 60).}

\item{na.rm}{Logical; if \code{TRUE} missing values are removed (default = \code{TRUE}).}

\item{df}{Logical; if \code{TRUE}, output is provided in a \code{data.frame} format
with a timestamp and a value column. If \code{FALSE}, output
is provided as a zoo vector object (default = \code{FALSE}).}
}
\value{
A zoo object or data.frame in the appropriate format for other functionalities.
}
\description{
Aggregation of time-series data and start/end time selection.
This function provides the option to select the temporal step size
for aggregation of a single time series origination from an \code{\link{is.trex}}-compliant object.
Additionally, the user can define the start and end time of the series and select
the function used for aggregation.
}
\details{
Time series are often derived at variable resolutions.
 This function provides the option to aggregate (homogenize) time steps with
 standard \code{FUN} statistics. When applying this function to calculate
 summed sap flow values (e.g., \eqn{cm^3 cm^{-2} d^{-1}}{cm3 cm-2 d-1}) one needs
 to include the velocity unit, as the summation is dependent upon the minimum timestep
 of the time series (e.g., \eqn{cm^3 cm^{-2} h^{-1}}{cm3 cm-2 h-1}, \code{unit = 60}).
}
\examples{
\dontrun{
#aggregate SFD values to mean hourly and daily sums

raw   <- example.data(type="doy")

input <- is.trex(raw,tz="GMT",time.format="\%H:\%M",
                  solar.time=TRUE,long.deg=7.7459,ref.add=FALSE,df=FALSE)

input[which(input<0.4)]<-NA

k.input<-tdm_dt.max(dt.steps(input,time.int=15,
               max.gap=180,decimals=10),methods=c("mw"))

sfd.input<-tdm_cal.sfd(k.input,make.plot=FALSE,
                  df=FALSE,wood="Coniferous")$sfd.mw$sfd

# means
output.1hmean <- agg.data(sfd.input,
                       time.agg=60,
                       start="2012-07-28 00:00",
                       end="2012-08-29 00:00",
                       FUN="mean",
                       na.rm=TRUE,
                       df=FALSE)
output.6hmean <- agg.data(sfd.input,
                         time.agg=60*6,
                         start="2012-07-28 00:00",
                         end="2012-08-29 00:00",
                         FUN="mean",
                         na.rm=TRUE,
                         df=FALSE)
plot(output.1hmean,col="cyan")
lines(output.6hmean,col="black")

# daily sums
output.dsum<-agg.data(sfd.input,
                      time.agg=60*24,
                      start="2012-07-28 00:00",
                      end="2012-10-29 00:00",
                      FUN="sum",
                      unit=60,
                      na.rm=TRUE,
                      df=FALSE)
plot(output.dsum)
points(output.dsum,pch=16)
}
}
