! Copyright 2019
!
! For a comprehensive list of the developers that contributed to these codes
! see the UK-AMOR website.
!
! This file is part of UKRmol-in (UKRmol+ suite).
!
!     UKRmol-in is free software: you can redistribute it and/or modify
!     it under the terms of the GNU General Public License as published by
!     the Free Software Foundation, either version 3 of the License, or
!     (at your option) any later version.
!
!     UKRmol-in is distributed in the hope that it will be useful,
!     but WITHOUT ANY WARRANTY; without even the implied warranty of
!     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!     GNU General Public License for more details.
!
!     You should have received a copy of the GNU General Public License
!     along with  UKRmol-in (in source/COPYING). Alternatively, you can also visit
!     <https://www.gnu.org/licenses/>.
      MODULE CONGEN_DATA
C
C Module containing parameters / data required throughout the
C congen program.
C
C Joanne Carr, August 2010
C
      USE precisn, ONLY : wp ! for specifying the kind of reals
      USE consts, ONLY : xhalf

      SAVE

      INTEGER, PARAMETER :: LG=75 ! ??? used to dimension arrays below; also in CPLE[A,M].

      INTEGER, PARAMETER :: NU=20

      INTEGER, PARAMETER :: NY=150 ! used to dimension refgu and reforb in csfgen.  Limit on input variable NREFO

      INTEGER, PARAMETER :: NZ=150 ! used to dimension REFDET in csfgen; maximum number of electrons

      INTEGER, PARAMETER :: JX=75 ! used to dimension many arrays in csfgen; limit on the sum of elements in the NSHLP array

      INTEGER, PARAMETER :: JY=10 ! used to dimension various arrays in csfgen including NELECP and NSHLP.
                                  ! limit on input variable NDPROD

      INTEGER, PARAMETER :: JZ=10 ! maximum number of constraints upon CSFs accepted (limit on input variable NTCON)

      INTEGER, PARAMETER :: KX=3000 ! limit on number of spin orbitals?  Used below to dimension exref and exdet

      INTEGER, PARAMETER :: KY=75 ! used to dimension refgug and reforg in csfgen.  Limit on input variable NREFOG?

      INTEGER, PARAMETER :: KZ=500 ! used to dimension REFDTG in csfgen; limit on input variable NELECG?

      INTEGER, PARAMETER :: MXDIFF=10 ! used only in function MPHASE to dimension a couple of local arrays.

      INTEGER, PARAMETER :: MXTARG=50 ! maximum number of target state symmetries

      REAL(KIND=wp), PARAMETER :: ROOT2=0.7071067811865475_wp ! note this is actually 1 / root 2 !!!

      REAL(KIND=wp), PARAMETER :: THRESH1=1.E-10_wp ! threshold used in CGCOEF

      REAL(KIND=wp), PARAMETER :: THRESH2=1.0E-30_wp ! threshold used in WFGNTR

      INTEGER, PARAMETER :: NFTR=5 ! unit number for reading standard input

      INTEGER :: NFTW=6 ! unit number for printing; may be changed via the STATE namelist so not a parameter...

C Headers and stuff from the PRINT* routines
      CHARACTER(LEN=4), DIMENSION(3), PARAMETER :: BLNK43=(/
     & '    ','    ','    '/)
      CHARACTER(LEN=8), DIMENSION(7), PARAMETER :: HEADER=(/'SHELL NO',
     & 'OCCSHL  ', 'SYM     ', 'GUSHL   ', 'PQN     ', 'QNSHL   ', 
     & 'CUP     '/)
      CHARACTER(LEN=3), PARAMETER :: LP=' ( '
      CHARACTER(LEN=1), PARAMETER :: STAR='*'

C From STWRIT/WVWRIT
      CHARACTER(LEN=4), DIMENSION(7), PARAMETER :: RHEAD=(/
     & '    ', 'MSHL', 'PQN ', 'NES ', 'SO1 ', 'SO2 ', 'G/U ' /)
 
C New variable for the number of interesting things printed per line in the PRINT* routines
      INTEGER, PARAMETER :: NITEM=9 

C Former common block variables

      CHARACTER(LEN=1), DIMENSION(132) :: HEAD
      INTEGER :: LPPMAX, LPPR, NPAGE
C      COMMON /PGCTL / LPPR, LPPMAX, NPAGE
C      COMMON /PGCTM / HEAD

      INTEGER :: LRATIO
C      COMMON /MCDEP / ICOMPL, LREAL, LINTEG, LRATIO

      INTEGER :: NDMXX
C      COMMON /STP   / NDMXX

      INTEGER :: ICDI, IEXCON, INDI, INODI, IQNSTR,
     &           IRFCON, NDEL, NDEL1, NDEL2
C      COMMON /B0    / IRFCON, IEXCON, IQNSTR, ICDI, INDI, INODI, NDEL,
C     &                NDEL1, NDEL2

      INTEGER :: GUTOT, NISZ, NNDEL, NNLECG, SYMTYP
      INTEGER, DIMENSION(3,LG) :: CUP, PQNST
      INTEGER, DIMENSION(LG) :: GUSHL, MSHL, OCCSHL, QNSHLR, SPNMIN,
     &                          SSHLST
      INTEGER, DIMENSION(2,LG) :: KSLIM, MCLIM
      INTEGER, DIMENSION(3,2*LG) :: QNSHL
      INTEGER, DIMENSION(3) :: QNTAR, QNTOT
      INTEGER, DIMENSION(NU) :: SHLMX1
C      COMMON /B1    / OCCSHL, PQNST, MSHL, GUSHL, CUP, SSHLST, QNSHL,
C     &                SPNMIN, KSLIM, MCLIM, QNSHLR, SHLMX1, QNTOT,
C     &                QNTAR, GUTOT, NNDEL, NNLECG, NISZ, SYMTYP

      INTEGER, PARAMETER :: JSMAX=20 ! JMC instead of setting this to 20 in CSFGEN
      REAL(KIND=wp), DIMENSION((JSMAX*JSMAX + 3*JSMAX + 4)/2) :: BINOM ! JMC re-dimensioning from 500
      INTEGER, DIMENSION(JSMAX+2) :: IND ! JMC redimensioning from 25
C     DIMENSION BINOM((JSMAX*JSMAX+3*JSMAX+4)/2),IND(JSMAX+2)
C      COMMON /B2    / BINOM, IND, JSMAX

      INTEGER :: IFT, NOBT, NSYM, NTCON
      INTEGER, DIMENSION(NU) :: NOBI, NSHSYM
      INTEGER, DIMENSION(JZ) :: NRCON, TEST
      INTEGER, DIMENSION(NU,LG) :: NST
C      COMMON /B4    / NTCON, TEST, NRCON, NOBT, NST, NSYM, NSHSYM, NOBI, 
C     &                JCON, IFT

      INTEGER :: CONFPF, NCSF, NDIST, NE, NSHL, NSTATE, NTYP
C      COMMON /B5    / NTYP, NDIST, NSTATE, NCSF, CONFPF, NSHL, NE

      INTEGER :: CDIMX, MEGUL, NCALL, NDIMX, NNCSF, NODIMX, NTSO
      INTEGER, DIMENSION(KX) :: EXDET, EXREF
      INTEGER, DIMENSION(LG) :: NONEW, NOREP
      INTEGER, DIMENSION(NU) :: NSOI
C      COMMON /B6    / EXDET, EXREF, NOREP, NONEW, NTSO, NODIMX, CDIMX,
C     &                NDIMX, MEGUL, NSOI, NNCSF, NCALL

      INTEGER :: IIDIS2, LCDI, LCDT, NI, NID, NOI
C      COMMON /B8    / NOI, NI, NID, IIDIS2, LCDI, LCDT

      INTEGER :: NEXT, NX
C      COMMON /B9    / NEXT, NX

      INTEGER :: IDCP, IDOP, IELTP
C      COMMON /OWF   / IDOP, IDCP, IELTP

      END MODULE CONGEN_DATA

!*==addl.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE ADDL(LINES)
      USE global_utils, ONLY : GETIN
      USE CONGEN_DATA, ONLY : HEAD, LPPR, LPPMAX, NPAGE, NFTW
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: LINES
      INTENT (IN) LINES
C
C*** End of declarations rewritten by SPAG
C
      LPPR=LPPR+LINES
      IF(LPPR.LE.LPPMAX)RETURN
      LPPR=LINES
      NPAGE=MOD(NPAGE+1,1000)
      CALL GETIN(NPAGE,3,HEAD(SIZE(HEAD)-2),1) ! JMC this is putting the max. 3-digit number npage into the last 3 elements of HEAD 
      WRITE(NFTW, 105) HEAD
 105  FORMAT('1',132A1/)
      RETURN
      END SUBROUTINE ADDL
!*==assign.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE ASSIGN(NSHL,NDIST,NUSED,REFCON,EXCON,QNSTOR,NX,NFTW)
C
C     ASSIGN QUANTUM NUMBERS TO REAL SHELLS
C
C     PQN(1,NSHL)   0 FOR PSEUDOSHELL
C                   SEQUENCE NUMBER FOR REAL SHELL
C     PQN(2,NSHL)   STARTING INDEX FOR PSEUDOSHELL
C     PQN(3,NSHL)   ENDING   INDEX FOR PSEUDOSHELL
C     OCCSHL(NSHL)  OCCUPATION
C     QNSTOR(NUSED) FINALLY ASSIGNED QUANTUM NUMBERS
C     SSHL(NSHL) SYM-VALUES
C     NST(M,N)      POINTER TO SHELL INDEX AND ORDER COUNT
C     NSHSYM(NSYM)  COUNTER FOR NUMBER OF SHELLS IN S SYMMETRY
C     NX            DIMENSION OF X OVERLAYED WITH QNSTOR
C     QNSHLR(NSHL)  WORK AREA STORES INDEX OF SHELLS
C     NSHL          NUMBER OF SHELLS
C     NDIST         NUMBER OF DISTRIBUTIONS GENERATED FROM A GIVEN
C                   SET OF SHELLS
C     NUSED         NUMBER OF SLOTS USED FOR FINALLY ASSIGNED SHELLS
C
      USE CONGEN_DATA, ONLY : NTCON, TEST, NRCON, NOBT, NST, 
     &                        NSHSYM, NOBI, IFT, OCCSHL, PQN=>PQNST,
     &                        SSHL=>SSHLST, QNSHLR
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NDIST, NFTW, NSHL, NUSED, NX
      INTEGER, DIMENSION(NOBT) :: EXCON
      INTEGER, DIMENSION(*) :: QNSTOR
      INTEGER, DIMENSION(NOBT,MAX(NTCON,1)) :: REFCON ! JMC changing the 2nd dimension from 2
      INTENT (IN) NFTW, NSHL, NX, REFCON
      INTENT (OUT) NUSED, QNSTOR
      INTENT (INOUT) EXCON, NDIST
C
C Local variables
C
      INTEGER, SAVE :: ALLOW, I, IC, IT, ITA, ITEST, J, KS, KSS, MRUN, 
     &                 MT, NAV, NAVM1, NDROP, NREP, NSHRUN, NT
C
C*** End of declarations rewritten by SPAG
C
      IF(IFT.NE.0)THEN
         NAV=NX
         NAVM1=NAV-1
         IFT=0
      END IF
C
C     INITIALIZE NST AND INDICIES AND NSHSYM (TO ZEROS)
C
      NSHRUN=0
      MRUN=0
 20   ITA=0
      MRUN=MRUN+1
      DO I=1, NSHL
         IF(MRUN.NE.SSHL(I))CYCLE
         ITA=ITA+1
         NST(MRUN,ITA)=I
      END DO
      NSHRUN=NSHRUN+ITA
      IF(NSHRUN.NE.NSHL)GO TO 20
      DO I=1, MRUN
         NSHSYM(I)=0
      END DO
      NDIST=0
      NDROP=0
      KS=0
C
C     DESCEND INTO ASSIGNMENT LOOP
C
 100  KS=KS+1
      QNSHLR(KS)=PQN(2,KS)
      IT=NSHSYM(SSHL(KS))
      MT=SSHL(KS)
      IT=NSHSYM(MT)
      NSHSYM(MT)=IT+1
C
 120  DO I=1, IT
         KSS=NST(MT,I)
         IF(QNSHLR(KSS).EQ.QNSHLR(KS))GO TO 200
         IF(OCCSHL(KSS).NE.OCCSHL(KS))CYCLE
         IF(QNSHLR(KSS).LT.QNSHLR(KS))CYCLE
         IF(QNSHLR(KS).GE.PQN(2,KSS) .AND. QNSHLR(KSS).LE.PQN(3,KS))
     &      GO TO 200
      END DO
      IF(KS.LT.NSHL)GO TO 100
      IF(NTCON.EQ.0)GO TO 1600
      DO I=1, NOBT
         EXCON(I)=0
      END DO
      DO I=1, NSHL
         J=NOBI(SSHL(I))+QNSHLR(I)
         EXCON(J)=OCCSHL(I)
      END DO
      ALLOW=0
      ITEST=0
      DO IC=1, NTCON
         NREP=0
         DO I=1, NOBT
            NT=EXCON(I)-REFCON(I,IC)
            NREP=ABS(NT)+NREP
         END DO
         IF(TEST(IC).EQ.1)GO TO 164
         IF(NREP.LE.NRCON(IC)+NRCON(IC))GO TO 200
         GO TO 168
 164     IF(NREP.LE.NRCON(IC)+NRCON(IC))ALLOW=1
 168     ITEST=ITEST+TEST(IC)
      END DO
      IF(ALLOW.EQ.0 .AND. ITEST.NE.0)GO TO 200
 1600 IF(NDROP+NSHL.GE.NAVM1)GO TO 1000
C
C     ALLOWED ASSIGNMENT IS TO BE STORED
C
      IF(NDROP+NSHL.GE.NAVM1)GO TO 1000
      NDIST=NDIST+1
      DO I=1, NSHL
         NDROP=NDROP+1
         QNSTOR(NDROP)=QNSHLR(I)
      END DO
C
C     ASCEND IN ASSIGNMENT LOOPS
C
 200  MT=SSHL(KS)
      IT=NSHSYM(MT)-1
      QNSHLR(KS)=QNSHLR(KS)+1
      IF(QNSHLR(KS).LE.PQN(3,KS))GO TO 120
      NSHSYM(MT)=IT
      KS=KS-1
      IF(KS.GE.1)GO TO 200
      NUSED=NDROP
      RETURN
C
C     STORAGE OVERFLOW ERROR
C
 1000 WRITE(NFTW,1010)NX
 1010 FORMAT('1',31('*')/' ',31('*'),'STORAGE OVERFLOW IN ASSIGN:',I8,
     &       ' WORDS AVAILABLE')
      STOP 70
      END SUBROUTINE ASSIGN
!*==cgcoef.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE CGCOEF(J1,J2,J3,M3,N,MS,C,INTPFG)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE consts, ONLY : xzero, xone
      USE CONGEN_DATA, ONLY : BINOM, IND, NFTW, THRESH1
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: INTPFG, J1, J2, J3, M3, N
      REAL(KIND=wp), DIMENSION(*) :: C
      INTEGER, DIMENSION(2,*) :: MS
      INTENT (IN) INTPFG, J1, J2, J3, M3
      INTENT (INOUT) C, MS, N
C
C Local variables
C
      REAL(KIND=wp) :: A, B, T
      INTEGER :: I, I1, I2, II, JJ, JS, LB, LB1, LB2, LBH, LBL, M, M1, 
     &           M2
      INTEGER, DIMENSION(3) :: J, K, L
C
C*** End of declarations rewritten by SPAG
C
      JS=(J1+J2+J3-1)/2
      J(1)=J1
      J(2)=J2
      J(3)=J3
      K(1)=JS-J2
      K(2)=JS-J3
      K(3)=JS-J1
      N=0
      M=M3
      IF(J3-1.LT.ABS(M-1))RETURN
      DO I=1, 3
         IF(K(I).LT.0)RETURN
      END DO
      A=XONE/(BINOM(IND(JS+1)+K(2))*BINOM(IND(J3)+K(1)))
      L(3)=(J3+M3-2)/2
      M1=J1
      DO JJ=1, J1
         M2=M3-M1+1
         IF(ABS(M2-1).GT.J2-1)GO TO 100
         N=N+1
         MS(1,N)=M1
         MS(2,N)=M2
         L(1)=(J1-M1)/2
         L(2)=(J2+M2-2)/2
         B=A
         DO II=1, 3
            B=BINOM(IND(J(II))+K(II))/BINOM(IND(J(II))+L(II))*B
         END DO
         B=SQRT(B)
         I1=MAX(L(1)-K(1),L(2)-K(3),0)
         I2=MIN(L(1),L(2),K(2))
         T=XZERO
         IF(I2.LT.I1)GO TO 201
         LBL=IND(K(2)+1)+I1
         LBH=IND(K(2)+1)+I2
         LB1=IND(K(1)+1)+L(1)-I1
         LB2=IND(K(3)+1)+L(2)-I1
         DO LB=LBL, LBH
            T=BINOM(LB)*BINOM(LB1)*BINOM(LB2)-T
            LB1=LB1-1
            LB2=LB2-1
         END DO
 201     C(N)=B*T*(-XONE)**I2
         IF(ABS(C(N)).LE.THRESH1)N=N-1
 100     M1=M1-2
      END DO
      IF(INTPFG.EQ.0)RETURN
      WRITE(NFTW, 1010) J1, J2, J3, M3
 1010 FORMAT(' CGCOEF : CLEBSCH-GORDAN COEFFICIENTS FOR',/,' J1 =',I4,
     &       ' J2 =',I4,' J3 =',I4,' M3 =',I4,/)
      WRITE(NFTW, 1) (C(I),MS(1,I),MS(2,I),I=1,N)
 1    FORMAT(/(E25.15,2I5))
      RETURN
      END SUBROUTINE CGCOEF
!*==cntrct.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE CNTRCT(NELT,NO,NDO,CDO,THRES)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NELT, NO
      REAL(KIND=wp) :: THRES
      REAL(KIND=wp), DIMENSION(*) :: CDO
      INTEGER, DIMENSION(*) :: NDO
      INTENT (IN) NELT, THRES
      INTENT (INOUT) CDO, NDO, NO
C
C Local variables
C
      INTEGER :: I, J, MD, MDD, MOV
C
C*** End of declarations rewritten by SPAG
C
      MOV=0
      MD=0
      DO I=1, NO
         IF(ABS(CDO(I)).GT.THRES)GO TO 10
         MOV=MOV+1
         GO TO 30
 10      IF(MOV.EQ.0)GO TO 30
         CDO(I-MOV)=CDO(I)
         MDD=MD-NELT*MOV
         DO J=1, NELT
            NDO(MDD+J)=NDO(MD+J)
         END DO
C
 30      MD=MD+NELT
      END DO
      NO=NO-MOV
      RETURN
      END SUBROUTINE CNTRCT
!*==comprd.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE comprd(mdiff,mark,mn)
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: MARK
      INTEGER, DIMENSION(mark) :: MDIFF
      INTEGER, DIMENSION(*) :: MN
      INTENT (IN) MN
      INTENT (INOUT) MARK, MDIFF
C
C Local variables
C
      INTEGER :: I, II, J
C
C*** End of declarations rewritten by SPAG
C
c     orders list of spin orbital diffrences and removes entries
c     where two spin orbitals belong to the same orbital
c
      DO i=1, mark
         ii=mdiff(i)
         DO j=i+1, mark
            IF(mdiff(j).LT.ii)THEN
               mdiff(i)=mdiff(j)
               mdiff(j)=ii
               ii=mdiff(i)
            END IF
         END DO
      END DO
      ii=1
 20   CONTINUE
      IF(mn(mdiff(ii)).EQ.mn(mdiff(ii+1)))THEN
         mark=mark-2
         DO j=ii, mark
            mdiff(j)=mdiff(j+2)
         END DO
         ii=ii-1
      END IF
      ii=ii+1
      IF(ii.LT.mark)GO TO 20
      RETURN
      END SUBROUTINE COMPRD
!*==cplea.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE CPLEA(NNCSF,NADEL,X,NFTW)
C
C     THIS ROUTINE LOOPS THROUGH AND FILLS ALL ALLOWED COUPLINGS
C         FOR A GIVEN ELECTRON DISTRIBUTION INTO SHELLS
C     CUPSET IS THE ENTRY TO SET LOCATIONS OF ARRAYS
C         MSHL(NSHL)     SYMMETRY NUMBER FROM ZERO TO N-1 (MVALUE)
C         QNSHL(3,2*NSHL-1)
C                        1 -- MULT / 2 -- SYMMETRY / 3 -- +- (NOT USED)
C         CUP(3,NSHL-1)
C         QNTOT(3)       TOTAL QN'S
C         SPNMIN(NSHL-1) TEMP STORAGE FOR LOWEST SPIN COUPLING
C         X(NX)          WORK AREA (R*8)
C         NSHL           NUMBER OF TRUE SHELLS OCCUPIED
C         NSTATE         NUMBER OF COUPLINGS (COMPUTED)
C         NTYPE          PROTO-TYPE NUMBER (INPUT)
C         NDIST          NUMBER OF PQN ASSIGNMENTS
C         NCSF           RUNNING CSF NUMBER
C         SYMTYP         GE 2 FOR MOLECULE
C         CONPF          PRINT FLAG
C
C         GUSHELL(NSHL)  GU VALUE FOR EACH SHELL
C         SHLMX(NSHL)    MAX OCCUPATION FOR A SHELL
C         OCCSHL(NSHL)   COMPRESSED SHELL OCC'S / ALL ZEROS DELETED
C                        AND PSEUDO SHELLS EXPANDED
C         QNSHL(3,NSHL)  FIRST INDEX = 1 MULTIPLICITY FOR EACH COUPLING
C                        FIRST INDEX = 2 M-VALUE FOR EACH COUPLING
C                        FIRST INDEX = 3 +1 FOR (S+) -1 FOR (S-)
C                                        OTHERWIZE ZERO
C         CUP(3,NSHL)    COUPLING SCEME IN ORDER STATE A TO STATE B
C                        GIVES STATE C
C         QNTOT(3)       INPUT STATE TO BE SEARCHED FOR. ORDER: MULTI-
C                        PLICITY,ANG.MOM., PLUS(+1) OR MINUS(-1)
C         GUTOT          G(+1) OR U(-1) FOR INPUT STATE
C         KSLIM(2,NSHL)  FIRST INDEX = 1  IS NUMBER OF STATES
C                        ALREDY LOOPED OVER IN A SHELL
C                        FIRST INDEX = 2 IS THE NUMBER OF STATES FOR
C                        A SHELL
C         MCLIM(2,NSHL)  FIRST INDEX = 1 IS THE NUMBER OF STATES
C                        ALREADY LOOPED OVER IN A COUPLING
C                        FIRST INDEX = 2 IS THE MAXIMUM NUMBER OF STATES
C                        IN A COUPLING
C         QNTMP(2,3,NSHL) FIRST INDEX POINTS ON + OR
C         QNTMP(2,3,NSHL) FIRST INDEX POINTS ON +- AND M(2 AND 1 RESP.)
C                        SECOND INDEX POINTS ON POSSIBLE COUPLINGS
C                        (M+M,M-M,2*M,S+,S-) SAVE AREA DOWN THE LOOPS
C         SPNMIN(NSHL)   MIN MULTIPLICITY FOR A COUPLING
C
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE CONGEN_DATA, ONLY : LG, NEXT, NX, ICDI, IEXCON, INDI, INODI, 
     &                        IQNSTR, IRFCON, NDEL, CONFPF, NDIST, NSHL,
     &                        NSTATE, OCCSHL, MSHL, GUSHL, CUP, QNSHL,
     &                        SPNMIN, KSLIM, MCLIM, SHLMX1, QNTOT,
     &                        QNTAR, GUTOT, NNDEL
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NADEL, NFTW, NNCSF
      REAL(KIND=wp), DIMENSION(*) :: X
C
C Local variables
C
      INTEGER :: GUTRY, I, IDUMM, IIDIS1, IIDIST, IOCC, KC, KCLIM, KCS, 
     &           KCSP, KS, M, MTRY, NAV, NNEXT, NUSED, SHL1, SHL2, 
     &           SPNTRY, Z1=1
      INTEGER, DIMENSION(2,3,LG) :: QNTMP
C
C*** End of declarations rewritten by SPAG
C
C         NSTATE         NUMBER OF STATES WHICH MAY BE FORMED
C                             WITH CURRENT DISTRIBUTION INTO SHELLS
C         NDIST          NUMBER OF THE CURRENT SHELL DISTRIBUTION
C
      NSTATE=0
      IIDIS1=0
C
C     PERFORM GROSS CHECKS ON SYMMETRIES ALLOWED FOR DIST
C
      IF(GUTOT.NE.0)THEN
         GUTRY=1
         DO I=1, NSHL
            IF(GUSHL(I).GT.0)CYCLE
            IF(IAND(OCCSHL(I),Z1).NE.0)GUTRY=-GUTRY
         END DO
         IF(GUTRY.NE.GUTOT)RETURN
      END IF
      SPNTRY=1
      MTRY=0
      DO I=1, NSHL
         M=MSHL(I)+1
         IF(GUTOT.NE.0)M=M+M
         IOCC=OCCSHL(I)
         IF(IOCC.GT.SHLMX1(M)/2)IOCC=SHLMX1(M)-IOCC
         SPNTRY=SPNTRY+IOCC
         MTRY=MTRY+IOCC*MSHL(I)
      END DO
      IF(SPNTRY.LT.QNTOT(1))RETURN
      IF(MTRY-QNTOT(2).LT.0 .OR. IAND(MTRY-QNTOT(2),Z1).NE.0)RETURN
C
C     INITIALIZE THIRD SHELL COUPLING
C
      KCLIM=NSHL-1
      DO I=1, KCLIM
         QNTMP(1,3,I)=0
         QNTMP(2,3,I)=-1
      END DO
C
C     INITIALIZE SHELL QUANTUM NUMBERS AND LOOP LIMITS FOR SHELL
C         COUPLING
C
      SPNTRY=1
      MTRY=0
      DO I=1, NSHL
         M=MSHL(I)+1
         IF(GUTOT.NE.0)M=M+M
         QNSHL(1,I)=1
         QNSHL(2,I)=0
         QNSHL(3,I)=1
         KSLIM(2,I)=1
         IF(OCCSHL(I).EQ.0 .OR. OCCSHL(I).EQ.SHLMX1(M))CYCLE
         SPNTRY=SPNTRY+1
         MTRY=MTRY+MSHL(I)
         QNSHL(1,I)=2
         QNSHL(2,I)=MSHL(I)
         QNSHL(3,I)=0
         IF(MSHL(I).EQ.0)QNSHL(3,I)=1
         IF(OCCSHL(I).NE.2)CYCLE
         KSLIM(2,I)=3
         SPNTRY=SPNTRY-1
         MTRY=MTRY-MSHL(I)
      END DO
C
C     BEGIN TO DECEND INTO LOOPS
C
      KS=1
 100  KSLIM(1,KS)=1
      IF(KSLIM(2,KS).EQ.1)GO TO 120
      QNSHL(1,KS)=3
      QNSHL(2,KS)=0
      QNSHL(3,KS)=-1
      SPNTRY=SPNTRY+2
 120  KS=KS+1
      IF(KS.LE.NSHL)GO TO 100
C
      IF(SPNTRY.LT.QNTOT(1) .OR. MTRY.LT.QNTOT(2))GO TO 600
      KC=1
      KCS=NSHL+1
      IF(KCLIM.NE.0)GO TO 300
      IF(QNSHL(1,1).NE.QNTOT(1) .OR. QNSHL(2,1).NE.QNTOT(2))GO TO 500
      IF(QNSHL(2,1).EQ.0 .AND. QNSHL(3,1).NE.QNTOT(3))GO TO 500
      GO TO 420
 300  SHL1=CUP(1,KC)
      SHL2=CUP(2,KC)
      QNSHL(1,KCS)=QNSHL(1,SHL1)+QNSHL(1,SHL2)-1
      SPNMIN(KC)=ABS(QNSHL(1,SHL1)-QNSHL(1,SHL2))+1
      QNTMP(1,1,KC)=QNSHL(2,SHL1)+QNSHL(2,SHL2)
      QNSHL(2,KCS)=QNSHL(2,SHL1)+QNSHL(2,SHL2)
      QNTMP(1,2,KC)=ABS(QNSHL(2,SHL1)-QNSHL(2,SHL2))
      QNTMP(2,1,KC)=QNSHL(3,SHL1)*QNSHL(3,SHL2)
      QNSHL(3,KCS)=QNSHL(3,SHL1)*QNSHL(3,SHL2)
      QNTMP(2,2,KC)=0
      MCLIM(1,KC)=1
      MCLIM(2,KC)=1
      IF(QNTMP(1,1,KC).EQ.QNTMP(1,2,KC))GO TO 320
      MCLIM(2,KC)=2
      IF(QNTMP(1,2,KC).NE.0)GO TO 320
      MCLIM(2,KC)=3
      QNTMP(2,2,KC)=1
 320  KC=KC+1
      KCS=KCS+1
      IF(KC.LE.KCLIM)GO TO 300
C
C     TEST IF THE FINAL COUPLING IS IN THE RANGE PERMITTED
C
      KC=KCLIM
      KCS=KCS-1
      IF(QNSHL(1,KCS).LT.QNTOT(1) .OR. SPNMIN(KC).GT.QNTOT(1))GO TO 500
      QNSHL(1,KCS)=QNTOT(1)
      IF(QNSHL(2,KCS).NE.QNTOT(2) .AND. QNTMP(1,2,KC).NE.QNTOT(2))
     &   GO TO 500
      QNSHL(2,KCS)=QNTOT(2)
      QNSHL(3,KCS)=QNTOT(3)
      IF(QNTMP(1,1,KC).NE.0)GO TO 420
      QNSHL(3,KCS)=QNTMP(2,1,KC)
      IF(QNSHL(3,KCS).NE.QNTOT(3))GO TO 500
C
C     FOR R-MATRIX CALCULATIONS:
C     REJECT COUPLINGS WHICH DO NOT PRESERVE THE TARGET QUANTUM
C     NUMBERS
C
 420  IF(QNTAR(1).GE.0)THEN
         KCSP=KCS-1
         IF(KCS.EQ.3)KCSP=1
         IF(QNSHL(1,KCSP).NE.QNTAR(1))GO TO 500
         IF(QNSHL(2,KCSP).NE.QNTAR(2))GO TO 500
         IF(QNSHL(3,KCSP).NE.QNTAR(3))GO TO 500
      END IF
      NSTATE=NSTATE+1
      IF(NSTATE.NE.1)GO TO 400
C     ASSIGN PQN VALUE AND PRINT TYPE AND DISTRIB DATA FOR
C     ALLOWED STATE
      CALL ASSIGN(NSHL,NDIST,NUSED,X(IRFCON),X(IEXCON),X(IQNSTR),NX,
     &            NFTW)
      IF(NDIST.EQ.0)THEN
         NSTATE=0
         RETURN
      END IF
      NAV=NX-NUSED
      NNEXT=NEXT+NUSED
      IF(NNDEL.NE.0)GO TO 405
      CALL PRINT1(X(IQNSTR))
 400  IF(CONFPF.GE.10 .AND. NNDEL.EQ.0)CALL PRINT2(0)
 405  CALL WFN(NNCSF,NADEL,IIDIST,IIDIS1,X(INODI),X(INDI),X(ICDI),
     &         X(NDEL),X(IQNSTR),X(NNEXT),X(NNEXT),NAV)
      IF(NNDEL.GT.0 .AND. NADEL.GT.NNDEL .AND. IIDIS1.EQ.0)RETURN
      IF(NNDEL.EQ.0)GO TO 500
      IF(IIDIST.EQ.0)GO TO 500
      IF(NSTATE.EQ.1)CALL PRINT1(X(IQNSTR))
      IF(CONFPF.GE.10 .AND. IIDIS1.NE.0)CALL PRINT2(IIDIS1)
C
C     ASCEND IN COUPLING TREE
C     ASCEND IN THE SHELL TO SHELL COUPLING LOOPS
C
 500  KC=KC-1
      KCS=KCS-1
      IF(KC.EQ.0)GO TO 600
      MCLIM(1,KC)=MCLIM(1,KC)+1
      IF(MCLIM(1,KC).LE.MCLIM(2,KC))GO TO 520
      QNSHL(1,KCS)=QNSHL(1,KCS)-2
      IF(QNSHL(1,KCS).LT.SPNMIN(KC))GO TO 500
      MCLIM(1,KC)=1
 520  QNSHL(2,KCS)=QNTMP(1,MCLIM(1,KC),KC)
      QNSHL(3,KCS)=QNTMP(2,MCLIM(1,KC),KC)
      GO TO 320
C
C     ASCEND IN THE LOOPS WHICH COUPLE SHELLS TO THEMSELVES
C
 600  KS=KS-1
      IF(KS.EQ.0)GO TO 900
      KSLIM(1,KS)=KSLIM(1,KS)+1
      IF(KSLIM(1,KS).GT.KSLIM(2,KS))GO TO 600
      IF(KSLIM(1,KS).EQ.3)GO TO 625
C
C     COUPLE TO 1(2*L) AND ADJUST SPNTRY AND MTRY
C
      QNSHL(1,KS)=1
      SPNTRY=SPNTRY-2
      QNSHL(2,KS)=MSHL(KS)+MSHL(KS)
      MTRY=MTRY+MSHL(KS)+MSHL(KS)
      QNSHL(3,KS)=0
      GO TO 120
C
C     COUPLE TO 1(S+) AND ADJUST SPNTRY AND MTRY
C
 625  MTRY=MTRY-QNSHL(2,KS)
      QNSHL(2,KS)=0
      QNSHL(3,KS)=1
      GO TO 120
C
 900  IF(NNDEL.NE.0 .AND. IIDIS1.NE.0)CALL PRINT3(IIDIS1,1)
      IF(NNDEL.EQ.0 .AND. NSTATE.NE.0)CALL PRINT3(IDUMM,2)
      RETURN
      END SUBROUTINE CPLEA
!*==cplem.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE CPLEM(NNCSF,NADEL,X,NFTW)
C
C         OCCSHL(NSHL)   COMPRESSED SHELL OCC'S / ALL ZEROS DELETED
C                        AND PSEUDO SHELLS EXPANDED
C         MSHL(NSHL)     SYMMETRY NUMBER FROM ZERO TO N-1 (MVALUE)
C         QNSHL(3,2*NSHL-1)
C                        1 -- MULT / 2 -- SYMMETRY / 3 -- +- (NOT USED)
C         CUP(3,NSHL-1)
C         QNTOT(3)       TOTAL QN'S
C         QNTMP(2*NSHL-1)
C                        TEMP STORAGE FOR TRUE MOLECULE SYM VALUES
C                         -- ZEROS PASSED TO BOWEN IN QNSHL
C         SPNMIN(NSHL-1) TEMP STORAGE FOR LOWEST SPIN COUPLING
C         X(NX)          WORK AREA (R*8)
C         NSHL           NUMBER OF TRUE SHELLS OCCUPIED
C         NSTATE         NUMBER OF COUPLINGS (COMPUTED)
C         NTYPE          PROTO-TYPE NUMBER (INPUT)
C         NDIST          NUMBER OF PQN ASSIGNMENTS
C         NCSF           RUNNING CSF NUMBER
C         SYMTYP         GE 2 FOR MOLECULE
C         CONPF          PRINT FLAG
C
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE GLOBAL_UTILS, ONLY : MPROD
      USE CONGEN_DATA, ONLY : LG, NEXT, NX, ICDI, IEXCON, INDI, INODI,
     &                        IQNSTR, IRFCON, NDEL, CONFPF, NDIST, NSHL,
     &                        NSTATE, OCCSHL, MSHL, CUP, QNSHL,
     &                        SPNMIN, SHLMX1, QNTOT, QNTAR, NNDEL
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NADEL, NFTW, NNCSF
      REAL(KIND=wp), DIMENSION(*) :: X
C
C Local variables
C
      INTEGER :: I, IDUMM, IIDIS1, IIDIST, KC, KCLIM, KCS, KCSP, MTRY, 
     &           MU1, MU2, NAV, NNEXT, NUSED, SPNTRY
      INTEGER, DIMENSION(2*LG) :: QNTMP ! JMC increasing the dimension from LG to match 2nd dimension of QNSHL
C
C*** End of declarations rewritten by SPAG
C
C     INITIALIZE
C
      NSTATE=0
      MTRY=0
      SPNTRY=1
      IIDIS1=0
C
      DO I=1, NSHL
         QNSHL(1,I)=1
         QNSHL(2,I)=0
         QNSHL(3,I)=1
         QNTMP(I)=0
         IF(OCCSHL(I).EQ.SHLMX1(MSHL(I)+1))CYCLE
         QNSHL(1,I)=2
         SPNTRY=SPNTRY+1
         QNTMP(I)=MSHL(I)
         MTRY=MPROD(MTRY+1,QNTMP(I)+1,0,NFTW)-1
      END DO
C
      IF(SPNTRY.LT.QNTOT(1))RETURN
      IF(MTRY.NE.QNTOT(2))RETURN
C
C     COMPLETE M-VALUES FOR COUPLING OF SHELLS TO EACH OTHER
C
      KCLIM=NSHL-1
      KCS=NSHL+1
      KC=0
      IF(KCLIM.EQ.0)THEN
         IF(QNSHL(1,1).EQ.QNTOT(1))GO TO 360
         RETURN
      END IF
      DO I=1, KCLIM
         QNTMP(KCS)=MPROD(QNTMP(CUP(1,I))+1,QNTMP(CUP(2,I))+1,0,NFTW)-1
         QNSHL(2,KCS)=0
         QNSHL(3,KCS)=1
         KCS=KCS+1
      END DO
C
C     BEGIN TO DESCEND INTO SHELL TO SHELL COUPLING TREE
C
      KCS=NSHL
C
 300  KC=KC+1
      KCS=KCS+1
      MU1=QNSHL(1,CUP(1,KC))
      MU2=QNSHL(1,CUP(2,KC))
      QNSHL(1,KCS)=MU1+MU2-1
      SPNMIN(KC)=ABS(MU1-MU2)+1
      IF(KC.LT.KCLIM)GO TO 300
C
C     TEST FOR ALLOWED STATE
C
      IF(QNSHL(1,KCS).LT.QNTOT(1) .OR. SPNMIN(KC).GT.QNTOT(1))GO TO 500
      QNSHL(1,KCS)=QNTOT(1)
C
C     FOR R-MATRIX CALCULATIONS:
C     REJECT COUPLINGS WHICH DO NOT PRESERVE THE TARGET QUANTUM
C     NUMBERS
C
 360  IF(QNTAR(1).GE.0)THEN
         KCSP=KCS-1
         IF(KCS.EQ.3)KCSP=1
         IF(QNSHL(1,KCSP).NE.QNTAR(1))GO TO 500
c         IF (QNSHL(2,KCSP).NE.QNTAR(2)) GOTO 500
c        if (qntar(2).ge.0 .and. qntmp(kcsp).ne.qntar(2)) goto 500
      END IF
      NSTATE=NSTATE+1
      IF(NSTATE.NE.1)GO TO 400
C
C     ASSIGN PQN VALUE AND PRINT TYPE AND DISTRIB DATA FOR
C         ALLOWED STATE
      IEXCON=1
      CALL ASSIGN(NSHL,NDIST,NUSED,X(IRFCON),X(IEXCON),X(IQNSTR),NX,
     &            NFTW)
      IF(NDIST.EQ.0)THEN
         NSTATE=0
         RETURN
      END IF
      NAV=NX-NUSED
      NNEXT=NEXT+NUSED
      IF(NNDEL.NE.0)GO TO 405
      CALL PRINT1(X(IQNSTR))
 400  IF(CONFPF.GE.10 .AND. NNDEL.EQ.0)CALL PRINT2(0)
 405  CALL WFN(NNCSF,NADEL,IIDIST,IIDIS1,X(INODI),X(INDI),X(ICDI),
     &         X(NDEL),X(IQNSTR),X(NNEXT),X(NNEXT),NAV)
      IF(NNDEL.GT.0 .AND. NADEL.GT.NNDEL .AND. IIDIS1.EQ.0)RETURN
      IF(NNDEL.EQ.0)GO TO 500
      IF(IIDIST.EQ.0)GO TO 500
      IF(NSTATE.EQ.1)CALL PRINT1(X(IQNSTR))
      IF(CONFPF.GE.10 .AND. IIDIS1.NE.0)CALL PRINT2(IIDIS1)
C
C     ACSEND IN COUPLING TREE
C
 500  KC=KC-1
      KCS=KCS-1
      IF(KC.LE.0)GO TO 600
      QNSHL(1,KCS)=QNSHL(1,KCS)-2
      IF(QNSHL(1,KCS).GE.SPNMIN(KC))GO TO 300
      GO TO 500
C
 600  IF(NNDEL.NE.0 .AND. IIDIS1.NE.0)CALL PRINT3(IIDIS1,1)
      IF(NNDEL.EQ.0)CALL PRINT3(IDUMM,2)
      RETURN
      END SUBROUTINE CPLEM
!*==csfgen.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE CSFGEN
C
C     Main driver routine: this is a transportable (Cray/IBM) version
C     of CONGEN with the D2h symmetry for MOLECULE re-instated
C
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE consts, ONLY : zero=>xzero, two=>xtwo
      USE CONGEN_DATA, ONLY : MXTARG, NX=>NU, NY, NZ, JX, JY, JZ, KX,
     &                        KY, KZ, NTCON, TEST, NRCON, NOBT, 
     &                        NSYM, NOBI, IFT, NEXT, NAVAIL=>NX, 
     &                        ICDI, IEXCON, INDI, INODI, IQNSTR,
     &                        IRFCON, NDEL, NDEL1, NDEL2, EXREF, NTSO,
     &                        NODIMX, CDIMX, NDIMX, MEGUL, NSOI, NNCSF, 
     &                        NCALL, NCSF, CONFPF, OCCST=>OCCSHL,
     &                        PQNST, MSHLST=>MSHL, GUSHST=>GUSHL, 
     &                        CUPST=>CUP, SSHLST, SHLMX1, NQNTOT=>QNTOT,
     &                        NQNTAR=>QNTAR, NGUTOT=>GUTOT, 
     &                        NNNDEL=>NNDEL, NNLECG, NISZ, 
     &                        NSMTYP=>SYMTYP, NFTW, NFTR
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Local variables
C
      REAL(KIND=wp), ALLOCATABLE, DIMENSION(:) :: BMX
      INTEGER :: BYPROJ, CDIMN, CONMES, D, DEFLTC, GUOLD, GUTOT, I, 
     &           IDIAG, IPOSIT, IS, ISCAT, ISO, ISZ, ITU, J, LC, LCDI, 
     &           LCDO, LCDT, LN, LNDI, LNDO, LNDT, LPP, LSQUARE, LTRI, 
     &           LUMPS, MAXTGSYM, MEGU, MFLAG, MOLD, MT, N, NADEL, NBMX, 
     &           NCONMX, NCSF0, NCUPP, NDIMN, NDPMAX, NDPP, NDPROD, 
     &           NEGMAX, NEGR, NELECG, NELECT, NELP, NELR, NEMAX, NERFG, 
     &           NERFS, NEXTK, NFTO, NNDEL, NOBEP, NODIMN, NPCUPF, 
     &           NPMULT, NREFO, NREFOG, NREFOP, NRERUN, NRFGMX, NRFGOE, 
     &           NRFOE, NRFOMX, NS, NSHGMX, NSHLP0, NSHLPT, 
     &           NSOMAX, NSPF, NSPI, NSYMMX, NSYMP, NTCONP
      INTEGER, DIMENSION(3,JX) :: CUP, PQN
      LOGICAL :: ENE, ENER, ENOB, ENREFO, EPSNO, EQNT, EREFD, ERROR, 
     &           ERRORG, ESPACE, ESYMT, QMOLN
      LOGICAL, DIMENSION(11) :: ERFG
      LOGICAL, DIMENSION(9) :: ERFS
      CHARACTER(LEN=80) :: GNAME, SNAME
      INTEGER, DIMENSION(mxtarg) :: GUCONT, MCONT, MDEGEN, MRKORB, 
     &                              NCTGT, NOTGT
      INTEGER, DIMENSION(JX) :: GUSHL, KSSS, LOOPF, MSHL, OCCSHL, SHLMX, 
     &                          SSHL
      INTEGER, DIMENSION(JY) :: KDSSV, NELECP, NSHLP, NSLSV
      INTEGER, DIMENSION(NX) :: NOB, NOB0, NOB0L, NOBL
      INTEGER, DIMENSION(nx) :: NOBE, NOBP, NOBV
      INTEGER, DIMENSION(6) :: NPFLG
      INTEGER, DIMENSION(JZ) :: NSHCON
      INTEGER :: NTGSMX, NTGSYM, NWFNGP, PQN2, SYMTYP
      REAL(KIND=wp) :: PIN, R, S, SZ, THRES
      INTEGER, DIMENSION(3) :: QNTAR, QNTAR1, QNTOT
      INTEGER, DIMENSION(NZ) :: REFDET
      INTEGER, DIMENSION(KZ) :: REFDTG
      INTEGER, DIMENSION(NY) :: REFGU
      INTEGER, DIMENSION(KY) :: REFGUG
      INTEGER, DIMENSION(5,NY) :: REFORB
      INTEGER, DIMENSION(5,KY) :: REFORG
      INTEGER, DIMENSION(3,JX,JZ) :: TCON
C
C*** End of declarations rewritten by SPAG
C
      EQUIVALENCE(REFORG(1,1),REFORB(1,1))
      EQUIVALENCE(REFGU(1),REFGUG(1))
      EQUIVALENCE(ERFS(1),ESYMT)
      EQUIVALENCE(ERFS(2),ENOB)
      EQUIVALENCE(ERFS(3),EPSNO)
      EQUIVALENCE(ERFS(4),ENE)
      EQUIVALENCE(ERFS(5),ENREFO)
      EQUIVALENCE(ERFS(6),ENER)
      EQUIVALENCE(ERFS(7),EREFD)
      EQUIVALENCE(ERFS(8),EQNT)
      EQUIVALENCE(ERFS(9),ESPACE)
C
      NAMELIST /STATE / MEGUL, NRERUN, LCDT, LNDT, NFTO, LTRI, IDIAG, 
     &   THRES, MEGU, NPFLG, NODIMX, NDIMX, CDIMX, BYPROJ, LCDO, LNDO, 
     &   NFTW, iscat, ntgsym, SNAME, LPP, CONFPF, SYMTYP, QNTOT, GUTOT, 
     &   ISZ, NPMULT, NOB, REFORB, REFGU, NREFO, NELECT, NNDEL, QMOLN, 
C      POSITRON CONTROL DATA
     &   IPOSIT, NOB0, nbmx, NOBE, NOBP, NOBV
C
      NAMELIST /WFNGRP/ NELECG, NDPROD, NELECP, NSHLP, GNAME, REFORG, 
     &   REFGUG, NREFOG, MSHL, GUSHL, PQN, CUP, DEFLTC, NPCUPF, TEST, 
     &   NRCON, NSHCON, TCON, NTCON, QNTAR, LSQUARE
C
C Some initializations
C
      conmes=400
      lumps=124
      NRFOE=30
      NRFGOE=10
      NERFS=9
      NERFG=11
      NOBL=0 ! array
      NOB0L=0 ! array
      mdegen=0 ! array
      NSYMMX=NX
      NRFOMX=NY
      NEMAX=NZ
      NSOMAX=KX
      NRFGMX=KY
      NEGMAX=KZ
      NSHGMX=JX
      NDPMAX=JY
      NCONMX=JZ
C
C     DEFAULT INPUT DATA
C
      QMOLN=.FALSE.
      iscat=0
      ntgsym=mxtarg
      NNDEL=0
      NOBE=0 ! array
      NOBP=0 ! array
      NOBV=0 ! array
      MEGUL=13
      NRERUN=0
      LCDT=500
      LNDT=5000
      LCDO=500
      LNDO=5000
      NFTO=15
      LTRI=300
      IDIAG=-1
      nbmx=2000000
      DO I=1, 6
         NPFLG(I)=0
      END DO
      BYPROJ=1
      MEGU=14
      THRES=1.E-10_wp
C
      CDIMX=400
      NDIMX=4000
      NODIMX=100
      CDIMN=100
      NDIMN=1000
      NODIMN=25
C
      ISZ=0
      LPP=0
      CONFPF=1
      SYMTYP=-1
      DO I=1, 3
         QNTOT(I)=-2
      END DO
      GUTOT=0
      NPMULT=0
      NELECT=0
      IPOSIT=0
C
      DO I=1, NSYMMX
         NOB(I)=0
         NOB0(I)=0
         NSOI(I)=0
         NOBI(I)=0
      END DO
      NREFO=0
      DO I=1, NEMAX
         REFDET(I)=0
      END DO
      DO I=1, NRFOMX
         REFGU(I)=-2
         DO J=1, 5
            REFORB(J,I)=-2
         END DO
      END DO
      DO I=1, NERFS
         ERFS(I)=.FALSE.
      END DO
C
      READ(NFTR,STATE,END=50)
C
      IF(idiag.LT.0)THEN
         IF(iscat.LE.0)idiag=0
         IF(iscat.GT.0)idiag=1
      END IF
      GO TO 60
 50   WRITE(NFTW,55)
 55   FORMAT('1*****   NO INPUT DATA FOR NAMELIST &STATE')
      RETURN
C
C     PROCESS INPUT DATA
C
 60   NSYMP=NSYMMX
      NREFOP=NRFOE
      NELP=0
      ESYMT=.TRUE.
      IF(SYMTYP.LT.0)GO TO 500
      ESYMT=.FALSE.
      NSYM=NSYMMX
c     checking the NOB-values
c     NOBE(i) number of electronic orbitals
c             default nobe(i)=nob(i)
c     NOBP(i) number of positronic orbitals
c             default nobp(i)=0
c     NOBV(i) at the moment not used, but
c             printed on output
c             default nobv(i)=nob0(i)
      DO i=1, nsym
         IF(nobp(i).EQ.0)THEN
            nobe(i)=nob(i)
         END IF
         nobep=nobe(i)+nobp(i)
         IF(nobep.NE.nob(i))THEN
            WRITE(NFTW,*)'ERROR on input:'
            WRITE(NFTW,*)'not: NOB(i)=NOBE(i)+NOBP(i)'
            WRITE(NFTW,*)'i=', i
            WRITE(NFTW,*)'NOB(i)=', nob(i)
            WRITE(NFTW,*)'NOBE(i)=', nobe(i)
            WRITE(NFTW,*)'NOBP(i)=', nobp(i)
         END IF
         IF(nobv(i).EQ.0)THEN
            nobv(i)=nob0(i)
         END IF
         IF(nob0(i).GT.nob(i))THEN
            WRITE(NFTW,*)'ERROR on input:'
            WRITE(NFTW,*)'NOB0(i) > NOB(i)'
            WRITE(NFTW,*)'i=', i
            WRITE(NFTW,*)'NOB(i)=', nob(i)
            WRITE(NFTW,*)'NOB0(i)=', nob0(i)
         END IF
      END DO
 
      DO I=1, NSYMMX
         IF(NOB(NSYM).NE.0)GO TO 210
         NSYM=NSYM-1
      END DO
      ENOB=.TRUE.
      GO TO 500
 210  NSYMP=NSYM
C
      SHLMX1(1)=2
      SHLMX1(2)=2
      IS=2
      NS=2
      IF(SYMTYP.EQ.1)IS=3
      IF(SYMTYP.LE.1)NS=4
      DO I=IS, NSYMMX
         SHLMX1(I)=NS
      END DO
      NOBT=0
      NTSO=0
      DO I=1, NSYM
         NSOI(I)=NTSO+1
         NOB(I)=ABS(NOB(I))
         NOBI(I)=NOBT
         NOBT=NOBT+NOB(I)
         NTSO=NTSO+SHLMX1(I)*NOB(I)
      END DO
      EPSNO=.TRUE.
      IF(NTSO.GT.NSOMAX)GO TO 500
      EPSNO=.FALSE.
      IF(NELECT.LE.0 .OR. NELECT.GT.NEMAX)GO TO 500
      ENE=.FALSE.
      NELP=NELECT
      CALL GETREF(REFORB,REFGU,NREFO,NELECT,REFDET,NELR,NSOI,NOB,SHLMX1,
     &            NSYM,SYMTYP,NRFOMX,ENREFO,ENER,EREFD)
      IF(.NOT.ENREFO)NREFOP=NREFO
      CONFPF=MAX(CONFPF,1)
      EQNT=.TRUE.
      IF(ISZ.EQ.0)ISZ=QNTOT(1)
      IF(QNTOT(1).LE.0 .OR. QNTOT(2).LT.0)GO TO 250
      IF(QNTOT(2).EQ.0 .AND. SYMTYP.LE.1 .AND. ABS(QNTOT(3)).NE.1)
     &   GO TO 250
      IF(ABS(ISZ-1).GT.QNTOT(1)-1)GO TO 250
      IF(SYMTYP.EQ.1 .AND. ABS(GUTOT).NE.1)GO TO 250
      EQNT=.FALSE.
C
 250  CDIMX=MAX(CDIMN,CDIMX)
      NDIMX=MAX(NDIMN,NDIMX)
      NODIMX=MAX(NODIMN,NODIMX)
C----------------------------------------------------------------------
      ALLOCATE(bmx(nbmx))
 
      ICDI=1
      INDI=ICDI+CDIMX
      INODI=INDI+NDIMX
      NDEL=INODI+NODIMX
      NDEL1=NDEL+NNDEL
      NDEL2=NDEL1+NNDEL
      NEXT=NDEL2+NNDEL
      NAVAIL=NBMX-NEXT+1
      NEXTK=NEXT/1024
      WRITE(NFTW,6000)NBMX, NEXT, NEXTK, NAVAIL
 6000 FORMAT(' NBMX =',I9,' WORDS'/' ***** REGION USED FOR INPUT DATA ',
     &       I7,' WORDS ',I5,' K'/' ***** LEFT ',I9,'  WORDS')
      IF(NAVAIL.LE.0)ESPACE=.TRUE.
C----------------------------------------------------------------------
C
 500  CALL STWRIT(NELECT,CONFPF,QNTOT,CDIMX,ICDI,NTSO,SYMTYP,NDIMX,INDI,
     &            NREFO,NODIMX,INODI,NSYM,GUTOT,NBMX,ISZ,NAVAIL,IDIAG,
     &            MEGU,THRES,LCDT,MEGUL,LNDT,NFTO,NRERUN,LTRI,NPFLG,
     &            NNDEL,NOB,NSOI,NSYMP,REFDET,NERFS,ERFS,NREFOP,REFORB,
     &            REFGU,NELP,LPP,SNAME,ERROR,BYPROJ,LNDO,LCDO,IPOSIT,
     &            NOB0,NPMULT,ntgsym,mxtarg,nobe,nobp,nobv)
      IF(NNDEL.NE.0)CALL SUBDEL(BMX(NDEL),BMX(NDEL1),BMX(NDEL2),NNDEL)
C
C     GENERAL DEFAULT FOR WFNGRP ARRAYS
C
      CALL WFNIN(NWFNGP,NADEL,NNCSF,NCSF,LCDI,LNDI,NELECG,NDPROD,NREFOG,
     &           NPCUPF,NEGMAX,REFDTG,NRFGMX,REFGUG,NTCON,REFORG,NSHGMX,
     &           NSYMMX,MSHL,GUSHL,PQN,CUP,NDPMAX,NSHLP,NCONMX,TEST,
     &           NRCON,NSHCON,TCON,ERRORG)
C
C     LOOP OVER WFNGRP INPUT SETS
C
      ncsf0=0
      ntgsmx=ntgsym
      ntgsym=0
      maxtgsym=0
      mold=-1
      guold=0
      qntar1(1)=-1
      pqn2=0
      lsquare=0
 1000 IF(NNDEL.NE.0 .AND. NADEL.GT.NNDEL)GO TO 3000
      CALL WFNIN0(NELECP,DEFLTC,NERFG,ERFG,GNAME,QNTAR,ERRORG,NDPMAX)
C
      READ(NFTR,WFNGRP,END=1050)
c     Store data about target states for phase correction, etc
c
      WRITE(*,*)'lsquare =', lsquare
      IF(iscat.LT.2 .OR. mold.LT.-1)GO TO 1070
c
c     Is this a new target state?
c
      NSHLPT=0
      DO I=1, NDPROD
         NSHLPT=NSHLPT+ABS(NSHLP(I))
      END DO
c
      IF(mold.NE.mshl(nshlpt))GO TO 310
      IF(symtyp.EQ.1 .AND. guold.NE.gushl(nshlpt))GO TO 310
      DO i=1, 3
         IF(qntar(i).NE.qntar1(i))GO TO 310
      END DO
      IF(pqn2.NE.pqn(2,nshlpt))GO TO 310
c     check continuum orbitals consistent
ccc      if ((iposit.ne.0).and.(lsquare.eq.1)) goto 1070
      IF(lsquare.EQ.1)THEN
         WRITE(*,*)'lsquare term detected'
         GO TO 310
      END IF
      IF(notgt(ntgsym).EQ.pqn(3,nshlpt)-pqn(2,nshlpt)+1)GO TO 1070
      WRITE(nftw,410)notgt(ntgsym), pqn(3,nshlpt)-pqn(2,nshlpt)+1
 410  FORMAT(//' Attempt to perform CI target calculation with ',
     &       'different length continua for same target state:',
     &       /' Number of continua, last WFNGRP',i4,
     &       /' Number of continua, this WFNGRP',i4/,' STOP')
      STOP
c     New target state detected: first save data about old one
 310  IF(ntgsym.GE.1)THEN
         nctgt(ntgsym)=(ncsf-ncsf0)/notgt(ntgsym)
         mrkorb(ntgsym)=nspi
      END IF
c     Have we finished all target states?
      IF(qntar(1).LE.0 .OR. ntgsym.EQ.ntgsmx)THEN
         mold=-2
         GO TO 1070
      END IF
c
      ncsf0=ncsf
      ntgsym=ntgsym+1
      IF(lsquare.EQ.0)maxtgsym=maxtgsym+1
      WRITE(nftw,400)ntgsym, qntar, mshl(nshlpt)
 400  FORMAT(/,' Target state number',i3,/,' TARGET MULTIPLICITY =',I5,
     &       5X,'TARGET SYMMETRY =',I5,5X,'TARGET INVERSION SYMMETRY =',
     &       I5,/' Coupling to continuum with M =',I3)
      IF(symtyp.EQ.1)WRITE(nftw,405)gushl(nshlpt)
 405  FORMAT('                           GU =',I3)
c     save continuum electron data for future use
      notgt(ntgsym)=pqn(3,nshlpt)-pqn(2,nshlpt)+1
      mcont(ntgsym)=mshl(nshlpt)
      IF(symtyp.EQ.1)gucont(ntgsym)=gushl(nshlpt)
      pqn2=pqn(2,nshlpt)
c     for degenerate symmetries/degenerate target states, need extra
c     information to sort out coupling of possible second continuum
      IF(symtyp.LE.1 .AND. qntot(2).GT.0 .AND. qntar(2).GT.0)
     &   mdegen(ntgsym)=max(qntot(2),qntar(2))-mcont(ntgsym)
c
      DO i=1, 3
         qntar1(i)=qntar(i)
      END DO
      mold=mshl(nshlpt)
      IF(symtyp.EQ.1)guold=gushl(nshlpt)
C
      GO TO 1070
 1050 CALL SPACE(2)
      CALL ADDL(1)
      IF(NWFNGP.EQ.0)THEN
         WRITE(NFTW,1065)
 1065    FORMAT(' *****  NO WFNGRP INPUT FOUND')
         RETURN
      END IF
      WRITE(NFTW,1055)
 1055 FORMAT(' *****  END OF FILE ON INPUT')
      GO TO 3000
C
 1070 NDPP=NDPMAX
      NELP=0
      NCUPP=0
      NTCONP=0
      NWFNGP=NWFNGP+1
      ERFG(1)=.TRUE.
      IF(NELECG.LE.0 .OR. NELECG.GT.NEGMAX)GO TO 1500
      ERFG(1)=.FALSE.
      NDPROD=MAX(1,NDPROD)
      ERFG(2)=.TRUE.
      IF(NDPROD.GT.NDPMAX)GO TO 1500
      ERFG(2)=.FALSE.
      NDPP=NDPROD
      NEGR=0
      NSHLPT=0
      DO I=1, NDPROD
         NELECP(I)=ABS(NELECP(I))
         NEGR=NEGR+NELECP(I)
         NSHLP(I)=ABS(NSHLP(I))
         IF(NSHLP(I).EQ.0)ERFG(3)=.TRUE.
         NSHLPT=NSHLPT+NSHLP(I)
      END DO
      NSHLP0=NSHLPT-NSHLP(NDPROD)
      IF(NSHLPT.GT.NSHGMX)ERFG(3)=.TRUE.
      IF(NEGR.NE.NELECG)ERFG(4)=.TRUE.
      IF(ERFG(3) .OR. ERFG(4))GO TO 1500
      CALL GETREF(REFORG,REFGUG,NREFOG,NELECG,REFDTG,NELR,NSOI,NOB,
     &            SHLMX1,NSYM,SYMTYP,NSHGMX,ERFG(5),ERFG(6),ERFG(7))
      IF(.NOT.ERFG(5))NREFOP=NREFOG
      IF(.NOT.ERFG(6))NELP=NELECG
      IF(ERFG(5) .OR. ERFG(6) .OR. ERFG(7))GO TO 1500
C
C     EXPAND REFDET INTO EXREF
C
      DO I=1, NTSO
         EXREF(I)=0
      END DO
      DO I=1, NELECT
         J=REFDET(I)
         EXREF(J)=1
      END DO
      DO I=1, NELECG
         J=REFDTG(I)
         IF(EXREF(J).EQ.0)ERFG(7)=.TRUE.
         EXREF(J)=0
      END DO
      IF(ERFG(7))GO TO 1500
C
C     CHECK SHELL DATA
C
      ERFG(8)=.TRUE.
      IF(IPOSIT.NE.0 .AND. NELECP(NDPROD).NE.1)GO TO 1500
      DO I=1, NSHLPT
         MSHL(I)=ABS(MSHL(I))
         MT=MSHL(I)+1
         IF(SYMTYP.EQ.1)THEN
            IF(ABS(GUSHL(I)).NE.1)GO TO 1500
            ITU=1
            IF(MOD(MT,2).EQ.0)ITU=-1
            MT=MT+MT-ABS((GUSHL(I)+ITU)/2)
         END IF
         SSHL(I)=MT
         IF(MT.GT.NSYM)GO TO 1500
         IF(PQN(1,I).NE.0)THEN
            PQN(2,I)=PQN(1,I)
            PQN(3,I)=PQN(2,I)
         END IF
         D=PQN(3,I)-PQN(2,I)
         IF(D.LT.0)GO TO 1500
         SHLMX(I)=SHLMX1(MT)*(D+1)
         NSPI=NSOI(MT)+(PQN(2,I)-1)*SHLMX1(MT)
         NSPF=NSPI+SHLMX(I)-1
         IF(IPOSIT.NE.0 .AND. I.GE.NSHLP0)CYCLE
         DO ISO=NSPI, NSPF
            IF(EXREF(ISO).NE.0)GO TO 1500
         END DO
         IF(pqn(3,i).GT.nob(mt))THEN
            WRITE(nftw,1199)i, pqn(3,i), mt, nob(mt)
 1199       FORMAT(//' Error: PQN number',i3,' accesses orbital number',
     &             i3,/' symmetry',i2,' only contains',i3,' orbitals')
            GO TO 1500
         END IF
      END DO
      ERFG(8)=.FALSE.
      NCUPP=NSHLPT-1
      CALL GETCUP(NSHLPT,DEFLTC,NDPROD,NSHLP,CUP(1,1),ERFG(9))
      IF(ERFG(9))NPCUPF=1
      NTCON=MIN(ABS(NTCON),NCONMX)
C     ****** CORE ALLOCATION ******
      IRFCON=NEXT
      IF(NTCON.EQ.0)GO TO 1500
      IEXCON=IRFCON+NOBT*NTCON
      NEXT=IEXCON+NOBT
      NAVAIL=NBMX-NEXT+1
      NEXTK=NEXT/1024
      WRITE(NFTW,6010)NEXT, NEXTK, NAVAIL
 6010 FORMAT(' ***** REGION USED FOR DETERMINANTS ',I7,' WORDS ',I5,
     &       ' K'/' **** LEFT ',I7,'  WORDS')
      IF(NAVAIL.LE.0)ERFG(11)=.TRUE.
C     ****** END CORE ALLOCATION ******
      CALL GETCON(NTCON,NSHCON,NRCON,NSHGMX,NRFGOE,NTCONP,NELECG,NSYM,
     &            NOBT,NOB,NOBI,NSOI,SHLMX1,EXREF,TCON,BMX(IRFCON),
     &            ERFG(10))
C
 1500 IQNSTR=NEXT
      CALL WVWRIT(NWFNGP,GNAME,NELECG,DEFLTC,IRFCON,NDPROD,SYMTYP,NTCON,
     &            NAVAIL,NREFOG,NELECP,NSHLP,QNTAR,NSHLPT,NSHGMX,MSHL,
     &            GUSHL,PQN,CUP,NCUPP,NPCUPF,REFDTG,NELP,NTCONP,NSHCON,
     &            NOBT,REFORB,REFGU,TEST,NRCON,TCON,BMX(IRFCON),NERFG,
     &            ERFG,NDPP,NREFOP,ERRORG)
      IF(ERRORG)RETURN
      DO I=1, NTSO
         EXREF(I)=0
      END DO
      DO I=1, NELECG
         J=REFDTG(I)
         EXREF(J)=1
      END DO
C
      DO I=1, 3
         NQNTOT(I)=QNTOT(I)
         NQNTAR(I)=QNTAR(I)
      END DO
      NISZ=ISZ
      NGUTOT=GUTOT
      NNLECG=NELECG
      NSMTYP=SYMTYP
      NNNDEL=NNDEL
C
      CALL ICGCF
      NCALL=1
      IFT=1
      CALL DISTRB(NELECP,NSHLP,SHLMX,OCCSHL,NSLSV,KDSSV,LOOPF,KSSS,PQN,
     &            OCCST,SHLMX1,PQNST,MSHL,MSHLST,GUSHL,GUSHST,CUP,CUPST,
     &            NDPROD,SYMTYP,CONFPF,SSHL,SSHLST,NCSF,NNCSF,NADEL,
     &            NNDEL,BMX,NFTW)
      CALL CSFOUT(LC,LN,MEGUL,NNDEL,BMX,BMX)
      LCDI=LCDI+LC
      LNDI=LNDI+LN
      GO TO 1000
C
 3000 ENDFILE MEGUL
      REWIND MEGUL
c     check that data for final target state has been saved
      mflag=0
      IF(ntgsym.GE.1)THEN
         IF(mold.GT.-2)THEN
            nctgt(ntgsym)=(ncsf-ncsf0)/notgt(ntgsym)
            mrkorb(ntgsym)=nspi
         END IF
c     for degenerate symmetries/degenerate target states, need extra
c     information to sort out coupling of possible second continuum
c     check this for errors and missed couplings
         IF(symtyp.LE.1 .AND. qntot(2).GT.0)THEN
            IF(mdegen(ntgsym).GT.0)mdegen(ntgsym)=0
            DO n=2, ntgsym
               IF(mdegen(n).LT.0)THEN
                  IF(mdegen(n-1).LE.0)THEN
                     WRITE(nftw,420)ntgsym
 420                 FORMAT(/,' WARNING: for target state number',i3,/,
     &                      ' Coupling to upper continuum only detected'
     &                      ,/,
     &                     ' Calculation may give target phase problems'
     &                     )
                     mdegen(n)=0
                  ELSE IF(nctgt(n).NE.nctgt(n-1))THEN
                     WRITE(nftw,430)n-1, n, nctgt(n-1), nctgt(n)
 430                 FORMAT(/,' Target states',i3,' and',i3,/,
     &              ' analysed for degenerate coupling to the continuum'
     &              ,/,' But number of CSFs differ:',i6,' and',i6,
     &              ' respectively: STOP')
                     STOP
                  END IF
               ELSE IF(mdegen(n).GT.0)THEN
                  IF(mdegen(n-1).GT.0)mdegen(n-1)=0
               END IF
               IF(mdegen(n).NE.0)mflag=max(mflag,nctgt(n))
            END DO
         END IF
      END IF
      CALL SPACE(2)
      CALL ADDL(1)
      WRITE(NFTW,3010)NCSF
 3010 FORMAT(' ********** TOTAL NUMBER OF CSF''S GENERATED IS ',I9)
!*************************************
! open a file fort.400 to inform the user about estimated time of the run
      IF(QMOLN .AND. iscat.LT.2 .AND. megul.EQ.70)THEN
         OPEN(UNIT=conmes,STATUS='unknown')
         IF(NCSF.LE.6000)THEN
            WRITE(conmes,3011)NCSF
         ELSE IF(NCSF.GT.6000 .AND. NCSF.LE.12000)THEN
            WRITE(conmes,3012)NCSF
         ELSE IF(NCSF.GT.12000 .AND. NCSF.LE.22000)THEN
            WRITE(conmes,3013)NCSF
         ELSE IF(NCSF.GT.22000 .AND. NCSF.LE.80000)THEN
            WRITE(conmes,3014)NCSF
         ELSE IF(NCSF.GT.80000)THEN
            WRITE(conmes,3015)NCSF
         END IF
 3011    FORMAT(/,' *** TOTAL NUMBER OF GENERATED CSF''S FOR THE ',
     &          'GROUND STATE IS ',I6,/,
     &          '*** This target calculation should not take long !',/)
 3012    FORMAT(/,' *** TOTAL NUMBER OF GENERATED CSF''S FOR THE ',
     &          'GROUND STATE IS ',I6,/,
     &          '*** This target calculation will take a few hours !',/,
     &          '*** You can have a cup of tea and come back later.',/)
 3013    FORMAT(/,' *** TOTAL NUMBER OF GENERATED CSF''S FOR THE ',
     &          'GROUND STATE IS ',I6,/,
     &          '*** Oops, This target calculation is very big !',/,
     &          '*** You can come back tomorrow.',/)
 3014    FORMAT(/,' *** TOTAL NUMBER OF GENERATED CSF''S FOR THE ',
     &          'GROUND STATE IS ',I6,/,
     &          '*** Oops, This target calculation is very big ',/,
     &          '***    and can take several days to run !',/)
 3015    FORMAT(/,' *** TOTAL NUMBER OF GENERATED CSF''S FOR THE ',
     &          'GROUND STATE IS ',I6,/,
     &          '*** Oops, This target calculation is too big ',/,
     &          '***    to be computationally possible !',/,
     &          '*** Rerun with a smaller basis or contact ',/,
     &          '*** technical support: support@quantemol.com',/)
         CLOSE(conmes)
      END IF
!************************************
      S=REAL(QNTOT(1)-1,KIND=wp)/TWO
      SZ=REAL(ISZ-1,KIND=wp)/TWO
      R=ZERO
      IF(QNTOT(2).EQ.0 .AND. SYMTYP.LE.1)R=REAL(QNTOT(3),KIND=wp)
      PIN=ZERO
C SAVE CONTENTS OF NOB AND NOB0 PRIOR TO ANY SYMMETRY CONVERSION
      DO I=1, NSYM
         NOBL(I)=NOB(I)
         NOB0L(I)=NOB0(I)
      END DO
      IF(SYMTYP.EQ.1)THEN
         PIN=REAL(GUTOT,KIND=wp)
         J=0
         DO I=1, NSYM, 2
            J=J+1
            NOB(J)=NOB(I)+NOB(I+1)
            NOB0(J)=NOB0(I)+NOB0(I+1)
         END DO
         NSYM=J
      END IF
      CALL NEWPG
 
      DEALLOCATE(BMX)
C
c     Section to project wavefunctions. Taken from SPEEDY
c
C
c     Section to project wavefunctions. Taken from SPEEDY
C     Also controls writing of wavefunctions for SCATCI & DENPROP
      IF(byproj.GT.0 .OR. iscat.GT.0)
     &   CALL projec(SNAME,MEGUL,SYMTYP,QNTOT(2),S,SZ,R,PIN,NCSF,BYPROJ,
     &               IDIAG,NPFLG,THRES,NELECT,NSYM,
     &               NOB,REFDET,NFTW,IPOSIT,NOB0,NOBL,NOB0L,iscat,
     &               ntgsym,notgt,
     &               nctgt,mcont,gucont,mrkorb,mdegen,
     &               mflag,nobe,nobp,nobv,maxtgsym)

      IF(iscat.LE.0)THEN
         CALL WRNMLT(MEGU,SNAME,NRERUN,MEGUL,SYMTYP,QNTOT(2),S,SZ,R,PIN,
     &               NCSF,BYPROJ,LCDI,LNDI,LCDO,LNDO,LCDT,LNDT,NFTO,
     &               LTRI,IDIAG,NPFLG,THRES,NELECT,NSYM,NOB,REFDET,NFTW,
     &               IPOSIT,NOB0,NOBL,NOB0L,NX,nobe,nobp,nobv)
         ENDFILE MEGU
         REWIND MEGU
      END IF
      IF(CONFPF.GE.1)CALL WRNMLT(NFTW,SNAME,NRERUN,MEGUL,SYMTYP,QNTOT(2)
     &                           ,S,SZ,R,PIN,NCSF,BYPROJ,LCDI,LNDI,LCDO,
     &                           LNDO,LCDT,LNDT,NFTO,LTRI,IDIAG,NPFLG,
     &                           THRES,NELECT,NSYM,NOB,REFDET,NFTW,
     &                           IPOSIT,NOB0,NOBL,NOB0L,NX,nobe,nobp,
     &                           nobv)
c
      RETURN
      END SUBROUTINE CSFGEN
!*==csfout.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE CSFOUT(IA,IB,MEGUL,NNDEL,CR,NR)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE CONGEN_DATA, ONLY : LRATIO, IIDIS2, LCDI, LCDT, NI, NID, NOI,
     &                        ICDI, INDI, INODI
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: IA, IB, MEGUL, NNDEL
      REAL(KIND=wp), DIMENSION(*) :: CR
      INTEGER, DIMENSION(*) :: NR
      INTENT (IN) CR, MEGUL, NNDEL, NR
      INTENT (OUT) IA, IB
C
C Local variables
C
      INTEGER :: I
C
C*** End of declarations rewritten by SPAG
C
      IF(NOI.EQ.0 .AND. NI.EQ.0 .AND. NID.EQ.0)GO TO 500
      IF(NNDEL.NE.0 .AND. IIDIS2.EQ.0)GO TO 450
      WRITE(MEGUL)NOI, (NR(INODI*LRATIO+I-LRATIO),I=1,NOI)
      WRITE(MEGUL)NID, (CR(ICDI+I-1),I=1,NID)
      WRITE(MEGUL)NI, (NR(INDI*LRATIO+I-LRATIO),I=1,NI)
      LCDI=LCDI+NID
      LCDT=LCDT+NI
 450  NOI=0
      NI=0
      NID=0
 500  CONTINUE
      IA=LCDI
      IB=LCDT
      RETURN
      END SUBROUTINE CSFOUT
!*==ctlpg1.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE CTLPG1(LPP,H1,NH1,H2,NH2)
C
C     CTLPG1 CONTROLS PAGE LAYOUT AND COUNTING
C
      USE CONGEN_DATA, ONLY : HEAD, LPPR, LPPMAX, NPAGE
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: LPP, NH1, NH2
      CHARACTER(LEN=1), DIMENSION(NH1) :: H1
      CHARACTER(LEN=1), DIMENSION(NH2) :: H2
      INTENT (IN) H1, H2, LPP, NH1, NH2
C
C Local variables
C
      CHARACTER(LEN=1) :: BLANK=' '
      INTEGER :: I, IL, IM, IP
      CHARACTER(LEN=1), DIMENSION(4) :: PAGE=(/ 'P', 'A', 'G', 'E' /)
C
C*** End of declarations rewritten by SPAG
C
      LPPMAX=LPP
      IF(LPP.LE.0 .OR. LPP.GT.60)LPPMAX=60 ! JMC this line sets the default value for LPPMAX (see item LPP in the documentation)
      LPPR=LPPMAX
      NPAGE=0
      DO I=1, SIZE(HEAD)
         HEAD(I)=BLANK
      END DO
C
      IM=MIN(NH1,120)
      DO I=1, IM
         HEAD(I)=H1(I)
      END DO
      IF(IM.NE.120)THEN
         IL=IM+1
         IM=MIN(IM+NH2,120)
         IP=0
         DO I=IL, IM
            IP=IP+1
            HEAD(I)=H2(IP)
         END DO
      END IF
C
      IM=SIZE(HEAD)-8 ! JMC changing from 124, as the last 8 elements of HEAD will contain 'PAGE' then ' ' then a 3-digit number 
      DO I=1, 4
         IM=IM+1
         HEAD(IM)=PAGE(I)
      END DO
      RETURN
      END SUBROUTINE CTLPG1
!*==distrb.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE DISTRB(NELECP,NSHLP,SHLMX,OCCSHL,NSLSV,KDSSV,LOOPF,
     &                  KSSS,PQN,OCCST,SHLMX1,PQNST,MSHL,MSHLST,GUSHL,
     &                  GUSHST,CUP,CUPST,NDPROD,SYMTYP,CONFPF,SSHL,
     &                  SSHLST,NCSF,NNCSF,NADEL,NNDEL,X,NFTW)
C
C     NPROD  # OF DISTINCT SETT OF ORBITALS
C     NELECP(NDPROD) # OF ELECTRONS PER SET OF ORBITALS
C     NSHLP(NDPROD)  # OF SHELLS IN A SET OF ORBITALS
C     SHLMX(# OF SHELLS) MAX OCCUPATION OF A SHELL OE A PSEUDOSHELL
C     OCCSHL(# OF SHLS)      OCCUPATION OF A SHELL OE A PSEUDOSHELL
C     NSLSV(NDPROD)  SAVE AREA FOR INDEX
C     LOOPF(# OF SHLS) POINTER FOR ZERO OCCUP OR PSEUDOSHELL
C     KSSS=# OF SHLS) SAVE AREA FOR INDEX
C     PQN(1,# OF SHLS)  =0  PSEUDOSHELL  NE 0 REAL SHELL INDEX
C     PQN(2,# OF SHLS)  START INDEX FOR PSEUDOSHELL
C     PQN(3,# OF SHLS)    END INDEX FOR PSEUDOSHELL
C     SHLMX(# OF SHLS)  MAX OCCUP OF A SHELL OR OF A REAL SHELL
C     IN A PSEUDOSHELL
C     MSHL(# OF SHLS) QUANTUM NUMBER OF A SHELL OR OF A PSEUDOSHELL
C     GUSHL(# OF SHLS)
C     CUP(3,2*(# OF SHLS)-1) COUPLING SCEME
C     OCCST(N),PQNST(3,N),MSHLST(N),GUSHST(N),CUPST(3,2*N-1)
C     ARE EXPANDED SHELLS WITH ZEROES DELETED
C
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE CONGEN_DATA, ONLY : NTYP, NDIST, NSTATE, NCSFT=>NCSF, 
     &                        CONFPT=>CONFPF, NSHRUN=>NSHL
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: CONFPF, NADEL, NCSF, NDPROD, NFTW, NNCSF, NNDEL, SYMTYP
      INTEGER, DIMENSION(3,*) :: CUP, CUPST, PQN, PQNST
      INTEGER, DIMENSION(*) :: GUSHL, GUSHST, KDSSV, KSSS, LOOPF, MSHL, 
     &                         MSHLST, NELECP, NSHLP, NSLSV, OCCSHL, 
     &                         OCCST, SHLMX, SHLMX1, SSHL, SSHLST
      REAL(KIND=wp), DIMENSION(*) :: X
      INTENT (IN) CONFPF, CUP, GUSHL, MSHL, NCSF, NDPROD, NELECP, NNDEL, 
     &            NSHLP, PQN, SHLMX, SHLMX1, SSHL, SYMTYP
      INTENT (OUT) GUSHST, MSHLST, PQNST, SSHLST
      INTENT (INOUT) CUPST, KDSSV, KSSS, LOOPF, NSLSV, OCCSHL, OCCST
C
C Local variables
C
      INTEGER :: I, IBIAS, IC1, ID, IDD, IT, IT1, IT2, ITA, J, KDS, 
     &           KDSB, KDST, KPROD, KRUN, KSI, KSS, NADD, NADD2, NCRUN, 
     &           NELA, NELEFT, NINITX, NSHLW, NSLOTS
C
C*** End of declarations rewritten by SPAG
C
      CONFPT=CONFPF
      NTYP=0
      NSTATE=0
      NDIST=0
      IBIAS=0
      KPROD=0
      NINITX=0
      DO I=1, NDPROD
         NINITX=NINITX+NSHLP(I)
      END DO
 10   KPROD=KPROD+1
      KDS=0
      NELEFT=NELECP(KPROD)
      NSLOTS=0
      NSHLW=NSHLP(KPROD)
      DO I=1, NSHLW
         NSLOTS=NSLOTS+SHLMX(I+IBIAS)
         OCCSHL(I+IBIAS)=0
      END DO
 50   KDS=KDS+1
      KDSB=KDS+IBIAS
      OCCSHL(KDSB)=MIN(NELEFT,SHLMX(KDSB))
      NELEFT=NELEFT-OCCSHL(KDSB)
      NSLOTS=NSLOTS-SHLMX(KDSB)
      IF(NELEFT.EQ.0)GO TO 150
      IF(NSLOTS.GE.NELEFT)GO TO 50
C     IF THERE ARE TOO MANY ELECTRONS FOR THE AVAILABLE SHELLS
C     ASCEND IN LOOPS
 60   NELEFT=NELEFT+OCCSHL(KDSB)
      OCCSHL(KDSB)=0
      NSLOTS=NSLOTS+SHLMX(KDSB)
      KDS=KDS-1
      KDSB=KDSB-1
      IF(NSLOTS.GT.NELEFT .OR. KDS.EQ.0)GO TO 130
      GO TO 60
 150  CONTINUE
C     TEST IF THE DISTRIBUTION IS COMPLETED
      IF(KPROD.EQ.NDPROD)GO TO 199
      NSLSV(KPROD)=NSLOTS
      KDSSV(KPROD)=KDS
      IBIAS=IBIAS+NSHLP(KPROD)
      GO TO 10
 199  CONTINUE
C     EXPANSION OF PSEUDOSHELLS AND DELETE OF ZEROES FOLLOW
C     THE "ST" ARRAYS BUT FOR CUPST ARE SET UP
      DO KSI=1, NINITX
         LOOPF(KSI)=0
         KSSS(KSI)=0
         IF(OCCSHL(KSI).EQ.0 .OR. PQN(1,KSI).NE.0)LOOPF(KSI)=1
      END DO
      KDST=0
      KSI=0
C     DECENDS START ON 400
C     ASCENDS START ON 300
 400  IF(KSI.EQ.NINITX)GO TO 399
      KSI=KSI+1
      KSS=1
      IF(OCCSHL(KSI).EQ.0)GO TO 400
      NELA=OCCSHL(KSI)
      KSS=0
 410  IF(KSS.GT.PQN(3,KSI)-PQN(2,KSI))GO TO 320
      KSS=KSS+1
      KDST=KDST+1
      OCCST(KDST)=MIN(NELA,SHLMX1(SSHL(KSI)))
      IF(KSS.NE.1 .AND. KDST.GT.1)OCCST(KDST)=MIN(NELA,OCCST(KDST-1))
C     DO 52 J=1,3
      DO J=1, 3
         PQNST(J,KDST)=PQN(J,KSI)
      END DO
      MSHLST(KDST)=MSHL(KSI)
      GUSHST(KDST)=GUSHL(KSI)
      SSHLST(KDST)=SSHL(KSI)
      NELA=NELA-OCCST(KDST)
      IF(NELA.NE.0)GO TO 410
      KSSS(KSI)=KSS
      GO TO 400
 399  CONTINUE
C     EXPAND AND COMPRESS THE COUPLING SCHEME
      NSHRUN=NINITX
      NCRUN=NSHRUN-1
      DO I=1, NCRUN
         DO J=1, 3
            CUPST(J,I)=CUP(J,I)
         END DO
      END DO
      KRUN=0
      DO I=1, NINITX
         KRUN=KRUN+1
         IF(KSSS(I).LT.1)THEN
C           DELETE SECTION
            DO ID=1, NCRUN
               IF(CUPST(1,ID).EQ.KRUN)EXIT
               IF(CUPST(2,ID).EQ.KRUN)GO TO 630
            END DO
            IT1=CUPST(2,ID)
            GO TO 640
 630        IT1=CUPST(1,ID)
 640        IT2=CUPST(3,ID)
            NCRUN=NCRUN-1
            IF(ID.GT.NCRUN)GO TO 660
            DO IDD=ID, NCRUN
               DO J=1, 3
                  CUPST(J,IDD)=CUPST(J,IDD+1)
               END DO
            END DO
 660        DO IDD=1, NCRUN
               IF(CUPST(1,IDD).EQ.IT2)GO TO 680
               IF(CUPST(2,IDD).EQ.IT2)GO TO 690
            END DO
            GO TO 615
 680        CUPST(1,IDD)=IT1
            GO TO 615
 690        CUPST(2,IDD)=IT1
 615        CONTINUE
            DO IDD=1, NCRUN
               DO J=1, 3
                  IF(CUPST(J,IDD).LE.KRUN)CYCLE
                  CUPST(J,IDD)=CUPST(J,IDD)-1
                  IF(CUPST(J,IDD).GE.IT2)CUPST(J,IDD)=CUPST(J,IDD)-1
               END DO
            END DO
            NSHRUN=NSHRUN-1
            KRUN=KRUN-1
            CYCLE
         ELSE IF(KSSS(I).EQ.1)THEN
            CYCLE
         ELSE
C           ADD SECTION
            NADD=KSSS(I)-1
            NADD2=NADD+NADD
            DO IDD=1, NCRUN
               CUPST(3,IDD)=CUPST(3,IDD)+NADD2
               DO J=1, 2
                  IF(CUPST(J,IDD).EQ.KRUN)THEN
                     CUPST(J,IDD)=NSHRUN+NADD2
                  ELSE IF(CUPST(J,IDD).GT.KRUN .AND. CUPST(J,IDD)
     &                    .LE.NSHRUN)THEN
                     CUPST(J,IDD)=CUPST(J,IDD)+NADD
                  ELSE IF(CUPST(J,IDD).GT.KRUN .AND. CUPST(J,IDD)
     &                    .GT.NSHRUN)THEN
                     CUPST(J,IDD)=CUPST(J,IDD)+NADD2
                  END IF
               END DO
            END DO
            IC1=KRUN
            NSHRUN=NSHRUN+NADD
            DO IDD=1, NADD
               CUPST(1,NCRUN+IDD)=IC1
               CUPST(2,NCRUN+IDD)=KRUN+IDD
               CUPST(3,NCRUN+IDD)=NSHRUN+IDD
               IC1=NSHRUN+IDD
            END DO
            NCRUN=NCRUN+NADD
            KRUN=KRUN+NADD
            CYCLE
         END IF
      END DO
C     END OF ADD/DELETE LOOP
C     NOW SORT THE EXPANDED COUPLING ARRAY
      I=1
      GO TO 72
 61   IT=CUPST(3,I)-KDST
      IF(IT.EQ.I)GO TO 70
      DO J=1, 3
         ITA=CUPST(J,IT)
         CUPST(J,IT)=CUPST(J,I)
         CUPST(J,I)=ITA
      END DO
      GO TO 61
 70   I=I+1
 72   IF(I.LT.NCRUN)GO TO 61
      NTYP=NTYP+1
      IF(SYMTYP.LT.2)THEN
         CALL CPLEA(NNCSF,NADEL,X,NFTW)
      ELSE
         CALL CPLEM(NNCSF,NADEL,X,NFTW)
      END IF
      IF(NSTATE.EQ.0)NTYP=NTYP-1
C     END OF COUPLING SCHEME SECTION
C     SECOND PART OF THE EXPANSION OF PSEUDOSHELLS AND DELETION OF ZEROS
 310  IF(LOOPF(KSI).EQ.0)GO TO 320
      KDST=KDST-KSSS(KSI)
      GO TO 360
 320  OCCST(KDST)=OCCST(KDST)-1
      NELA=NELA+1
      IF(OCCST(KDST).NE.0)GO TO 410
      KSS=KSS-1
      KDST=KDST-1
      IF(KSS.GE.1)GO TO 320
      NELA=0
 360  KSI=KSI-1
      IF(KSI.LE.0)GO TO 110
      IF(LOOPF(KSI).EQ.0)GO TO 370
      KDST=KDST-KSSS(KSI)
      GO TO 360
 370  KSS=KSSS(KSI)
      GO TO 310
C     END OF PSEUDOSHELL EXPANSION LOOPS
C     LAST PART OF OUTER LOOP FOLLOWS
 110  IF(OCCSHL(KDSB).EQ.0)GO TO 140
      OCCSHL(KDSB)=OCCSHL(KDSB)-1
      NELEFT=1
      IF(NNDEL.NE.0 .AND. NADEL.GT.NNDEL)GO TO 9999
      IF(KDS.LT.NSHLP(KPROD))GO TO 50
      NELEFT=NELEFT+OCCSHL(KDSB)
      OCCSHL(KDSB)=0
 120  NSLOTS=NSLOTS+SHLMX(KDSB)
      KDS=KDS-1
      KDSB=KDSB-1
 130  IF(KDS.EQ.0)GO TO 140
      IF(OCCSHL(KDSB).EQ.0)GO TO 120
      OCCSHL(KDSB)=OCCSHL(KDSB)-1
      NELEFT=NELEFT+1
      IF(NNDEL.NE.0 .AND. NADEL.GT.NNDEL)GO TO 9999
      GO TO 50
 140  CONTINUE
      KPROD=KPROD-1
      IF(KPROD.EQ.0)GO TO 9999
      IBIAS=IBIAS-NSHLP(KPROD)
      NSLOTS=NSLSV(KPROD)
      KDS=KDSSV(KPROD)
      KDSB=KDS+IBIAS
      GO TO 110
 9999 NCSFT=NCSF
      RETURN
      END SUBROUTINE DISTRB


      subroutine dophz0(nftw,nocsf,nelt,ndtrf,nconf,
     &                   indo,ndo,lenndo,icdo,cdo,lencdo,
     &                   iphz,npflg)
!
!-----------------------------------------------------------------------
!     Compute phase factor for target CSFs - given by reordering 
!     spin-orbitals in ascending order
!-----------------------------------------------------------------------
!
!-----------------------------------------------------------------------
! MAL 10/05/2011: Changes have been made to this subroutine to bring
! it into line with the changes made to 'projec' and ensure to compliance
! with F95 standards
!-----------------------------------------------------------------------
!
      USE precisn, ONLY : wp
      IMPLICIT NONE
!
      INTEGER                         :: n,i,mb,md,m,na,nftw,iphase,
     &                                   npflg,nocsf,nelt,lenndo,
     &                                   lencdo
      INTEGER, DIMENSION(nelt)        :: ndtrf,nconf
      INTEGER, DIMENSION(nocsf)       :: indo,icdo,iphz
      INTEGER, DIMENSION(lenndo)      :: ndo
      REAL(KIND=wp), PARAMETER        :: zero = 0.0_wp
      REAL(KIND=wp),DIMENSION(lencdo) :: cdo(lencdo)
!
      DO n=1,nocsf
!
!-------------------------------------------------------------------------
!     First load reference determinant
!-------------------------------------------------------------------------
!
         DO i=1,nelt
            nconf(i)=ndtrf(i)
         END DO
!-------------------------------------------------------------------------
!       Then make substitutions
!-------------------------------------------------------------------------
          mb = indo(n)
          md = ndo(mb)
!
          DO 310 m=1,md
             na=ndo(mb+m)
             DO 320 i=1,nelt
                IF (na .EQ. ndtrf(i)) THEN
                  nconf(i)=ndo(mb+md+m)
                  GOTO 310
                END IF
  320        CONTINUE
             WRITE(nftw,*) 'DOPHZ0: help I should not have got here!!! 
     &                       na =',na
             WRITE(nftw,*) ' ndtrf ',ndtrf
             WRITE(nftw,*) ' nconf ',nconf
             STOP
  310     CONTINUE
!
          IF (cdo(icdo(n)) .GT. zero) THEN
            iphz(n)=iphase(nconf,nelt) 
          ELSE
            iphz(n)=-iphase(nconf,nelt)
          END IF
!
      END DO
!
      IF (npflg .GT. 0) THEN
         WRITE(nftw,1010) nocsf
         WRITE(nftw,1030) (iphz(n),n=1,nocsf)
         WRITE(nftw,1040)
      END IF
!
!-------------------------------------------------------------------------
! Subroutine return point
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! Format statements
!-------------------------------------------------------------------------
!
 1010 format(5x,'Phz factor, per target CSF (',i7,'), for future use:')
 1030 format((5x,15(i3,1x)))
 1040 format(/)
!
      END SUBROUTINE  dophz0

      SUBROUTINE dophz(nftw,nocsf,nelt,ndtrf,nconf,            
     &                  indo,ndo,lenndo,icdo,cdo,lencdo,        
     &                  iphz,leniphz,iphz0,leniphz0,            
     &                  nctarg,nctgt,notgt,                     
     &                  mrkorb,mdegen,ntgsym,mcont,symtyp,npflg)
!
!-------------------------------------------------------------------------
!     compute phase factor implied by placing continuum spin-orbital
!     after all target spin-orbitals
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! MAL 10/05/2011 Changes made are in order to bring dophz into line 
! with the changes made in 'projec' in order to utilize dynamic memory
!-------------------------------------------------------------------------
!
      USE precisn, ONLY : wp
      IMPLICIT NONE 
!
      INTEGER                      :: symtyp,i,n,ntci,nt,marked,nc,
     &                                 mb,md,m,na,mark1,iloc,inum,
     &                                 ntci1, ntci0,nftw,nctarg,iph,
     &                                 iphase,npflg,nocsf,nelt,
     &                                 leniphz,leniphz0,ntgsym,
     &                                 lenndo,lencdo
      INTEGER, DIMENSION(nelt)     :: ndtrf,nconf
      INTEGER, DIMENSION(lenndo)   :: ndo
      INTEGER, DIMENSION(nocsf)    :: indo,icdo
      INTEGER, DIMENSION(lencdo)   :: cdo
      INTEGER, DIMENSION(leniphz)  :: iphz
      INTEGER, DIMENSION(ntgsym)   :: nctgt,mrkorb,mcont,notgt,mdegen
      INTEGER, DIMENSION(leniphz0) :: iphz0
      REAL(KIND=wp), PARAMETER     :: zero = 0.0_wp
      LOGICAL, PARAMETER           :: zdebug = .true.      
!
!-------------------------------------------------------------------------
! Debug banner header
!-------------------------------------------------------------------------
!      
      WRITE(nftw, 1000)
      WRITE(nftw, 1010) nocsf,  nelt,   ntgsym, symtyp, 
     &                   lenndo, lencdo, nctarg
      WRITE(nftw, 1020) 
      DO I=1,ntgsym
           WRITE(nftw, 1025) i, nctgt(i), notgt(i), mcont(i)
      END DO
      WRITE(nftw, 1030) 
!
!-------------------------------------------------------------------------
! Descend into loop over target states
!-------------------------------------------------------------------------
!
      n=1
      ntci=0
!      
      DO 100 nt=1,ntgsym
         marked=mrkorb(nt)
!-------------------------------------------------------------------------
!        Descend into loop over number of continuum orbs  
!-------------------------------------------------------------------------         
         do 100 nc=1,nctgt(nt)
!-------------------------------------------------------------------------
!           First load reference determinant
!-------------------------------------------------------------------------
            DO i=1,nelt
               nconf(i)=ndtrf(i)
            END DO
!-------------------------------------------------------------------------
!           Now make substitutions
!-------------------------------------------------------------------------
            mb = indo(n)
            md = ndo(mb)
!            
            DO 310 m=1,md
               na=ndo(mb+m)
               DO 320 i=1,nelt
                  IF (na .EQ. ndtrf(i)) THEN
                    nconf(i)=ndo(mb+md+m)
                    GOTO 310
                  END IF
  320          CONTINUE
               WRITE(nftw,*) 'DOPHZ: help I should not have got here!!!
     &                         na =',na
               WRITE(nftw,*) ' ndtrf ',ndtrf
               WRITE(nftw,*) ' nconf ',nconf
  310       CONTINUE
!
!-------------------------------------------------------------------------
!           We have the present configuration, find the marked orbital
!-------------------------------------------------------------------------
!
            mark1=marked
      DO 330 iloc=1,nelt
      IF (nconf(iloc) .EQ. mark1) GOTO 400
  330 CONTINUE
!--------------------------------------------------------------------------
!     Didn't find it here, try other spin componant
!--------------------------------------------------------------------------
      mark1=marked+1
      DO 340 iloc=1,nelt
      IF (nconf(iloc) .EQ. mark1) GOTO 400
  340 CONTINUE
!--------------------------------------------------------------------------
!     For degenerate symmetries have two more tries
!--------------------------------------------------------------------------
      IF (symtyp .LE. 1 .AND. mcont(nt) .GT. 0) THEN
        mark1=mark1+1
        DO 350 iloc=1,nelt
        IF (nconf(iloc) .EQ. mark1) GOTO 400
  350   CONTINUE
        mark1=mark1+1
        DO 360 iloc=1,nelt
        IF (nconf(iloc) .EQ. mark1) GOTO 400
  360   CONTINUE
      ENDIF
      WRITE(nftw,1000) nt,nc,mrkorb(nt)
      WRITE(nftw,*) ' Configuration is ',nconf
      STOP
!-------------------------------------------------------------------------
!     Phase depends on where the marked orbital is in the determinant
!-------------------------------------------------------------------------
  400 ntci=ntci+1
      inum=0
      DO 410 i=1,nelt
  410 IF (nconf(i) .GT. mark1) inum=inum+1
      IF (mdegen(nt) .GE. 0) THEN
         IF (cdo(icdo(n)) .GT. zero) THEN
            iph=iphase(nconf,nelt)
         ELSE
            iph=-iphase(nconf,nelt)
         END IF
         IF (MOD(inum,2) .EQ. 0) THEN
            iphz(ntci)=iph
         ELSE
            iphz(ntci)=-iph
         END IF
         IF (mdegen(nt) .GT. 0) iphz0(nc)=iph
      ELSE
!------------------------------------------------------------------------
!     treat phase factor caused by coupling down rather than up for second
!     continua in degenerate symmetry/degenerate target as special case
!------------------------------------------------------------------------
         IF (MOD(inum,2) .EQ. 0) THEN
            iphz(ntci)=iphz0(nc)
         ELSE
            iphz(ntci)=-iphz0(nc)
         END IF
       END IF
      n=n+notgt(nt)
!      
  100 CONTINUE ! End of loop over target states 
!
!-------------------------------------------------------------------------
! Having completed the computation, print results.
!-------------------------------------------------------------------------
!      
      IF (npflg .GT. 0) THEN
         WRITE(nftw,2010)
         ntci1=0
         DO 235 NT=1,ntgsym
            ntci0=ntci1+1
            ntci1=ntci1+nctgt(nt)
            WRITE(nftw,2020) nt
            WRITE(nftw,2030) (iphz(ntci),ntci=ntci0,ntci1)
  235    CONTINUE
         WRITE(nftw,2040)
      END IF
!
!-------------------------------------------------------------------------
! Subroutine return point
!-------------------------------------------------------------------------
!
      IF (zdebug) THEN
        WRITE(nftw, 8000)
      END IF
!
!-------------------------------------------------------------------------
! Format statements
!-------------------------------------------------------------------------
!
 1000 format(/,5x,'Phase analysis for total wavefunction:',/)
 1010 format(5x,' ',/, 
     &        5x,'  Number of CSFS           (nocsf) = ',i8,/,
     &        5x,'  Number of electrons       (nelt) = ',i8,/,
     &        5x,'  Number of target states (ntgsym) = ',i8,/, 
     &        5x,'  Spatial group type      (symtyp) = ',i8,/, 
     &        5x,'  Size of packed dets     (lenndo) = ',i8,/, 
     &        5x,'  Size of cdo (#dets)     (lencdo) = ',i8,/,
     &        5x,'                          (nctarg) = ',i8,/)  
 1020 format(5x,'Structure of wavefunction:',//,               
     &        5x,'Target   #CSFs    #Continuum  Spatial Sym ',/,
     &        5x,'State     targ     functions  continuum   ',/,
     &        5x,'------  -------   ----------  ----------- ')
 1025 format(5x,i6,2x,i7,3x,i10,2x,i10)
 1030 format(/,5x,'**** End of structure of wavefunction',/)
!             
 2010 format(//,' Phase factors for CI target states:')
 2020 format(/,' Target symmetry',i3/)
 2030 format(25i3)
 2040 format(//)
!             
 8000 format(/,5x,'***** dophz() - completed ',/)
!
      END SUBROUTINE dophz

!*==getcon.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE GETCON(NTCON,NSHCON,NRCON,NSHGMX,NPMAX,NC,NELECG,NSYM,
     &                  NOBT,NOB,NOBI,NSOI,SHLMX1,EXREF,TCON,REFCON,
     &                  ERROR)
C
C     SUBROUTINE TO CHECK TCON DATA AND FORM REFCON ARRAY
C
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      LOGICAL :: ERROR
      INTEGER :: NC, NELECG, NOBT, NPMAX, NSHGMX, NSYM, NTCON
      INTEGER, DIMENSION(*) :: EXREF, NOB, NOBI, NRCON, NSHCON, NSOI, 
     &                         SHLMX1
      INTEGER, DIMENSION(NOBT,*) :: REFCON
      INTEGER, DIMENSION(3,NSHGMX,*) :: TCON ! JMC the dimensions could be changed to (3,JX,JZ) if desired.
      INTENT (IN) EXREF, NELECG, NOB, NOBI, NOBT, NPMAX, NRCON, NSHGMX, 
     &            NSOI, NSYM, NTCON, SHLMX1, TCON
      INTENT (OUT) ERROR
      INTENT (INOUT) NC, NSHCON, REFCON
C
C Local variables
C
      INTEGER :: IC, J, K, NEL, NESYM, NET, NETC, NOC, NS, NSHCR, NSPF, 
     &           NSPI, PQNT, PQNTM, SYMT
C
C*** End of declarations rewritten by SPAG
C
      ERROR=.FALSE.
      NC=0
      IF(NTCON.EQ.0)RETURN
      ERROR=.TRUE.
      DO IC=1, NTCON
         NC=NC+1
         DO J=1, NOBT
            REFCON(J,IC)=0
         END DO
         NSHCR=NSHCON(IC)
         IF(NSHCR.LE.NSHGMX)THEN
         ELSE
            NSHCON(IC)=NPMAX
            RETURN
         END IF
         IF(NRCON(IC).LT.0 .OR. NRCON(IC).GT.NELECG)RETURN
         NETC=0
         DO J=1, NSHCR
            SYMT=TCON(1,J,IC)+1
            PQNT=TCON(2,J,IC)
            NET=TCON(3,J,IC)
            IF(SYMT.LE.0 .OR. SYMT.GT.NSYM)RETURN
            IF(NET.LE.0)RETURN
            NETC=NETC+NET
            NESYM=SHLMX1(SYMT)
            PQNTM=PQNT+(NET-1)/NESYM
            IF(PQNT.LE.0 .OR. PQNTM.GT.NOB(SYMT))RETURN
            NSPI=NSOI(SYMT)+(PQNT-1)*NESYM
            NSPF=NSPI+((NET+1)/NESYM)*NESYM-1
            DO NS=NSPI, NSPF
               IF(EXREF(NS).NE.0)RETURN
            END DO
            NOC=NOBI(SYMT)+PQNT-1
            NEL=NET
            DO K=1, NEL, NESYM
               NOC=NOC+1
               IF(REFCON(NOC,IC).NE.0)RETURN
               REFCON(NOC,IC)=MIN(NESYM,NET)
               NET=NET-NESYM
            END DO
         END DO
         IF(NETC.NE.NELECG)RETURN
      END DO
      ERROR=.FALSE.
      RETURN
      END SUBROUTINE GETCON
!*==getcup.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE GETCUP(NSHLT,DEF,ND,NSHLP,CUP,ERROR)
C
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: DEF, ND, NSHLT
      LOGICAL :: ERROR
      INTEGER, DIMENSION(3,NSHLT) :: CUP
      INTEGER, DIMENSION(ND) :: NSHLP
      INTENT (IN) DEF, ND, NSHLP, NSHLT
      INTENT (OUT) ERROR
      INTENT (INOUT) CUP
C
C Local variables
C
      INTEGER :: I, I1CUP, I2CUP, IFC, IFCUP, II, IICUP, ITEST, J, NC, 
     &           NCUP, NCUP2, NDM1, NS1, NS2, NSC1, NSC2
C
C*** End of declarations rewritten by SPAG
C
      ERROR=.FALSE.
      IF(NSHLT.EQ.1)RETURN
      IF(DEF.NE.0)GO TO 300
C
C     DEFAULT CUP ARRAY
C
      IFCUP=NSHLT
      IFC=0
      I1CUP=1
      DO I=1, ND
         IICUP=NSHLP(I)-1
         IF(IICUP.EQ.0)GO TO 50
         I2CUP=I1CUP
         DO II=1, IICUP
            IFC=IFC+1
            IFCUP=IFCUP+1
            I2CUP=I2CUP+1
            CUP(1,IFC)=I1CUP
            CUP(2,IFC)=I2CUP
            CUP(3,IFC)=IFCUP
            I1CUP=IFCUP
         END DO
         I1CUP=I2CUP
 50      I1CUP=I1CUP+1
      END DO
      NDM1=ND-1
      IF(NDM1.EQ.0)GO TO 300
C
C     COMPLETE SHELL TO SHELL COUPLINGS
C
      NS1=1
      NSC1=NSHLP(1)-1
      DO I=1, NDM1
         NS2=NS1+NSHLP(I)
         NSC2=NSC1+(NSHLP(I+1)-1)
         IFC=IFC+1
         IFCUP=IFCUP+1
         I1CUP=NS1
         I2CUP=NS2
         IF(NSHLP(I).NE.1)I1CUP=CUP(3,NSC1)
         IF(NSHLP(I+1).NE.1)I2CUP=CUP(3,NSC2)
         IF(I.GT.1)I1CUP=CUP(3,IFC-1)
         CUP(1,IFC)=I1CUP
         CUP(2,IFC)=I2CUP
         CUP(3,IFC)=IFCUP
         NS1=NS2
         NSC1=NSC2
      END DO
C
C     CHECK CUP ARRAY FOR ALLOWED VALUES
C
 300  ERROR=.TRUE.
      NCUP=NSHLT-1
      ITEST=NSHLT
      DO I=1, NCUP
         ITEST=ITEST+1
         IF(CUP(3,I).NE.ITEST)RETURN
         IF(CUP(1,I).GE.ITEST .OR. CUP(2,I).GE.ITEST)RETURN
      END DO
C
      NCUP2=NCUP+NCUP
      DO I=1, NCUP2
         NC=0
         DO J=1, NCUP
            IF(CUP(1,J).EQ.I)NC=NC+1
            IF(CUP(2,J).EQ.I)NC=NC+1
         END DO
         IF(NC.NE.1)RETURN
      END DO
      ERROR=.FALSE.
      RETURN
      END SUBROUTINE GETCUP
!*==getref.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE GETREF(REFORB,REFGU,NREFO,NELEC,REFDET,NELR,NSOI,NOB,
     &                  SHLMX,NSYM,SYMTYP,NRFOMX,E1,E2,E3)
C
C     SUBROUTINE TO FORM REFDET LIST OF SPIN ORBITAL NUMBERS
C        REFORB(5,NREFO)      1 - M-VALUE OF SHELL
C                             2 - PQN
C                             3 - NUMBER OF ELECTRONS IN SHELL
C                             4 - SPIN ORB 1
C                             5 - SPIN ORB 2
C        REFGU(NREFO)        +1 - G ORBITAL
C                            -1 - U ORBITAL
C                                 ONLY USED FOR SYMTYP=1 (D INF H)
C        NREFO
C        NELEC             INPUT VALUE OF NUMBER OF ELECTRONS
C        REFDET(NELEC)     LIST OF SPIN ORBITAL NUMBERS (IN INCREASING
C                          ORDER) IN REFERENCE DETERMINANE
C        NELR              COMPUTED NUMBER OF ELEC FROM REFORB(3,I)
C
C        NSOI(NSYM)        INITIAL VALUE OF SPIN ORB 1 OF SYM I
C        SYMTYP            0 - C INF V
C                          1 - D INF H
C                          2 - D2H,C2V,CS,E
C
C        SHLMX(NSYM)      SHELL OCC MAX BY SYMMETRY
C        NSYM
C        NRFOMX           MAX NUMBER OF ORBITALS FOR REF STATE
C                             IN ARRAYS REFORB AND REFGU
C
C        E1               NREFO OUT OF RANGE ERROR
C        E2               NELR DOES NOT MATCH NELEC
C        E3               ERRORS IN REFORB AMD REFGU ARRAYS
C        E1 - E3          TRUE=ERROR (L*1)
C
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      LOGICAL :: E1, E2, E3
      INTEGER :: NELEC, NELR, NREFO, NRFOMX, NSYM, SYMTYP
      INTEGER, DIMENSION(*) :: NOB, NSOI, REFDET, SHLMX
      INTEGER, DIMENSION(*) :: REFGU
      INTEGER, DIMENSION(5,*) :: REFORB
c  SHOULD I HAVE CHANGED THE VALUE OF the other things????
      INTENT (IN) NELEC, NOB, NREFO, NRFOMX, NSOI, NSYM, REFGU, REFORB, 
     &            SHLMX, SYMTYP
      INTENT (OUT) E1, E2, E3
      INTENT (INOUT) NELR, REFDET
C
C Local variables
C
      INTEGER :: I, ISOT, J, JJ, NE, NEB, NELRM1, NEO, NER, NESR, PQNR, 
     &           PQNRM, SYMR, T1, TGU
C
C*** End of declarations rewritten by SPAG
C
      E1=.TRUE.
      E2=.FALSE.
      E3=.FALSE.
C
      IF(NREFO.LE.0 .OR. NREFO.GT.NRFOMX)RETURN
      E1=.FALSE.
C
      E2=.TRUE.
      NELR=0
      DO I=1, NREFO
         NELR=ABS(REFORB(3,I))+NELR
      END DO
      IF(NELR.NE.NELEC)RETURN
C
      E2=.FALSE.
      E3=.TRUE.
      NELR=0
      DO I=1, NREFO
         SYMR=REFORB(1,I)+1
         IF(SYMTYP.NE.1)GO TO 110
         TGU=REFGU(I)
         IF(ABS(TGU).NE.1)RETURN
         IF(MOD(SYMR,2).NE.0)TGU=-TGU
         SYMR=2*SYMR-(1-TGU)/2
C
 110     IF(SYMR.LE.0 .OR. SYMR.GT.NSYM)RETURN
C
         PQNR=REFORB(2,I)
         NE=REFORB(3,I)
         IF(NE.LE.0)RETURN
         NESR=SHLMX(SYMR)
         PQNRM=PQNR+(NE-1)/NESR
         IF(PQNR.LE.0 .OR. PQNRM.GT.NOB(SYMR))RETURN
         ISOT=NSOI(SYMR)+(PQNR-1)*NESR-1
C
         NEO=MOD(NE,NESR)
         NER=NELR+NE-NEO
         DO J=1, NE
            NELR=NELR+1
            ISOT=ISOT+1
            REFDET(NELR)=ISOT
         END DO
         IF(NEO.EQ.0)CYCLE
         NEB=NEO
         IF(NEB.GT.NESR/2)NEB=NESR-NEO
         DO J=1, NEB
            IF(REFORB(3+J,I).NE.-1)GO TO 140
         END DO
         CYCLE
C
 140     ISOT=ISOT-NEO+1
         IF(NEO.NE.NEB)GO TO 160
         DO J=1, NEB
            NER=NER+1
            IF(REFORB(3+J,I).LT.0 .OR. REFORB(3+J,I).GE.NESR)RETURN
            REFDET(NER)=REFORB(3+J,I)+ISOT
         END DO
         CYCLE
 160     DO J=1, NESR
            DO JJ=1, NEB
               IF(REFORB(3+JJ,I).LT.0 .OR. REFORB(3+JJ,I).GE.NESR)
     &            RETURN
               IF(REFORB(3+JJ,I).EQ.J-1)GO TO 180
            END DO
            NER=NER+1
            REFDET(NER)=ISOT+J-1
 180     END DO
      END DO
      E3=.FALSE.
C
C     ORDER SO NUMBERS IN REFDET
C
      NELRM1=NELR-1
      IF(NELRM1.EQ.0)GO TO 230
      DO I=1, NELRM1
         T1=REFDET(I)
         J=I+1
         DO JJ=1, NER
            IF(T1.EQ.REFDET(JJ))RETURN
            IF(T1.LE.REFDET(JJ))CYCLE
            T1=REFDET(JJ)
            REFDET(JJ)=REFDET(I)
            REFDET(I)=T1
         END DO
      END DO
 230  E3=.FALSE.
C
      RETURN
      END SUBROUTINE GETREF
!*==getsa.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE GETSA(NE,L,IS,ISZ,M,NC,C,ISO)
C
C     FORM NE ELECTRONS IN A SHELL COUPLED TO (L,IS)
C         NE   NUMBER OF ELECTRONS
C         L    LAMBDA OF SHELL
C         IS   SPIN OF COUPLED SHELL (IS=2*S+1)
C
C         ISZ  (ISZ=2*SZ+1)
C         M    PROJECTION OF LAMBDA OF COUPLED SHELL
C         NC   NUMBER OF DETS REQUIRED FOR SHELL
C         C    COEFFICIENT OF DET
C         ISO  SPINORBITALS FOR DETS IN CODE
C                   0    SA        0    L+A
C                   1    SB        1    L+B
C                                  2    L-A
C                                  3    L-B
C
C     **** This version is for linear molecules (ALCHEMY)
C
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE consts, ONLY : one=>xone
      USE CONGEN_DATA, ONLY : ROOT2
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: IS, ISZ, L, M, NC, NE
      REAL(KIND=wp), DIMENSION(*) :: C
      INTEGER, DIMENSION(*) :: ISO
      INTENT (IN) IS, ISZ, L, M, NE
      INTENT (OUT) C, NC
      INTENT (INOUT) ISO
C
C*** End of declarations rewritten by SPAG
C
      NC=1
      C(1)=ONE
      IF(NE.EQ.0)RETURN
      IF(NE.NE.4)THEN
         IF(NE.LT.2)THEN
            ISO(1)=1-ISZ/2
            IF(L.EQ.0)RETURN
            IF(M.LT.0)ISO(1)=ISO(1)+2
            RETURN
         ELSE IF(NE.EQ.2)THEN
            IF(L.EQ.0)GO TO 20
            IF(ISZ+M.NE.1)THEN
               IF(M.NE.0)THEN
                  ISO(1)=1-(L+L)/M
                  ISO(2)=ISO(1)+1
                  RETURN
               END IF
               ISO(1)=(3-ISZ)/4
               ISO(2)=ISO(1)+2
               RETURN
            END IF
            NC=2
            ISO(1)=0
            ISO(2)=3
            ISO(3)=1
            ISO(4)=2
            C(1)=ROOT2
            C(2)=ROOT2
            IF(IS.EQ.1)C(2)=-ROOT2
            RETURN
         ELSE
            IF(M.LT.0)THEN
               ISO(1)=1-ISZ/2
               ISO(2)=2
               ISO(3)=3
               RETURN
            END IF
            ISO(1)=0
            ISO(2)=1
            ISO(3)=3-ISZ/2
            RETURN
         END IF
      END IF
      ISO(3)=2
      ISO(4)=3
 20   ISO(1)=0
      ISO(2)=1
      RETURN
      END SUBROUTINE GETSA
!*==getsm.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE GETSM(NE,ISZ,NC,C,ISO)
C
C     FORM NE ELECTRONS IN A SHELL COUPLED TO (L,IS)
C         NE   NUMBER OF ELECTRONS
C         L    LAMBDA OF SHELL
C         IS   SPIN OF COUPLED SHELL (IS=2*S+1)
C
C         ISZ  (ISZ=2*SZ+1)
C         M    PROJECTION OF LAMBDA OF COUPLED SHELL
C         NC   NUMBER OF DETS REQUIRED FOR SHELL
C         C    COEFFICIENT OF DET
C         ISO  SPINORBITALS FOR DETS IN CODE
C                   0    SA        0    L+A
C                   1    SB        1    L+B
C                                  2    L-A
C                                  3    L-B
C
C     **** This version is for non-linear molecules (MOLECULE)
C
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE consts, ONLY : one=>xone
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: ISZ, NC, NE
      REAL(KIND=wp), DIMENSION(*) :: C
      INTEGER, DIMENSION(*) :: ISO
      INTENT (IN) ISZ, NE
      INTENT (OUT) C, ISO, NC
C
C*** End of declarations rewritten by SPAG
C
      NC=1
      C(1)=ONE
      ISO(1)=0
      ISO(2)=1
      IF(NE.EQ.1)ISO(1)=1-ISZ/2
      RETURN
      END SUBROUTINE GETSM
!*==getso.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE GETSO(NS,INTPFG,NTI,IQNS,CI,ND,ID,CD,LAST)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE CONGEN_DATA, ONLY : NES=>OCCSHL, MS=>MSHL, IQN=>QNSHL,
     &                        NE=>NNLECG, SYMTYP, NFTW
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: INTPFG, LAST, ND, NS, NTI
      REAL(KIND=wp), DIMENSION(*) :: CD, CI
      INTEGER, DIMENSION(*) :: ID
      INTEGER, DIMENSION(2,NS,*) :: IQNS
      INTENT (IN) CI, INTPFG, IQNS, LAST, NS, NTI
      INTENT (INOUT) CD, ID, ND
C
C Local variables
C
      REAL(KIND=wp), DIMENSION(100) :: C ! JMC change dimension to ns*(max nc=2) ??? (an overestimate, for safety).
      REAL(KIND=wp), DIMENSION(NS) :: CS ! JMC changing the dimension from 50
      INTEGER :: I, IE1, IE2, IS, ISZ, ITI, KC, KE, KSO, LD, LD1, LD2, 
     &           ML, NC
      INTEGER, DIMENSION(200) :: ISO ! JMC change dimension to (max nc=2)*sum(nes(i),i=1,ns) ??? (an overestimate, for safety).
      INTEGER, DIMENSION(150) :: JSO ! JMC change dimension to max(ne, sum(nes(i),i=1,ns)) ???
      INTEGER, DIMENSION(NS+1) :: LC, LSO ! JMC changing the dimension from 51.  Think LSO could be (NS) not (NS+1)...
      INTEGER, DIMENSION(NS) :: LCS, LSOS ! JMC changing the dimension from 50
      REAL(KIND=wp) :: T
C
C*** End of declarations rewritten by SPAG
C
      IF(INTPFG.EQ.0)GO TO 50
      WRITE(NFTW,10)NTI
 10   FORMAT(' GETSO : NTI =',I10,/,' IQNS :',/)
      DO ITI=1, NTI
         WRITE(NFTW,2)(IQNS(1,IS,ITI),IS=1,NS)
         WRITE(NFTW,2)(IQNS(2,IS,ITI),IS=1,NS)
      END DO
 2    FORMAT(20I5)
 50   ND=0
      LD=1
      DO ITI=1, NTI
         KC=1
         KSO=1
         DO IS=1, NS
            ISZ=IQNS(1,IS,ITI)
            IF(SYMTYP.LE.1)THEN
               ML=IQNS(2,IS,ITI)
               CALL GETSA(NES(IS),MS(IS),IQN(1,IS),ISZ,ML,NC,C(KC),
     &                    ISO(KSO))
            ELSE
               CALL GETSM(NES(IS),ISZ,NC,C(KC),ISO(KSO))
            END IF
            LC(IS)=KC
            LSO(IS)=KSO
            KC=KC+NC
            KSO=KSO+NC*NES(IS)
         END DO
         LC(NS+1)=KC
         IS=1
         T=CI(ITI)
         IE2=0
 300     CS(IS)=T
         LSOS(IS)=LSO(IS)
         LCS(IS)=LC(IS)
         IF(NES(IS).EQ.0)GO TO 415
 400     IE1=IE2+1
         IE2=IE2+NES(IS)
         KSO=LSOS(IS)
         DO KE=IE1, IE2
            JSO(KE)=ISO(KSO)
            KSO=KSO+1
         END DO
 415     LSOS(IS)=KSO
         T=CS(IS)*C(LCS(IS))
         LCS(IS)=LCS(IS)+1
         IS=IS+1
         IF(IS.LE.NS)GO TO 300
         ND=ND+1
         IF(ND.GT.LAST)GO TO 999
         DO KE=1, NE
            ID(LD)=JSO(KE)
            LD=LD+1
         END DO
         CD(ND)=T
 500     IS=IS-1
         IE2=IE2-NES(IS)
         IF(LCS(IS).LT.LC(IS+1))GO TO 400
         IF(IS.GT.1)GO TO 500
      END DO
      IF(INTPFG.EQ.0)RETURN
      WRITE(NFTW,110)ND
 110  FORMAT(' GETSO : ND =',I6,/,' CD, ID :',/)
      LD2=0
      DO I=1, ND
         LD1=LD2+1
         LD2=LD2+NE
         WRITE(NFTW,3)CD(I), (ID(LD),LD=LD1,LD2)
      END DO
 3    FORMAT(E25.15,20I5)
      RETURN
 999  WRITE(NFTW,1)
 1    FORMAT('0STORAGE OVERFLOW')
      ND=0
      RETURN
      END SUBROUTINE GETSO
!*==icgcf.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE ICGCF
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE consts, ONLY : one=>xone
      USE CONGEN_DATA, ONLY : BINOM, IND, JSMAX
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Local variables
C
      INTEGER :: I, JJ, JS, LB, LB1
C
C*** End of declarations rewritten by SPAG
C
      IND(1)=1
      IND(2)=1
      BINOM(1)=ONE
      BINOM(2)=ONE
      LB=3
      LB1=1
      JS=JSMAX+1
      DO I=2, JS
         DO JJ=2, I
            BINOM(LB)=BINOM(LB1)+BINOM(LB1+1)
            LB=LB+1
            LB1=LB1+1
         END DO
         IND(I+1)=LB1
         BINOM(LB)=ONE
         LB=LB+1
      END DO
      RETURN
      END SUBROUTINE ICGCF
!*==iphase.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      FUNCTION iphase(nconf,nelt)
c
c     compute phase factor (if any) due to out of sequence ordering
c     of spin-orbitals in CSF stored in nconf
c
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NELT
      INTEGER :: IPHASE
      INTEGER, DIMENSION(nelt) :: NCONF
      INTENT (IN) NCONF, NELT
C
C Local variables
C
      INTEGER :: ISO, ISWAP, M, N, NST
C
C*** End of declarations rewritten by SPAG
C
c     first check if there are any spin-orbitals out of sequence
      DO n=2, nelt
         IF(nconf(n).LT.nconf(n-1))GO TO 20
      END DO
c     all spin-orbitals are in ascending order: no phase
      iphase=1
      RETURN
c     there is a possible phase factor...
 20   CONTINUE
c     can we eliminate some electrons from the phase computation?
      nst=1
      DO n=1, nelt
         IF(nconf(n).NE.n)EXIT
         nst=nst+1
      END DO
c     logic says you can't reach this statement
      iswap=0
      DO m=nelt, nst+1, -1
         iso=nconf(m)
         DO n=nst, m-1
            IF(iso.LT.nconf(n))iswap=iswap+1
         END DO
      END DO
c     phase given by whether number of swaps is odd or even
      IF(mod(iswap,2).EQ.0)THEN
         iphase=1
      ELSE
         iphase=-1
      END IF
      RETURN
      END FUNCTION IPHASE

      subroutine mkorbs(nob,nsym,mn,mg,mm,ms,norb,nsrb_in,map,mpos,
     &                   iposit,nobl,nob0l,symtyp)
!--------------------------------------------------------------------
! 
!     MKORBS - Computes the orbital table which is then used in the
!              projection step. This is called from projec().
!
!     Input data:
!        ISYMTYP  Switch for C-inf-v (=0 or 1) / Abelian point group (=2
!            NOB  Number of orbitals per symmetry
!           NSYM  Number of symmetries in the orbital set
!          NPFLG  Flag controlling printing of computed orbital table
!
!     Output data:
!              MN  Orbital number associated with each spin-orbital
!              MG  G/U designation for each spin-orbital (C-inf-v only)
!                  Actually this is always zero because C-inf-v does not
!                  distinguish between g/u. It exists because original
!                  version of Alchemy tried to use it for D-inf-h too;
!                  all CI evauation is doen in C-inf-v now because CONGE
!                  converts D-inf-h to C-inf-v data.
!              MM  Symmetry quantum number associated with each spin-orb
!              MS  Spin function ( alpha or beta ) associated with each
!                  spin orbital
!
!     Notes:
!
!      The orbital table establishes orbital and quantum number data for
!     each spin orbital in the set.
!
!     e.g. C-inf-v symmetry with NSYM=2, NOB=3,1, yields ten spin
!          orbitals which are designated as follows by this routine:
!
!        Spin orb.     MN  MG  MM  MS     Comments
!            1          1   0   0   0     1 sigma spin up
!            2          1   0   0   1     1 sigma spin down
!            3          2   0   0   0     2 sigma spin up
!            4          2   0   0   1     2 sigma spin down
!            5          3   0   0   0     3 sigma spin up
!            6          3   0   0   1     3 sigma spin down
!            7          4   0   1   0     1 pi(lambda=+1) spin up
!            8          4   0   1   1     1 pi(lambda=+1) spin down
!            9          4   0  -1   0     1 pi(lambda=-1) spin up
!           10          4   0  -1   1     1 pi(lambda=-1) spin down                       
!
!------------------------------------------------------------------------
!
!------------------------------------------------------------------------
! MAL 11/05/2011 : Changes made here are to bring the subroutine into
! line with the changes that were made in 'projec' in order to utilize
! dynamic memory and also to comply with the F95 standard
!------------------------------------------------------------------------
!                        
      USE precisn
      USE CONGEN_DATA, ONLY : nftw
      implicit none
!
!..... Integer variables passed in the argument list      
!
      integer :: nsym
      integer :: iposit
      integer :: symtyp
!      
      integer :: norb
      integer :: nsrb_in
!      
      integer :: nob(nsym)
      integer :: mn(nsrb_in)
      integer :: mg(nsrb_in)
      integer :: mm(nsrb_in)
      integer :: ms(nsrb_in)
      integer :: map(norb)
      integer :: mpos(nsrb_in)
      integer :: nobl(*)
      integer :: nob0l(nsym)
!
!..... Local integer variables
!      
      integer  i, ik, ikp, ipos, is, ic, iso
      integer  j, k
      integer  m, ma, mb, m1, n, nep
      integer  ierr
      integer  len_noblj
!      
      integer :: nsrb
      integer, allocatable :: noblj(:)
!
      integer, parameter :: iwrite = 6
!
!..... Local logical variables
!      
      logical, parameter :: zdebug = .false.
!
!---- Debug banner header
!      


      if(zdebug)then
        write(nftw,1000)
        write(nftw,1010) nsym, symtyp, iposit, norb, nsrb_in
        write(nftw,1020) 'nob:  ',(nob(i),i=1,nsym)
        if(symtyp .eq. 1)then      
          write(nftw,1020) 'nobl: ',(nobl(i),i=1,nsym)
        else
          write(nftw,1020) 'nobl: ',(nobl(i),i=1,2*nsym)
        endif
        write(nftw,1090)
      endif

!
!---- Copy the contents of input array nobl() to local storage noblj()
!
!     When we are working with D-inf-h we need to remember that 
!     nsym and nob refer to the C-inf-v representation, whereas 
!     nobl() holds the D-inf-h representation. Thus we need to 
!     double "nsym".
!
      if(symtyp .eq. 1)then
        len_noblj = 2*nsym
      else
        len_noblj = nsym
      end if
!      
      allocate(noblj(len_noblj), stat=ierr)
!
      if(0 .ne. ierr)then
        write(nftw, 9900)
        write(nftw, 9950) ierr
        stop
      end if
!
      noblj(1:len_noblj) = nobl(1:len_noblj)
!
      IF(IPOSIT.NE.0) then
        do is=1,nsym
          NOBLJ(is)= NOBL(is)/2
        end do 
      END IF 

!
!======================================================================
!
!     E L E C T R O N I C    O R B I T A L S
!
!======================================================================
!
      IF (SYMTYP .EQ. 0) THEN
         IC=1
         ISO=4
      ELSE IF (SYMTYP .EQ. 1) THEN
         IC=2
         ISO=4
      ELSE
         IC=1
         ISO=2
      ENDIF
      IF (IPOSIT.NE.0) THEN
        DO is=1, nsym*IC
          NOBLJ(is)= NOBL(is)/2
        ENDDO
      ELSE
        DO is=1, nsym*IC
          NOBLJ(is)= NOBL(is)
        ENDDO
      ENDIF
 
!      
!---- First of all we loop over all non-degenerate electron orbitals
!     and build the table of spin-orbitals for them.
!
!     We set mpos() to be zero for "electron" orbitals.
!
!     For linear molecules this is  
!
!         C-inf-v : Sigma type
!
!         D-inf-h : Sigma_g and Sigma_u
!
!     Actually the code also handle here the first IRR of Abelian
!     point groups too.      
!      
      i  = 1
      ma = 0
!      
      do j=1,ic
         m1   = ma + 1
         ma   = ma + noblj(j)
         ipos = 0
!         
         do n=m1,ma
            map(n) = n
!
!.......... Spin orbital with spin-up 
!
            mn(i)   = n
            mg(i)   = 0
            mm(i)   = 0
            ms(i)   = 0
            mpos(i) = ipos
!
!.......... Spin orbital with spin-down 
!
            i = i + 1
!            
            mn(i)   = n
            mg(i)   = 0
            mm(i)   = 0
            ms(i)   = 1
            mpos(i) = ipos
!
            i = i + 1
         end do
      end do
!
!     write(6,*) ' sigma processed '      
!            
!---- Process remaining orbitals
!
!       C-inf-v:  Pi, Delta, ....
!
!       D-inf-h:  Pi_u, Pi_g, Delta_g, ...
!
!       Abelian:  irr = 2, 3, 4,      
!      
!
      K=MA+1
!
      DO 20 M=IC+1,NSYM*IC
         MA=NOBLJ(M)
         MB=(M-1)/IC
         IPOS = 0
         DO 30 N=1,MA
            MAP(K) = K
!
            DO 40 J=1,ISO
               MN(I)=K
               MG(I)=0
               MM(I)=MB
               MS(I)=0
               MPOS(I)=IPOS
!
               I=I+1
 40         continue
            K=K+1
            MS(I-1)=1
            IF (SYMTYP .LE. 1) THEN
              MM(I-1)=-MB
              MM(I-2)=-MB
              MS(I-3)=1
            ENDIF
   30    CONTINUE
   20 CONTINUE
!
!---- Compute the total number of electron type spin orbitals.
!            
      NSRB = I - 1
!
!======================================================================
!
!     P O S I T R O N I C    O R B I T A L S
!
!======================================================================
!

      if(iposit .ne. 0)then
!
      WRITE(nftw,*) ' MAP : OLD, NEW'
      IK=K-1
      IKP=IK+1
!     NEP = total number of orbitals (electron + positron)
      NEP=IK+IK
      DO 800 N=IKP,NEP
      MAP(N)=MAP(N-IK)
 800  CONTINUE
      WRITE(nftw,*) ' MAP : OLD, NEW'
      DO 810 N=1,NEP
      WRITE(nftw,*) N,MAP(N)
 810  CONTINUE
      DO 850 N=IKP,NEP
      MN(IK+IKP)=N
      IK=IK+1
      MN(IK+IKP)=N
      IK=IK+1
 850  CONTINUE
      DO 900 J=1,NEP
      MG(J+NEP)=MG(J)
      MM(J+NEP)=MM(J)
      MS(J+NEP)=MS(J)
      MPOS(J+NEP)=1

 900  CONTINUE 
        NSRB=2*NSRB

      endif
!
!...................POSITRON LOOP ENDS.......................
!
 955  CONTINUE

!
!---- Now print-out a table of the spin-orbitals
!      
      write(nftw,*) '                  I         N         G         M
     &         S      MPOS      '
!
      do j=1,nsrb
         write(iwrite,3000)J,MN(J),MG(J),MM(J),MS(J),MPOS(J)
      end do
!      
      if(nsrb .NE. nsrb_in)then
        write(iwrite,9910) nsrb, nsrb_in
        stop 999
      endif
!      
!---- Return point 
!      
!     Release any allocated storage 
!      
      if(allocated(noblj))then
        deallocate(noblj, stat=ierr)
!
        if(0 .ne. ierr)then
          write(iwrite, 9900)
          write(iwrite, 9960) ierr
          stop 999
        endif
      endif
!      
      if(zdebug)then
        write(iwrite,8000)
      endif
!
      return
!
!---- Format statements
!
 1000 format(/,10x,'====> mkorbs() <====',/)
 1010 format(/,10x,'Input data: ',/,
     &          10x,'  nsym    = ',i6,/,
     &          10x,'  symtyp  = ',i6,/,
     &          10x,'  iposit  = ',i6,/,
     &          10x,'  norbs   = ',i6,/,
     &          10x,'  nsrb_in = ',i6,/)
 1020 format(12x,a,1x,20(i3,1x))
 1090 format(/,10x,'**** End of input data',/)
!               
 3000 format(10x,7i10)
!      
 8000 format(/,10x,'***** Completed - mkorbs() ',/)
!               
 9900 format(/,10x,'**** Error in mkorbs() ',/)
 9910 format(' HELP!!! MKORBS: NSRB, NSRBD = ',2I6)
 9950 format(/,10x,'Cannot allocate noblj - ierr = ',i6,/)
 9960 format(/,10x,'Cannot deallocate noblj - ierr = ',i6,/)
!      
      end subroutine mkorbs



!*==mphase.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      FUNCTION mphase(nelt,mconf,nconf,mn)
c
c     compute phase factor (if any) due to moving of electron to allow
c     for coupling down in degenerate target/degenerate symmetry case
c
      USE CONGEN_DATA, ONLY : MXDIFF, NFTW
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NELT
      INTEGER, DIMENSION(nelt) :: MCONF, NCONF
      INTEGER, DIMENSION(*) :: MN
      INTEGER :: MPHASE
      INTENT (IN) MCONF, NCONF, NELT
C
C Local variables
C
      INTEGER :: I, ILOC, J, MFIND, MID, MMARK, N, NFIND, NMARK
      INTEGER, DIMENSION(mxdiff) :: MDIFF, NDIFF
C
C*** End of declarations rewritten by SPAG
C
      mphase=1
c     first find differences in spin orbital occupancy
      DO iloc=1, nelt
         IF(nconf(iloc).NE.mconf(iloc))GO TO 20
      END DO
      WRITE(NFTW,*)'MPHASE: help I should not have got here!!!'
      WRITE(NFTW,*)' mconf ', mconf
      WRITE(NFTW,*)' nconf ', nconf
 20   iloc=iloc-1
      mmark=0
      nmark=0
      DO i=iloc, nelt
         mfind=mconf(i)
         nfind=nconf(i)
         DO j=iloc, nelt
            IF(mfind.EQ.nconf(j))GO TO 50
         END DO
         mmark=mmark+1
         mdiff(mmark)=mfind
c
 50      CONTINUE
         DO j=iloc, nelt
            IF(nfind.EQ.mconf(j))GO TO 30
         END DO
         nmark=nmark+1
         ndiff(nmark)=nfind
 30   END DO
c
      IF(nmark.GT.1)THEN
         IF(nmark.GT.mxdiff)THEN
            WRITE(NFTW,910)mxdiff, nmark
 910        FORMAT(/' HELP!!! in MPHASE:',/' Parameter MXDIFF =',i3,
     &             ' but needs to be at least',i3)
            STOP
         END IF
         WRITE(NFTW,920)mmark, (mdiff(i),i=1,mmark)
         WRITE(NFTW,920)nmark, (ndiff(i),i=1,nmark)
         CALL comprd(mdiff,mmark,mn)
         CALL comprd(ndiff,nmark,mn)
         IF(max(nmark,mmark).NE.1)THEN
            WRITE(NFTW,920)mmark, (mdiff(i),i=1,mmark)
            WRITE(NFTW,920)nmark, (ndiff(i),i=1,nmark)
 920        FORMAT(' MPHASE:',i3,' orbital differences found:',10I3)
         END IF
      END IF
c
      WRITE(NFTW,920)mmark, (mdiff(i),i=1,mmark)
      WRITE(NFTW,920)nmark, (ndiff(i),i=1,nmark)
      DO i=1, nmark
         IF(abs(ndiff(i)-mdiff(i)).NE.2)THEN
            WRITE(NFTW,900)mdiff(i), ndiff(i)
 900        FORMAT(/
     &            ' HELP!!! Degenerate target/degenerate symmetry case:'
     &            /' Marked spin orbitals',i4,' and',i4,
     &            ' do not differ by 2'/
     &            ' Computation of phase factor SKIPPED')
            RETURN
         END IF
         mid=(mdiff(i)+ndiff(i))/2
         WRITE(NFTW,*)' mid ', mid
c     check if any spin orbs between two marked ones,
c     if so, switching spin orbs gives a phase factor
         DO n=1, nelt
            IF(nconf(n).EQ.mid)mphase=-mphase
         END DO
      END DO
      WRITE(NFTW,*)' mphase ', mphase
      RETURN
      END FUNCTION MPHASE
!*==newpg.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE NEWPG
      USE global_utils, ONLY : GETIN
      USE CONGEN_DATA, ONLY : HEAD, LPPR, NPAGE, NFTW
      IMPLICIT NONE
C
      LPPR=0
      NPAGE=MOD(NPAGE+1,1000)
      CALL GETIN(NPAGE,3,HEAD(SIZE(HEAD)-2),1) ! JMC this is putting the max. 3-digit number npage into the last 3 elements of HEAD
      WRITE(NFTW, 105) HEAD
 105  FORMAT('1',132A1/)
      RETURN
      END SUBROUTINE NEWPG
!*==pack.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE PACK(IQN,NI,JQN,NJ,CI,CJ,NT)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NI, NJ, NT
      REAL(KIND=wp), DIMENSION(*) :: CI, CJ
      INTEGER, DIMENSION(2,NI,*) :: IQN
      INTEGER, DIMENSION(2,NJ,*) :: JQN
      INTENT (IN) CI, IQN, NI, NJ, NT
      INTENT (OUT) CJ, JQN
C
C Local variables
C
      INTEGER :: IJ, IT
C
C*** End of declarations rewritten by SPAG
C
      IT=NT
 100  IJ=NJ
 200  JQN(2,IJ,IT)=IQN(2,IJ,IT)
      JQN(1,IJ,IT)=IQN(1,IJ,IT)
      IJ=IJ-1
      IF(IJ.GT.0)GO TO 200
      IT=IT-1
      IF(IT.GT.0)GO TO 100
      IT=NT
 300  CJ(IT)=CI(IT)
      IT=IT-1
      IF(IT.GT.0)GO TO 300
      RETURN
      END SUBROUTINE PACK
!*==congen.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      PROGRAM CONGEN
      USE GLOBAL_UTILS, ONLY : UTILS_GET_BYTESIZES, UTILS_DATE_TIME
      USE CONGEN_DATA, ONLY : LRATIO, NFTW
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Local variables
C
      INTEGER :: LINTEG, LREAL
      CHARACTER(LEN=8) :: CURDAT
      CHARACTER(LEN=10) :: TIM
C
C*** End of declarations rewritten by SPAG
C
c --- Date stamp output
c      CALL DATEST(CURDAT)
      CALL UTILS_DATE_TIME(CURDAT, TIM)
 
      CALL WRITE_SVN_INFO(NFTW)
 
      WRITE(NFTW,10)CURDAT, TIM
 
 10   FORMAT('1',//,' PROGRAM CONGEN :',//,24X,' DATE = ',A8//,24X,
     &       ' TIME = ',A10,//)
C
C jmc      lreal=8
C jmc      linteg = 4
C jmc      lratio = 2
      CALL UTILS_GET_BYTESIZES(linteg, lreal)
      lratio=lreal/linteg

      WRITE(NFTW,11)LINTEG, LREAL
 11   FORMAT(//'Using ',I3,'-byte integers'/'  and ',I3,'-byte reals'/)
C
C---- Call main routine
C
      CALL CSFGEN
C
      STOP
      END PROGRAM CONGEN

      subroutine pkwf(nod,ieltp,cdo,mdo,     
     &                 idopl,mdop,idcpl,mdcp, 
     &                 nftw,                  
     &                 ndo,ndto,len_ndto,     
     &                 ithis_csf)              
!------------------------------------------------------------------------
!     pkwf() - reformats (packs) the CSF expression into the style used 
!              throughout the rest of Alchemy, that is as a set of
!              replacements from the reference determinant. Adds this 
!              to the end of the array ntdo() from location "ndo".
!
!     On entry to this routine we have the CSF defined for us as
!     followsi (from the projection step):
!
!         i. there are "nod" determinants 
!
!        ii. each determinant is of length "ieltp". 
!    
!       iii. "cdo" contains the coefficient which multiplies each
!            determinant. This is derived from the coupling process.              
!
!        iv. the determinants are stored in "mdo", as a list of 
!            spin orbitals
!                - so it is of lenth nod*ieltp
!
!     The above information is complemented by the analysis in the
!     calling routine which classifies spin orbitals in this CSF 
!     wrt the reference determinant:                      
!
!         v. "idopl" is the number of spin orbs in the reference det 
!                    but not present in this CSF.
!            
!            "mdop()" is the list of those spin orbitals 
!
!        vi. "idcpl"  is the number of spin orbs in this CSF 
!                     but not present in the reference determinant
!                      
!            "mdcp()" is the list of those spin orbitals.
!
!                     
!     So, given all of the above information, the determinants in 
!     "mdo" are processed and each expressed in the format
!
!            number of replacements from ref determinant
!            list of replaced spin orbitals
!            list of replacing spin orbitals
!
!     The output is placed into array "ndto". The length available
!     in "ndto" is passed into the routing in "len_ndto" and this is
!     monitored to be sure we do not overflow it.
!                     
!     During the process, it may be necessary to multiply "cdo" by
!     -1 as we order spin orbitals. cdo() holds the coefficients 
!     associated with each determinant. These were constructed earlier
!     in the spin projection - note we only receive the relevant 
!     "piece" of the cdo(0 array in the arglist, the bit for this CSF,
!     not all of it for all CSFs, as is the case with "ndto()".
!
!     "nftw" is the logical unit for the printer                      
!
!-----------------------------------------------------------------------
!
!-----------------------------------------------------------------------
! MAL 11/05/2011: Changes made here are to bring the subroutine into
! line with the changes that were made in 'projec' in order to utilize
! dynamic memory and to comply with the F95 standard.
!-----------------------------------------------------------------------
      USE precisn
      implicit none
!  
!..... Double precision variables passed in the argument list
!
      REAL(KIND=wp)              :: cdo(nod)  ! coupling coeffs for each deterinant
!
!..... Integer variables passed in the arugment list
!                      
      integer nod      ! number of determinants
      integer ieltp    ! number of electrons in each determinant
!
      integer idopl, mdop(idopl) ! S.O.s in refdet but not in this CSF.
!
      integer idcpl, mdcp(idcpl) ! S.O.s in this CSF but not ref det.
!      
      integer mdo(nod*ieltp)     ! the determinants on input 
!
      integer nftw               ! logical unit for the printer 
!      
      integer len_ndto, ndto(len_ndto) ! the determinants on output 
!      
      integer ndo      ! On output points to the highest location used
                       ! in array ndto                       
!
      integer ithis_csf ! The present CSF index - helpful in error msgs.
!
!....  Local integer variables
!       
      integer  i, j, k, n, nc, nd, md, mdopi
!
      integer  mdi(idcpl+ieltp) ! Temporary workspace array
!
      integer  nt(idopl)        ! Temporary workspace array
!
!..... Local logical variables
!
      logical, parameter :: zdebug = .false.
!
!---- Debug banner header 
!
      if(zdebug)then
        write(nftw,1000)
        write(nftw,1010) nod,ieltp
!
        write(nftw,1020) 
        md = 0
        do i=1,nod
           write(nftw,1022) i, cdo(i),(mdo(md+j),j=1,ieltp)     
           md = md + ieltp
        end do 
!
        write(nftw,1030) idopl,(mdop(i),i=1,idopl)
        write(nftw,1040) idcpl,(mdcp(i),i=1,idcpl)
!
        write(nftw,1080) len_ndto              
      endif
!
!---- Special case is where idopl is 0. There is no work to be done.
!      
!     We have same spin orbitals as the reference determinant. 
!
      if(0 .eq. idopl)then
        ndto(ndo) = 0
        ndo       = ndo + 1
!
        goto 800 
      endif 
!
!---- Loop over all determinants in this CSF
!
!     "md" points at the location of the input determinant 
!          as we work though the list. Remember that each is 
!          of length ieltp.
!
      md=0
!      
      do k=1,nod
!
!....... Populate mdi() with the list of spin orbitals in this 
!        CSF but not in the reference determinant. 
!      
         do i=1,idcpl
            mdi(i) = mdcp(i)
         end do
!         
         nd = idcpl
!
!....... Copy the current determinant onto the end of array mdi()
!
         do i=1,ieltp
            nd      = nd+1
            mdi(nd) = mdo(md+i)
         end do
!
!....... Extract the list of spin orbitals which have replaced
!        those in the reference determinant but not present in 
!        this CSF - as defined by array MDOP().  
!
!        We build "nt()" are a set pointers into mdi(). 
!         
         nd = 0
!
         DO 190 I=1,IDOPL
            MDOPI=MDOP(I)
            DO 160 J=1,IDOPL
               IF (MDI(J) .EQ. MDOPI) THEN
                 IF (I .NE. J) THEN
                   CDO(K)=-CDO(K)
                   MDI(J)=MDI(I)
                 ENDIF
                 MDI(I)=0
                 GOTO 190
               ENDIF
  160       CONTINUE
            ND=ND+1
            NT(ND)=I
  190    CONTINUE
!
!...... Ok, we now know how long the "packed" determinant is.
!
!       Let's check that we have enough space available in NDTO 
!       in which to store the data.
!
!       This data is: 
!
!                     number of replacements
!                     list of replaced spin orbs
!                     list of replacing spin orbs
!
        if( (ndo+2*nd) .gt. len_ndto )then
          write(nftw,9900)
          write(nftw,9950) k, nod, ndo+2*nd, len_ndto, ithis_csf 
!
          stop 999
        endif
!
!...... Copy the determinant into place in NDTO
!
!       It is useful to remember that "nd" is the number of
!       replacements from the reference determinant
!      
        ndto(ndo) = nd
        nc        = ndo + nd
!        
        do i=1,nd
           n = nt(i)
!           
           ndto(ndo+i) = mdop(n)
           ndto(nc+i)  = mdi(n)
        end do
!
        if(zdebug)then
          write(nftw,5010) k,(ndto(i),i=ndo,ndo+2*nd)
        endif        
!
        ndo = ndo + nd + nd + 1
!
!...... Augment the pointer for the next determinant
! 
        md = md + ieltp
!      
      end do ! End of loop over determinants in this CSF
!
!---- Subroutine return point
!
  800 continue
!      
      if(zdebug)then
        write(nftw,7990) ndo
        write(nftw,8000)
      endif
!      
      return
!
!---- Format statements
!
 1000 format(/,10x,'====> PKWF() <====',/)
 1010 format(10x,'Input data: ',/,                            
     &        10x,'  No. of determinants       (nod) = ',i5,/, 
     &        10x,'  No of electrons per det (ieltp) = ',i5,/)
 1020 format(10x,'  Input determinants: ')
 1022 format(/,10x,'  Determinant ',i5,' Coeffcient = ',f13.6,//, 
     &          10x,'  Spin orbs: ',20(i3,1x),/,(25x,20(i3,1x)))
 1030 format(/,10x,'  No. spin orbs in the reference det ',/,         
     &          10x,'  but not present in this CSF (idopl) = ',i5,//, 
     &          10x,'  mdop: ',10(i3,1x),/,(16x,10(i3,1x)))
 1040 format(/,10x,'  No. spin orbs in this CSF but ',/,         
     &          10x,'  not present in ref det (idcpl) = ',i5,//, 
     &          10x,'  mdcp: ',10(i3,1x),/,(16x,10(i3,1x)))
 1080 format(/,10x,'Space available in ndto() = ',i10,/)
!
 5010 format(/,10x,'Packed format for determinant ',i5,': ',//,
     &          (10x,20(i3,1x)))
!
 7990 format(/,10x,'On output: ',/,
     &          10x,'   Highest location in ndto()  (ndo) = ',i10,/) 
!      
 8000 format(/,10x,'**** PKWF() - completed',/)
!
 9900 format(/,10x,'***** Error in: PKWF() ',/)
 9950 format(10x,'There is not enough space in NDTO to store the ',/,
     &        10x,'present determinant (',i4,' of ',i4,' ). ',/,      
     &        10x,'Space needed = ',i8,' Given (len_ndto) = ',i8,     
     &        10x,'This present CSF number = ',i10,/)      
!
      end subroutine pkwf

      SUBROUTINE PMKORBS(nob,nobe,nsym,mn,mg,mm,ms,
     &                    nsrb,norb,nsrbd,          
     &                    map,mpos,iposit,symtyp)
!
      USE CONGEN_DATA, ONLY : nftw
      IMPLICIT NONE

      INTEGER               :: nob(nsym),nobe(nsym),mpos(nsrb), 
     &                         map(norb)
!     
      INTEGER               :: mn(nsrb),mg(nsrb),mm(nsrb),ms(nsrb)
      INTEGER               :: symtyp,maxspin,imo,emo,ispin,iso,ipos,
     &                         isym,j,jmo,maxmo,minmo,n,amo,nsrbd,
     &                         nsym,iposit,norb,nsrb
!
!     Setting up the following arrays:
!
!       mn()   = orbital number
!       mg()   = ??? destinguish gerade and ungerade
!       mm()   = ??? m-quantum number for degenerate MOs
!       ms()   = spin (for alpha=0, for beta=1)
!       mpos() = flag for positron (for e-=0, for p+=1)
!
!     NOTE: only implemented for poly-atomic code (symtyp=2)  
!
      if (symtyp.ne.2) then
         write(nftw,*) ' ERROR in PMKORBS: calculation with positrons'
         write(nftw,*) '                   only possible for SYMTYP=2'
         write(nftw,*) '                   (abelian groups).'
         write(nftw,*) ' here: SYMTYP=',SYMTYP         
         STOP
      endif

      maxspin=2

!     imo = mo-number
!     iso = so-number
!     ipos = positron-flag 
!          = 0 for 1..nobe(isym)
!          = 1 for nobe(isym)..nob(isym)
      
      imo=0
      iso=0
      emo=0
      do 10 isym=1,nsym

!     electronic MOs

        ipos=0
        maxmo=nobe(isym)
        amo=emo
        do 20 jmo=1,maxmo
          imo=imo+1
          emo=emo+1
          map(imo)=emo
          do 30 ispin=1,maxspin
            iso=iso+1
            mn(iso)=imo
            mg(iso)=0
            mm(iso)=isym-1
            ms(iso)=ispin-1
            mpos(iso)=ipos
 30       continue     
 20     continue     

!     positronic MOs

        ipos=1
        minmo=nobe(isym)+1
        maxmo=nob(isym)
!        shift=ipos*nobe(isym)
        emo=amo
        do 40 jmo=minmo,maxmo
          imo=imo+1
          emo=emo+1
!          map(imo)=imo-shift
          map(imo)=emo
          do 50 ispin=1,maxspin
            iso=iso+1
            mn(iso)=imo
            mg(iso)=0
            mm(iso)=isym-1
            ms(iso)=ispin-1
            mpos(iso)=ipos
 50       continue     
 40     continue     

 10   continue

      nsrb=iso

!     output the labels
      WRITE(nftw,*) ' MAP : OLD, NEW'
      DO 810 N=1,norb
      WRITE(nftw,*) N,MAP(N)
 810  CONTINUE

      write(6,*) '                  I         N         G         M    
     &      S      MPOS    '
!
      DO 950 J=1,NSRB
         WRITE(6,3000)J,MN(J),MG(J),MM(J),MS(J),MPOS(J)
 950  CONTINUE
!
 3000 FORMAT(10X,7I10)
!
!     Control number of spin orbitals
!     
      WRITE(6,*) 'GIVEN NSRBD=',NSRBD
      WRITE(6,*) 'CALCULATED NSRB=', NSRB

      IF (NSRB .NE. NSRBD) THEN
         WRITE(6,1010) NSRB,NSRBD
 1010    FORMAT(' HELP!!! MKORBS: NSRB, NSRBD = ',2I6)
         STOP
      ENDIF
!
      RETURN
!
      END SUBROUTINE PMKORBS
 
      subroutine popnwf(nsrb,nsrbs,nelt,ndtrf,mopmx,mdop, 
     &                   mdcp,mop,mdc,mdo,ndta,nod,nda,    
     &                   idop,idcp,ieltp,nalm)
!***************************************************************************
!
!
!     OUTPUT IDOP        NO OF SO IN DR BUT NOT IN DC
!            MDOP(NELT)        SO IN DR BUT NOT IN DC
!            IDCP        NO OF SO IN DC BUT NOT IN DR
!            MDCP(NELT)        SO IN DC BUT NOT IN DR
!            IELTP       NO OF SO IN OPEN SHELLS FOR A DTR
!            MOP(MOPMX)  SO
!
!     Linkage:
!
!             None
!
!     Notes:
!
!       In the original code there was a common block
!      
!          /OWF/ IDOP,IDCP,IELTP
!
!     which was used to pass three integer values back to the 
!     caling routine. these have now been placed into the
!     argument list; correspondingly the routine WFGNTR has
!     been modified. It is the only routine whihc calls this 
!     one. the purpose of the variables is as follows:
!
!            IDOP  holds the number of entries in MDOP 
!            IDCP  holds the number of entries in MDCP
!            IELTP is the number of electrons in open shell
!
!***************************************************************************
      USE precisn
      implicit none
!
!..... Integer variables passed in the argument list 
!
      integer nsrb
      integer nsrbs
      integer nelt
      integer nod   ! Number of replacements from reference
      integer nalm  ! Output - return code
                    !   =0,    NORMAL EXIT
                    !   =1,    DIFFERENT NELTP
                    !   =2,    NEED MORE SPACE FOR MOP
                    !   =3,    NELTP=0, BUT NOD NOT =1
!
      integer :: ndtrf(nelt) ! Input: the reference determinant
!
      integer :: mdc(nsrb) ! Workspace: spin orbs in closed shell, 
                           !            common to all determinants 
!
      integer :: mdo(nsrb) ! Workspace: Union of all spin-orbs
                           !            in open shell  
!
      integer :: ndta(nsrb) ! Workspace: to expand to full determinant
!
      integer :: mopmx      ! Maximum size of the mop() array
      integer :: mop(mopmx) ! Spin-orbs 
!
      integer :: mdop(nelt)
      integer :: mdcp(nelt)
!
      integer :: nda(*) ! Input - the array of packed determinants 
                        !         on which we work
!
      integer idop, idcp, ieltp
!
!..... Local integer variables
!
      integer i, k, m, md, me, n, na, nb, ndo, ndc, nod2, nd, no
!
      integer ndop, ndcp, neltp
!
!..... Local fixed integer values
!
      integer, parameter :: nftw = 6 ! logical unit for printer
!
!..... Local fixed logical values
!
      logical, parameter :: zdebug = .false.
!
!---- Debug banner header
!
      if(zdebug)then
        write(nftw,1000)
        write(nftw,1010) nsrb,nsrbs,nelt,mopmx,nod
        write(nftw,1020) (ndtrf(i),i=1,nelt)
      endif                        
!
!---- Initialize the return data 
!
      idop  = 0 
      idcp  = 0
      ieltp = 0
!
      nalm  = 0
!
!---- Initialize local data 
!
      ndop  = 0 
      ndcp  = 0
      neltp = 0
!
!======================================================================
!
!    S T E P :  1
!
!======================================================================
!
!     We build NDTA() which repesents the spin-orbitals used in this
!     CSF. 
!
!     We start by initializing NDTA which is of length equal to the 
!     number of spin-orbitals in the system. 
!
      do i=1,nsrb
         ndta(i) = 0
      end do
!
!---- Now loop over the reference determinant and for every spin-orbital
!     within it, we mark that spin orbital to be populated in EVERY 
!     determinant of this CSF. Thus we set its value in NDTA to be 
!     equal to the number of determinants in this CSF. 
!
      do i=1,nelt
         ndta( ndtrf(i) ) = nod
      end do
!
!---- Loop over all determinants in this CSF and modify the
!     count per spin-orb in ndta()
!
      md = 1
!
      do i=1,nod
         m = nda(md)
!
!....... Loop over all replacement/replacing spin-orbitals
!
!        For each replaced spin-orb, we decrement its count in 
!        ndta() and for each replacing spin-orb, we increment 
!        its count in ndta.
!
         do k = md+1,md+m
            ndta( nda(k) )   = ndta( nda(k)   ) - 1
            ndta( nda(k+m) ) = ndta( nda(k+m) ) + 1
         end do
!
!....... Update the pointer "md" to be at the start of the 
!        next determinant. That is the value which defines
!        the number of replacements in that determinant. 
!
         md = md + 2*m + 1
      end do
!
      if(zdebug)then
        write(nftw,1500) nod, (i,ndta(i),i=1,nsrb)
      endif
!
!==========================================================================
!
!    S T E P :  2
!
!==========================================================================
!
!---- We loop over all "orbitals" which are not lambda-degenerate
!
!     This means all sigma type orbitals when dealing with C_inf_v
!     and ALL orbitals when dealing with D2h and sub-groups.
!
!     Given we have set the occupancy of an occupied spin-orbital
!     to "nod" initially, then since each orbital is composed of 
!     TWO spin orbitals, we will know that the orbital is full
!     if its occupancy is 2*nod. It may or may have been processed
!     in the list of determinants. Remember that NDTA() is summed
!     over ALL determinants in the CSF. 
!
!     Following code: 
!
!         1. Examines each orbital 
!
!         2. If an orbital is FULL, we store the constituent
!            spin-orbs in MDC()
!
!         3. Otherwise we store in MDO() 
!
!     Note: this code works at the orbital level but produces output
!           at the spin-orbital level
!
      nod2 = nod + nod
!
      ndo = 0
      ndc = 0
!
      do i=1,nsrbs,2
         if(ndta(i)+ndta(i+1) .eq. nod2)then 
           mdc(ndc+1) = i             ! Fully occupied
           mdc(ndc+2) = i + 1
           ndc        = ndc + 2
         else
           if(ndta(i) .ne. 0)then     ! Partially occupied
             ndo      = ndo + 1
             mdo(ndo) = i
           endif
!
           if(ndta(i+1) .ne. 0)then
              ndo      = ndo + 1
              mdo(ndo) = i + 1
           endif
         endif
      end do
!
!---- We do the same thing again but now for lambda-degenerate
!     orbitals - of any exist.
!
!     Of course the occupany is 4*nod.
!
      nod2 = nod2 + nod2
!
      do i=nsrbs+1,nsrb,4
         nd = ndta(I) + ndta(i+1) + ndta(i+2) + ndta(i+3)
!
         if(nd .eq. nod2)then
           do k=i,i+3
              ndc      = ndc + 1
              mdc(ndc) = k
           end do
         else
           do k=i,i+3
              if(ndta(k) .ne. 0)then
                ndo      = ndo + 1
                mdo(ndo) = k
             endif
           end do
         endif
      end do
!
      if(zdebug)then
        write(nftw,2050) ndc, ndo
        write(nftw,2053) (mdc(i),i=1,ndc)
        write(nftw,2055) (mdo(i),i=1,ndo)
      endif
!
!==========================================================================
!
!    S T E P :  3
!
!==========================================================================
!
!---- ndta() is an array with one entry for each spin-orbitals
!
!     First we zeroize the array 
!
      do i=1,nsrb
         ndta(i)=0
      end do
!
!---- Next we mark any spin-orbital in the reference determinant
!     as being occuiped in ndta()
!
!
      do i=1,nelt
         n       = ndtrf(i)
         ndta(n) = 1
      end do
!
      IF (NDC .EQ. 0) THEN
         DO 330 I=1,NELT
  330    MDOP(I)=NDTRF(I)
         NDOP=NELT
         NDCP=0
         GOTO 400
      ENDIF
!
      do I=1,NDC
         N=MDC(I)
         NDTA(N)=NDTA(N)+1
      end do
!
      NDOP=0
      DO 360 I=1,NELT
         N=NDTRF(I)
         IF (NDTA(N) .EQ. 2) GOTO 360
           NDOP=NDOP+1
           MDOP(NDOP)=N
  360 CONTINUE
!
      NDCP=0
      DO 370 I=1,NDC
         N=MDC(I)
         IF(NDTA(N) .EQ. 2) GOTO 370
           NDCP=NDCP+1
           MDCP(NDCP)=N
  370 CONTINUE
!
  400 NELTP=NELT-NDC
!  
      IF (NELTP .EQ. 0) THEN
         IF (NOD .EQ. 1) GOTO 470
         NALM=3
         goto 800
      ENDIF
!
      do i=1,nsrb
         ndta(i)=0
      end do
!
      do i=1,nelt
         n = ndtrf(i)
         ndta(n) = 1
      end do
!
      do I=1,NDO
         N=MDO(I)
         NDTA(N)=NDTA(N)+1
         MDC(I)=NDTA(N)
      end do
!
!---- Loop over all determinants in the CSF
!
      NO=0
      MD=1
!
      do i=1,nod
         M=NDA(MD)
         ME=MD+M
!
         do K=1,M
            NA=NDA(MD+K)
            NB=NDA(ME+K)
            NDTA(NA)=NDTA(NA)-1
            NDTA(NB)=NDTA(NB)+1
         end do
!
         do k=1,ndo
            n = mdo(k)
!               
            if(ndta(n) .eq. 2)then
              no = no + 1
!                 
              if(no .gt. mopmx)then
                write(nftw,9900)
                write(nftw,9940) i,no, mopmx
                stop 999
              endif
!
              mop(no) = n
            endif
!
            ndta(n) = mdc(k)
         end do
!      
         md = md + m + m + 1
      end do
!
      IF(MOD(NO,NOD) .NE. 0) THEN
        write(nftw,9900)
        stop 999
      ENDIF
!
!---- We reach this point if all has gone successfully
!
!     We copy the work variables into the return variables.
!
!     And then set a return code of success (nalm=0)
!
  470 continue
!
      IDOP=NDOP
      IDCP=NDCP
      IELTP=NELTP
!
      nalm = 0
!
!---- Subroutine return point
!
  800 continue
!
      if(zdebug)then
        write(nftw, 7990) idop, idcp, ieltp
!
        write(nftw, 7992) 
        write(nftw, 7996) (mdop(i),i=1,idop)
        write(nftw, 7994) 
        write(nftw, 7996) (mdcp(i),i=1,idcp)
!
        write(nftw, 7995) nalm
        write(nftw ,8000)
      endif
!
      return
!      
!---- Format statements
!
 1000 format(/,25x,'====> POPNWF() <====',/)
 1010 format(/,25x,'Input data: ',/,                                  
     &          25x,'  No. of spin orbitals          (nsrb) = ',i10,/, 
     &          25x,'  No .of sigma-type spin orbs  (nsrbs) = ',i10,/, 
     &          25x,'  No. of electrons              (nelt) = ',i10,/, 
     &          25x,'  Units available in mop()     (mopmx) = ',i10,/, 
     &          25x,'  No. of dets in this CSF        (nod) = ',i10,/)
 1020 format(27x,'Ref det = ',10(i5,1x),/,(37x,10(i5,1x)))
! 
 1500 format(/,25x,'Expanded determinant (NDTA) representation after',/,
     &          25x,'processing all (',i6,') dets within the ',/,
     &          25x,'present CSF.                            ',//,
     &          25x,'Spin Orb.   Count ',/,
     &          25x,'---------  -------',/,
     &          (25x,i9,2x,i7))
!               
 2050 format(/,25x,'After step 2 we have; ',//,
     &          25x,'  Number of closed orbtials (ndc) = ',i6,/,
     &          25x,'  Number of open   orbitals (ndo) = ',i6,/)
 2053 format(25x,'Closed orbitals: ',20(i3,1x),/,(20x,20(i3,1x)))
 2055 format(25x,'Open   orbitals: ',20(i3,1x),/,(20x,20(i3,1x)))
!
 7990 format(/,25x,'Output data: ',/,                                 
     &          25x,'                                (idop) = ',i10,/, 
     &          25x,'                                (idcp) = ',i10,/, 
     &          25x,'  No. electrons in open shells (ieltp) = ',i10,/)
 7992 format(27x,'Spin orbitals in DR but not DC: ',/)
 7994 format(/,27x,'Spin orbitals in DC but not DR: ',/)
 7996 format(27x,9(i4,1x))
 7995 format(/,25x,'Return code (nalm) = ',i10,/)
!
 8000 format(/,25x,'**** Completed - POPNWF() ',/)
!
 9900 format(/,25x,'**** Error in; POPNWF() ',/)
 9940 format(/,25x,'Exceeded size of mop() ',//,  
     &          25x,'   Determinant num (i) = ',i6,/,
     &          25x,'   spin orbital   (no) = ',i6,/,
     &          25x,'   mopmx               = ',i6,/)        
!
      end subroutine popnwf




 
 
!*==print1.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE PRINT1(QNSTOR)
      USE global_utils, ONLY : GETIN
      USE CONGEN_DATA, ONLY : CONFPF, NDIST, NE, NSHL, NTYP,
     &                        OCCSHL, PQNR=>PQNST, MSHL, GUSHL, QNSHL,
     &                        NNELCG=>NNLECG, SYMTYP, NFTW, BLNK43, 
     &                        HEADER, LP, STAR, NITEM
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER, DIMENSION(*) :: QNSTOR
      INTENT (IN) QNSTOR
C
C Local variables
C
      INTEGER :: I, II, IMAX, J, JJ, K, KF, KI, KLABEL, LT, LTA, NLEX, 
     &           NSTAR
      CHARACTER(LEN=4), DIMENSION(3,4) :: LABEL=RESHAPE( (/' NTY', 
     &  'P=XX', 'X   ', ' NDI', 'ST=Y', 'YYY ', ' NST', 'ATE=', 'ZZZ ',
     &   '    ', '    ', '    '/) , (/ 3, 4/) )
      CHARACTER(LEN=1), DIMENSION(12,4) :: LABELL
C
C*** End of declarations rewritten by SPAG
C
      EQUIVALENCE(LABEL(1,1),LABELL(1,1))
C
C     PRINT TYPE(CONFPF.GE.1) AND DISTRIBUTION DATA (CONFPF.GE.20)
C
      NE=NNELCG
      IF(CONFPF.LT.1)RETURN
      NLEX=0
      IF(SYMTYP.EQ.1)NLEX=1
      NSTAR=20+MIN(NITEM,NSHL)*12
C
      KLABEL=1
      CALL GETIN(NTYP,3,LABELL(7,1),0)
      IF(CONFPF.GT.1 .OR. NTYP.EQ.1)GO TO 20
      CALL TADDL1(5+(6+NLEX)*((NSHL+NITEM-1)/NITEM),LTA)
      IF(LTA.EQ.0)GO TO 20
      CALL SPACE(2)
      GO TO 22
 20   CALL NEWPG
 22   DO I=1, NSHL, NITEM
         IMAX=MIN(I+NITEM-1,NSHL)
         CALL ADDL(5+NLEX)
         WRITE(NFTW, 5020) (LABEL(J,KLABEL),J=1,3), HEADER(1), 
     &                     (J,J=I,IMAX)
 5020    FORMAT(3A4,A8,I8,8I12)
         WRITE(NFTW, 5020) BLNK43, HEADER(2), (OCCSHL(J),J=I,IMAX)
         WRITE(NFTW, 5020) BLNK43, HEADER(3), (MSHL(J),J=I,IMAX)
         IF(SYMTYP.EQ.1)WRITE(NFTW, 5020) BLNK43, HEADER(4), 
     &                        (GUSHL(J),J=I,IMAX)
C
C     PRINT OCCSHL AND SYM DATA
C
         KLABEL=4
         WRITE(NFTW, 25) BLNK43, HEADER(5), (LP,(PQNR(JJ,J),JJ=1,3),
     &                   J=I,IMAX)
 25      FORMAT(3A4,A8,9(A3,2(I2,','),I2,')'))
         IF(SYMTYP.LT.2)THEN
            WRITE(NFTW, 25) BLNK43, HEADER(6), 
     &            (LP,(QNSHL(JJ,J),JJ=1,3),J=I,IMAX)
         ELSE
            WRITE(NFTW, 5020) BLNK43, HEADER(6), (QNSHL(1,J),J=I,IMAX)
         END IF
         CALL SPACE(1)
      END DO
C
C     BYPASS PRINTING OF DISTRIBUTIONS IF NOT REQUIRED
C
      IF(CONFPF.LT.20)GO TO 200
C
C     PRINT ROW OF STAR SEPARATOR
C
      CALL TADDL(1,LT)
      IF(LT.GT.0)WRITE(NFTW, 5105) (STAR,J=1,NSTAR)
 5105 FORMAT(' ',132A1)
      CALL SPACE(1)
      KF=0
      DO II=1, NDIST
         KLABEL=2
         CALL GETIN(II,4,LABELL(8,2),0)
         DO I=1, NSHL, NITEM
            IMAX=MIN(I+NITEM-1,NSHL)
            CALL ADDL(4+NLEX)
            WRITE(NFTW, 5020) (LABEL(J,KLABEL),J=1,3), HEADER(1), 
     &                        (J,J=I,IMAX)
            WRITE(NFTW, 5020) BLNK43, HEADER(2), (OCCSHL(J),J=I,IMAX)
            WRITE(NFTW, 5020) BLNK43, HEADER(3), (MSHL(J),J=I,IMAX)
            IF(SYMTYP.EQ.1)WRITE(NFTW, 5020) BLNK43, HEADER(4), 
     &                           (GUSHL(J),J=I,IMAX)
            KLABEL=4
            KI=KF+1
            KF=KI+(IMAX-I)
            WRITE(NFTW, 5020) BLNK43, HEADER(5), (QNSTOR(K),K=KI,KF)
            CALL SPACE(1)
         END DO
      END DO
C
C     MERGE CONFPF.GE.1 AND CONFPF.GE.20 PATHS
C
 200  CALL ADDL(1)
      WRITE(NFTW, 205) NTYP, NDIST
 205  FORMAT(' ',19('*'),5X,'TOTAL NUMBER OF DISTRIBUTIONS FOR NTYP =',
     &       I3,' IS',I5)
      IF(CONFPF.LT.10)RETURN
C
C     PREPARE FOR STATE PRINTING
C
      CALL SPACE(1)
      CALL TADDL(1,LT)
      IF(LT.GT.0)WRITE(NFTW, 5105) (STAR,J=1,NSTAR)
      CALL SPACE(1)
      RETURN
      END SUBROUTINE PRINT1
!*==print2.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE PRINT2(IIDIS1)
      USE global_utils, ONLY : GETIN
      USE CONGEN_DATA, ONLY : CONFPF, NCSF, NDIST, NSHL, NSTATE,
     &                        CUP, QNSHL, SYMTYP, NFTW, BLNK43, 
     &                        HEADER, LP, NITEM
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: IIDIS1
      INTENT (IN) IIDIS1
C
C Local variables
C
      INTEGER :: I, IMAX, J, JJ, KF, KI, KLABEL, NCSFF, NCSFI, NSHLM1
      CHARACTER(LEN=4), DIMENSION(3,4) :: LABEL=RESHAPE( (/' NTY', 
     &  'P=XX', 'X   ', ' NDI', 'ST=Y', 'YYY ', ' NST', 'ATE=', 'ZZZ ',
     &   '    ', '    ', '    '/) , (/ 3, 4/) )
      CHARACTER(LEN=1), DIMENSION(12,4) :: LABELL
C
C*** End of declarations rewritten by SPAG
C
      EQUIVALENCE(LABEL(1,1),LABELL(1,1))
C
C     PRINT STATE DATA
C
      NSHLM1=NSHL-1
      IF(CONFPF.LT.10)RETURN
      CALL GETIN(NSTATE,3,LABELL(9,3),0)
      IF(NSHLM1.GT.0)GO TO 320
      CALL ADDL(1)
      WRITE(NFTW, 5020) (LABEL(J,3),J=1,3)
 5020 FORMAT(3A4,A8,I8,8I12)
      RETURN
 320  KF=NSHL
      KLABEL=3
      DO I=1, NSHLM1, NITEM
         IMAX=MIN(I+NITEM-1,NSHLM1)
         CALL ADDL(2) ! JMC argument should probably be 3 as there are 3 writes below???
         WRITE(NFTW, 25) (LABEL(J,KLABEL),J=1,3), HEADER(7), 
     &         (LP,(CUP(JJ,J),JJ=1,3),J=I,IMAX)
 25      FORMAT(3A4,A8,9(A3,2(I2,','),I2,')'))
         KLABEL=4
         KI=KF+1
         KF=KI+(IMAX-I)
         WRITE(NFTW, 25) BLNK43, HEADER(6), (LP,(QNSHL(JJ,J),JJ=1,3),
     &                   J=KI,KF)
         IF(SYMTYP.LT.2)THEN
            WRITE(NFTW, 25) BLNK43, HEADER(6), 
     &            (LP,(QNSHL(JJ,J),JJ=1,3),J=KI,KF)
         ELSE
            WRITE(NFTW, 5020) BLNK43, HEADER(6), (QNSHL(1,J),J=KI,KF)
         END IF
         CALL SPACE(1)
      END DO
C
C     PRINT CSF NUMBERS FOR THIS STATE
C
      IF(IIDIS1.EQ.0)GO TO 323
      NCSFI=NCSF-IIDIS1+1
      NCSFF=NCSF
      GO TO 324
 323  NCSFI=NCSF+1
      NCSFF=NCSF+NDIST
 324  CALL ADDL(1)
      WRITE(NFTW, 350) NCSFI, NCSFF, NSTATE
 350  FORMAT(' ',19('*'),5X,'CSF NUMBERS',I6,' TO',I6,
     &       ' GENERATED FOR NSTATE=',I3)
      CALL SPACE(1)
      RETURN
      END SUBROUTINE PRINT2
!*==print3.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE PRINT3(IIDIS1,I13)
      USE CONGEN_DATA, ONLY : CONFPF, NCSF, NDIST, NSHL, NSTATE, NTYP,
     &                        NFTW, STAR, NITEM
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: I13, IIDIS1
      INTENT (IN) I13, IIDIS1
C
C Local variables
C
      INTEGER :: I, J, LT, NCSFI, NSTAR, NSTOT
C
C*** End of declarations rewritten by SPAG
C
C     PRINT SUMMARY DATA
C
      IF(I13.NE.2)THEN
         NSTOT=IIDIS1
      ELSE
         IF(CONFPF.LT.1)RETURN
         NSTOT=NSTATE*NDIST
      END IF
      NCSFI=NCSF+1-NSTOT
      IF(CONFPF.GE.40)CALL SPACE(1)
      CALL ADDL(2)
      WRITE(NFTW, 420) NTYP, NSTATE, NCSFI, NCSF, NSTOT
 420  FORMAT(' ',19('*'),5X,'TOTAL NUMBER OF STATES FOR NTYP=',I3,' IS',
     &       I4/20X,'CSF NUMBERS',I10,' TO',I10,' (',I9,
     &       ' CSFS) GENERATED')
      NSTAR=20+MIN(NITEM,NSHL)*12 ! JMC see PRINT1 to understand where this hardwiring has come from
      DO I=1, 2
         CALL TADDL(1,LT)
         IF(LT.GT.0)WRITE(NFTW, 5105) (STAR,J=1,NSTAR)
 5105    FORMAT(' ',132A1)
      END DO
      RETURN
      END SUBROUTINE PRINT3
!*==print4.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE PRINT4(ND,X,IX)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE CONGEN_DATA, ONLY : NE, NFTW
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: ND
      INTEGER, DIMENSION(*) :: IX
      REAL(KIND=wp), DIMENSION(*) :: X
      INTENT (IN) IX, ND, X
C
C Local variables
C
      INTEGER :: IE, IND, IP, IPI, IT, J, NL, NITEM
C
C*** End of declarations rewritten by SPAG
C
C     PRINT DETERMINANT AND SPIN-ORBITAL DATA
C
C
      IPI=0
      IT=1
      NITEM=20
      NL=(NE+NITEM-1)/NITEM
      DO IND=1, ND
         CALL ADDL(NL+IT)
         IF(IT.NE.0)THEN
            WRITE(NFTW, 515) ND
 515        FORMAT(30X,'NUMBER OF DET IS',I3)
            IT=0
         END IF
         DO IE=1, NE, NITEM
            IP=IPI+1
            IPI=IP+MIN(NITEM-1,NE-IE)
            IF(IE.NE.1)THEN
               WRITE(NFTW, 525) (IX(J),J=IP,IPI)
 525           FORMAT(45X,20I4)
            ELSE
               WRITE(NFTW, 535) IND, X(IND), (IX(J),J=IP,IPI)
 535           FORMAT(I25,5X,E15.8,20I4)
            END IF
         END DO
      END DO
      CALL SPACE(1)
      RETURN
      END SUBROUTINE PRINT4
!*==print5.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE PRINT5(ND,NDI)
      USE CONGEN_DATA, ONLY : NCSF, NFTW
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: ND
      INTEGER, DIMENSION(*) :: NDI ! jmc changing the dimension from 2
      INTENT (IN) ND, NDI
C
C Local variables
C
      INTEGER :: IND, IP, IPI, J, NREP
C
C*** End of declarations rewritten by SPAG
C
      IP=1
      DO IND=1, ND
         NREP=NDI(IP)
         IF(NREP.NE.0)GO TO 640
         CALL ADDL(1)
         WRITE(NFTW, 620) IND, NREP
 620     FORMAT(35X,2I5)
         IF(IND.EQ.1)WRITE(NFTW, 630) NCSF ! JMC why isn't there a call addl(1) in an if block with this write???
 630     FORMAT('+',29X,I5)
         GO TO 680
 640     CALL ADDL(2)
         IPI=IP+1
         IP=IP+NREP
         IF(IND.EQ.1)GO TO 660
         WRITE(NFTW, 650) IND, NREP, (NDI(J),J=IPI,IP)
 650     FORMAT(35X,2I5,21I4/(45X,21I4))
         GO TO 670
 660     WRITE(NFTW, 665) NCSF, IND, NREP, (NDI(J),J=IPI,IP)
 665     FORMAT(30X,3I5,21I4/(45X,21I4))
 670     IPI=IP+1
         IP=IP+NREP
         WRITE(NFTW, 675) (NDI(J),J=IPI,IP) ! JMC why isn't there a call addl(1) here???
 675     FORMAT(45X,21I4)
 680     IP=IP+1
      END DO
      RETURN
      END SUBROUTINE PRINT5

      subroutine prjct(nelt,mxss,nodi,ndo,cdi,nodo,cdo,maxcdo,       
     &                  mgvn,iss,isd,thres,r,ndtr,mm,ms,maxndo,symtyp,
     &                  nsrb)
!**********************************************************************
!
!     This routine applies the Lowdin projection operator. More details
!     can be found in the literature at for example:
!
!       Nelson F Beebe and Sten Lucil, J Phys B: At Mol Phys
!                                      Vol. 8, Issue 14, 1975, p2320
!
!     This routine is called when a CSF is found to have two, or
!     more electrons in open shells. Each pair of spin-orbitals in
!     each determinant is examined and potentially used to create a 
!     new determinant. Thus the output expression for the CSF 
!
!                nodo, cdo(), ndo()
!
!     may be much larger than the input 
!
!                nodi, cdi(), ndo()                       
!                       
!     Note reuse of ndo() here. cdi() is used an an extendable buffer
!     too and must have more than "nodi" elements.
!
!     The generated list of determinants is examined for any with
!     very small coefficients (thres) and these are removed. Thus the
!     the list may grow and shrink in this routine.                    
!
!     Of course the nature of the projection process is controlled
!     by the quantum numbers input.
!                       
!     The routine terminates with an error message if any error
!     conditions are found.
!                       
!**********************************************************************
      USE precisn
      implicit none
!
!..... Double precision variables passed in the argument list
!
      REAL(KIND=wp)              :: r           ! +1.0 for Sigma(+), 
                                                ! -1.0 for Sigma(-)
      REAL(KIND=wp)              :: thres       ! Determinants with coefficients 
                                                ! < thres are deleted
!
      REAL(KIND=wp)              :: cdi(*)      ! Expansion coeffs of each det 
                                                ! on input - grows as the routine
                                                ! adds new determinants to the CSF
      REAL(KIND=wp)              :: cdo(maxcdo) ! On output holds the expansion 
                                                ! coefficients for all determinants
!
!..... Local double precision variables      
!
      REAL(KIND=wp)              :: fcta,fctb,fctc,fctr,tmp
      REAL(KIND=wp), parameter   :: zero = 0.0_wp      
      REAL(KIND=wp), parameter   :: one  = 1.0_wp      
      REAL(KIND=wp), parameter   :: four = 4.0_wp      
!
!..... Integer variables passed in the argument list
!
      integer                    :: nelt    ! # of electrons in open shells (i.e. per det)
      integer                    :: mxss    ! max S for projecttion operator
      integer                    :: nodi    ! Number of determinants in CSF on input 
      integer                    :: nodo    ! Number of determinants in CSF in output
      integer                    :: maxcdo  ! Max size of cdo()
      integer                    :: maxndo  ! Max size of ndo()
      integer                    :: mgvn    ! Lambda or IRR for CSF
      integer                    :: iss     ! Required S value
      integer                    :: isd     ! Sz for determinants
!
      integer                    :: ndo(maxndo) ! Input determinants - overwitten
      integer                    :: ndtr(nsrb)  ! Workspace for building new determinants
      integer                    :: mm(nsrb)    ! Lambda/IRR for each spin orbital
      integer                    :: ms(nsrb)    ! Spin (Sz) of each spin prbital
!
      integer                    :: symtyp      ! Designates C-inf-v, D-inf-h or Abelian
      integer                    :: nsrb        ! Number of spin-orbitals in system 
!
!...., Local integer variables
!
      integer                    :: i, ia, ib, id, idet, is, issp,
     &                               istart,ma,mb,mga,mgb,nd,
     &                               ninitial_dets 
!      
!
!..... Local logical variables
!
      logical, parameter         :: zdebug = .false.
!
!---- External functions called
!      
      REAL(KIND=wp)              :: snrm2
!
      external                   :: snrm2      
!
!---- Banner header
!      
      if(zdebug)then
        write(6,1000) 
        write(6,1010) nelt, mxss, mgvn, iss, isd, thres, maxcdo, 
     &                 maxndo, symtyp, nsrb
        write(6,1020) nodi
!
        do idet=1,nodi
           istart = (idet-1)*nelt
           write(6,1030) idet, cdi(idet), (ndo(istart+i),i=1,nelt)
        end do
      endif     

!
!---- Save the number of determinants in the CSF into a variable
!     for use during diagnostic printing later (if used). 
!
!     The value of "nodi"  may increase during execution of this
!     routine.     
!    
      ninitial_dets = nodi  
!
!---- Compute the pre-multiplcation factors whihc depend only on
!     overal values - number of electrons and overal Spin. 
!
      fcta = -nelt*(nelt - 4)
!
      fctb = iss*(iss + 2)
!      
      issp = iss + 1
!      
!---- We initialize the number of output determinants to be 
!     the same as the number input.
!
      nodo = nodi
!
!---- Copy CSF expansion coefficients from input array to output
!     array before we launch into the loop over Sz components      
!      
      do i=1,nodi
         cdo(i) = cdi(i)
      end do
!
!---- Loop over Sz components of spin 
!
      if(zdebug)then
        write(6,1500) fcta, fctb, issp
      endif      
!
!---- As shown in equation (6) of the Beebe and Stencil 1975 paper,
!     referenced above, the spin ptojector is product over 
!     spin operators. This is instanciated here as the DO loop to 
!     line 180. 
!      

      do 180 is=isd+1,mxss+1,2
!
!....... As hsown in equation (6) we omit the case k=S
!
         if(is .EQ. issp) goto 180
!
!....... Compute coefficient multiplication factors for this Sz 
!
         fctc = (is-1)*(is+1)
         fctr = (fcta - fctc)/(fctb - fctc)
!
         if(zdebug)then
           write(6,2000) is, fctc, fctr
         endif         
!
!....... Copy all existing determinant coefficients for this 
!        CSF into cdo() and in doing so multiply by the factor
!        pertaining to this Sz.
!    
!        "nodo" is the associated length of "cdo"
!         
         do i=1,nodi
            cdo(i) = cdi(i)*fctr
         end do
!
         nodo = nodi
!
!....... Descend into loop over all determinants currently 
!        in this CSF
!
!        This may include determinants that we have created
!        in previous iterations of the loop to line 180 as well
!        as those in the initial input list.
!
!        "nd" points at the location of the determinants in ndo()
!             for each iteration
!
         nd = 0
!         
         do id=1,nodi
!            
            fctr = four*cdi(id)/(fctb - fctc)
!
            if(zdebug)then
               write(6,2005) id, nodi, cdi(id), fctr
               write(6,2006) (ndo(nd+i),i=1,nelt)
            endif
!
!.......... Now descend into loop over all PAIRS of electrons
!
!           This is implemented as a double DO loop to line 150
!
            do 150 ia=2,nelt
               do 150 ib=1,ia-1
!
!................ Copy the determinant from its location in NDO() 
!                 to a temporary area in NDTR().
!
!                 Here, the determinant is composed of "nelt" electrons
!                 and is expressed as a list of occupied spin-orbitals
!               
                  do i=1,nelt
                     ndtr(i) = ndo(nd+i)
                  end do
!
!................ Consider the present pair of electrons and find
!                 their spin
!
!                 The debug here is extremely useful but can generate
!                 massive amounts of output - uncomment if really needed.
!
                  ma  = ndtr(ia)
                  mb  = ndtr(ib)
!                  
                  mga = ms(ma)
                  mgb = ms(mb)
!
                  if(zdebug)then
                    write(6,2010) ia, ma, mga, ib, mb, mgb
                  endif
!
!................ Now look at the spins of this pair.
!
!                 Remember that 0 means spin-up, 1 means spin-down.                  
!                  
!                 Option #    Electron a       Electron b
!                 --------    ----------       ----------
!                    1            0                0
!                    2            1                0                     
!                    3            0                1
!                    4            1                1
!                  
!                 When the spin-orbitals have the same value, that is
!                 options 1 and 4, we can't change them so all we do 
!                 is augment the (output) coefficient of this determinant 
!                 by the required factor - no more work to be done, so
!                 we can proceed to the next electron pair.
!
!                 For options 2 and 3, we can create a new determinant
!                 by switching the electrons around. We preserve the Sz
!                 value by doing that. We rely in the following that the
!                 spin orbitals are created (see ms() mn() ...) in a
!                 particular order ( Orb N spin-up, Orb N spin down,
!                 ...)
!                  
                  if(mga .EQ. mgb)then
                    cdo(id) = cdo(id) + fctr
                    goto 150
                  endif
!                  
                  if(mga .eq. 0)then
                    ma = ma + 1
                    mb = mb - 1
                  else
                    ma = ma - 1
                    mb = mb + 1
                  endif
!
                  ndtr(ia) = ma
                  ndtr(ib) = mb
!
                  if(zdebug)then
                    write(6,2012)
                    write(6,2013) (ndtr(i),i=1,nelt)
                  endif                  
!
!................ We ee to screen to see that the spin-orbitals wei have
!                 just added to the determinant (ma and mb) do not already
!                 occur elsewhere in it. if so, the new determinant
!                 created is not valid and must be rejected. 
!                  
                  do i=1,nelt
                     if( (ndtr(i) .eq. ma) .and. (i .ne. ia) )goto 150
                     if( (ndtr(i) .eq. mb) .and. (i .ne. ib) )goto 150
                  end do
!
!................ Given the "new" determinant just constructed in
!                 "ndtr" with associated coefficient "fctr",
!                 we examine the list of "nodo" determinants for 
!                 this CSF, defined in ndo()/cdo(), and merge
!                 the "new" determinant into the list. This may
!                 mean adding it onto the end of cdo()/ndo() - see
!                 comments in the routine for explanation.
!      
!                 So, stmrg() needs to know the maximum dimensions
!                 of ndo()/cdo() to monitor the extension of these
!                 arrays.
!
!                 "nodo" will be updated on return if we add ndtr()
!                 and fctr into the list.      
!
                  call stmrg(nelt,maxcdo,maxndo,ndo,cdo,nodo,ndtr,fctr)
!
  150          continue ! End of loop(s) over pairs of electrons 
!
!............. End of loop over determinants in this CSF, update 
!              the pointer "nd" to start at next CSF in NDO(). 
!              Remember that a determinant consists of "nelt"
!              consequtive spin orbitals in ndi()     
!                  
            nd = nd + nelt
!            
         end do ! End loop over "nodi" current dets in CSF
!
!....... Remove any determinants whihch have an expansion coefficient 
!        less than "thres".
!
!        Number of elements "nodo" in cdo() and ndo() may actually 
!        decrease here as elemenst are removed.
!
         call cntrct(nelt,nodo,ndo,cdo,thres)
!
!....... If we find that we have no determinants left in the CSF, we 
!        have an error condition.
!         
         if(nodo .eq. 0)then
           write(6,9900)
           write(6,9935) thres
           stop 999
         endif
!                  
!....... Ok, so now copy the full set of coefficients back to 
!        array cdi(). Note that originally cdi() was of length
!        "nodi" but we have added to it. The variable "nodo"
!        now holds the total number of determinants - so we need 
!        to reset "nodi" to that value.          
!
!        We do this because the next iteration of the loop to
!        line 180 starts by copying from cdi().
!
         nodi = nodo
!
         do i=1,nodi
            cdi(i) = cdo(i)
         end do
!
  180 continue
!
!---- For Sigma wavefunctions in C-inf-v/D-inf-h we needed to 
!     consider the reflection symmetry.
!
!     They can be Sigma(+) or Sigma(-)         
!
      if( (symtyp .le. 1) .and. (mgvn .eq. 0) )then
        if(zdebug) write(6,4000)
!
         nodi = nodo
!
         do i=1,nodi
            cdi(i) = cdo(i)
         end do
!
         call rfltn(nelt,nodi,ndo,cdi,r,maxcdo,maxndo, 
     &               thres,nodo,cdo,ndtr,mm,nsrb)
!
         if(nodo .le. 0)then
           write(6,9900)
           write(6,9945) 
           stop 999
         endif
!
      endif
!
!---- Debug printout of the coefficients after spin projection
!      
      if(zdebug)then
        write(6,5000) nodi
        write(6,5010) (i,cdi(i),i=1,nodi) 
      endif
!
!---- Compute inverse sum of squared coefficients
!     and normalize output
!
      tmp = snrm2(nodo,cdo,1)
!      
      tmp = one/SQRT(tmp)
!      
      do i=1,nodo
         cdo(i)=cdo(i)*tmp
      end do
!
!---- Return point 
!      
      continue
!      
      if(zdebug)then
        write(6,7990) nodo
!
        if(nodo .ne. ninitial_dets)then
           ia = nodo - ninitial_dets
           write(6,7995) ninitial_dets,  is
        else
           write(6,7997) 
        endif
!        
        write(6,8000) 
      endif      
!
      return
!
!---- Format statements      
!
 1000 format(/,20x,'====> prjct() - project wavefunction <====',/)      
 1010 format(20x,'Input data: ',/,
     &        20x,'  # electrons  open shell  (nelt) = ',i7,/,
     &        20x,'  Maximum S for projection (mxss) = ',i7,/,
     &        20x,'  Lambda value for Wavefn  (mgvn) = ',i7,/,
     &        20x,'  Required Spin value       (iss) = ',i7,/,
     &        20x,'  Required Sz   value       (isd) = ',i7,/,
     &        20x,'  Threshold               (thres) = ',d13.6,/,
     &        20x,'  Dimension of cdo()     (maxcdo) = ',i7,/,
     &        20x,'  Dimension of ndo()     (maxndo) = ',i7,/,
     &        20x,'  Abelian/C-inf-v flag   (symtyp) = ',i7,/,
     &        20x,'  Number of spin orbs      (nsrb) = ',i7,/)
 1020 format(20x,'No. of dets in this CSF (nodi) = ',i7)      
 1030 format(/,20x,'Det No = ',i7,' Coeff (cdi) = ',d13.6,//, 
     &          20x,'    Sp. orbs in open shells (ndi) = ',20(i3,1x))
!               
 1500 format(/,20x,'Entering loop over components of spin',//,
     &          20x,'  fcta = ',d13.6,/,  
     &          20x,'  fctb = ',d13.6,/,  
     &          20x,'  issp = ',i6,/)
!             
 2000 format(/,20x,'Working on Spin Iteration (is) = ',i5,//,
     &          20x,'  Factor fctc = ',d13.6,/,
     &          20x,'  Factor fctr = ',d13.6,/)
 2005 format(23x,'Working on determinant (id) = ',i5,' of ',i5,/,
     &        23x,'Coefficient, cdi() = ',d13.6,/,
     &        23x,'Factor (fctr)      = ',d13.6,/)
 2006 format(23x,'Current op-shl det: ',20(i3,1x),/,(20x,20(i3,1x)) )
 2010 format(23x,'Evaluating electron pair: ',/,
     &  23x,'  #1: idx(ia) = ',i3,'sporb(ma) = ',i3,' Sz (mga) = ',i3,/,
     &  23x,'  #2: idx(ib) = ',i3,'sporb(mb) = ',i3,' Sz (mgb) = ',i3,/)
 2012 format(23x,'New valid determinant produced by this pair',/)
 2013 format(23x,'New open shell det: ',20(i3,1x),/,(20x,20(i3,1x)) )
!
 4000 format(/,20x,'Analysis of Reflection operator required',/)
!       
 5000 format(/,20x,'Coefficients after projection ',/, 
     &          20x,'  (but not yet normalized)    ',//,
     &          20x,'  No. of determinants (nodi) = ',i6,/)
 5010 format(20x,i4,2x,d13.6)
!
 7990 format(20x,'Final number of determinants in CSF (nodo) = ',i5,/)
 7995 format(20x,'The length of the CSF has changed: ',/,
     &        20x,'    Initial number of dets = ',i6,/,   
     &        20x,'    # of dets added   = ',i6,' by projection',/)
 7997 format(20x,'# of dets in the CSF has NOT changed ',/)
 8000 format(/,20x,'**** prjct() - completed',/)      
!
 9900 format(/,10x,'**** Error in prjct() ',/)
 9935 format(10x,'After removing all determinants with expansion ',/,
     &        10x,'coefficients less than (thres) = ',d13.6,/,       
     &        10x,'there are no determinants left in this CSF',/)       
 9945 format(10x,'After reflection analysis there are no ',/,
     &        10x,'no determinants left in the CSF',/)
!
      end subroutine prjct

!*==projec.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE projec(sname,megul,symtyp,mgvn,s,sz,r,pin,nocsf,byproj,
     &                  idiag,npflg,thres,
     &                  nelt,nsym,nob,ndtrf,nftw,iposit,nob0,nob1,
     &                  nob01,iscat,ntgsym,notgt,nctgt,mcont,gucont,
     &                  mrkorb,mdegen,mflag,nobe,nobp,nobv,maxtgsym,
     &                  lumps)
c
c     Projec controls the projection of the wavefunctions (if byproj .ne
c     and writes out the final wavefunctions plus header information for
c     future use
c
      USE precisn,      ONLY : wp ! for specifying the kind of reals                        
      USE GLOBAL_UTILS, ONLY : mprod 
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C

      INTEGER, INTENT(IN)        :: iscat,mflag
      INTEGER, INTENT(INOUT)     :: ntgsym
      INTEGER                    :: byproj,idiag,iposit,lumps,
     &                               megul,mgvn,nelt,nftw,nocsf,
     &                               nsym,symtyp,npflg(6),
     &                               num_csfs_unproj,num_dets_unproj,
     &                               len_pkd_dets_unproj
      REAL(KIND=wp)              :: pin, r, s, sz,thres 
      CHARACTER(LEN=80)          :: sname 
      INTEGER, DIMENSION(ntgsym) :: gucont,mcont,mdegen,mrkorb, 
     &                               nctgt,notgt 
      INTEGER, DIMENSION(nsym)   :: nob,nob0,nob01,nobe,nobp,nobv
      INTEGER, DIMENSION(nelt)   :: ndtrf 
      INTEGER, DIMENSION(*)      :: nob1
C
C Local variables
C
      INTEGER                    :: i,nalm,nb,nctarg,nd,nl,norb,junk,
     &                                isd,iss,n,k,msum,isum,m,ierr,
     &                                num_dets,nreps,maxndi,maxcdi,
     &                                maxndo,maxcdo,lenndo,lencdo,
     &                                leniphase,leniphase0,maxtgsym
C
C*** End of declarations rewritten by SPAG
C
!-----------------------------------------------------------------------
! MAL 06/05/11 From this point onwards PROJEC has been considerably 
! modified to take advantage of dynamic memory allocation. 
!-----------------------------------------------------------------------

!-----------------------------------------------------------------------
! Following are used to store the "unprojected" wavefunction
!-----------------------------------------------------------------------
!  
      INTEGER                    :: wfn_unproj_num_csfs, 
     &                               wfn_unproj_num_dets,
     &                               wfn_unproj_len_pkd_dets
      INTEGER, ALLOCATABLE       :: wfn_unproj_dets_per_csf(:),
     &                              wfn_unproj_packed_dets(:),
     &                              wfn_unproj_indx_1st_det_per_csf(:),
     &                              wfn_unproj_indx_1st_coeff_per_csf(:)
      REAL(KIND=WP), ALLOCATABLE :: wfn_unproj_coefficients_per_det(:)
!
!-----------------------------------------------------------------------
! Following are used to store the "projected" wavefunction
!-----------------------------------------------------------------------
!
      INTEGER                    :: wfn_proj_num_csfs,
     &                                wfn_proj_num_dets,
     &                                wfn_proj_len_pkd_dets
      INTEGER, ALLOCATABLE       :: wfn_proj_dets_per_csf(:),
     &                               wfn_proj_packed_dets(:),
     &                               wfn_proj_indx_1st_det_per_csf(:),
     &                               wfn_proj_indx_1st_coeff_per_csf(:)
      REAL(KIND=WP), ALLOCATABLE :: wfn_proj_coefficients_per_det(:)
!
!-----------------------------------------------------------------------
! Following are used to store the table of spin-orbitals
!-----------------------------------------------------------------------
!
      INTEGER                    :: nsrb,noarg
      INTEGER, ALLOCATABLE       :: itab_sporb_indx_in_sym(:),
     &                               itab_sporb_gu_value(:),
     &                               itab_sporb_sym(:),
     &                               itab_sporb_isz(:),
     &                               itab_sporb_mpos(:),
     &                               map_orbitals(:)
!
!------------------------------------------------------------------------
! Following are used during the phase analysis of the wavefunctio
!------------------------------------------------------------------------
!
      INTEGER, ALLOCATABLE       :: nconf(:),iphase(:),iphase0(:)
!
!-------------------------------------------------------------------------
! Following logical flags are used to control the computation
! 
! They are provided to make the code easier to read than trying to 
! remember that "byproj .eq. 0" means "bypass the projection of the
! wavefunction".
!-------------------------------------------------------------------------
!
      LOGICAL :: zbypass_wfn_projection,
     &            zadjust_wfn_phase_for_scattering,
     &            zpositrons,ztarget_state_calculation,
     &            zscattering_calculation,zabelian


      INTEGER :: num_csfs_proj,num_dets_proj,len_pkd_dets_proj ! MAL 12/05/11 :
                                                               ! None of these were declared in CG code. Why?
                                                               ! They are not assigned values either, so most
                                                               ! likely a problem here
!
!-------------------------------------------------------------------------
! End declarations rewritten by MAL 06/05/11 
!-------------------------------------------------------------------------     
!

      IF (symtyp.GE.2) THEN
         WRITE(nftw,1910) symtyp
 1910    FORMAT(' MOLECULE SYMMETRY CASE,  symtyp =',I2)
         junk=MPROD(1,1,npflg(6),nftw)
      END IF
C
      nalm=0 ! JMC initialization
      iss=s+s
      isd=sz+sz
      IF (iss .LT. isd) THEN
         WRITE(nftw, 40)
         WRITE(nftw, 46)
         STOP 
      END IF
!
!-------------------------------------------------------------------------
! The following logicals are created to improve code readability
!-------------------------------------------------------------------------
!
      zbypass_wfn_projection = byproj == 0
      zadjust_wfn_phase_for_scattering = iscat .GT. 0
      zpositrons = iposit /= 0
      zabelian = symtyp == 2
!
!-------------------------------------------------------------------------
! Compute the table of spin-orbitals
!-------------------------------------------------------------------------
!
      nsrb=0
      DO i=1, nsym 
         nsrb=nsrb+nob(i)
      END DO
      norb=nsrb
C JMC set but not used      NORBB=(NORB*(NORB+1))/2
      nsrb=2*nsrb
!
!------------------------------------------------------------------------
! Memory allocation for table of spin-orbitals
!------------------------------------------------------------------------
!
      ALLOCATE(itab_sporb_indx_in_sym(nsrb),stat=ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'itab_sporb_indx_in_sym',ierr
       STOP
      END IF

      ALLOCATE(itab_sporb_gu_value(nsrb),stat=ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'itab_sporb_gu_value',ierr
       STOP
      END IF
     
      ALLOCATE(itab_sporb_sym(nsrb),stat=ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'itab_sporb_sym',ierr
       STOP
      END IF

      ALLOCATE(itab_sporb_isz(nsrb),stat=ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'itab_sporb_isz',ierr
       STOP
      END IF

      ALLOCATE(itab_sporb_mpos(nsrb),stat=ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'itab_sporb_mpos',ierr
       STOP
      END IF

      ALLOCATE(map_orbitals(norb),stat=ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'mpos_orbitals',ierr
       STOP
      END IF

!
!-------------------------------------------------------------------------
! Compute the table of spin orbitals
!-------------------------------------------------------------------------
!      
!-------------------------------------------------------------------------
! For positrons in Abelian point groups there is a separate 
! processing routine
!-------------------------------------------------------------------------
!
      IF (zpositrons .AND. zabelian) THEN
         CALL pmkorbs(nob,nobe,nsym,
     &                itab_sporb_indx_in_sym,
     &                itab_sporb_gu_value,
     &                itab_sporb_sym,
     &                itab_sporb_isz,
     &                nsrb,norb,nsrb,
     &                map_orbitals,
     &                itab_sporb_mpos,
     &                iposit,symtyp)
      ELSE
         CALL mkorbs(nob,nsym,
     &                itab_sporb_indx_in_sym,
     &                itab_sporb_gu_value,
     &                itab_sporb_sym,
     &                itab_sporb_isz,
     &                norb,nsrb,map_orbitals,
     &                itab_sporb_mpos,
     &                iposit,nob1,nob01,symtyp)
      END IF

!
!-------------------------------------------------------------------------
! Validate the reference determinant
!-------------------------------------------------------------------------
!
      isum = 0
      IF (.NOT. zabelian) THEN
         msum = 0
         DO i = 1,nelt
            m = ndtrf(i)
            msum = msum+itab_sporb_sym(m)
            isum = isum+1-itab_sporb_isz(m)-itab_sporb_isz(m)
         END DO
      ELSE
         msum = 1
         DO i = 1,nelt
            m = ndtrf(i)
            msum = mprod(msum,itab_sporb_sym(m)+1,0,nftw)   !MAL 12/05/11 nftw was missing in CG code. Why?
            isum = isum+1-itab_sporb_isz(m)-itab_sporb_isz(m)
         END DO
         msum = msum-1
      END IF

!
!-------------------------------------------------------------------------
! Cross check with input
!-------------------------------------------------------------------------
!
      IF (abs(msum) .NE. mgvn) THEN
         WRITE(nftw,9900)
         WRITE(nftw,1190)
         STOP
      END IF
!
    
      IF (abs(isum) .NE. isd) THEN
         WRITE(nftw,9900)
         WRITE(nftw,1195)
         STOP
      END IF

!
!-------------------------------------------------------------------------
! Read the unprojected wavefunctions from unit megul
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! MAL 06/05/11 : Read the dimension information only, in order to see
! how many CSFs, how many determinants there are and also how long the
! determinant array is
!-------------------------------------------------------------------------
!
      CALL rdwf_getsize(megul,wfn_unproj_num_csfs,
     &                   wfn_unproj_num_dets,
     &                   wfn_unproj_len_pkd_dets)

!
!-------------------------------------------------------------------------
! Allocate the arrays dynamically for storage of the unprojected
! wavefunction
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! (1). Number of determinants per CSF
!-------------------------------------------------------------------------
!
      ALLOCATE(wfn_unproj_dets_per_csf(wfn_unproj_num_csfs),stat=ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'wfn_unproj_dets_per_csf',ierr
       STOP
      END IF
!
!-------------------------------------------------------------------------
! (2). The coefficient for each and every determinant 
!-------------------------------------------------------------------------
!
      ALLOCATE(wfn_unproj_coefficients_per_det(wfn_unproj_num_dets),
     &          stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'wfn_unproj_coefficients_per_det',ierr
       STOP
      END IF
!
!-------------------------------------------------------------------------
! (3). Each and every packed determinant 
!-------------------------------------------------------------------------
!
      ALLOCATE(wfn_unproj_packed_dets(wfn_unproj_len_pkd_dets),
     &          stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'wfn_unproj_packed_dets',ierr
       STOP
      END IF
!
!-------------------------------------------------------------------------      
! (4). Index into the list of determinants to the location for the first
!      determinant of each CSF
!      Note how this has one extra entry.
!-------------------------------------------------------------------------
!
      ALLOCATE(wfn_unproj_indx_1st_det_per_csf(wfn_unproj_num_csfs+1),
     &          stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'wfn_unproj_indx_1st_det_per_csf',ierr
       STOP
      END IF
!
!-------------------------------------------------------------------------
! (5). Index into the list of coefficients to the location for the first
!      coefficient of each CSF
!      Note how this has one extra entry
!-------------------------------------------------------------------------
!
      ALLOCATE(wfn_unproj_indx_1st_coeff_per_csf(wfn_unproj_num_csfs+1)
     &          ,stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw,9900)
       WRITE(nftw,9950) 'wfn_unproj_indx_1st_coeff_per_csf',ierr
       STOP
      END IF
!
!-------------------------------------------------------------------------
! Now able to read the unprojected wavefunction from file
! Note that this does not include the indexing arrays
! These are computed next
!-------------------------------------------------------------------------
!
      CALL rdwf(megul,num_csfs_unproj,wfn_unproj_dets_per_csf,
     &           num_dets_unproj,wfn_unproj_coefficients_per_det,
     &           len_pkd_dets_unproj,wfn_unproj_packed_dets)


!
!-------------------------------------------------------------------------
! Check that the values read back match to those read earlier
!-------------------------------------------------------------------------
!
      IF (num_csfs_unproj /= wfn_unproj_num_csfs) THEN
         WRITE(nftw,*) ' Error 1 '
         STOP 999
      END IF
!
      IF (num_dets_unproj /= wfn_unproj_num_dets) THEN
         WRITE(nftw,*) ' Error 2 '
         STOP 999
      END IF
!
      IF (len_pkd_dets_unproj /= wfn_unproj_len_pkd_dets) THEN
         WRITE(nftw,*) ' Error 3 '
         STOP 999
      END IF
!
!-------------------------------------------------------------------------
! Given the input wavefunction, indexing vectors for it are built here
!
!    wnf_unproj_indx_1st_det_per_csf()
!       points to the location of the first deteminant for each CSF
!       within the array ndi() which holds all the packed determinants
!       in the wavefunction.
!
!    wfn_unproj_indx_1st_coeff_per_csf()
!       points to the location of the first coefficient for each CSF
!       within the array cdi() which holds all the coefficients 
!       (one per determinant) in the wavefunction
!
!-------------------------------------------------------------------------
!
      wfn_unproj_indx_1st_coeff_per_csf(1) = 1
!
      DO n = 2, num_csfs_unproj
         wfn_unproj_indx_1st_coeff_per_csf(n) =   
     &     wfn_unproj_indx_1st_coeff_per_csf(n-1) + 
     &     wfn_unproj_dets_per_csf(n-1)
      END DO 

!      
      wfn_unproj_indx_1st_coeff_per_csf(num_csfs_unproj+1) = 
     &  wfn_unproj_indx_1st_coeff_per_csf(num_csfs_unproj)  + 
     &  wfn_unproj_dets_per_csf(num_csfs_unproj)
!
!-------------------------------------------------------------------------
! Index determinants now
!-------------------------------------------------------------------------
!
      wfn_unproj_indx_1st_det_per_csf(1) = 1
      k = 1
      DO n = 1, num_csfs_unproj
         num_dets = wfn_unproj_dets_per_csf(n)
         DO m = 1,num_dets
            nreps = wfn_unproj_packed_dets(k)
            k = k + (2*nreps + 1)
         END DO
         IF (n .LE. num_csfs_unproj) THEN
            wfn_unproj_indx_1st_det_per_csf(n+1) = k
         END IF 
      END DO 
!-------------------------------------------------------------------------
! If the user has requested it, then print the wavefunction
!-------------------------------------------------------------------------
      IF (npflg(1) .GT. 5) THEN
         WRITE(nftw,1285) megul
         CALL ptpwf(nftw,num_csfs_unproj,nelt,ndtrf,
     &              wfn_unproj_dets_per_csf,
     &              wfn_unproj_indx_1st_det_per_csf,
     &              wfn_unproj_indx_1st_coeff_per_csf,
     &              wfn_unproj_packed_dets,
     &              wfn_unproj_coefficients_per_det)
      END IF
!
!
!-------------------------------------------------------------------------
! Allocate storage space for the projected wavefunction
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! The number of CSFs in the projected wavefunction will be no greater
! than the number in the unprojected wavefunction. It is possible to 
! even delete a few due to the THRESHOLD criterion on coefficients. 
! However, the number of determinants may grow due to the projection
! for open shell determinants  (see prjct()).
!
! A factor of 10 is allowed here as a guesstimate...this may need revision
!
!-------------------------------------------------------------------------
! If no projection is to be done, the data is just copied straight over
! which means the subsequent code does not need to be rewritten with
! different variable names
!-------------------------------------------------------------------------
!
      IF (zbypass_wfn_projection) THEN
         wfn_proj_num_csfs     = wfn_unproj_num_csfs
         wfn_proj_num_dets     = wfn_unproj_num_dets
         wfn_proj_len_pkd_dets = wfn_unproj_len_pkd_dets
      ELSE
         wfn_proj_num_csfs     = wfn_unproj_num_csfs
         wfn_proj_num_dets     = 10*wfn_unproj_num_dets
         wfn_proj_len_pkd_dets = 10*wfn_unproj_len_pkd_dets
      END IF

!
!-------------------------------------------------------------------------
! Allocate space for the projected wavefunction
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! (1). Number of determinants per CSF
!-------------------------------------------------------------------------
!
       ALLOCATE(wfn_proj_dets_per_csf(wfn_proj_num_csfs),stat=ierr)
       IF (ierr /= 0) THEN
          WRITE(nftw,9900)
          WRITE(nftw,9950) 'wfn_proj_dets_per_csf', ierr
          STOP
       END IF
!
!------------------------------------------------------------------------- 
! (2). The coefficient for each and every determinant
!-------------------------------------------------------------------------
!
       ALLOCATE(wfn_proj_coefficients_per_det(wfn_proj_num_dets),
     &          stat = ierr)
       IF (ierr /= 0) THEN
          WRITE(nftw,9900)
          WRITE(nftw,9950) 'wfn_proj_coefficients_per_det', ierr
          STOP
       END IF
!
!-------------------------------------------------------------------------
! (3). Each and every packed determinant
!-------------------------------------------------------------------------
! 
       ALLOCATE(wfn_proj_packed_dets(wfn_proj_len_pkd_dets), stat=ierr)
       IF (ierr /= 0) THEN
          WRITE(nftw,9900)
          WRITE(nftw,9950) 'wfn_proj_packed_dets', ierr
          STOP
       END IF
!
!-------------------------------------------------------------------------
! (4). Index into the list of determinants to the location for the first
!      determinant of each CSF
!     
!      This (and 5 below) have to have a "fake" N+1 CSF, so the size
!      of the last Nth CSF can be known
!-------------------------------------------------------------------------             
!
      ALLOCATE(wfn_proj_indx_1st_det_per_csf(wfn_proj_num_csfs+1),
     &          stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw,9900)
         WRITE(nftw,9950) 'wfn_proj_indx_1st_det_per_csf', ierr
         STOP
      END IF
!
!-------------------------------------------------------------------------
! (5). Index into the list of coefficients to the location for the first
!      coefficient of each CSF
!-------------------------------------------------------------------------
!
      ALLOCATE(wfn_proj_indx_1st_coeff_per_csf(wfn_proj_num_csfs+1),
     &          stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw,9900)
         WRITE(nftw,9950) 'wfn_proj_indx_1st_coeff_per_csf', ierr
         STOP
      END IF


!
!-------------------------------------------------------------------------
! Project the wavefunction
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! There is a special case -- the wavefunctions read are already projected.
! In this case the input is just copied to the output
!-------------------------------------------------------------------------
!
      IF (zbypass_wfn_projection) THEN
       wfn_proj_dets_per_csf         = wfn_unproj_dets_per_csf
       wfn_proj_packed_dets          = wfn_unproj_packed_dets
       wfn_proj_coefficients_per_det = wfn_unproj_coefficients_per_det           
       wfn_proj_indx_1st_det_per_csf = wfn_unproj_indx_1st_det_per_csf
       wfn_proj_indx_1st_coeff_per_csf = wfn_unproj_indx_1st_det_per_csf
      ELSE

       maxndi = SIZE(wfn_unproj_packed_dets)
       maxcdi = SIZE(wfn_unproj_coefficients_per_det)
       maxndo = SIZE(wfn_proj_packed_dets)
       maxcdo = SIZE(wfn_proj_coefficients_per_det)


       IF ((maxndi .LE. 0) .OR. (maxcdi .LE. 0)) STOP 901
       IF ((maxndo .LE. 0) .OR. (maxcdo .LE. 0)) STOP 902
       

 
       CALL wfgntr(mgvn,iss,isd,thres,r,symtyp,nelt,
     &               nsym,nob,nob1,nob01,nobe,norb,nsrb,
     &              itab_sporb_indx_in_sym,
     &              itab_sporb_gu_value,
     &              itab_sporb_sym,
     &              itab_sporb_isz,
     &              iposit,map_orbitals,itab_sporb_mpos,
     &              wfn_unproj_num_csfs,
     &              ndtrf,
     &              wfn_unproj_dets_per_csf,
     &              wfn_unproj_packed_dets,
     &              wfn_unproj_coefficients_per_det,
     &              wfn_unproj_indx_1st_det_per_csf,
     &              wfn_unproj_indx_1st_coeff_per_csf,
     &              maxndi,maxcdi,
     &              wfn_proj_dets_per_csf,
     &              wfn_proj_packed_dets,
     &              wfn_proj_coefficients_per_det,
     &              wfn_proj_indx_1st_det_per_csf,
     &              wfn_proj_indx_1st_coeff_per_csf,
     &              maxndo,maxcdo,lenndo,lencdo,
     &              npflg,byproj,NFTW,nalm)
!

       IF (nalm /= 0) THEN
          WRITE(nftw,9900)
          WRITE(nftw,46)
          STOP
       END IF
!
      END IF !end of bypass wavefunction projection switch
!
!-------------------------------------------------------------------------
! Print the projected CSFs
!-------------------------------------------------------------------------
!
      IF (NPFLG(3) /= 0) THEN
        WRITE(nftw,104)
104     FORMAT('1 OUTPUT FUNCTIONS IN PACKED FORM')
        CALL ptpwf(NFTW,wfn_proj_num_csfs,nelt,ndtrf,
     &              wfn_proj_dets_per_csf,
     &              wfn_proj_indx_1st_det_per_csf,
     &              wfn_proj_indx_1st_coeff_per_csf,
     &              wfn_proj_packed_dets,
     &              wfn_proj_coefficients_per_det)
      END IF
!
!-------------------------------------------------------------------------
! Clean up dynamic storage that is no longer needed
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! Deallocate the arrays used to read the unprojected wavefunction
!-------------------------------------------------------------------------
!
      DEALLOCATE(wfn_unproj_dets_per_csf, stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw, 9900)
       WRITE(nftw, 9960) 'wfn_unproj_dets_per_csf', ierr
       STOP
      END IF
!
      DEALLOCATE(wfn_unproj_coefficients_per_det, stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw, 9900)
       WRITE(nftw, 9960) 'wfn_unproj_coefficients_per_det', ierr
       STOP
      END IF
!
      DEALLOCATE(wfn_unproj_packed_dets, stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw, 9900)
       WRITE(nftw, 9960) 'wfn_unproj_packed_dets', ierr
       STOP
      END IF
!
      DEALLOCATE(wfn_unproj_indx_1st_det_per_csf, stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw, 9900)
       WRITE(nftw, 9960) 'wfn_unproj_indx_1st_det_per_csf', ierr
       STOP
      END IF
!
      DEALLOCATE(wfn_unproj_indx_1st_coeff_per_csf, stat = ierr)
      IF (ierr /= 0) THEN
       WRITE(nftw, 9900)
       WRITE(nftw, 9960) 'wfn_unproj_1st_coeff_per_csf', ierr
       STOP
      END IF
!
!-------------------------------------------------------------------------
! Calculate phase correction for SCATCI
!-------------------------------------------------------------------------
!-------------------------------------------------------------------------
! Figure out which calculation is being done
!-------------------------------------------------------------------------
!
      ztarget_state_calculation = iscat == 1
      zscattering_calculation  = iscat .gt. 1  
!
!-------------------------------------------------------------------------
! Allocate workspace arrays needed in this step
!
! Depends on type of calculation
!
! Note that the phase array is needed for one of the write to file options
!-------------------------------------------------------------------------
!
      ALLOCATE(nconf(nelt), stat = ierr)
!
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9950) 'nconf', ierr
         STOP
      END IF
!
!-------------------------------------------------------------------------
! iphase()
!-------------------------------------------------------------------------
!
      IF (ztarget_state_calculation) THEN
         leniphase = nocsf
      ELSE
         leniphase = sum(nctgt(1:ntgsym))
      END IF
!
      ALLOCATE(iphase(leniphase), stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9950) 'iphase', ierr
         STOP 999
      END IF
!
      leniphase = SIZE(iphase)
!
!-------------------------------------------------------------------------
! iphase0()
!-------------------------------------------------------------------------
!
      ALLOCATE(iphase0(3*nocsf), stat = ierr)
!
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9950) 'iphase0', ierr
         STOP 999
      END IF
!
!-------------------------------------------------------------------------
! Branch to appropriate phase handler -- watch for error condition
! (that is, iscat <= 0)
!-------------------------------------------------------------------------
!
      IF (ztarget_state_calculation) THEN
         WRITE(nftw, 3000)
!
         nctarg = nocsf
         ntgsym = -1
!      
         CALL dophz0(NFTW,nocsf,nelt,ndtrf,nconf, 
     &                wfn_proj_indx_1st_det_per_csf,
     &                wfn_proj_packed_dets,
     &                lenndo, 
     &                wfn_proj_indx_1st_coeff_per_csf,
     &                wfn_proj_coefficients_per_det,
     &                lencdo,
     &                iphase,
     &                npflg(5))
!
      ELSE IF (zscattering_calculation) THEN
          WRITE(nftw, 3100)
          WRITE(nftw, 3110) ntgsym,notgt
          WRITE(nftw, 3120) nctgt
          WRITE(nftw, 3130) mcont

          IF (symtyp == 1) WRITE(nftw, 3140) gucont
          IF (npflg(5) .gt. 0) WRITE(nftw, 3150) mrkorb
          IF (symtyp .LE. 1 .AND. mgvn .GT. 0) WRITE(nftw, 3160)
     &         mdegen
!
!-------------------------------------------------------------------------
! Count the number of continuum functions, that is a sum over all target
! states
!-------------------------------------------------------------------------
!
      nctarg = sum(nctgt(1:ntgsym))
!-------------------------------------------------------------------------
! Execute the phase alignment routine 
!-------------------------------------------------------------------------
!
      CALL dophz(nftw,nocsf,nelt,ndtrf,nconf, 
     &            wfn_proj_indx_1st_det_per_csf,
     &            wfn_proj_packed_dets,
     &            lenndo,
     &            wfn_proj_indx_1st_coeff_per_csf,
     &            wfn_proj_coefficients_per_det,
     &            lencdo,
     &            iphase,
     &            leniphase,
     &            iphase0,
     &            leniphase0,
     &            nctarg,nctgt,notgt,mrkorb,
     &            mdegen,ntgsym,mcont,
     &            symtyp,npflg(5))
!
      ELSE
          WRITE(nftw,9900)
          WRITE(nftw,*) 'neither a target state nor a scattering run'
          STOP 999
      END IF
!
!------------------------------------------------------------------------
! Write the header and (projected) wavefunctions back to unit MEGUL
!------------------------------------------------------------------------
!
!------------------------------------------------------------------------
! iscat > 0 => SCATCI, DENPROP format
!              otherwise SPEEDY format
!------------------------------------------------------------------------
!
      IF (iscat .GT. 0) then
!        
         WRITE(nftw, 3167) megul
!
         CALL wrnfto(sname,mgvn,s,sz,r,pin,norb,nsrb,
     &                nocsf,nelt,idiag,nsym,symtyp,
     &                nob, ndtrf, wfn_proj_dets_per_csf,
     &                nocsf+1,
     &                wfn_proj_indx_1st_coeff_per_csf,
     &                wfn_proj_indx_1st_det_per_csf,
     &                wfn_proj_packed_dets,
     &                lenndo,
     &                wfn_proj_coefficients_per_det,
     &                lencdo,
     &                megul,nob1,2*nsym,
     &                npflg,thres,iposit,nob0,nob01,nctarg,
     &                ntgsym,notgt,nctgt,mcont,gucont,iphase,
     &                nobe,nobp,nobv,maxtgsym)
         WRITE(nftw, 3170) megul
      ELSE
!
         WRITE(nftw, 3168) megul
!     
         CALL wrwf(megul, 
     &              num_csfs_proj,                  !MAL 12/05/11 : Not declared in CG code 
     &              wfn_proj_dets_per_csf,
     &              num_dets_proj,                  !MAL 12/05/11 : Not declared in CG code
     &              wfn_proj_coefficients_per_det,
     &              len_pkd_dets_proj,              !MAL 12/05/11 : Not declared in CG code
     &              wfn_proj_packed_dets)
      END IF
!
!-------------------------------------------------------------------------
! Deallocate workspace arrays used in dophz0()/dophz()
!-------------------------------------------------------------------------
!
      IF (ALLOCATED(nconf)) THEN
          DEALLOCATE(nconf, stat = ierr)
!
          IF (ierr /= 0) THEN
             WRITE(nftw, 9900)
             WRITE(nftw, 9960) 'nconf', ierr
             STOP
          END IF
      END IF
!
      IF (ALLOCATED(iphase)) THEN
          DEALLOCATE(iphase, stat = ierr)
!
          IF (ierr /= 0) THEN
             WRITE(nftw, 9900)
             WRITE(nftw, 9960) 'iphase', ierr
             STOP
          END IF
      END IF
!
      IF (ALLOCATED(iphase0)) THEN
          DEALLOCATE(iphase0, stat = ierr)
!
          IF (ierr /= 0) THEN
             WRITE(nftw, 9900)
             WRITE(nftw, 9960) 'iphase0', ierr
             STOP
          END IF
      END IF
!
!-------------------------------------------------------------------------
! Subroutine common return point
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! Deallocate storage used for the table of spin-orbitals
!-------------------------------------------------------------------------
!
      DEALLOCATE(itab_sporb_indx_in_sym, stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9960) 'itab_sporb_indx_in_sym', ierr
         STOP
      END IF 
!      
      DEALLOCATE(itab_sporb_gu_value, stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9960) 'itab_sporb_gu_value', ierr
         STOP
      END IF 
!
      DEALLOCATE(itab_sporb_sym, stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9960) 'itab_sporb_sym', ierr
         STOP
      END IF 
!
      DEALLOCATE(itab_sporb_isz, stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9960) 'itab_sporb_isz', ierr
         STOP
      END IF 
!
      DEALLOCATE(itab_sporb_mpos, stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9960) 'itab_sporb_mpos', ierr
         STOP
      END IF 
!
      DEALLOCATE(map_orbitals, stat = ierr)
      IF (ierr /= 0) THEN
         WRITE(nftw, 9900)
         WRITE(nftw, 9960) 'mpos_orbitals', ierr
         STOP
      END IF 
!
      WRITE(nftw, 8000)
!
!------------------------------------------------------------------------
! Format statements
!------------------------------------------------------------------------
!
   40 format('  S.LT.SZ')
 1000 format(/,5x,'Projection and phase alignment of wavefunction ',/,
     &          5x,'============================================== ',//,
     &        5x,'Input data: ',/)
 1005 format(5x,'  Sname = ',a,/,     
     &        5x,'  Mgvn  = ',i10,/,   
     &        5x,'  S     = ',f10.4,/, 
     &        5x,'  Sz    = ',f10.4,/, 
     &        5x,'  R     = ',f10.4,/, 
     &        5x,'  Pin   = ',f10.4,/, 
     &        5x,'  Nocsf = ',i10,/,   
     &        5x,'  Idiag = ',i10,//)
 1007 format(5x,'  Number of electrons in system   (nelt) = ',i5,//, 
     &        5x,'  Reference determinant: ',//, 
     &        5x,'     (refdet) = ',10(i5,1x),/,
     &       (21x,10(i5,1x)))
!
 1020 format(5x,'  Point group (symmetry) of nuclear framework (symtyp)
     &         = ',i3,/)
 1021 format(5x,'  This is the C-inf-v point group',/) 
 1022 format(5x,'  This is the D-inf-h point',/) 
 1023 format(5x,'  This is an Abelian point group ',/)
!
 1030 format(5x,'  Bypassing wavefunction projection (byproj .eq. 0)',/)
 1031 format(5x,'  Wavefunction will be projected (byproj .ne. 0)',/)
!
 1035 format(5x,'  Adjusting phase of wavefunction for scattering 
     &              (iscat .gt. 0)',/)
 1036 format(5x,'  Not adjusting phase of wavefunction for scattering 
     &              (iscat .le. 0)',/)
!
 1038 format(/,5x,'  Print flags (npflg) ',/,
     &          5x,'  ------------------- ',/,
     &          5x,'  1. Unprojec and projec wavefunctions  : ',i5,/,
     &          5x,'  2.                                    : ',i5,/,
     &          5x,'  3.                                    : ',i5,/,
     &          5x,'  4.                                    : ',i5,/,
     &          5x,'  5. Target or scattering phase compute : ',i5,/,
     &          5x,'  6. Abelian point grp multiplctn table : ',i5,/)
!
 1099 format(/,5x,'**** End of the input data',/)             
!
 1100 format(5x,'Orbitals per symmetry (nob):',/,(6x,i3,'.  ',i3))
 1110 format(/,5x,'Total number of orbitals  (norb) = ',i8,/, 
     &          5x,'Triangulation of norb    (norbb) = ',i8)
 1120 format(/,5x,'Total number of spin-orbs (nsrb) = ',i8,/)
 1130 format(5x,'Spin orbitals table of quantum numbers',//, 
     &        5x,'  I      N      G      M      S     MPOS   ',/,
     &        5x,'-----  -----  -----  -----  -----  -----   ')
 1140 format((5x,6(i5,2x)))
 1145 format(/,5x,'**** End of table of spin-orbitals ',/)
!
 1160 format(/,5x,'User defined quantum numbers of ref determinant
     &        :',//,
     &          5x,'  mgvn = ',i5,/,    
     &          5x,'  S    = ',f8.3,/,  
     &          5x,'  Sz   = ',f8.3,//, 
     &          5x,'and locally computed vars for spin from S,Sz: ',//,
     &          5x,'  iss  = ',i5,/,    
     &          5x,'  isd  = ',i5)
 1170 format(/,5x,'For check, computed q-numbers of ref det:',//,
     &          5x,'  2*Sz + 1 = ',i5)
 1180 format(  5x,'  irreducible representation   = ',i5,//,
     &          5x,'   (Note: totally symmetric representation = 0) ',/)
!
 1185 format(5x,'  Lambda value = ',i5,/)
 1190 format(5x,'  Symmetry quantum number in refdet is not MGVN')
 1195 format(5x,'  Sz in refdet is not = SZ')
!
 1270 format(/,5x,'Starting to build indexes for the wavefunction',/)
 1280 format(/,5x,'Finished building indexes for the wavefunction',/)
 1285 format(/,5x,'Wavefunctions read from input file on unit ',i5,/)
!
 2000 format(/,5x,'The wavefunction will be projected',//, 
     &    5x,'This means that the wavefunction on unit ',i5,' is an',/,
     &    5x,'unprojected wavefunction.',/)
 2010 format(5x,'Data read from the wavefunction on unit: ',i5,//,   
     &        5x,'   number of CSFs                = ',i10,/,  
     &        5x,'   number of determinants        = ',i10,/,  
     &        5x,'   length of packed determinants = ',i10,//, 
     &        5x,'This data will be used to allocate dynamic storage',/,
     &        5x,'in which to hold the wavefunction.',/)
 2100 format(5x,'Projected CSFs in packed format:',/)
 3000 format(/,5x,'Computing phase for target state',/)
 3100 format(/,5x,'Performing phase correction for target',/,
     &          5x,'states in a scattering run',/)
   46 FORMAT('  DUE TO ALARM CONDITION THIS RUN WAS TERMINATED')
 3110 format(/' CI target data for SCATCI:', 
     &        //' Number of target symmetries in expansion,   NTGSYM =',
     &        i5/' Number of continuum orbs for each state, NOTGT =',
     &        20I5,/,(' ',20I5))
 3120 format(' Number of CI components for each state,      NCTGT =',
     &        20I5,/,('  ',20I5))
 3130 format(' Continuum M projection  for each state,      MCONT =',
     &        20I5,/,('  ',20I5))
 3140 format(' Continuum G/U symmetry  for each state,     GUCONT =',
     &        20I5,/,('  ',20I5))
 3150 format(' Marked continuum orbital for each state,    MRKORB =',
     &        20I5,/,('  ',20I5))
 3160 format(' Degenerate coupling case flag               MDEGEN =',
     &        20I5,/,('  ',20I5))

 3167 FORMAT(5x,'Writing projected CSFs to unit ',i5,' in format',/,
     &        5x,'required by the SCATCI/DENPROP programs ',/)
 3168 FORMAT(5x,'Writing projected CSFs to unit ',i5,' in format',/,
     &        5x, 'required by the SPEEDY program ',/)
 3170 FORMAT(5x,'Data on CSFs has been written to file (MEGUL) = ',i5/)
 8000 FORMAT(5x,'***** Wavefn projection (projec()) - completed',/)
 9900 FORMAT(/,5x,'***** Error in: projec() ',//)
 9950 FORMAT(5x,'Cannot allocate space for array ',a,//,
     &        5x,'Return status from allocate() = ',i8,/)
 9960 FORMAT(5x,'Cannot de-allocate space for array ',a,//,
     &        5x,'Return status from deallocate() = ',i8,/)
 

      END SUBROUTINE PROJEC


!*==ptpwf.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE PTPWF(NFTW,NOCSF,NELT,NDTRF,NODI,INDI,ICDI,NDI,CDI)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NELT, NFTW, NOCSF
      REAL(KIND=wp), DIMENSION(*) :: CDI
      INTEGER, DIMENSION(*) :: ICDI, INDI, NDI, NDTRF, NODI
      INTENT (IN) CDI, ICDI, INDI, NDI, NDTRF, NELT, NFTW, NOCSF, NODI
C
C Local variables
C
      INTEGER :: I, K, MA, MB, MC, MD, N
C
C*** End of declarations rewritten by SPAG
C
      WRITE(NFTW,139)(NDTRF(I),I=1,NELT)
 139  FORMAT(' REFERENCE DETERMINANT'//(1X,20I5))
      WRITE(NFTW,137)
 137  FORMAT('  CSF',9X,'COEFFICIENT',2X,'NSO'/)
      DO N=1, NOCSF
         MA=NODI(N)
         MB=INDI(N)
         MC=ICDI(N)-1
         MD=NDI(MB)
         WRITE(NFTW,138)N, CDI(MC+1), MD, (NDI(MB+I),I=1,2*MD)
 138     FORMAT(1X,I4,D20.10,I5,2X,20I5/(32X,20I5))
         MB=MB+MD+MD+1
         DO K=2, MA
            MD=NDI(MB)
            WRITE(NFTW,140)CDI(MC+K), MD, (NDI(MB+I),I=1,2*MD)
 140        FORMAT(5X,D20.10,I5,2X,20I5/(32X,20I5))
            MB=MB+MD+MD+1
         END DO
      END DO
      RETURN
      END SUBROUTINE PTPWF

      SUBROUTINE rdwf_getsize(iunit,num_csfs,num_dets,len_dets)

!-------------------------------------------------------------------------
!     rdwf_getsize() reads the information giving the size of the
!                    data used for the wavefunction, for example
!                    the number of determinants, but does not
!                    read the actual data,  such as the determinants.
!
!                    This is really just a stripped down version of
!                    the routine rdwf() which reads the full data.
!
!     Input data:
!          iunit  the logical unit on which the wavefucntion
!                 data is located.
!
!
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! MAL 10/05/2011: This subroutine is new to congen and is included to bring
! congen into line with the changes that were made in 'projec' in order
! to utilize dynamic memory
!-------------------------------------------------------------------------
      USE precisn
      IMPLICIT NONE
!-------------------------------------------------------------------------
! Integer variables passed in the argument list
!-------------------------------------------------------------------------
      INTEGER                    :: iunit,num_csfs,num_dets,len_dets
!-------------------------------------------------------------------------
! Local integer variables 
!-------------------------------------------------------------------------
      INTEGER                    :: ncsfs,ndets,ldets,ios,ntemp
!
      REWIND iunit
!
      ncsfs = 0
      ndets = 0
      ldets = 0
!
!-------------------------------------------------------------------------
!     The while loop reads records from the logical unit
!     until the end of file, or some other error occurs.
!-------------------------------------------------------------------------
!
      DO
!-------------------------------------------------------------------------
! First record is a CSF counter
!-------------------------------------------------------------------------
        READ(iunit, IOSTAT = ios) ntemp
!
        IF (0 .ne. ios) EXIT
!      
        ncsfs = ncsfs + ntemp
!-------------------------------------------------------------------------
! Second record is a counter for determinants
!-------------------------------------------------------------------------
        READ(iunit) ntemp
!
        ndets = ndets + ntemp
!-------------------------------------------------------------------------
! Third record is the actual determinants themselves
!-------------------------------------------------------------------------
        READ(iunit) ntemp
! 
        ldets = ldets + ntemp
!
      END DO
!-------------------------------------------------------------------------
! Reach this point when the wavefunction has been
! read successfully. Can copy temporary data counters
! to the return variables in the argument list
!-------------------------------------------------------------------------
      REWIND iunit
!
      num_csfs = ncsfs 
      num_dets = ndets
      len_dets = ldets
!-------------------------------------------------------------------------
! Subroutine return point
!-------------------------------------------------------------------------
!
      END SUBROUTINE rdwf_getsize




      SUBROUTINE RDWF (nft,k1,nodi,k2,cdi,k3,ndi)

!********************************************************************
!
!
!********************************************************************
!
      USE precisn 
      IMPLICIT NONE 
!
      INTEGER                     ::  k1,k2,k3,n1,n2,n3,i,nft
      INTEGER, DIMENSION(*)       ::  nodi,ndi
      REAL(KIND=wp), DIMENSION(*) ::  cdi
!     
      REWIND nft
!
      k1=0
      k2=0
      k3=0
!-------------------------------------------------------------------------
! Begin loop over the CSFs data at line 100.
!
! We terminate when we hit the end of file.
!
! Routine WFN in CONGEN creates the CSFs data in buffers of 
! fixed size.
!
! When the buffers are full, they are emptied to disk
! and reused from the start. This is why we can have several
! sets to read.
!-------------------------------------------------------------------------

  100 READ(nft,END=200) n1,(nodi(k1+i),i=1,n1)
      k1=k1+n1
!
      READ(nft) n2,(cdi(k2+i),i=1,n2)
      k2=k2+n2
!
      READ(nft) n3,(ndi(k3+i),i=1,n3)
      k3=k3+n3
!
      GOTO 100
!--------------------------------------------------------------------------
!    Branch here at the end of file
!--------------------------------------------------------------------------
  200 CONTINUE
!
      REWIND nft
!--------------------------------------------------------------------------
! Subroutine return point
!--------------------------------------------------------------------------
      return
!
      END SUBROUTINE rdwf


!*==rfltn.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE RFLTN(NELT,NODI,NDI,CDI,R,MXND,NDMXP,THRES,NODO,CDO,
     &                 NDTR,MM)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE consts, ONLY : half=>xhalf
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: MXND, NDMXP, NELT, NODI, NODO
      REAL(KIND=wp) :: R, THRES
      REAL(KIND=wp), DIMENSION(*) :: CDI, CDO
      INTEGER, DIMENSION(*) :: MM, NDI, NDTR
      INTENT (IN) CDI, MM, NODI, R
      INTENT (INOUT) NODO
C
C Local variables
C
      REAL(KIND=wp) :: CFD
      INTEGER :: I, J, MA, ND
C
C*** End of declarations rewritten by SPAG
C
      DO I=1, NODI
         CDO(I)=HALF*CDI(I)
      END DO
C
      ND=0
      NODO=NODI
      DO I=1, NODI
         CFD=HALF*R*CDI(I)
         DO J=1, NELT
            MA=NDI(ND+J)
            IF(MM(MA).NE.0)MA=MA+SIGN(2,MM(MA))
            NDTR(J)=MA
         END DO
         CALL STMRG(NELT,MXND,NDMXP,NDI,THRES,CDO,NODO,NDTR,CFD)
         IF(NODO.LT.0)RETURN
         ND=ND+NELT
      END DO
      CALL CNTRCT(NELT,NODO,NDI,CDO,THRES)
      RETURN
      END SUBROUTINE RFLTN
!*==snrm2.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      FUNCTION SNRM2(N,ARRAY,ISTEP)
C     FORTRAN version of BLAS level 1 routine of the same name
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE consts, ONLY : zero=>xzero
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: ISTEP, N
      REAL(KIND=wp), DIMENSION(*) :: ARRAY
      REAL(KIND=wp) :: SNRM2
      INTENT (IN) ARRAY, ISTEP, N
C
C Local variables
C
      INTEGER :: I, II
C
C*** End of declarations rewritten by SPAG
C
      SNRM2=ZERO
      IF(N.LE.0)RETURN
      II=1
      DO I=1, N
         SNRM2=SNRM2+ARRAY(II)**2
         II=II+ISTEP
      END DO
      RETURN
      END FUNCTION SNRM2
!*==space.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE SPACE(LINES)
      USE CONGEN_DATA, ONLY : LPPR, LPPMAX, NFTW
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: LINES
      INTENT (IN) LINES
C
C Local variables
C
      INTEGER :: J
C
C*** End of declarations rewritten by SPAG
C
      LPPR=LPPR+LINES
      IF(LPPR.GE.LPPMAX)RETURN
      DO J=1, LINES
         WRITE(NFTW, 155)
      END DO
 155  FORMAT(' ')
      RETURN
      END SUBROUTINE SPACE
!*==state.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE STATE(NS,X,LAST,ND,CONFPF)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE CONGEN_DATA, ONLY : LRATIO, CUP, IQN=>QNSHL,
     &                        NE=>NNLECG, ISZ=>NISZ
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: CONFPF, LAST, ND, NS
      REAL(KIND=wp), DIMENSION(*) :: X
      INTENT (IN) CONFPF, LAST
      INTENT (INOUT) ND, X
C
C Local variables
C
      INTEGER :: IC, ID, INTPFG, IQNS, JQNS, LC, LD, LDP, LDQ, NAM, 
     &           NDMX, NT, NTMX
C
C*** End of declarations rewritten by SPAG
C
      INTPFG=0
      IF(CONFPF.GT.40)INTPFG=1
      ND=0
      NAM=NS+NS-1
      NTMX=LAST/(NAM+NAM+1)
      IC=1
      IQNS=IC+NTMX
      CALL WFCPLE(NAM,IQN,ISZ,CUP,X(IQNS),X(IC),NTMX,NT,INTPFG)
      IF(NT.EQ.0)RETURN
C
      JQNS=LAST-2*NS*NT+1
      LC=JQNS-NT
      CALL PACK(X(IQNS),NAM,X(JQNS),NS,X(IC),X(LC),NT)
      NDMX=(LC-1)/(NE+1)
      LD=IC+NDMX
      CALL GETSO(NS,INTPFG,NT,X(JQNS),X(LC),ND,X(LD),X(IC),NDMX)
      IF(ND.EQ.0)RETURN
C
      LDP=ND+1
      LDQ=ND+(NE*ND+LRATIO-1)/LRATIO
      DO ID=LDP, LDQ
         X(ID)=X(LD)
         LD=LD+1
      END DO
      RETURN
      END SUBROUTINE STATE

      subroutine stmrg(nelt,maxcdo,maxndo,ndo,cdo,nodo,ndi,cdi)
!**********************************************************************
!
!     Given an existing list of determinants in cdo()/ndo() and 
!     a new single determinant cdi/ndi(), the new determinant
!     is merged into the list and the list extended if necessary.
!
!     This operation is used during spin-projection of a CSF. 
!
!**********************************************************************
!     MAL 16/05/11 : Modified to bring the subroutine into line
!     with the changes made to projec
!----------------------------------------------------------------------
      USE precisn
      implicit none

!
!..... Double precision variables passed in the argument list
!
      REAL(KIND=wp)              :: cdo(maxcdo) ! Coeff. for each det in ndo()
!
      REAL(KIND=wp)              :: cdi       ! Single coeff. going with the
                                              ! single determinant defined in
                                              ! ndi()      
!
!..... Local double precision variables 
!
      REAL(KIND=wp) :: sign 
!
!..... Local double precision variables
!                                    
      REAL(KIND=wp), parameter   :: one = 1.0_wp
!
!..... Integer variables passed in the argument list
!
      integer :: nelt           ! Number of electrons in each det.
      integer :: maxcdo         ! Dimension of cdo
      integer :: maxndo         ! Dimension of ndo       
!
      integer :: ndo(maxndo)    ! List of determinants each with
                                ! "nelt" spin-orbs
!
      integer :: nodo           ! On input is the number of dets
                                ! in cdo()/ndo(). Will be updated
                                ! for output if the data in cdi/ndi()
                                ! is merged into cdo()/ndo() as a 
                                ! new entry.     
!
      integer :: ndi(nelt)      ! A single det of "nelt" spin orbs
                                ! which has to be merged into ndo().
!
!..... Local integer variables
!
      integer  i, ibase, idet, j, nda, n, nd, ndonpi, ndt 
!
!..... Local logical variables
!
      logical, parameter :: zdebug = .false. 
!
!---- Debug banner header
!
      if(zdebug)then
        write(6,1000)
        write(6,1010) nelt,maxcdo,maxndo,cdi
        write(6,1020) nodo
!        
        ibase = 0
        do idet=1,nodo
           write(6,1025) idet, cdo(idet), (ndo(ibase+i),i=1,nelt)
           ibase = ibase + nelt
        end do
      endif      
!
!      
!---- Loop over all determinants in the list input
!
!     Test each against the target in ndi() 
!
!          => double loop over electrons in each     
!
!     "nd" counts the number of differences in spin-orbs
!
      nda  = 0
      sign = one
!      
      do n=1,nodo
         nd = 0
!
!....... Descend into loop over electrons in this determinant
!
!        We pull out the spin orbital for it. 
!
         do 20 i=1,nelt
!         
            if(nda+i .gt. maxndo)then
              write(6,9900)
              write(6,9920) n, nodo, i, nelt, nda, maxndo
              stop 999
            endif
!            
            ndonpi = ndo(nda+i)
!           
!.......... Descend into loop over electrons in the "new" 
!           determinant.
!
!           Check to see if we find the same spin-orbital
!           anywhere in the list.            
!            
            do 10 j=1,nelt
               if(NDI(J) .EQ. NDONPI) THEN
                 IF (I .NE. J) THEN
                   NDT=NDI(I)
                   NDI(I)=NDI(J)
                   NDI(J)=NDT
                   SIGN=-SIGN
                 ENDIF
                 GOTO 20
               ENDIF
   10       CONTINUE
!
!.......... Ok, we get to the next statement only if we do
!           not find the spin-orbital in the current determinant.
!
!           This means that the two determinants which we are 
!           comparing are in fact different in regard to this 
!           spin-orbital             
!               
!           So, augment the counter "nd".
!               
            nd = nd + 1
!            
   20    continue
!
         if(zdebug)then
           write(6,1050) n, nd
         endif            
!
!....... If there are no difference between the present 
!        determinant in the list NDO/CDO and the one 
!        in NDI against which we are testing, then 
!        we will have "nd" = 0.
!
!        In other words, NDI(), is already in the 
!        list NDO().      
!
!        We simply manipulate the sign of the coefficient
!        in CDO() and exit this routine
!      
         if(0 .eq. nd)then
           if(zdebug)then
             write(6,2050) n, cdo(n), cdi*sign 
           endif
!           
           cdo(n) = cdo(n) + cdi*sign
!
           goto 800
         endif
!
!....... Augment the pointer "nda" to start at the next
!        determinant in list "ndo()".
!        
         nda = nda + nelt
!
      end do ! End of loop over determinants in ndo/cdo 
!
!---- Ok, so we get here if we have to add the determinant
!     onto the end of the exisitng list.
!
      if(zdebug)then
        write(6,3000) 
      endif      
!      
      nodo = nodo + 1
!      
      if( (nodo .GT. maxcdo) .OR. (nda+nelt .GT. maxndo) )then
        write(6,9900)
        write(6,9910) nodo, maxcdo, nda+nelt, maxndo
        stop 999
      endif
!      
      cdo(nodo) = cdi*sign
!      
      do i=1,nelt
         ndo(nda+i) = ndi(i)
      end do
!
!---- Return point
!
  800 continue
!
      if(zdebug)then
        write(6,1020) nodo 
!        
        ibase = 0
        do idet=1,nodo
           write(6,1025) idet, cdo(idet), (ndo(ibase+i),i=1,nelt)
           ibase = ibase + nelt
        end do
!             
        write(6,8000)
      endif      
!      
      return
!
!---- Format statements
!
 1000 format(/,30x,'===> STMRG() <====',/)
 1010 format(30x,'Input data: ',/,
     &        30x,'  nelt   = ',i6,/,
     &        30x,'  maxcdo = ',i6,/,
     &        30x,'  maxndo = ',i6,/,
     &        30x,'  cdi    = ',d13.6) 
 1020 format(/,30x,'# of dets in current (cdo,ndo) list (nodo) = ',i5,/)
 1025 format(30x,i5,2x,d13.6,20(i3,1x))            
!
 1050 format(/,30x,'Det. (n) ',i3,' in list has (nd) ',i3,' spin-orb ',
     &            'differences from new one being added',/)        
!             
 2050 format(30x,'New determinant found in "existing" list:',/,
     &        30x,'  Found in exisiting list at n = ',i6,/,
     &        30x,'  Coefficient cdo(n)           = ',d13.6,/,
     &        30x,'  Augment coeff,  cdi*sign     = ',d13.6,/)
!
 3000 format(30x,'Adding new determinant to end of list',/)
!
 8000 format(/,30x,'***** STMRG() - completed ',/)
!      
 9900 format(/,10x,'**** Error in stmrg(): ',/)
 9910 format(10x,'Insufficient space to add extra determinant onto',/,
     &        10x,'end of list.                                    ',/,
     &        10x,'  cdo() : required ',i10,' available ',i10,/,
     &        10x,'  ndo() : required ',i10,' available ',i10,/)
 9920 format(10x,'Exceed dimensions of ndo() - which is allocated as',/,
     &        10x,'mop() in wfgntr originally.                 ',/,
     &        10x,'  Processing determinant (n)      = ',i12,/,
     &        10x,'  from maximum           (nodo)   = ',i12,/,
     &        10x,'  Electron number        (i)      = ',i12,/,
     &        10x,'  Number of electrons    (nelt)   = ',i12,/,
     &        10x,'  Base ptr now           (nda)    = ',i12,/,
     &        10x,'  Space in ndo()         (maxndo) = ',i12,/)
!      
      end subroutine stmrg


!*==stwrit.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE STWRIT(NELECT,CONFPF,QNTOT,CDIMX,ICDI,NTSO,SYMTYP,
     &                  NDIMX,INDI,NREFO,NODIMX,INODI,NSYM,GUTOT,NBMX,
     &                  ISZ,NAVAIL,IDIAG,MEGU,THRES,LCDT,MEGUL,LNDT,
     &                  NFTO,NRERUN,LTRI,NPFLG,NNDEL,NOB,NSOI,NSYMP,
     &                  REFDET,NERFS,ERFS,NREFOP,REFORB,REFGU,NELP,LPP,
     &                  SNAME,ERROR,BYPROJ,LNDO,LCDO,IPOSIT,NOB0,NPMULT,
     &                  ntgsym,mxtarg,nobe,nobp,nobv)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE GLOBAL_UTILS, ONLY : MPROD
      USE CONGEN_DATA, ONLY : NFTW, NU, RHEAD
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: BYPROJ, CDIMX, CONFPF, GUTOT, ICDI, IDIAG, INDI, INODI, 
     &           IPOSIT, ISZ, LCDO, LCDT, LNDO, LNDT, LPP, LTRI, MEGU, 
     &           MEGUL, MXTARG, NAVAIL, NBMX, NDIMX, NELECT, NELP, 
     &           NERFS, NFTO, NNDEL, NODIMX, NPMULT, NREFO, NREFOP, 
     &           NRERUN, NSYM, NSYMP, NTGSYM, NTSO, SYMTYP
      LOGICAL :: ERROR
      CHARACTER(LEN=80) :: SNAME
      REAL(KIND=wp) :: THRES
      LOGICAL, DIMENSION(9) :: ERFS
      INTEGER, DIMENSION(NU) :: NOB, NOB0, NOBE, NOBP, NOBV, NSOI ! JMC changing the dimension from 10
      INTEGER, DIMENSION(6) :: NPFLG
      INTEGER, DIMENSION(3) :: QNTOT
      INTEGER, DIMENSION(*) :: REFDET, REFGU
      INTEGER, DIMENSION(5,*) :: REFORB
      INTENT (IN) BYPROJ, CDIMX, CONFPF, ERFS, GUTOT, ICDI, IDIAG, INDI, 
     &            INODI, IPOSIT, ISZ, LCDO, LCDT, LNDO, LNDT, LTRI, 
     &            MEGU, MEGUL, MXTARG, NAVAIL, NBMX, NDIMX, NELECT, 
     &            NELP, NERFS, NFTO, NNDEL, NOB, NOB0, NOBE, NOBP, NOBV, 
     &            NODIMX, NPFLG, NREFO, NREFOP, NRERUN, NSOI, NSYM, 
     &            NSYMP, NTGSYM, NTSO, QNTOT, REFDET, REFGU, REFORB, 
     &            SYMTYP, THRES
      INTENT (INOUT) ERROR
C
C Local variables
C
      CHARACTER(LEN=32), DIMENSION(9) :: ERSNTS
      CHARACTER(LEN=30) :: HEAD='CONGEN 1.0  IBM SAN JOSE      '
      INTEGER :: I, II, IMAX, IP, IT, JUNK, LSN=64, NITEM=30
C
C*** End of declarations rewritten by SPAG
C
      DATA ERSNTS/'SYMMETRY TYPE OUT OF RANGE      ', 
     &     'NO ORBITALS GIVEN               ', 
     &     'TOO MANY SPIN ORBITALS          ', 
     &     'NELECT OUT O F RANGE            ', 
     &     'NREFO OUT OF RANGE              ', 
     &     'SUM NELEC IN REF ORBS NE NELECT ', 
     &     'ERROR IN REFORB DATA            ', 
     &     'ERROR IN TOTAL QN DATA          ', 
     &     'NO CORE FOR CDI, NDI, AND NODI  '/
C
      CALL CTLPG1(LPP,HEAD,LEN(HEAD),SNAME,LSN)
      CALL NEWPG
      CALL ADDL(15)
C
      WRITE(NFTW, 505) NELECT, CONFPF, QNTOT(1), CDIMX, ICDI, NTSO, 
     &      SYMTYP, QNTOT(2), NDIMX, INDI, NREFO, QNTOT(3), NODIMX, 
     &      INODI, NSYM, GUTOT, NBMX, ISZ, NAVAIL, IDIAG, MEGU, THRES, 
     &      LCDT, MEGUL, LNDT, NFTO, NRERUN, LTRI, NPFLG, NNDEL
 505  FORMAT(T2,'NELECT',T8,I4,T15,'CONFPF',I3,T27,'MULT  ',I2,T38,
     &       'CDIMX ',I5,T52,'ICDI ',I6/' NTSO  ',I4,T15,'SYMTYP',I3,
     &       T27,'MVAL  ',I2,T38,'NIDMX ',I5,T52,'INDI ',I6/' NREFO ',
     &       I4,T27,'REFLC',I3,T38,'NODIMX',I5,T52,'INODI',I6/' NSYM  ',
     &       I4,T27,'GUTOT',I3,T38,'NCORE',I10/T27,'ISZ  ',I3,T38,
     &       'NAV  ',I10///T14,' DATA FOR SPEEDY INPUT',//T14,'IDIAG ',
     &       I4,T27,'MEGU ',I3,T38,'THRES ',1PE12.4/T14,'LCDT  ',I4,T27,
     &       'MEGUL',I3/T14,'LNDT  ',I4,T27,'NFTO ',I3/T14,'NRERUN',I4,
     &       T27,'LTRI ',I3//T14,'NPFLG =',6I3,2X,'NNDEL =  ',I5)
      CALL ADDL(1)
      WRITE(NFTW, 507) BYPROJ, LNDO, LCDO
 507  FORMAT(T14,'BYPROJ',I2,3x,'LNDO',I10,3x,'LCDO',I10)
      IF(ntgsym.LT.mxtarg)THEN
         CALL ADDL(1)
         WRITE(NFTW, 508) ntgsym
 508     FORMAT(' ntgsym',i4)
      END IF
      CALL SPACE(2)
      CALL ADDL(3)
      WRITE(NFTW, 510) (IP,IP=1,NSYMP)
      WRITE(NFTW, 511) (NOB(IP),IP=1,NSYMP)
      IF(IPOSIT.NE.0)THEN
         CALL ADDL(4) ! JMC adding this line
         WRITE(NFTW, 5115) (NOB0(IP),IP=1,NSYMP)
         WRITE(NFTW, 5116) (NOBE(IP),IP=1,NSYMP)
         WRITE(NFTW, 5117) (NOBP(IP),IP=1,NSYMP)
         WRITE(NFTW, 5118) (NOBV(IP),IP=1,NSYMP)
      END IF
      WRITE(NFTW, 512) (NSOI(IP),IP=1,NSYMP)
 510  FORMAT(' NSYM',30I5)
 511  FORMAT(' NOB ',30I5)
 5115 FORMAT(' NOB0',30I5)
 5116 FORMAT(' NOBE',30I5)
 5117 FORMAT(' NOBP',30I5)
 5118 FORMAT(' NOBV',30I5)
 512  FORMAT(' NSOI',30I5)
      CALL SPACE(1)
      IF(IPOSIT.NE.0)THEN
         CALL ADDL(1) ! JMC adding this line
         WRITE(NFTW, 506) IPOSIT
         CALL SPACE(1)
      END IF
 506  FORMAT(5X,'POSITRON SCATTERING CASE: IPOSIT =',I3)
C
      IT=1
      IF(SYMTYP.EQ.1)IT=2
      DO I=1, NREFOP, NITEM
         IMAX=MIN(I+NITEM-1,NREFOP)
         CALL ADDL(6) ! JMC the argument will be too small in some cases (i=1 and symtyp=1)???
         IF(I.NE.1)GO TO 540
         WRITE(NFTW, 530)
 530     FORMAT(' REFERENCE DETERMINANT INPUT DATA')
         IT=IT-1
C
 540     WRITE(NFTW, 550) RHEAD(1), (IP,IP=I,IMAX)
 550     FORMAT(1X,A4,I5,29I4)
         DO II=1, 5
            WRITE(NFTW, 550) RHEAD(II+1), (REFORB(II,IP),IP=I,IMAX)
         END DO
         IF(SYMTYP.EQ.1)WRITE(NFTW, 550) RHEAD(7), (REFGU(IP),IP=I,IMAX)
         CALL SPACE(1)
      END DO
      CALL SPACE(1)
      IT=(NELP+NITEM-1)/NITEM
      IF(MOD(NELP,NITEM).EQ.0)IT=IT+1
C
      IF(NELP.NE.0)THEN
         CALL ADDL(IT)
         WRITE(NFTW, 590) (REFDET(IP),IP=1,NELP)
 590     FORMAT(' REFDET =',30(I3,',')/(9X,30(I3,',')))
      END IF
C
      IF(SYMTYP.GE.2 .AND. NPMULT.NE.0)THEN
         CALL ADDL(25)
         JUNK=MPROD(1,1,NPMULT,NFTW)
      END IF
C
C     PROCESS &STATE ERRORS
C
      ERROR=.FALSE.
      DO I=1, NERFS
         IF(.NOT.ERFS(I))CYCLE
         IF(ERROR)GO TO 640
         CALL SPACE(2)
         CALL ADDL(2)
         WRITE(NFTW, 630) ERSNTS(I)
 630     FORMAT(
     &     ' **** ERROR DATA FOR &STATE FOLLOWS (&WFNGRP NOT PROCESSED)'
     &     /12X,A32)
         ERROR=.TRUE.
         CYCLE
 640     CALL ADDL(1)
         WRITE(NFTW, 645) ERSNTS(I)
 645     FORMAT(12X,A32)
      END DO
C
      RETURN
      END SUBROUTINE STWRIT
!*==subdel.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE SUBDEL(NDEL,NDEL1,NDEL2,NNDEL)
      USE CONGEN_DATA, ONLY : NFTW, NFTR
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: NNDEL
      INTEGER, DIMENSION(*) :: NDEL, NDEL1, NDEL2 ! JMC changing dimension from 2.  Also note the actual args are all d.p.???
      INTENT (INOUT) NDEL, NDEL1, NDEL2, NNDEL
C
C Local variables
C
      INTEGER :: I, J, K, M, NNDEL1
C
C*** End of declarations rewritten by SPAG
C
      READ(NFTR,1000)NNDEL
      READ(NFTR,1000)(NDEL(I),I=1,NNDEL)
 1000 FORMAT(16I5)
 10   READ(NFTR,1000)NNDEL1
      IF(NNDEL1.EQ.0)GO TO 310
      READ(NFTR,1000)(NDEL1(J),J=1,NNDEL1)
      I=1
      J=1
      K=0
 100  IF(NDEL(I).GT.NDEL1(J))GO TO 200
      K=K+1
      IF(NDEL(I).EQ.NDEL1(J))J=J+1
      NDEL2(K)=NDEL(I)
      I=I+1
      IF(I.GT.NNDEL)GO TO 210
      IF(J.GT.NNDEL1)GO TO 240
      GO TO 100
 200  K=K+1
      NDEL2(K)=NDEL1(J)
      J=J+1
      IF(J.GT.NNDEL1)GO TO 240
      GO TO 100
 210  DO M=1, K
         NDEL(M)=NDEL2(M)
      END DO
      DO M=J, NNDEL1
         K=K+1
         NDEL(K)=NDEL1(M)
      END DO
      GO TO 300
 240  DO M=I, NNDEL
         K=K+1
         NDEL2(K)=NDEL(M)
      END DO
      DO M=1, K
         NDEL(M)=NDEL2(M)
      END DO
 300  NNDEL=K
      GO TO 10
 310  WRITE(NFTW,2000)NNDEL
 2000 FORMAT(' ***** NUMBER OF CHOSEN CONFIGURATIONS ***',I10)
      WRITE(NFTW,2010)(NDEL(I),I=1,NNDEL)
 2010 FORMAT(/,24I5)
      WRITE(7,1000)(NDEL(I),I=1,NNDEL) ! JMC writing to unit 7 (hardwired)???
      RETURN
      END SUBROUTINE SUBDEL
!*==taddl1.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE TADDL1(LINES,LT)
      USE CONGEN_DATA, ONLY : LPPR, LPPMAX
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: LINES, LT
      INTENT (IN) LINES
      INTENT (OUT) LT
C
C*** End of declarations rewritten by SPAG
C
      LT=0
      IF(LPPR+LINES.GT.LPPMAX)RETURN
      LT=1
      RETURN
      END SUBROUTINE TADDL1
!*==taddl.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE TADDL(LINES,LT)
      USE CONGEN_DATA, ONLY : LPPR, LPPMAX
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: LINES, LT
      INTENT (IN) LINES
      INTENT (OUT) LT
C
C*** End of declarations rewritten by SPAG
C
      LT=0
      IF(LPPR+LINES.GT.LPPMAX)RETURN
      LPPR=LPPR+LINES
      LT=1
      RETURN
      END SUBROUTINE TADDL
!*==wfcple.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE WFCPLE(NAM,IQN,ISZ,ICUP,IQNS,C,LAST,LC2,INTPFG)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE consts, ONLY : one=>xone
      USE CONGEN_DATA, ONLY : ROOT2, NFTW, LG
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: INTPFG, ISZ, LAST, LC2, NAM
      REAL(KIND=wp), DIMENSION(*) :: C
      INTEGER, DIMENSION(3,LG) :: ICUP
      INTEGER, DIMENSION(3,*) :: IQN
      INTEGER, DIMENSION(2,NAM,*) :: IQNS
      INTENT (IN) ICUP, ISZ, LAST, NAM
      INTENT (INOUT) C, IQNS, LC2
C
C Local variables
C
      INTEGER :: I, IAM, IC, INIT, J, L, LC, LC1, LC3, M, MP, MS, N, N1, 
     &           N2, N3, NC, NIAM, NIAM1
      LOGICAL, DIMENSION(NAM) :: IND ! JMC changing the dimension from 150
      INTEGER, DIMENSION(2,200) :: ISZT ! JMC not sure how to dimension this...
      REAL(KIND=wp) :: SIGN
C
C*** End of declarations rewritten by SPAG
C
 1    FORMAT('0ERROR IN COUPLING TREE'//(3I5))
 2    FORMAT('0COUPLING IMPOSSIBLE  MULTIPLICITIES FOLLOW'//(3I5))
 3    FORMAT('0STORAGE OVERFLOW IN VECTOR COUPLING')
      IQNS(1,NAM,1)=ISZ
      IQNS(2,NAM,1)=IQN(2,NAM)
      C(1)=ONE
      LC2=1
      IF(NAM.EQ.1)RETURN
      DO I=1, NAM
         IND(I)=.TRUE.
      END DO
      NIAM=(NAM+1)/2
 100  N3=NAM
 110  IF(IND(N3))THEN
         IF(N3.LE.NIAM)GO TO 299
         IND(N3)=.FALSE.
         INIT=LAST-LC2+1
         L=LAST
         LC=LC2
 200     DO IAM=1, NAM
            IQNS(1,IAM,L)=IQNS(1,IAM,LC)
            IQNS(2,IAM,L)=IQNS(2,IAM,LC)
         END DO
         C(L)=C(LC)
         LC=LC-1
         L=L-1
         IF(LC.GT.0)GO TO 200
         N=1
 300     IF(ICUP(3,N).EQ.N3)THEN
            N1=ICUP(1,N)
            N2=ICUP(2,N)
            IF(N1.GT.N3 .OR. N2.GT.N3)GO TO 299
            IF(.NOT.IND(N1) .OR. .NOT.IND(N2))GO TO 299
            IF(N1.LE.NIAM)IND(N1)=.FALSE.
            IF(N2.LE.NIAM)IND(N2)=.FALSE.
            LC2=0
            DO L=INIT, LAST
               IQNS(2,N1,L)=IQN(2,N1)
               IQNS(2,N2,L)=IQN(2,N2)
               M=IQNS(2,N3,L)
               IF(ABS(M).NE.IQN(2,N1)+IQN(2,N2))THEN
                  MP=IQN(2,N1)-IQN(2,N2)
                  IF(ABS(M).NE.ABS(MP))GO TO 511
                  N=N2
                  IF(M.NE.MP)N=N1
                  IQNS(2,N,L)=-IQNS(2,N,L)
                  GO TO 510
               END IF
               IF(IQNS(2,N3,L).GE.0)GO TO 510
               IQNS(2,N1,L)=-IQNS(2,N1,L)
               IQNS(2,N2,L)=-IQNS(2,N2,L)
 510           LC1=LC2+1
               MS=IQNS(1,N3,L)
               CALL CGCOEF(IQN(1,N1),IQN(1,N2),IQN(1,N3),MS,NC,ISZT,
     &                     C(LC1),INTPFG)
               IF(NC.GT.0)THEN
                  LC2=LC2+NC
                  IF(LC2.GE.L)GO TO 899
                  IC=1
                  DO LC=LC1, LC2
                     DO IAM=1, NAM
                        DO I=1, 2
                           IQNS(I,IAM,LC)=IQNS(I,IAM,L)
                        END DO
                     END DO
                     IQNS(1,N1,LC)=ISZT(1,IC)
                     IQNS(1,N2,LC)=ISZT(2,IC)
                     IC=IC+1
                     C(LC)=C(LC)*C(L)
                  END DO
                  IF(IQNS(2,N3,L).LT.0)THEN
                     IF(IQN(3,N1).GE.0 .AND. IQN(3,N2).GE.0)CYCLE
                     DO LC=LC1, LC2
                        C(LC)=-C(LC)
                     END DO
                  ELSE IF(IQNS(2,N3,L).EQ.0)THEN
                     IF(IQN(2,N1).NE.0)THEN
                        IF(LC2+NC.GE.L)GO TO 899
                        LC3=LC2
                        SIGN=ONE
                        IF(IQN(3,N3).LT.0)SIGN=-ONE
                        DO LC=LC1, LC3
                           LC2=LC2+1
                           DO IAM=1, NAM
                              DO I=1, 2
                                 IQNS(I,IAM,LC2)=IQNS(I,IAM,LC)
                              END DO
                           END DO
                           IQNS(2,N1,LC2)=-IQNS(2,N1,LC2)
                           IQNS(2,N2,LC2)=-IQNS(2,N2,LC2)
                           C(LC)=C(LC)*ROOT2
                           C(LC2)=C(LC)*SIGN
                        END DO
                        CYCLE
                     END IF
                     IF(IQN(3,N1)*IQN(3,N2).NE.IQN(3,N3))GO TO 511
                  END IF
                  CYCLE
               END IF
 511           WRITE(NFTW,2)(IQN(I,N1),IQN(I,N2),IQN(I,N3),I=1,3)
               LC2=0
               RETURN
            END DO
            GO TO 100
         END IF
         N=N+1
         IF(N.LT.NIAM)GO TO 300
         GO TO 299
      END IF
      N3=N3-1
      IF(N3.GT.0)GO TO 110
      RETURN
 299  NIAM1=NIAM-1
      WRITE(NFTW,1)((ICUP(I,J),I=1,3),J=1,NIAM1)
      LC2=0
      RETURN
 899  WRITE(NFTW,3)
      LC2=0
      RETURN
      END SUBROUTINE WFCPLE

      SUBROUTINE wfgntr(mgvn,iss,isd,thres,r,symtyp,nelt,
     &                   nsyml,nob,nobl,nob0l,nobe,norb,nsrb,
     &                   mn,mg,mm,ms,iposit,map,mpos,
     &                   nocsf,
     &                   ndtrf,
     &                   nodi, ndi, cdi, indil, icdil,
     &                   maxndi, maxcdi, 
     &                   nodo, ndo, cdo, indo, icdo,
     &                   maxndo, maxcdo, lenndo, lencdo,
     &                   npflg, byproj, nftw, nalm)                            
!------------------------------------------------------------------------
! Takes the wavefunction generated by CSFGEN and transforms it to be
! fully in accord with the spin quantum numbers of the system.
!-------------------------------------------------------------------------
!-------------------------------------------------------------------------
! MAL 10/05/2011: The changes made to wfgntr have made so as to make the
!                 subroutine compatible with the changes made to its
!                 calling subroutine, PROJEC. 
!-------------------------------------------------------------------------
      USE precisn, ONLY : wp
      USE GLOBAL_UTILS, ONLY : MPROD
      IMPLICIT NONE
! 
!-------------------------------------------------------------------------
! Local temporary storage 
!-------------------------------------------------------------------------
!     len_cdit has to be >= the maximum number of determinants in any one 
!     CSF
!-------------------------------------------------------------------------
!
      INTEGER, PARAMETER         :: len_cdit = 5000
      REAL(KIND=wp)              :: cdit(len_cdit)
!
!-------------------------------------------------------------------------
! Fixed constants
!-------------------------------------------------------------------------
!
      REAL(KIND=wp), PARAMETER   :: verysmall = 1.0d-30
!
!-------------------------------------------------------------------------
! Integer variables passed in the argument list 
!-------------------------------------------------------------------------
!
      INTEGER                    :: nftw  ! Logical unit for the printer      
      INTEGER                    :: symtyp, byproj 
      INTEGER                    :: lencdo ! Final usage in cdo()
      INTEGER                    :: lenndo ! Final usage in ndo()
      INTEGER                    :: maxcdo ! Maximum available in cdo()
      INTEGER                    :: maxndo ! Maximum available in ndo()
      INTEGER                    :: mgvn
      INTEGER                    :: iss 
      INTEGER                    :: isd 
      INTEGER                    :: norb 
      INTEGER                    :: ndmx 
      INTEGER                    :: ncmx
      INTEGER                    :: ndmxp
      INTEGER                    :: nsyml
      INTEGER                    :: nelt
      INTEGER                    :: iposit
      INTEGER                    :: nocsf,nsrb
      INTEGER                    :: maxndi,maxcdi
      INTEGER, DIMENSION(nsyml)  :: nob(nsyml),nobl(nsyml),nob0l(nsyml),
     &                               nobe(nsyml) 
      INTEGER, DIMENSION(nsrb)   :: mn,mg,mm,ms,map,mpos 
      INTEGER, DIMENSION(nelt)   :: ndtrf
      INTEGER                    :: npflg(6)
      REAL(KIND=wp)              :: r,thres
!
!-------------------------------------------------------------------------
! As elsewhere in the code, the wavefunction is represented as a 
! set of data packed into arrays. 
!-------------------------------------------------------------------------
!     For the input wavefunction we have:
!
!            nodi()  is the number of dets in each CSF   
!            ndi()   holds the dets in packed format, that is as    
!                      number of replacements + replaced + replacing
!            cdi()   is the coefficient for each determinant
!-------------------------------------------------------------------------
!     We need two further indexing arrays, each of length,
!     NOCSF+1 to handle the wavefunction data:
!
!            icdil(n) points at the first entry in the coefficients
!                     array, cdi(), for CSF "n".
!
!            indil(n) points at the first entry in the determinants
!                     array, ndi(), for CSF "n".
!-------------------------------------------------------------------------
!     Remember these have to be one larger than the number of CSFs. 
!     We compute the storage size of CSF by looking at the location 
!     of the "following one" - hence need to add one on at the end.
!-------------------------------------------------------------------------
!
      INTEGER, DIMENSION(nocsf)           :: nodi 
      INTEGER, DIMENSION(maxndi)          :: ndi
      INTEGER, DIMENSION(nocsf+1)         :: indil, icdil
      REAL(KIND=wp), DIMENSION(maxcdi)    :: cdi
!
!-------------------------------------------------------------------------
! Similar arrays exist for the output wavefunction
! and they are declared in the argument list too.
!-------------------------------------------------------------------------
!
      INTEGER, DIMENSION(nocsf)           :: nodo 
      INTEGER, DIMENSION(maxndi)          :: ndo
      INTEGER, DIMENSION(nocsf+1)         :: indo, icdo
      REAL(KIND=wp), DIMENSION(maxcdi)    :: cdo
!
!-------------------------------------------------------------------------
! Local integer variables
!-------------------------------------------------------------------------
      INTEGER                             :: n,i,num_dets_input,
     &                                        ipos_dets_input,
     &                                        ipos_coeffs_out,
     &                                        ipos_coeffs_in,
     &                                        ipos_dets_out,idet,
     &                                        isum,msum,nsrbs,
     &                                        needed,ierr,lenmop,nalm,
     &                                        ipos_this_det,nreps,me,mf,
     &                                        idop,idcp,ieltp,
     &                                        num_dets_final,mxss 
      INTEGER, DIMENSION(nelt)            :: mdop,mdcp
      INTEGER, DIMENSION(nsrb)            :: mdc,mdo,ndta
!-------------------------------------------------------------------------
! Local real variables
!-------------------------------------------------------------------------

      REAL(KIND=wp)                       :: mysum
!-------------------------------------------------------------------------      
      INTEGER, ALLOCATABLE                :: mop(:) ! Holds all expanded 
                                                    ! open shell per CSF
                                                    ! (see allocation)
!-------------------------------------------------------------------------
! Following are used to analyze CSF dimensions on input
!-------------------------------------------------------------------------
      INTEGER                             :: icsf_with_max(1)
      INTEGER                             :: max_num_dets_input
      INTEGER                             :: max_num_dets_output
!
!-------------------------------------------------------------------------
! Local fixed logical values
!-------------------------------------------------------------------------
!
      LOGICAL, PARAMETER                  :: zdebug = .false.
!
!-------------------------------------------------------------------------
! Intrinsic Fortran functions used
!-------------------------------------------------------------------------
!    
      INTRINSIC                           :: SQRT, MAXLOC, MINLOC
!
!-------------------------------------------------------------------------
! External functions used
!-------------------------------------------------------------------------
!     external  mprod
!
!     integer  mprod
!
      EXTERNAL                            :: snrm2
      REAL(KIND=wp)                       :: snrm2
!
!-------------------------------------------------------------------------
! Debug banner header
!-------------------------------------------------------------------------
!


      IF (zdebug) THEN
        WRITE(nftw,1000)
        WRITE(nftw,1010) mgvn,iss,isd,thres,r,nsyml,nelt,nocsf,nsrb
        WRITE(nftw,1020) norb, ndmx, ncmx, ndmxp
        WRITE(nftw,1030) maxcdo, maxndo
        WRITE(nftw,1035) 
        WRITE(nftw,1036) (i,mn(i),mg(i),mm(i),ms(i),mpos(i),i=1,nsrb)
        WRITE(nftw,1037) 
      END IF
!                        
!-------------------------------------------------------------------------
! We compute the number of spin-orbitals which are not 
! degenerate. For C-inf-v and D-inf-h this means sigma
! type. For Abelian point groups it is all orbitals.
!-------------------------------------------------------------------------
!
      nsrbs = 0
      SELECT CASE(symtyp)
        CASE (0)
                  nsrbs = 2*nob(1)
                
  	CASE (1)
  	          nsrbs = 2*(nob(1) + nob(2))
  	          
        CASE (2)
                  DO i=1,nsyml
                     nsrbs = nsrbs + nob(i)
                  END DO 
               	  nsrbs = nsrbs*2

        CASE DEFAULT 
                  WRITE(nftw, 9900)
                  STOP 
      END SELECT 
!
      IF (zdebug) THEN
        WRITE(nftw,1040) nsrbs
      END IF
!         
!=========================================================================
!                                                 
!     C O U N T   M A X I M A   F R O M   C S F s
!
!=========================================================================
!
! Looking at the number of determinants per CSF, we work out
! the CSF which has the maximum number of determinants.
!------------------------------------------------------------------------
!
      max_num_dets_input = MAXVAL(nodi)
      icsf_with_max      = MAXLOC(nodi)
!      WRITE(nftw,2990) icsf_with_max(1), max_num_dets_input
!
!-------------------------------------------------------------------------
! mop() needs to hold the expanded determinants when
! processing each CSF one at a time (see popnwf().
! Each det is then a list of "ieltp" spin orbs,
! where "ieltp" <= "nelt".
!
! So we can compute lenmop and allocate the array.  
! We over allocate by a factor (10 ?) here as the 
! later processing requirements are not precisely known.
!-------------------------------------------------------------------------
      lenmop = 7*nelt*max_num_dets_input
!      WRITE(nftw, 1055) lenmop
      ALLOCATE(mop(lenmop), stat=ierr )
      IF (ierr /= 0) THEN
          WRITE(nftw,9900) 
          WRITE(nftw,9925) lenmop
          STOP 999
      END IF
!         
!=========================================================================
!                                                 
!     L O O P   O V E R   C S F s
!
!=========================================================================
!
      IF (zdebug) THEN
        WRITE(nftw, 3000)
      END IF
!                                                                       
      nalm = 0 
      ipos_coeffs_out = 1
      ipos_dets_out   = 1




      DO n = 1, nocsf 
         num_dets_input  = nodi(n) 
         ipos_dets_input = indil(n)
         icdo(n) = ipos_coeffs_out 
         indo(n) = ipos_dets_out
!
         IF (zdebug) THEN
           WRITE(nftw,3010) n, nocsf, num_dets_input, 
     &                       ipos_dets_input,          
     &                       ipos_coeffs_out,          
     &                       ipos_dets_out
         END IF 
!
!-------------------------------------------------------------------------
! Step 1: Validate spatial and spin quantum numbers 
!         for all determinants in this CSF 
!-------------------------------------------------------------------------
!
!        Compute the overall change in spatial quantum number 
!        and in Sz component of spin for each determinant 
!        relative to the reference determinant.
!                           
!        The overall change in spatial and in spin quantum 
!        numbers relative to the reference determinant should 
!        be zero.
!
!        If not, then such a deterinant does not match the 
!        overall system quantum numbers and we have an error 
!        condition.
!                                            
!        Remember that we have already verified the quantum 
!        numbers of the reference determinant before calling 
!        this routine.
!-------------------------------------------------------------------------
!
         ipos_this_det = ipos_dets_input 
!
         DO idet = 1, num_dets_input 
            nreps = ndi(ipos_this_det) 
!
            IF (zdebug) THEN
              write(nftw,3020) n, idet, num_dets_input, nreps 
            END IF 
!            
            IF (nreps /=  0) THEN ! If 0 would be reference det 
              IF (zdebug) THEN
                WRITE(nftw,3030) (ndi(ipos_this_det+i),i=1,nreps)
                WRITE(nftw,3035) (ndi(ipos_this_det+nreps+i),i=1,nreps)
              END IF
!
              isum = 0 ! Sum of Sz over spin-orbs 

              SELECT CASE(symtyp)
  	        !
  	        !... C-inf-v and D-inf-h
  	        !
  	        CASE (:1)  
	                  msum = 0 
	                  DO i = 1, nreps 
	                     me   = ndi(ipos_this_det + i) 
	                     mf   = ndi(ipos_this_det + nreps + i) 
	                     isum = isum + ms(me) - ms(mf) 
	                     msum = msum + mm(me) - mm(mf) 
                          END DO 
                !
                !... Abelian point groups 
                !
                CASE (2) 
                   msum = 1 
                   DO i = 1, nreps 
                    me   = ndi(ipos_this_det + i) 
                    mf   = ndi(ipos_this_det + nreps + i) 
                    isum = isum + ms(me) - ms(mf) 
                    msum = 
     &               MPROD(msum,MPROD(mm(me)+1,mm(mf)+1,0,nftw),0,nftw)                                                       
                   END DO     
                        msum = msum - 1 
	        !
	        !... Erroneous "symtyp" value
	        !
                CASE (3:) 
               	         WRITE(nftw,9900)
               	         STOP
              END SELECT 
!
              IF (msum /= 0) THEN 
                WRITE(nftw, 9900)
                WRITE(nftw, 9214) idet, n 
                STOP 999
              END IF
!                                                                       
              IF (isum /= 0) THEN 
                WRITE(nftw,9900) 
                WRITE(nftw,9215) idet, n
                STOP 999
              END IF
!
            END IF ! End of if test on zero replacements 
!------------------------------------------------------------------------                                            
!           Align pointers for the next deterinant
!
!           Remember a determinant is stored as 
!
!               the number of replacements/replaced
!               each replaced    spin-orb
!               each replacement spin-orb
!                           
!           therefore this determinant was of length 2*md+1
!-------------------------------------------------------------------------
            ipos_this_det = ipos_this_det + nreps + nreps + 1 
!-------------------------------------------------------------------------
         END DO 
!
         IF (zdebug) THEN
           WRITE(nftw, 3090)
         END IF
!
!-------------------------------------------------------------------------
!                                                                       
!        Step 2: Find the number of electrons which are in 
!                orbitals that are not fully occupied.
!                These are known as "open shells".
!                Also find the list of the spin-orbitals 
!                corresponding to these. 
!
!-------------------------------------------------------------------------
!                               
!        popnwf() operates on the complete set of 
!        determinants defining this CSF. It is worth
!        remembering that in Alchemy a CSF is defined 
!        firstly as an assignment of orbital occupation 
!        numbers. One, or more, CSFs can then be formed 
!        by distributing electrons to the spin-orbitals
!        associated with this orbital assignment and 
!        then generating the required coupling coefficients.
!
!        On successful return, "ieltp" will hold the number
!        of electrons in open shells. This may even be zero.
!
!-------------------------------------------------------------------------
         num_dets_input  = nodi(n) 
         ipos_dets_input = indil(n)
!
         CALL popnwf(nsrb,nsrbs,nelt,ndtrf,lenmop,mdop, 
     &                mdcp,mop,mdc,mdo,                  
     &                ndta,                                     
     &                num_dets_input,ndi(ipos_dets_input),     
     &                idop,idcp,ieltp,                       
     &                ierr)
!     
!-------------------------------------------------------------------------		                                       
! Test for error condition and print details 
!-------------------------------------------------------------------------
         IF (ierr == 0) THEN
           IF (zdebug) THEN
             WRITE(nftw,4010) ieltp
           END IF
         ELSE
           WRITE(nftw,9900)
!
           SELECT CASE (ierr)
	      CASE (1) 
	                WRITE(nftw,233) n 
              CASE (2) 
	                WRITE(nftw,235) n 
              CASE (3:) 
               	        WRITE(nftw,237) n 
           END SELECT 
!           
           STOP 999
	 END IF 
!          
!-------------------------------------------------------------------------
!                                                                       
!        Step 3: Normalize the expansion coefficients 
!                associated with the determinants in this
!                CSF. These coefficients were obtained
!                from products of the Clebsch-Gordan
!                coupling coefficients.
!
!-------------------------------------------------------------------------
!                               
!        The computation depends on how many electrons 
!        are in open shells. 
!
!        Normalized expansion coefficients are placed into 
!        the array "cdo()" during this process.
!-------------------------------------------------------------------------
         ipos_coeffs_in = icdil(n) - 1 
!  
!-------------------------------------------------------------------------
!        0 or 1 ELECTRONS in OPEN SHELLS
!-------------------------------------------------------------------------
!
         IF (ieltp .LE. 1) THEN  ! 0 or 1 electrons in open shells.
!
           IF (zdebug) THEN
             WRITE (nftw,4510) 
             WRITE (nftw,4520) 
             WRITE (nftw,4522) ipos_coeffs_in, ipos_coeffs_out
             WRITE (nftw,4525) 
     &        (i,cdi(ipos_coeffs_in+1+i-1),i=1,num_dets_input)
           END IF
!           
           mysum = snrm2(num_dets_input, cdi(ipos_coeffs_in+1),1)
!           
           IF (zdebug) WRITE(nftw,4530) mysum
!           
           IF (mysum .LT. verysmall) THEN ! Monitor for very small numbers
             WRITE(nftw, 9900)
             WRITE(nftw, 2222) mysum
             STOP 999
           END IF
! 
           mysum = 1.0_wp/SQRT(mysum)  !MAL 10/05/2011: This was 1.0e00/SQRT(mysum) 
!
           DO i=1,num_dets_input 
              cdo(ipos_coeffs_out+i-1) = mysum * 
     &         cdi(ipos_coeffs_in+1+i-1) 
           END DO
!
           num_dets_final = num_dets_input
!           
           IF (zdebug) THEN
             WRITE(nftw,4540) 
             WRITE(nftw,4525)
     &              (i,cdo(ipos_coeffs_out+i-1),i=1,num_dets_final)
           END IF
!
!-------------------------------------------------------------------------
!         >= 2 ELECTRONS in OPEN SHELLS 
!-------------------------------------------------------------------------
!
         ELSE ! >= 2 electrons in open shells - project wfn  
!
           IF (zdebug) THEN
             WRITE(nftw,4610) 
             WRITE(nftw,4520) 
             WRITE(nftw,4522) ipos_coeffs_in, ipos_coeffs_out
             WRITE(nftw,4525) 
     &             (i,cdi(ipos_coeffs_in+1+i-1),i=1,num_dets_input)
           END IF
!
!-------------------------------------------------------------------------           
!          We need to copy the expansion coefficients
!          to temporary local storage 
!-------------------------------------------------------------------------
!
           IF (num_dets_input .GT. len_cdit) THEN 
             WRITE(nftw,9900)
             WRITE(nftw,9935) n, num_dets_input, len_cdit
             STOP 999
           ELSE
             DO i = 1, num_dets_input 
               cdit(i) = cdi(ipos_coeffs_in + i)
             END DO
           END IF
!
           IF (zdebug) THEN
             WRITE(nftw,4625) 
             WRITE(nftw,4525) (i,cdit(i),i=1,num_dets_input)
           END IF
!-------------------------------------------------------------------------                                                                      
!          Call PRJCT() to perform the spin projection
!
!           It is useful to remember that: 
!
!            ieltp = number of electrons 
!            mxss  = maximum Spin for projection
!            ma    = number of ddterminants
!            mop   = input determinants (overwritten on output)
!            cdit  = input coefficients with each determinant
!
!            nod   = Return code (>0 means number of dets in output)
!
!            cdo() = Coefficients of determinants after projection
!                    These are stored into cdo() beginning at
!                    location ipos_coeffs_out, which is updated
!                    for every CSF.
!
!           lencdo = space reaining in cdo() array - monitored 
!
!-------------------------------------------------------------------------
            mxss = ieltp
            lencdo = maxcdo - ipos_coeffs_out + 1
            lenmop = SIZE(mop)


            CALL prjct(ieltp, mxss, num_dets_input, mop, cdit,  
     &                  num_dets_final, cdo(ipos_coeffs_out),   
     &                  lencdo, mgvn, iss, isd, thres, r,      
     &                  ndta, mm, ms, lenmop, symtyp, nsrb)                   
!           
           IF (zdebug) THEN
             WRITE(nftw,4540) 
             WRITE(nftw,4525) 
     &             (i,cdo(ipos_coeffs_out+i-1),i=1,num_dets_final)
           END IF
!
         END IF
!          
!-------------------------------------------------------------------------
!        Step 4: Now we can move the determinants for this 
!                CSF into place in the output array.
!-------------------------------------------------------------------------
!
         IF (zdebug) THEN
           WRITE(nftw, 4060) 
           WRITE(nftw, 4062) num_dets_final, ieltp, idop, idcp, 
     &                        ipos_dets_out,                     
     &                        maxndo 
         END IF
!
         CALL pkwf(num_dets_final,ieltp,cdo(ipos_coeffs_out), 
     &              mop,                                          
     &              idop,mdop,idcp,mdcp,                        
     &              nftw,                                      
     &              ipos_dets_out,ndo,maxndo,n)
!              
!-------------------------------------------------------------------------                               
! Record the number of dets for this CSF in nodo()
!-------------------------------------------------------------------------
! Update pointer to next location in cdo().
!-------------------------------------------------------------------------
!
         nodo(n) = num_dets_final  
         ipos_coeffs_out = ipos_coeffs_out + num_dets_final 
!
!-------------------------------------------------------------------------
! Screen for exhaustion of memory in ndo(), cdo()
!-------------------------------------------------------------------------
!
         IF (ipos_dets_out .GE. maxndo) THEN
           WRITE(nftw,9900) 
           WRITE(nftw,9981) n, maxndo
           STOP 999
         END IF
!         
         IF (ipos_coeffs_out .GE. maxcdo) THEN
           WRITE(nftw,9900) 
           WRITE(nftw,9982) n, maxcdo
           STOP 999
         endif
!
!-------------------------------------------------------------------------
! Finished with this CSF
!-------------------------------------------------------------------------
!
         IF (zdebug) THEN
           WRITE (nftw,4690) n
         END IF
!
      END DO 
!                      
!=========================================================================
!                                                 
!     E N D   L O O P   O V E R   C S F s
!
!=========================================================================
! Finished with dynamic array mop()
!-------------------------------------------------------------------------
!
      IF (allocated(mop)) THEN
!
        DEALLOCATE(mop, stat=ierr)
!
        IF(0 .ne. ierr) THEN
          WRITE(nftw,9900)
          WRITE(nftw,9927) lenmop 
          STOP 999
        END IF
      END IF
!
!-------------------------------------------------------------------------
! Need starting values for the "N+1" th CSF (which does not exist).
!
! These also serve as an upper bound for the "N" th CSF and are used
! in loops in the subsequent code whihc evaluates symbolic energy 
! expressions
!-------------------------------------------------------------------------
!
      indo(nocsf+1)= ipos_dets_out 
      icdo(nocsf+1)= ipos_coeffs_out 
!
!-------------------------------------------------------------------------
! High watermark in both arrays needs to be returned to caller.
!-------------------------------------------------------------------------
!
      lenndo = ipos_dets_out   - 1
      lencdo = ipos_coeffs_out - 1
!
!-------------------------------------------------------------------------
! Looking at the number of determinants per CSF, we work out
! the CSF which has the maximum number of determinants.
!-------------------------------------------------------------------------
!
      max_num_dets_output = MAXVAL( nodo )
      icsf_with_max       = MAXLOC( nodo )
!
      WRITE(nftw,2992) icsf_with_max(1), max_num_dets_output
!
!--------------------------------------------------------------------------           
! Subroutine return point
!--------------------------------------------------------------------------                                                           
!
      WRITE(nftw,7990) lenndo, maxndo, lencdo, maxcdo
      WRITE(nftw,8000) 
!
!--------------------------------------------------------------------------
! Format statements
!--------------------------------------------------------------------------
!
! 126 format('1 INPUT FUNCTIONS IN PACKED FORM') 
! 204 format('1 OUTPUT FUNCTIONS, ORBITALS IN OPEN SHELL',//) 
  233 format(I6,' TH WF IN ERROR, (NO. OF OPEN SO NOT =)') 
  237 format(I6,' TH WF IN ERROR,(NELTP=0,BUT NOD GT. 1)') 
  235 format('  NEED MORE SPACE FOR MOP IN',I5,' TH WF',/, 
     &        '  Increase parameter LNDT in input')         
! 244 format(5X,20I5) 
! 270 format(I6,' TH WF,(TOO MANY DTRS IN R)') 
! 271 format(I6,' TH WF,(R PROJ. IMPOSSIBLE)') 
! 272 format(I6,' TH WF,(TOO MANY DTRS IN SPIN)') 
! 273 format(I6,' TH WF,(SPIN PROJ. IMPOSSIBLE)') 
! 286 format(5X,I5,D20.10,9X,'0') 
! 287 format(10X,D20.10,9X,'0') 
! 288 format(5X,I5,D20.10,5X,20I4/(35X,20I4))  
! 289 format(10X,D20.10,5X,20I4/(35X,20I4)) 
! 292 format('  NEED MORE SPACE IN NDO AT',I6,' TH WF',/, &
!            '  Re-run with increased memory')                       
! 296 format(' EXCEED CDO STORAGE AT',I6,'TH WF') 
!
 1000 format(/,10x,'====> WFGNTR() <====',/)
 1010 format(10x,'Input data: ',/,
     &        10x,'  mgvn  = ',i10,/,    
     &        10x,'  iss   = ',i10,/,    
     &        10x,'  isd   = ',i10,/,    
     &        10x,'  thres = ',f12.5,/,  
     &        10x,'  r     = ',f12.5,/,  
     &        10x,'  nsyml = ',i10,/,    
     &        10x,'  nelt  = ',i10,/,    
     &        10x,'  nocsf = ',i10,/,    
     &        10x,'  nsrb  = ',i10)
 1020 format(10x,'  norb  = ',i10,/,    
     &        10x,'  ndmx  = ',i10,/,    
     &        10x,'  ncmx  = ',i10,/,    
     &        10x,'  ndmxp = ',i10,/)
 1030 format(10x,'  maxcdo = ',i10,/,
     &        10x,'  maxndo = ',i10,/)
!             
 1035 format(5x,'Spin orbitals table of quantum numbers',//,
     &        5x,'  I      N      G      M      S     MPOS   ',/,
     &        5x,'-----  -----  -----  -----  -----  -----   ')
 1036 format((5x,6(i5,2x)))
 1037 format(/,5x,'**** End of table of spin-orbitals ',/)
!
 1040 format(10x,'No. non-degenerate spin orbitals (nsrbs) = ',i6,/)
 1055 format(10x,'Allocating ',i8,' integers for array mop() ',/)
!
 1500 format(/,10x,'Allocated ',i10,' integer units to array nr() ',/)
!
 2222 format(/,' Sum IN WFGNTR =',E20.12,//) 
! 
 2990 format(/,10x,'On input CSF ',i7,' has the largest ',/,
     &          10x,'number of determinants = ',i7,/) 
 2992 format(/,10x,'On output CSF ',i7,' has the largest ',/,
     &          10x,'number of determinants = ',i7,/) 
!
 3000 format(/,10x,'Entering loop over CSFs ',/)
 3010 format(/,10x,'>>>> Processing input CSF ',i10,' of ',i10,//,  
     &          10x,'Number of determinants (num_dets_input) = ',i7,/, 
     &          10x,'1st in pkd dets array (ipos_dets_input) = ',i7,//, 
     &          10x,'1st in Out coefs arry (ipos_coeffs_out) = ',i7,/, 
     &          10x,'1st in Output dets arry (ipos_dets_out) = ',i7)
 3020 format(/,15x,'CSF ',i7,' - Det. ',i6,' of ',i6,//,
     &          20x,'Number of replacements (nreps) = ',i5,/)
 3030 format(20x,'Replaced spin orbs    : ',20(i3,1x))
 3035 format(20x,'Replacments spin. orbs: ',20(i3,1x))
 3090 format(/,15x,'Quantum numbers for all determinants in this CSF',/,
     &          15x,'have been validated.',/)
!
 4010 format(15x,'Number of electrons in open shells (ieltp) = ',i5,/)
 4050 format(15x,'The expansion coefficients for each determinant ',/
     &        15x,'have been normalized.',/)
 4060 format(/,15x,'This projected CSF will now be packed into',/
     &        15x,'into the array holding all output packed CSF',/)
 4062 format(15x,'Data sent into PKWF() follows: (old name/new name)',/,
     &        15x,'    nod   (num_dets_final) = ',i10,/, 
     &        15x,'    neltp (ieltp)          = ',i10,/, 
     &        15x,'    idop  (idop)           = ',i10,/, 
     &        15x,'    idcp  (idcp)           = ',i10,/, 
     &        15x,'    no    (ipos_dets_out)  = ',i10,/, 
     &        15x,'    ndmx  (maxndo)         = ',i10,/)
!
 4510 format(15x,'Normalizing CSF expansion coefficients using ',/,
     &        15x,'the SNRM2 function. Projection is not needed.'/)
 4520 format(/,15x,'CSF coefficients before normalization: ',/)
 4522 format(15x,'Storage locs for input and output coefficients: ',//,
     &        15x,'  For cdi(), ipos_coeffs_in  = ',i7,//,
     &        15x,'  For cdo(), ipos_coeffs_out = ',i7,/)
 4525 format(15x,i6,'.  ',2x,f13.7)
 4530 format(/,15x,'Sum - sqrs of coefficients (this CSF) = ',d13.6,/)
 4540 format(/,15x,'CSF coefficients after normalization: ',/)
!
 4610 format(15x,'Normalizing CSF expansion coefficients using ',/,
     &        15x,'projection because it has >= 2 electrons in  ',/,
     &        15x,'open shells.                                 '/)
!
 4625 format(/,15x,'Coefficients have been copied into CDIT(): ',/)
!
 4690 format(/,10x,'<<<< Completed processing of CSF number ',i6,/)
!
 7990 format(/,10x,'At end of wfgntr(), usage of memory in output',/,
     &          10x,'arrays is as follows:                        ',//,
     &          10x,'  Array     Used     Max avail               ',/,
     &          10x,'  -----  ---------   ---------               ',/,
     &          10x,'  ndo()  ',i9,2x,i9,/,
     &          10x,'  cdo()  ',i9,2x,i9,/) 
 8000 format(/,10x,'**** WFGNTR() - completed ',/)
!
!.... Error messages
!
 9214 format(5x,'Spatial symmetry for determinant ',i5,/,    
     &        5x,'in  CSF ',i5,' does not match ref determinant',/)
 9215 format(5x,'Sz quantum number for determinant ',i5,/,   
     &        5x,'in  CSF ',i5,' does not match ref determinant',/)
! 
 9900 format(/,5x,'***** Error in: wfngtr() ',//)
 9925 format(5x,'Cannot allocate array mop() of length (lenmop) ',i8,/)
 9927 format(5x,'Cannot de-alloc array mop() of length (lenmop) ',i8,/)
 9935 format(5x,'Insufficient space in cdit() for projection  ',/,
     &        5x,'CSF ',i10,' has ',i10,' determinants         ',/,
     &        5x,'cdit() holds the expansion coefficient       ',/,
     &        5x,'for each determinant and len_cdit must be    ',/,
     &        5x,'at least as big as the number of determinants',/,
     &        5x,'Currenttly it is fixed at ',i10,/)
 9955 format(5x,'WFNGTR() has received an error on return',/,
     &        5x,'fromPOPNWF(). Code is terminating now.',/) 
 9981 format(5x,'CSF ',i7,' has exhausted space available in ndo',/,
     &        5x,'Available (maxndo) = ',i10)    
 9982 format(5x,'CSF ',i7,' has exhausted space available in cdo',/,
     &        5x,'Available (maxcdo) = ',i10)    
!
      END SUBROUTINE wfgntr



!*==wfn.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE WFN(NNCSF,NADEL,IIDIST,IIDIS3,NODI,NDI,CDI,NDEL,PQNSHL,
     &               X,IX,NX)
C     NOI # OF STATES (NODI)
C     NID # OF DETERMINANTS (CDI)
C     NI # OF REPLACEMENTS (NDI)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      USE CONGEN_DATA, ONLY : LRATIO, IIDIS2, LCDI, LCDT, NI, 
     &                        NID, NOI, EXDET, EXREF, NOREP, NONEW, 
     &                        NTSO, NOIMX=>NODIMX, NIDMX=>CDIMX, 
     &                        JMX=>NDIMX, MEGUL, NSOI, NCALL, NFTW, 
     &                        CONFPF, NCSF, NDIST, NSHL, OCCSHL, 
     &                        SSHL=>SSHLST, SHLMX1, NNDEL,NELEC=>NNLECG,
     &                        NDIMX
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: IIDIS3, IIDIST, NADEL, NNCSF, NX
      REAL(KIND=wp), DIMENSION(*) :: CDI, X
      INTEGER, DIMENSION(*) :: IX, NDEL, NDI, NODI, PQNSHL
      INTENT (IN) NDEL, PQNSHL
      INTENT (OUT) IIDIS3
      INTENT (INOUT) CDI, IIDIST, NADEL, NDI, NNCSF, NODI
C
C Local variables
C
      INTEGER :: DET, I, IA, IB, ID, IDIST, IIDIS1, IREP, J, K, K1, 
     &           KSHL, KSHLST, LF, LI, ND, NII

      SAVE IIDIS1 ! JMC adding this in consultation with Jonathan Tennyson because the variable was found to be used but not set in tests...
                  ! The other variables initialized in the 1st call to this routine are (former) common block variables now in congen_data.
C
C*** End of declarations rewritten by SPAG
C
      IF(NCALL.NE.1)GO TO 11
      LCDI=0
      LCDT=0
      NOI=0
      NID=0
      IIDIS1=0
      IIDIS2=0
      NI=0
      NCALL=0
 11   CONTINUE
C
      CALL STATE(NSHL,X,NX,ND,CONFPF)
C
      IF(ND.LE.0)GO TO 1000
C
      KSHLST=0
      IIDIST=0
      IDIST=0
      IF(NNDEL.NE.0 .AND. NADEL.GT.NNDEL)RETURN
 100  IDIST=IDIST+1
      NNCSF=NNCSF+1
      IF(IDIST.GT.NDIST)RETURN
      IF(NNDEL.NE.0 .AND. NDEL(NADEL).NE.NNCSF)GO TO 105
      NCSF=NCSF+1
      IF(NNDEL.NE.0)THEN
         NADEL=NADEL+1
         IIDIST=IIDIST+1
      END IF
      K=ND*LRATIO
      IA=ND*(2*NELEC+1)+NI
      IB=ND+NID
      K1=NOI+1
      IF(IA.LE.JMX .AND. IB.LE.NIDMX .AND. K1.LE.NOIMX)GO TO 120
      IF(NNDEL.NE.0 .AND. IIDIS2.EQ.0)GO TO 450
      WRITE(MEGUL)NOI, (NODI(I),I=1,NOI)
      WRITE(MEGUL)NID, (CDI(I),I=1,NID)
      WRITE(MEGUL)NI, (NDI(I),I=1,NI)
      LCDI=LCDI+NID
      LCDT=LCDT+NI
 450  NOI=0
      NI=0
      NID=0
 120  CONTINUE
      NII=NI+1
      DO ID=1, ND
         DO I=1, NTSO
            EXDET(I)=0
         END DO
         KSHL=KSHLST
         LF=0
         DO I=1, NSHL
            LI=LF+1
            LF=LF+OCCSHL(I)
            KSHL=KSHL+1
            DO J=LI, LF
               K=K+1
               DET=IX(K)+NSOI(SSHL(I))+(PQNSHL(KSHL)-1)*SHLMX1(SSHL(I))
               EXDET(DET)=1
            END DO
         END DO
         IA=1
         IB=1
         DO I=1, NTSO
            IF(EXDET(I).LT.EXREF(I))THEN
               NOREP(IA)=I
               IA=IA+1
            ELSE IF(EXDET(I).GT.EXREF(I))THEN
               NONEW(IB)=I
               IB=IB+1
            END IF
         END DO
         IREP=IB-1
         NI=NI+1
C ZM check that NI does not overflow NDIMX
C    If NDI was allocatable we could resize it here
         IF (NI+2*IREP > NDIMX) THEN
            WRITE(NFTW,1002) NI+2*IREP,NDIMX
            STOP 81
         ENDIF
         NDI(NI)=IREP
         DO I=1, IREP
            NI=NI+1
            NDI(NI)=NOREP(I)
            NDI(NI+IREP)=NONEW(I)
         END DO
         NI=NI+IREP
      END DO
C
      IF(CONFPF.GE.40)CALL PRINT5(ND,NDI(NII))
      NOI=NOI+1
C ZM check that NOI does not overflow NODIMX
C    If NODI was allocatable we could resize it here
      IF (NOI > NOIMX) THEN
         WRITE(NFTW,1003) NOI,NOIMX
         STOP 82
      ENDIF
      NODI(NOI)=ND
C ZM check that NID+ND does not overflow CDIMX
C    If CDI was allocatable we could resize it here
      IF (NID+ND > NIDMX) THEN
         WRITE(NFTW,1004) NID+ND,NIDMX
         STOP 83
      ENDIF
      DO I=1, ND
         NID=NID+1
         CDI(NID)=X(I)
      END DO
      KSHLST=KSHL
      GO TO 130
 105  DO I=1, NSHL
         KSHLST=KSHLST+1
      END DO
 130  IF(IDIST.LT.NDIST)GO TO 100
      IIDIS1=IIDIS1+IIDIST
      IIDIS2=IIDIST+IIDIS2
      IF(CONFPF.GE.30 .AND. IIDIST.GT.0)
     &   CALL PRINT4(ND,X,IX(ND*LRATIO+1))
      IIDIS3=IIDIS1
      RETURN
 1000 WRITE(NFTW, 1001)
 1001 FORMAT('1','*******   ERROR IN WFN ND=0'//)
      STOP 70
 1002 FORMAT('*******   ERROR IN WFN, NDIMX TOO SMALL',2I10)
 1003 FORMAT('*******   ERROR IN WFN, NODIMX TOO SMALL',2I10)
 1004 FORMAT('*******   ERROR IN WFN, CDIMX TOO SMALL',2I10)
      END SUBROUTINE WFN
!*==wfnin0.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE WFNIN0(NELECP,DEFLTC,NERFG,ERFG,GNAME,QNTAR,ERRORG,
     &                  NDPMAX)
C
C     DEFAULTS TO BE RESET BEFORE EVERY WFNGRP
C
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: DEFLTC, NDPMAX, NERFG
c     define errorg as logical
      LOGICAL :: ERRORG
      CHARACTER(LEN=80) :: GNAME
      LOGICAL, DIMENSION(*) :: ERFG
      INTEGER, DIMENSION(*) :: NELECP
      INTEGER, DIMENSION(3) :: QNTAR
      INTENT (IN) NDPMAX, NERFG
      INTENT (OUT) DEFLTC, ERFG, GNAME, NELECP, QNTAR
C
C Local variables
C
      CHARACTER(LEN=8) :: BLANK='        '
      INTEGER :: I
C
C*** End of declarations rewritten by SPAG
C
      DO I=1, NDPMAX
         NELECP(I)=-1
      END DO
      GNAME=BLANK
      DEFLTC=0
      DO I=1, NERFG
         ERFG(I)=.FALSE.
      END DO
C
      QNTAR(1)=-1
      QNTAR(2)=0
      QNTAR(3)=0
C
      RETURN
      END SUBROUTINE WFNIN0
!*==wfnin.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE WFNIN(NWFNGP,NADEL,NNCSF,NCSF,LCDI,LNDI,NELECG,NDPROD,
     &                 NREFOG,NPCUPF,NEGMAX,REFDTG,NRFGMX,REFGUG,NTCON,
     &                 REFORG,NSHGMX,NSYMMX,MSHL,GUSHL,PQN,CUP,NDPMAX,
     &                 NSHLP,NCONMX,TEST,NRCON,NSHCON,TCON,ERRORG)
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      LOGICAL :: ERRORG
      INTEGER :: LCDI, LNDI, NADEL, NCONMX, NCSF, NDPMAX, NDPROD, 
     &           NEGMAX, NELECG, NNCSF, NPCUPF, NREFOG, NRFGMX, NSHGMX, 
     &           NSYMMX, NTCON, NWFNGP
      INTEGER, DIMENSION(3,*) :: CUP, PQN
      INTEGER, DIMENSION(*) :: GUSHL, MSHL, NRCON, NSHCON, NSHLP, 
     &                         REFDTG, REFGUG, TEST
      INTEGER, DIMENSION(5,*) :: REFORG
      INTEGER, DIMENSION(3,NSHGMX,*) :: TCON ! JMC the dimensions could be changed to (3,JX,JZ) if desired.
      INTENT (IN) NCONMX, NDPMAX, NEGMAX, NRFGMX, NSHGMX, NSYMMX
      INTENT (OUT) CUP, ERRORG, GUSHL, LCDI, LNDI, MSHL, NADEL, NCSF, 
     &             NDPROD, NELECG, NNCSF, NPCUPF, NRCON, NREFOG, NSHCON, 
     &             NSHLP, NTCON, NWFNGP, PQN, REFDTG, REFGUG, REFORG, 
     &             TCON, TEST
C
C Local variables
C
      INTEGER :: I, J, K
C
C*** End of declarations rewritten by SPAG
C
C     GENERAL DEFAULT FOR WFNGRP ARRAYS
C
      NWFNGP=0
      NADEL=1
      NNCSF=0
      NCSF=0
      LCDI=0
      LNDI=0
C
      NELECG=0
      NDPROD=0
      NREFOG=0
      NPCUPF=0
      DO I=1, NEGMAX
         REFDTG(I)=0
      END DO
      DO I=1, NRFGMX
         REFGUG(I)=-2
         DO J=1, 5
            REFORG(J,I)=-2
         END DO
      END DO
      NTCON=0
      DO I=1, NSHGMX
         MSHL(I)=NSYMMX+1
         GUSHL(I)=-2
         DO J=1, 3
            PQN(J,I)=-1
            CUP(J,I)=-1
         END DO
      END DO
      ERRORG=.FALSE.
      DO I=1, NDPMAX
         NSHLP(I)=0
      END DO
      DO I=1, NCONMX
         TEST(I)=1
         NRCON(I)=-1
         NSHCON(I)=0
         DO K=1, NSHGMX
            TCON(1,K,I)=-1
            TCON(2,K,I)=0
            TCON(3,K,I)=0
         END DO
      END DO
      RETURN
      END SUBROUTINE WFNIN

      SUBROUTINE wrnfto(sname,mgvn,s,sz,r,pin,norb,nsrb,      
     &                   nocsf,nelt,idiag,nsym,symtyp,         
     &                   nob,ndtrf,nodo,m,icdo,indo,           
     &                   ndo,lndi,cdo,lcdi,nfto,nobl,nx,       
     &                   npflg,thres,iposit,nob0,nob0l,nctarg, 
     &                   ntgsym,notgt,nctgt,mcont,gucont,iphz, 
     &                   nobe,nobp,nobv,maxtgsym)
!-------------------------------------------------------------------------
!     WRNFTO - WRite wavefunction data to unit NFTO
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! MAL 10/05/2011 : This subroutine has been changed to bring it into
! line with the changes that have been made to 'projec' in order to
! utilize dynamic memory. 'wrnfto' has also been modified in order to
! comply to the F95 standard
!-------------------------------------------------------------------------
      USE precisn
      IMPLICIT NONE
!
      INTEGER                    :: symtyp,i,nfto,iposit,norb,
     &                              nsrb,idiag,itg,maxtgsym,mgvn,
     &                              norbw,nsrbw,lcdi,lndi,
     &                              nsym,nelt,m,nx,nctarg,
     &                              ntgsym,nocsf
      INTEGER, PARAMETER         :: iwrite = 6
      INTEGER, DIMENSION(nsym)   :: nob,nob0,nobe,nobp,nobv
      INTEGER, DIMENSION(nelt)   :: ndtrf
      INTEGER, DIMENSION(nocsf)  :: nodo
      INTEGER, DIMENSION(m)      :: icdo,indo
      INTEGER, DIMENSION(lndi)   :: ndo
      INTEGER, DIMENSION(ntgsym) :: notgt,nctgt,mcont,gucont
      INTEGER, DIMENSION(nctarg) :: iphz
      INTEGER, DIMENSION(20)     :: nobw
      INTEGER, DIMENSION(nx)     :: nobl,nob0l
      INTEGER, DIMENSION(6)      :: npflg
      REAL(KIND=wp),DIMENSION(lcdi)   :: cdo
      REAL(KIND=wp)              :: s,sz,r,pin,thres
      CHARACTER(120)             :: name 
      CHARACTER(80)              :: sname
!      
!-------------------------------------------------------------------------
!     Debug banner header
!-------------------------------------------------------------------------      
!
      WRITE(iwrite,1000)
      WRITE(iwrite,1010) nfto, iposit, nelt, nocsf, nsym, symtyp
      WRITE(iwrite,1020) (nob(i),i=1,nsym)
      WRITE(iwrite,1025) norb, nsrb
      WRITE(iwrite,1030) m
      WRITE(iwrite,1035) lcdi
      WRITE(iwrite,1040) lndi
      WRITE(iwrite,1045) s, sz, r, pin, idiag
!      
      name = ' '
      name = sname
!
      norbw = norb
      nsrbw = nsrb
!
      DO i=1,nsym
         nobw(i) = nob(i)
      END DO
!
!--------------------------------------------------------------------------
!     Rewind the unit before writing on it
!--------------------------------------------------------------------------
!
      REWIND nfto
!
!--------------------------------------------------------------------------
!     Slightly different formats if positrons are involved
!--------------------------------------------------------------------------
!
      IF (iposit .EQ. 0) THEN
         WRITE(NFTO) name,mgvn,s,sz,r,pin,norbw,nsrbw,       
     &                nocsf,nelt,lcdi,idiag,nsym,symtyp,lndi, 
     &                npflg,thres,nctarg,ntgsym
         IF (ntgsym .GT. 0) WRITE(nfto) iphz,nctgt,notgt,mcont,gucont
         IF (ntgsym .LE. 0) WRITE(nfto) iphz
         WRITE(nfto) (nobw(i),i=1,nsym),ndtrf,nodo,iposit,nob0,nobl,
     &                nob0l
      ELSE
         WRITE(nfto) name,mgvn,s,sz,r,pin,norbw,nsrbw,       
     &                nocsf,nelt,lcdi,idiag,nsym,symtyp,lndi, 
     &                npflg,thres,nctarg,maxtgsym
         IF (maxtgsym .GT. 0) THEN
            WRITE(nfto) iphz
            WRITE(nfto) (nctgt(itg),itg=1,maxtgsym) 
            WRITE(nfto) (notgt(itg),itg=1,maxtgsym) 
            WRITE(nfto) (mcont(itg),itg=1,maxtgsym) 
            WRITE(nfto) (gucont(itg),itg=1,maxtgsym)
         END IF
         IF (maxtgsym .LE. 0) WRITE(nfto) iphz
         WRITE(nfto) (nobw(i),i=1,nsym),ndtrf,nodo,iposit,nob0,nobl,
     &                 nob0l
         WRITE(nfto) (nobe(i),i=1,nsym)
         WRITE(nfto) (nobp(i),i=1,nsym)
         WRITE(nfto) (nobv(i),i=1,nsym)
      END IF 
!
!-------------------------------------------------------------------------
! Now come the determinants per CSF
!-------------------------------------------------------------------------
!
      WRITE(nfto) icdo,indo
      WRITE(nfto) ndo
      WRITE(nfto) cdo
!-------------------------------------------------------------------------
! Subroutine return point
!-------------------------------------------------------------------------
!
!-------------------------------------------------------------------------
! Format statements
!-------------------------------------------------------------------------
!
 1000 format(/,5x,'Writing final results to disk (wrnfto) ',/,
     &          5x,'-------------------------------------- ') 
 1010 format(5x,'  Logical unit         (nfto)   = ',i8,/,
     &        5x,'  Positrons present    (iposit) = ',i8,/,
     &        5x,'  Number of electrons  (nelt)   = ',i8,/,
     &        5x,'  Number of CSFs       (nocsf)  = ',i8,/,
     &        5x,'  Number of symmetries (nsym)   = ',i8,/,
     &        5x,'  Point group flag     (symtyp) = ',i8)
 1020 format(5x,'  Orbitals per symm    (nob)    :  ',(20(i3,1x)))
 1025 format(5x,'  Total # of orbitals  (norb)   = ',i8,/,
     &        5x,'  Total # of spin orbs (nsrb)   = ',i8,/)
 1030 format(5x,'  Length of index  arrays - icdo,indo (m)    = ',i8)
 1035 format(5x,'  Length of coeff. array  - cdo       (lcdi) = ',i8,/,
     &        5x,'    (equals # dets in wfn)')
 1040 format(5x,'  Length of packed dets array - ndo   (lndi) = ',i8,/)
 1045 format(5x,'  Spin quantum number  (s)      = ',f8.2,/,
     &        5x,'  Z-projection of spin (sz)     = ',f8.2,/,
     &        5x,'  Reflection quant. #  (r)      = ',f8.2,/,
     &        5x,'  Pin                  (pin)    = ',f8.2,/,
     &        5x,'                       (idiag)  = ',i8,/)
!
      END SUBROUTINE wrnfto


!*==wrnmlt.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE WRNMLT(K,SNAME,NRERUN,MEGUL,SYMTYP,MGVN,S,SZ,R,PIN,
     &                  NCSF,BYPROJ,LCDI,LNDI,LCDO,LNDO,LCDT,LNDT,NFTO,
     &                  LTRI,IDIAG,NPFLG,THRES,NELECT,NSYM,NOB,REFDET,
     &                  NFTW,IPOSIT,NOB0,NOBL,NOB0L,NX,nobe,nobp,nobv)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: BYPROJ, IDIAG, IPOSIT, K, LCDI, LCDO, LCDT, LNDI, LNDO, 
     &           LNDT, LTRI, MEGUL, MGVN, NCSF, NELECT, NFTO, NFTW, 
     &           NRERUN, NSYM, NX, SYMTYP
      REAL(KIND=wp) :: PIN, R, S, SZ, THRES
      CHARACTER(LEN=80) :: SNAME
      INTEGER, DIMENSION(*) :: NOB, NOB0, REFDET
      INTEGER, DIMENSION(NX) :: NOB0L, NOBL
      INTEGER, DIMENSION(nx) :: NOBE, NOBP, NOBV
      INTEGER, DIMENSION(6) :: NPFLG
      INTENT (IN) BYPROJ, IDIAG, IPOSIT, K, LCDI, LCDO, LCDT, LNDI, 
     &            LNDO, LNDT, LTRI, MEGUL, MGVN, NCSF, NELECT, NFTO, 
     &            NOB, NOB0, NOB0L, NOBE, NOBL, NOBP, NOBV, NPFLG, 
     &            NRERUN, NSYM, NX, PIN, R, REFDET, S, SNAME, SYMTYP, 
     &            SZ, THRES
C
C Local variables
C
      CHARACTER(LEN=4) :: BLANK1='    '
      INTEGER :: J
C
C*** End of declarations rewritten by SPAG
C
      WRITE(K,10)SNAME, NRERUN, MEGUL, SYMTYP, MGVN, S, SZ, R, PIN, NCSF
      WRITE(K,20)BYPROJ
      WRITE(K,30)LCDI, LNDI, LCDO, LNDO, LCDT, LNDT, NFTO, LTRI, IDIAG, 
     &           NPFLG, THRES
      WRITE(K,40)NELECT, NSYM, (NOB(J),J=1,NSYM)
      WRITE(K,50)(BLANK1,REFDET(J),J=1,NELECT)
      WRITE(K,52)NOBL
      WRITE(K,53)NOB0L
      IF(IPOSIT.NE.0)THEN
         WRITE(K,54)iposit
         WRITE(K,55)(NOB0(J),J=1,NSYM)
         WRITE(K,56)(NOBE(J),J=1,NSYM)
         WRITE(K,57)(NOBP(J),J=1,NSYM)
         WRITE(K,58)(NOBV(J),J=1,NSYM)
      END IF
      WRITE(K,60)
C
 10   FORMAT(' &INPUT',/,' NAME=''',A80,''',',/,' NRERUN=',I3,
     &       ',  MEGUL=',I3,',  SYMTYP=',I3,',',/,' MGVN=',I3,',  S=',
     &       F6.1,',SZ=',F6.1,', R=',F6.1,',  PIN=',F6.1,',  NOCSF=',I6,
     &       ',')
 20   FORMAT(' BYPROJ=',I2,',')
 30   FORMAT(' LCDI=',I15,',  LNDI=',I15,', LCDO=',I7,', LNDO=',I15,',',
     &       ' LCDT=',I7,',  LNDT=',I7,',',/,' NFTO=',I3,',  LTRI=',I5,
     &       ', IDIAG=',I3,', NPFLG=',5(I2,','),' NPMSPD =',I2,
     &       ','/' THRES=',1PD9.2,',')
 40   FORMAT(' NELT=',I4,', NSYM=',I3,', NOB=',10(I3,','))
 50   FORMAT(' NDTRF=',A1,12(I3,',',A1)/(8X,12(I3,',',A1)))
 52   FORMAT(' NOBL=',10(I3,','))
 53   FORMAT(' NOB0L=',10(I3,','))
 54   FORMAT(' IPOSIT=',I3)
 55   FORMAT(' NOB0=',10(I3,','))
 56   FORMAT(' NOBE=',10(I3,','))
 57   FORMAT(' NOBP=',10(I3,','))
 58   FORMAT(' NOBV=',10(I3,','))
 60   FORMAT(' &END')
C
      RETURN
      END SUBROUTINE WRNMLT


!*==wrwf.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE WRWF(NFT,N1,NODO,N2,CDO,N3,NDO)
      USE precisn, ONLY : wp ! for specifying the kind of reals                        
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: N1, N2, N3, NFT
      REAL(KIND=wp), DIMENSION(N2) :: CDO
      INTEGER, DIMENSION(N3) :: NDO
      INTEGER, DIMENSION(N1) :: NODO
      INTENT (IN) CDO, N1, N2, N3, NDO, NFT, NODO
C
C*** End of declarations rewritten by SPAG
C
      REWIND NFT
C
      WRITE(NFT)N1, NODO
      WRITE(NFT)N2, CDO
      WRITE(NFT)N3, NDO
C
      REWIND NFT
      RETURN
      END SUBROUTINE WRWF
!*==wvwrit.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
      SUBROUTINE WVWRIT(NWFNGP,GNAME,NELECG,DEFLTC,IRFCON,NDPROD,SYMTYP,
     &                  NTCON,NAVAIL,NREFOG,NELECP,NSHLP,QNTAR,NSHLPT,
     &                  NSHGMX,MSHL,GUSHL,PQN,CUP,NCUPP,NPCUPF,REFDTG,
     &                  NELP,NTCONP,NSHCON,NOBT,REFORB,REFGU,TEST,NRCON,
     &                  TCON,REFCON,NERFG,ERFG,NDPP,NREFOP,ERRORG)
      USE CONGEN_DATA, ONLY : NFTW, RHEAD
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: DEFLTC, IRFCON, NAVAIL, NCUPP, NDPP, NDPROD, 
     &           NELECG, NELP, NERFG, NOBT, NPCUPF, NREFOG, NREFOP, 
     &           NSHGMX, NSHLPT, NTCON, NTCONP, NWFNGP, SYMTYP
      LOGICAL :: ERRORG
      CHARACTER(LEN=80) :: GNAME
      INTEGER, DIMENSION(3,*) :: CUP, PQN
      LOGICAL, DIMENSION(11) :: ERFG
      INTEGER, DIMENSION(*) :: GUSHL, MSHL, NELECP, NRCON, NSHCON, 
     &                         NSHLP, REFCON, REFDTG, REFGU, TEST
c     change refcon from integer to couble for consistency
c      DOUBLE PRECISION  REFCON(*) ! jmc the correponding actual arg is d.p. ???
      INTEGER, DIMENSION(3) :: QNTAR
      INTEGER, DIMENSION(5,*) :: REFORB
      INTEGER, DIMENSION(3,NSHGMX,*) :: TCON ! jmc changing the 2nd dimension from LG to NSHGMX for consistency with elsewhere.
                                             ! The dimensions could also be changed to (3,JX,JZ) if desired.
      INTENT (IN) CUP, DEFLTC, ERFG, GNAME, GUSHL, IRFCON, MSHL, 
     &            NAVAIL, NCUPP, NDPP, NDPROD, NELECG, NELECP, NELP, 
     &            NERFG, NOBT, NPCUPF, NRCON, NREFOG, NREFOP, NSHCON, 
     &            NSHGMX, NSHLP, NSHLPT, NTCON, NTCONP, NWFNGP, PQN, 
     &            QNTAR, REFCON, REFDTG, REFGU, REFORB, SYMTYP, TCON
      INTENT (INOUT) ERRORG, TEST
C
C Local variables
C
      CHARACTER(LEN=32), DIMENSION(11) :: ERSNTG
      CHARACTER(LEN=4) :: HCUP='CUP ', HTCON='TCON', LPC='  ( '
      INTEGER :: I, I1, I2, IC, II, IIMAX, IMAX, IP, ISHP, IT, JJ, 
     &           JNSHL, NSHCR, NIT1=10, NIT2=30
C
C*** End of declarations rewritten by SPAG
C
      DATA ERSNTG/'NELECG OUT OF RANGE             ', 
     &     'NDPROD TOO LARGE                ', 
     &     'NSHLP OUT OF RANGE              ', 
     &     'NELECG NE SUM OF NELEP          ', 
     &     'NREF OUT OF RANGE               ', 
     &     'NELECG NE SUM OVER NELEC IN REFO', 
     &     'ERROR IN REF ORB DATA           ', 
     &     'ERROR IN SHELL DATA             ', 
     &     'ERROR IN COUPLING DATA          ', 
     &     'ERROR IN CONFIG CONSTRAINT DATA ', 
     &     'NO SPACE FOR REFCON ARRAY       '/
C
C     PRINT WFNGRP INPUT DATA
C
      CALL NEWPG
      CALL ADDL(9) ! JMC addl(8) ???
      WRITE(NFTW, 1505) NWFNGP, GNAME, NELECG, DEFLTC, IRFCON, NDPROD,
     &      NTCON, NAVAIL, NREFOG
 1505 FORMAT(' WFN GROUP',I4,4X,A80/' NELECG',I4,T15,'DEFLTC',I3,T27,
     &       'IRFCON',I6/' NDPROD',I4,T15,'NTCON ',I3,T27,'NAV  ',
     &       I10/' NREFOG',I4/)
      WRITE(NFTW, 1510) (I,I=1,NDPP)
      WRITE(NFTW, 1515) (NELECP(I),I=1,NDPP)
      WRITE(NFTW, 1520) (NSHLP(I),I=1,NDPP)
 1510 FORMAT(9X,9I3)
 1515 FORMAT(' NELECP =',9I3)
 1520 FORMAT(' NSHLP  =',9I3)
      IF(QNTAR(1).EQ.-1)GO TO 1512
C
      CALL ADDL(1)
      WRITE(NFTW, 1511) (QNTAR(I),I=1,3)
 1511 FORMAT(5X,'TARGET MULTIPLICITY =',I5,5X,'TARGET SYMMETRY =',I5,5X,
     &       'TARGET INVERSION SYMMETRY =',I5)
C
 1512 CALL SPACE(1)
      IF(NDPROD.EQ.0 .OR. NSHLPT.GT.NSHGMX)GO TO 1800
      IT=0
      IF(SYMTYP.EQ.1)IT=1
      ISHP=0
      DO IP=1, NDPROD
         JNSHL=NSHLP(IP)
         IF(JNSHL.NE.0)GO TO 1560
         CALL ADDL(1)
         WRITE(NFTW, 1550) JNSHL, IP
 1550    FORMAT(I4,' ORBITALS IN GROUP',I2)
         CALL SPACE(2)
         GO TO 1590
 1560    DO I=1, JNSHL, NIT1
            IMAX=MIN(I+NIT1-1,JNSHL)
            IF(I.NE.1)GO TO 1565
            CALL ADDL(4+IT)
            WRITE(NFTW, 1550) JNSHL, IP
            GO TO 1570
 1565       CALL ADDL(3+IT)
 1570       WRITE(NFTW, 1575) RHEAD(1), (II,II=I,IMAX)
            WRITE(NFTW, 1575) RHEAD(2), (MSHL(ISHP+II),II=I,IMAX)
            IF(SYMTYP.EQ.1)WRITE(NFTW, 1575) RHEAD(7), 
     &                           (GUSHL(ISHP+II),II=I,IMAX)
 1575       FORMAT(1X,A4,I8,9I12)
            WRITE(NFTW, 1580) RHEAD(3), 
     &            (LPC,(PQN(JJ,ISHP+II),JJ=1,3),II=I,IMAX)
 1580       FORMAT(1X,A4,10(A3,I2,',',I2,',',I2,')'))
            CALL SPACE(1)
         END DO
 1590    ISHP=ISHP+JNSHL
      END DO
      CALL SPACE(1)
      IF(NCUPP*NPCUPF.EQ.0)GO TO 1650
      DO I=1, NCUPP, NIT1
         IMAX=MIN(I+NIT1-1,NCUPP)
         I1=I+NSHLPT
         I2=IMAX+NSHLPT
         IF(I.NE.1)GO TO 1610
         CALL ADDL(3)
         WRITE(NFTW, 1600)
 1600    FORMAT(' COUPLING DATA')
         GO TO 1615
 1610    CALL ADDL(2)
 1615    WRITE(NFTW, 1575) RHEAD(1), (II,II=I1,I2)
         WRITE(NFTW, 1580) HCUP, (LPC,(CUP(JJ,II),JJ=1,3),II=I,IMAX)
         CALL SPACE(1)
      END DO
 1650 IT=1
      IF(SYMTYP.EQ.1)IT=2
      DO I=1, NREFOP, NIT2
         IMAX=MIN(I+NIT2-1,NREFOP)
         CALL ADDL(6+IT)
         IF(I.NE.1)GO TO 540
         WRITE(NFTW, 530)
 530     FORMAT(' REFERENCE DETERMINANT INPUT DATA')
         IT=IT-1
C
 540     WRITE(NFTW, 550) RHEAD(1), (IP,IP=I,IMAX)
 550     FORMAT(1X,A4,I5,29I4)
         DO II=1, 5
            WRITE(NFTW, 550) RHEAD(II+1), (REFORB(II,IP),IP=I,IMAX)
         END DO
         IF(SYMTYP.EQ.1)WRITE(NFTW, 550) RHEAD(7), (REFGU(IP),IP=I,IMAX)
         CALL SPACE(1)
      END DO
      CALL SPACE(1)
      IT=(NELP+NIT2-1)/NIT2
      IF(MOD(NELP,NIT2).EQ.0)IT=IT+1
      IF(NELP.EQ.0)GO TO 1665
      CALL ADDL(IT)
      WRITE(NFTW, 590) (REFDTG(IP),IP=1,NELP)
 590  FORMAT(' REFDET =',30(I3,',')/(9X,30(I3,',')))
 1665 CALL SPACE(1)
      IF(NTCONP.EQ.0)GO TO 1800
      DO IC=1, NTCONP
         NSHCR=NSHCON(IC)
         IT=1+2*((NSHCR+NIT1-1)/NIT1)+1+(NOBT+NIT2-1)/NIT2 ! JMC one too many here???
         IF(MOD(NOBT,NIT2).EQ.0)IT=IT+1
         IF(IC.EQ.1)THEN
            CALL ADDL(2+IT)
            WRITE(NFTW, 1680)
 1680       FORMAT(' EXITATION CONSTRAINTS / TCON(SYM,PQN,NE'/)
         ELSE
            CALL ADDL(IT)
         END IF
         IF(TEST(IC).NE.1)THEN
            WRITE(NFTW, 1715) IC, NRCON(IC)
 1715       FORMAT(I3,10X,'GT',I3,' REPLACEMENTS ALLOWED(INTERSECTION)')
            TEST(IC)=0
         ELSE
            WRITE(NFTW, 1725) IC, NRCON(IC)
 1725       FORMAT(I3,10X,'LE',I3,' REPLACEMENTS ALLOWED(UNION)')
         END IF
         IF(NSHCR.EQ.0)GO TO 1770
         DO II=1, NSHCR, NIT1
            IIMAX=MIN(II+NIT1-1,NSHCR)
            WRITE(NFTW, 1575) RHEAD(1), (IP,IP=II,IIMAX)
            WRITE(NFTW, 1580) HTCON, (LPC,(TCON(JJ,IP,IC),JJ=1,3),
     &                        IP=II,IIMAX)
         END DO
         CALL SPACE(1)
         WRITE(NFTW, 1760) (REFCON(IP),IP=1,NOBT)
 1760    FORMAT(' REFCON =',30(I3,',')/(9X,30(I3,',')))
 1770    CALL SPACE(1)
      END DO
C
C     PRINT WFNGRP ERROR MESSAGES
C
 1800 DO I=1, NERFG
         IF(.NOT.ERFG(I))CYCLE
         IF(ERRORG)GO TO 1840
         CALL SPACE(2)
         CALL ADDL(2)
         WRITE(NFTW, 1830) ERSNTG(I)
 1830    FORMAT(' **** ERROR DATA FOR &WFNGRP FOLLOWS'/12X,A32)
         ERRORG=.TRUE.
         CYCLE
 1840    CALL ADDL(1)
         WRITE(NFTW, 645) ERSNTG(I)
 645     FORMAT(12X,A32)
      END DO
C
      RETURN
      END SUBROUTINE WVWRIT
!*==write_svn_info.spg  processed by SPAG 6.56Rc at 13:56 on 20 Aug 2010
C
C     Write svn info for file to unit
C
      SUBROUTINE WRITE_SVN_INFO(unit)
      IMPLICIT NONE
C
C*** Start of declarations rewritten by SPAG
C
C Dummy arguments
C
      INTEGER :: UNIT
      INTENT (IN) UNIT
C
C*** End of declarations rewritten by SPAG
C
C
C     Please do not edit text between pair of $'s
C     subversion automatically edits these entries.
C
C     The double colon (::) specifies fixed width which
C     is important to work with fortran fixed format files.
C
C     The format statement has been carefully constructed to
C     give maximum width between $$'s
C
C     If edits are not occuring then enable svn keywords with:
C     svn propset svn:keywords "URL Author Date Rev Id" thisfile.f
C
 9876 FORMAT(/,1X,                                                     '
     &$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
     &     '/,1X,'$',64X,'$',/,
     &     1X,'$',16X,'Subversion Revision Information',17X,'$',/,
     &     1X,'$',64X,'$',/,1X,                                        '
     &$Id::                                                            $
     &     ',/,1X,'$',64X,'$',/,1X,                                    '
     &$URL::                                                           $
     &     ',/,1X,                                                     '
     &$LastChangedBy::                                                 $
     &     ',/,1X,                                                     '
     &$LastChangedDate::                                               $
     &     ',/,1X,                                                     '
     &$LastChangedRevision::                                           $
     &     ',/,1X,'$',64X,'$',/,1X,                                    '
     &$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
     &     ',/)
C
      WRITE(unit,9876)
C
      END SUBROUTINE WRITE_SVN_INFO
