UKRmol+ (inner)
===============

UKRmol-in is licensed with the Gnu Public License.  For a comprehensive list of the developers 
that contributed to these codes see the UK-AMOR website.

Before compiling and using the code, check [Zenodo](https://doi.org/10.5281/zenodo.2630495) for the latest 
version of UKRmol-in, that may contain bug fixes, new functionality, etc.

Table of contents
-----------------

 * Downloading
 * Building
     * Compatible libraries
     * List of available preprocessor directives
     * Testing
     * Known issues and compatible software
 * Notes for developers
     * Git-flow
     * Working on your own developments


Downloading
-----------

You can obtain a release version from Zenodo following the link above. If you are planning to develop the code,
you can request access and download the current development version from the [Gitlab repository](https://gitlab.com/Uk-amor/UKRMol/UKRmol-in/).

UKRmol+ uses Git as its version control system. To download it, request permission from the
project managers and then just issue the following command:

    git clone --recurse-submodules https://gitlab.com/UK-AMOR/UKRMol/UKRmol-in.git

You will be prompted for your user name and password, and then the master branch of the repository 
will be downloaded to your computer. The option `--recurse-submodules` is required, because
the project uses several other projects using the Git submodules feature.

Some versions of Git will not prompt you for your user name and automatically infer it from
the environment (username). In such cases you may want to force your username. This can
be done by inserting `username@` between `https://` and `gitlab.com`, where `username` is your
Gitlab username.

If you forget to use the option `--recurse-submodules`, you can retrieve the submodule later by the sequence
of commands

    git submodule init
    git submodule update


Building
--------

UKRmol+ uses the freely and open source tool [CMake](https://cmake.org/download/) for
configuration, compilation, testing and installation. The newest CMake can always be
downloaded as an unpack-and-go binary package.

For building and testing, it is recommended to create a separate build directory (anywhere) and carry out
the compilation in that directory. (This way, one can have different builds with various combinations
of precision, integer width, compilers etc.) The build process then consists of the two commands

    cmake ..
    make

with the two dots replaced by the path to the UKRmol-in directory. CMake by default picks the
system compiler, so you will most likely need to force the correct parallel compiler of your choice.
This can be done either by exporting the environment variables `CC`, `CXX` and `FC`, e.g.,

    export CC=$(which icc)
    export CXX=$(which icpc)
    export FC=$(which mpiifort)   # only parallel Fortran compiler is needed

or by providing the same data directly on the CMake command line,

    cmake -D CMAKE_C_COMPILER=$(which icc) \
          -D CMAKE_CXX_COMPILER=$(which icpc) \
          -D CMAKE_Fortran_COMPILER=$(which mpiifort) \
          ..

Furthermore, UKRmol+ has to be compiled in ILP64 mode because the number of basis elements
processed by the GBTO library can very easily reach ten-digit amounts so the use of 8-byte integers
is required. Various compilers use different flags for promotion of all integers to 8 bytes. The table
below shows values for some of them:

| compiler       | promotion flag        |
| -------------- | --------------------- |
| GNU (gfortran) | `-fdefault-integer-8` |
| Intel          | `-i8`                 |
| Cray           | `-default64`          |

While the package does provide some flexibility in using mixed LP64/ILP64 modes, it is recommended that
all linked external libraries use ILP64 for maximal compatibility and as a means to avoid surprises.
The compilation flags for the Fortran compiler are set either by exporting the environment variable
`FFLAGS`, e.g.,

    export FFLAGS="-i8"

or by adding the option `-D CMAKE_Fortran_FLAGS="-i8"` at the CMake command line.

Finally, in most cases you will want to customize the build by specifying
where the needed/optional external libraries are located. For that purpose, customize and use the sample
build script shown below. This example uses the Intel Fortran compiler, with
Intel MPI and the BLAS, LAPACK and SCALAPACK routines from Intel MKL. You will need to adjust
the paths to your system (see below for an explanation of the libraries and flags used).

    export BLA_VENDOR=Intel10_64ilp
    
    cmake -D CMAKE_C_COMPILER=$(which icc) \
          -D CMAKE_CXX_COMPILER=$(which icpc) \
          -D CMAKE_Fortran_COMPILER=$(which mpiifort) \
          -D CMAKE_Fortran_FLAGS="-mkl=cluster -i8" \
          -D ARPACK_LIBRARIES="...." \
          -D SLEPC_INCLUDE_DIRS="......" \
          -D SLEPC_LIBRARIES="....." \
          ..
    
    make

BLA_VENDOR is required when using the Intel compiler to pick the correct variant of Intel MKL; for other compilers
it is normally safe not to specify this. The flag `-mkl=cluster` ensures linking to the BLAS, LAPACK
and SCALAPACK libraries. When use of ScaLAPACK is not desired, e.g. when compiling without MPI, use just `-mkl`.

Some older versions of CMake fail to find the correct BLAS libraries on their own (so we recommend using always the newest
version available); in such a case one needs to provide them on the command line as below:

    cmake -D CMAKE_C_COMPILER=$(which icc) \
          -D CMAKE_CXX_COMPILER=$(which icpc) \
          -D CMAKE_Fortran_COMPILER=$(which mpiifort) \
          -D CMAKE_Fortran_FLAGS="-i8" \
          -D BLAS_LIBRARIES="$MKLROOT/lib/intel64/libmkl_intel_ilp64.so;$MKLROOT/lib/intel64/libmkl_intel_thread.so;$MKLROOT/lib/intel64/libmkl_core.so" \
          -D LAPACK_LIBRARIES="$MKLROOT/lib/intel64/libmkl_intel_ilp64.so;$MKLROOT/lib/intel64/libmkl_intel_thread.so;$MKLROOT/lib/intel64/libmkl_core.so" \
          -D SCALAPACK_LIBRARIES="$MKLROOT/lib/intel64/libmkl_scalapack_ilp64.so;$MKLROOT/lib/intel64/libmkl_blacs_intelmpi_ilp64.so" \
          -D ARPACK_LIBRARIES="......" \
          -D SLEPC_INCLUDE_DIRS="......" \
          -D SLEPC_LIBRARIES="....." \
          ..
    
    make

The above scripts will compile all components, placing the resulting programs into the "bin" subdirectory
of your build directory. (It is possible to compile individual programs using `make program_name` provided
`cmake` has already been executed.)

As usual with CMake projects, you can also specify `-D CMAKE_INSTALL_PREFIX=` and follow the compilation
by installation (`make install`) into the provided directory. The installation will contain all programs,
libraries, module files and documentation.


### Compatible libraries

Here are details on the individual libraries used by UKRmol+. The needed ones are:

* **BLAS**, **LAPACK**: Intel MKL provides ILP64 version of both. When using open-source tools,
  it is possible to use OpenBLAS instead, compiled with option `INTERFACE64=1`. In spite
  of its name, that library provides also LAPACK.

The optional ones are:

* **ARPACK**: Can be compiled in 64-bit mode if `-DINTERFACE64=ON` option is passed to CMake
  when compiling ARPACK. But then also BLAS and LAPACK (which are needed by ARPACK) must
  use ILP64 interface. The Arpack library can be downloaded from https://github.com/opencollab/arpack-ng/releases

* **SLEPc**: Used by MPI-SCATCI only; the suite will compile without them but MPI-SCATCI will not
  have its full functionality. It inherits integer bitness from PETSc, which is its prerequisite. 
  This is controlled by `--with-64-bit-indices`. Also, do not forget to add the `--with-fortran-datatypes`
  option when compiling PETSc, so that it can be properly interfaced with Fortran. Note that
  SLEPC_INCLUDE_DIRS will need to include paths to the Fortran modules in both PETSc and SLEPc, as well 
  as to directory containing the "finclude" subdirectory, all separated by semicolons. The 
  SLEPC_LIBRARIES will need full paths to both the PETSc and SLEPc library, again separated by semicolons. 
  SLEPc (and its prerequisite PETSc) can be downloaded from http://slepc.upv.es/download/ and 
  https://www.mcs.anl.gov/petsc/download/index.html .

* **ScaLAPACK**: Intel MKL (cluster edition) provides ILP64 version of this library. When using
  open-source tools, one can use the Netlib ScaLAPACK. The latest released version (2.1.0) does
  not yet support compilation in ILP64 mode, but the current development version, which can be
  obtained from Github (https://github.com/Reference-ScaLAPACK/scalapack), does support ILP64.
  Some compilers (e.g. Cray) link ScaLAPACK automatically and no `SCALAPACK_LIBRARIES` need to
  be speficied. In such cases, add `-D WITH_SCALAPACK=ON` to your CMake command line instead,
  so that the configuration script knows that it should build ScaLAPACK-dependent code even when
  there are no `SCALAPACK_LIBRARIES`.

* **ELPA**: The "Eigenvalue SoLvers for Petaflop Applications" package can be optionally used by
  MPI-SCATCI when the module include directory and the ELPA library are provided using the CMake
  options `ELPA_INCLUDE_DIRS` and `ELPA_LIBRARIES`, respectively.

* **MPI**: Can be both LP64 and ILP64; this is automatically detected by the configuration
  script. When using free software tools, you can use Open MPI, which by default compiles
  to LP64 mode, but can be compiled in ILP64 mode if `FCFLAGS=-fdefault-integer-8` is used
  (or `FCFLAGS=-i8` when compiling with/for Intel) suite. For (optional) support of quadruple
  precision reductions with Open MPI, you will also need to give the `CFLAGS=-mlong-double-128`
  flag when compiling it.

It is also possible to compile the code without the need for MPI at all. To achieve this: 
(i) avoid the compiler option `-Dusempi`; (ii) use the plain Fortran compiler, without the MPI
wrapper suggested in the above example (e.g. use ifort instead of mpiifort); (iii) add the CMake
option `-D WITH_MPI=OFF`.


### List of available preprocessor directives

GBTOlib (the library used by scatci_integrals) can use either double precision (default) or quadruple 
precision real numbers. To use the latter, add the following preprocessor definition among your compiler options (`CMAKE_Fortran_FLAGS`):

* `-Dusequadprec`
  Enable quadruple precision floating point operation. This will make the
  operation notably slower, but will allow you to extend the Gaussian continuum basis to
  larger distances.

There are several other options that can be added, all of them are related to capabilities of
the MPI library used. The CMake script will normally determine which of them to use on its
own, so you need to worry about them only in case that the automatic analysis fails.
The automatically included options are added to the CMake variable `GBTOlib_Fortran_FLAGS`, which
is printed out during the configuration step. The configuration script compiles a few trivial MPI
programs and runs them using the MPI launcher, which is expected to be named `mpiexec`. If you
use a different launcher (e.g. `mpirun` or `aprun`), you need to provide that name to CMake
using the option `-D MPIEXEC_EXECUTABLE=$(which mpirun)`.

* `-Dusempi`: include  to compile with MPI library. 

* `-Dquadreduceworks`: include if you're compiling with quad precision and your MPI library correctly handles
 quad precision arithmetics. Ignored if you're not using MPI or double precision is used.

* `-Dsplitreduce`: include if MPI_REDUCE from your library does not work correctly for data structures
 larger than ~2GB (i.e. limit of 32bit integer address). Ignored if you're not using MPI.

* `-Dmpithree`: include if you're using MPI 3.0 standard. This feature only affects the module
 mpi_memory_mod.F90 which is used by the UKRmol+ program MPI-SCATCI. Note that if GBTOlib
 is linked with MPI-SCATCI the integer precision of GBTOlib must be -i8 since that is explicitly
 required by the MPI-SCATCI module CSF_module.F90 which calls functions from mpi_memory_mod.F90.

The compilation itself, as well as operation of the code have been successfully tested with GCC 8.2+,
Intel 2016+, Cray 8.7+, Intel MPI 2017+, Open MPI 3.1+, Arpack-ng 3.5+, PetSc 3.10+, SLEPc 3.10+ and
others.


### Testing

After the compilation (`make`) finishes, the binaries can be tested using (within the build directory)

    ctest -R serial
    mv ./Testing Testing_serial
    ctest -R parallel
    mv ./Testing Testing_parallel

This will run all preset test calculations distributed with the suite and save the outputs of each type of test
to a separate directory for a further inspection. All the parallel runs use 2 MPI processes.
To provide additional flags for your MPI launcher in these runs, give them as a semicolon-separated list to CMake. 
For instance, with Open MPI you may want to restrict the number of OpenMP threads and prevent automatic binding 
of the processes like this

    ctest -D MPIEXEC_PREFLAGS="-x;OMP_NUM_THREADS=2;-bind-to;none"

You can also execute only a subset of the test suite. For instance, this command will select only tests whose name contains
the string "target_CAS" and "_serial":

    ctest -R 'target_CAS.*_serial'

A full list of test names can be obtained by `ctest -N`. To also enable  UKRmol-out-related tests, one needs to build
UKRmol-out jointly with UKRmol-in, which is done by passing the path to the UKRmol-out package to CMake using the
option `-D UKRMOL_OUT_DIR=`.

For more details see the test suite [README](tests/suite/README.md).


### Known issues and compatible software

* For a list of known issues related to compilers, external libraries and the CMake system, see: 
  [Git-lab](https://gitlab.com/Uk-amor/UKRMol/UKRmol-in/wikis/Compatible-software). This includes a list of compatible
  software that has been used to compile and run the code.


Notes for the developers
------------------------

A commmit.template is available to ensure that developers do not forget to provide sufficient
information on thei work they've done. We ask that you do:

    git config commit.template commit.template

This way, when you commit some changes, the commit log will be pre-filled with the information in the
template. Alternatively, you can supply it on every commit by

    git commit -t commit.template


### Git-flow

From version 1.1 the UKRmol-in repository has switched to using  an adapted version of
[Git-flow](https://www.atlassian.com/git/tutorials/comparing-workflows/gitflow-workflow).
Git-flow defines a set of branches and prefixes which have a well-defined meaning.

In the case of UKRmol-in the set of permanent branches and the naming convention is the following
(the flow chart [here](https://gitlab.com/Uk-amor/UKRMol/UKRmol-in/wikis/home) helps understanding
the structure):

    master : main development branch from which feature branches are created
    release: branch that contains code ready for (or already) release
    release-X.Y.Z: hotfix of the tagged version X.Y of the release branch

* Release is the branch which contains versions of the code that have been thoroughly tested. It usually
  correspond to a code that has undergone a major upgrade and is ready for release. Each version will
  be tagged, either by going to the Tags area of the GitLab interface, or automatically when a release file
  is generated using the Release facility of GitLab.

* Fixes of important bugs in the release versions (i.e. hotfixes) should be implemented in a branch
  originating from `release` and equipped with an incremented version number `release-X.Y.Z`, where X and Y
  correspond to the latest release tag. Implementation of each hotfix must be followed by its merge into
  the `master` branch.

* The Master branch is an integration branch for the Feature branches and it is based on the latest
  `release` version. We can see that it has the meaning of the `develop` branch in the usual
  Git-flow system, i.e. the `master` branch is the one into which all features are merged. This branch will
  eventually be merged into the `release` branch to create a new release.

* New features and your own developments should be implemented branching from the `master`. The names of
  such branches must be functional, i.e. referring to a particular feature that you're developing.
  If you wish you can prefix the name of your development branch with the string `feature-`.
  If it is possible to split the development of a major feature into a series of smaller upgrades
  (branches) then please do that since it helps to visualize the progress of the development and to
  see what was done by who and when. Implementation of each feature is followed by its merge into
  the `master` branch.


### Working on your own developments ###

To create a branch for your own developments use the following commands:

    git checkout master
    git branch name_of_feature

You'll then checkout the branch, work on it and commit it when needed. Once you're satisfied
with your implementation you should create a merge request by using the facility in the GitLab
interface. One of the managers/maintaners of the project will check it and merge it to `master`.

(When the development of one or several new features has finished and the code in the `master`
branch been thoroughly tested, the codes will be merged into the  `release` branch  and tagged.)
