# Contributing

Contributions are always greatly appreciated and credit will always be given.

## Types of contributions

### Bug reports

Report bugs at the [GitHub issues](https://github.com/sp94/Peacock.jl/issues).

If you are reporting a bug, please include:

* Your operating system name and version.
* Any details about your local setup that might be helpful in troubleshooting.
* Detailed steps to reproduce the bug.

### Bug fixes

Look through the [GitHub issues](https://github.com/sp94/Peacock.jl/issues) for bugs. Anything tagged with "bug" and "help wanted" is open to whoever wants to implement it.

### New features

Look through the [GitHub issues](https://github.com/sp94/Peacock.jl/issues) for features. Anything tagged with "enhancement" and "help wanted" is open to whoever wants to implement it.

### New crystals

If you model a new crystal with `Peacock.jl`, please consider contributing it to the [`Peacock.Zoo`](@ref how_to_zoo) submodule to help others reproduce your work.

## Pull request guidelines

Before you submit a pull request, check that it meets these guidelines:

1. The pull request should include tests.
2. If the pull request adds functionality, put your new functionality into a function with a docstring.
  * The docstrings will be automatically included in the [technical reference](@ref reference).
  * Consider also writing a tutorial or how-to guide for the new functionality.
3. The pull request should work for Julia 1.4. Check the [test logs](https://travis-ci.com/sp94/Peacock.jl/pull_requests) and make sure that the tests pass.


---

Thanks to the [DetecTree](https://github.com/martibosch/detectree/blob/master/CONTRIBUTING.md) library for letting us use their contributions page as a template.