# Copyright 2020 Karlsruhe Institute of Technology
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import pickle

from pylatex import Command
from pylatex import Document
from pylatex import Package
from pylatex.utils import NoEscape
from xmlhelpy import command
from xmlhelpy import option


@command(name="StartReport", version="0.0.1", description="Initialize a report")
@option("title", char="t", default="Autogenerated Report", description="Report title")
@option("author", char="a", default="Anonymous author", description="Report title")
def execute(*args, **kwargs):
    """execute"""

    geometry_options = {"right": "2cm", "left": "2cm"}
    title = kwargs["title"]
    author = kwargs["author"]
    doc = Document("basic", geometry_options=geometry_options)
    doc.packages.append(Package("attachfile"))
    doc.preamble.append(Command("title", title))
    doc.preamble.append(Command("author", author))
    doc.preamble.append(Command("date", NoEscape(r"\today")))
    doc.append(NoEscape(r"\maketitle"))

    with open(".report.obj", "wb") as f:
        pickle.dump(doc, f)


if __name__ == "__main__":
    execute()
