power,'_kin','_ss',k=k,spec1=spec1,spec2=spec2,i=n,tt=t,/noplot
;
;  $Id: ppower_all.pro,v 1.2 2020/10/04 19:59:15 brandenb Exp $
;
;  This routine is used to view all power spectra
;  that were written during the run (controlled by dspec)
;  The plot range yr is set to a default value.
;  The time interval of plotting is "w" (default value)
;
;   5-oct-02/axel: written
;
spawn,'if (! -f param.pro) touch parameters.pro'
@parameters
xr=[1,max(k)]
istride=1
default,w,.2
default,t1,.0
default,iover,0
default,istride,1
default,yr,[3e-12,3e-2]
ampl15=3e-10 & ampl4=1e-13
ampl15=3e-6 & ampl4=1e-8
!p.multi=0
;
good=where(t ge t1)
i1=min(good)
i2=n-2
;
; averages
;
;pc_read_kf,kf
ngood=n_elements(good)
;mspec1=total(spec1(*,i1:i2),2)/ngood
;mspec2=total(spec2(*,i1:i2),2)/ngood
;mspec1h=total(spec1h(*,i1:i2),2)/ngood
;mspec2h=total(spec2h(*,i1:i2),2)/ngood
circ_sym,.5,1
circ_sym,1.1,1
;
;  compute mean epsM
;
pc_read_ts,o=ts
good=where(ts.t ge t1)
;epsM=mean(ts.epsM(good))
;pc_read_param,o=param,/param2
;eta=param.eta
;save,file='mean_spec.sav',k,epsM,eta,mspec1,mspec2,mspec1h,mspec2h
;
;  plot all spectra
;
for i=i1,i2,istride do begin
  if iover eq 0 or i eq 0 then begin
    plot_oo,k,spec1(*,i),xr=xr,yr=yr,tit='t='+str(t(i))
  endif else begin
    oplot,k,spec1(*,i)
  endelse
  oplot,k,spec1(*,i),col=122
  oplot,k,spec2(*,i),col=55
  ;
  kk=[3,60] & oplot,kk,.007/kk^(7./3.)
  print,i,t(i)
  wait,w
end
;
;arrow,/data,3.,1e-3,2.,1e-5,col=122
END
