;$Id: pdecay_comp_rescaled.pro,v 1.2 2020/10/05 18:48:18 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=11,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
  col=255
endif else begin
  col=255
endelse
;
siz=1.5
!p.charsize=1.7
!x.margin=[7.5,.8]
!y.margin=[3.1,.5]
;
!x.title='!7v!8k!6/!8c!d!7c!6!n = !13l !8k!6'
!x.title='!13l !8k!6!d1!n'
!y.title='!7k!6!d!n/(!8c!d!7c!6!n!8k!6!d1!n/3)'
xr=[2e-4,4e2]
yr=[7e-2,2.3]
cgam=3.874
siz1=1.5
siz2=1.4
siz3=1.2
xx=[xr[0],.001]
uu=[0.,0.]
k1=1.
;
file='decay.dat'
a=rtable(file,6,head=1)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(5,*))
ell=1./(4e-4*tkap0)
xtickv=[.001,.01,.1,1.,10.,100.,1000.]
xtickn=['0.001','0.01','0.1','1','10','100','1000']
plot_oo,k1*ell,3.*lam/(cgam*k1),xr=xr,yr=yr,/nodata,xtickv=xtickv,xtickn=xtickn
;
file='decay_1em2.dat' & kf=10.
a=rtable(file,6,head=1)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(5,*))
ell=1./(4e-4*tkap0)
oplot,k1*ell,3.*lam/(cgam*k1),ps=-4,col=55,li=1
;
file='decay_1em3.dat' & urms_cgam=.58 & kf=10.
a=rtable(file,6,head=1)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(5,*))
ell=1./(4e-4*tkap0)
oplot,k1*ell,3.*lam/(cgam*k1),ps=-4,col=55
;
file='decay_1em2_k1.dat' & urms_cgam=.62 & kf=1.5
a=rtable(file,6,head=1)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(5,*))
ell=1./(4e-4*tkap0)
oplot,k1*ell,3.*lam/(cgam*k1),ps=-4,col=155
;
file='decay_1em3_k3.dat' & urms_cgam=.46 & kf=1.5
a=rtable(file,6,head=1)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(5,*))
ell=1./(4e-4*tkap0)
oplot,k1*ell,3.*lam/(cgam*k1),ps=-4,col=155,li=1
;
file='decay_1em3_k6.dat' & urms_cgam=.46 & kf=1.5
a=rtable(file,6,head=1)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(5,*))
ell=1./(4e-4*tkap0)
oplot,k1*ell,3.*lam/(cgam*k1),ps=-4,col=155,li=2
;
;  overplot various lines
;
xx=grange(xr(0),xr(1),100,/log)
oplot,xx,xx/(1.+xx^2),col=122
;
print,"$mv idl.ps ~/tex/upasana/mixing/fig/pdecay_comp_rescaled.ps"
END
