;$Id: pdecay_comp0.pro,v 1.2 2020/10/07 18:31:06 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=11,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
  col=255
endif else begin
  col=255
endelse
;
!p.charsize=1.7
!x.margin=[7.5,1.]
!y.margin=[3.1,.3]
;
!x.title='!7v!8k!6/!8c!d!7c!6!n = !13l !8k!6'
!x.title='!13l !8k!6'
!y.title='!7k!6!d!n/(!8c!d!7c!6!n!8k!6/3)'
xr=[1e-2,1e2]
yr=[1e-2,1.]
cgam=3.874
siz1=1.5
siz2=1.4
siz3=1.2
;
file='decay_corr.dat'
file='decay.dat'
a=rtable(file,6,head=1)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(5,*))
ell=1./(4e-4*tkap0)
xtickv=[.01,.1,1.,10.,100.]
xtickn=['0.01','0.1','1','10','100']
plot_oo,kx*ell,3.*lam/(cgam*kx),xr=xr,yr=yr,/nodata,xtickv=xtickv,xtickn=xtickn
;
file='decay_o.dat'
a=rtable(file,6,head=2)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(5,*))
ell=1./(4e-4*tkap0)
oplot,kx*ell,3.*lam/(cgam*kx),ps=1,symsize=1.8
;
circ_sym,1.0,1
file='../../idl/decay_corr_3D.dat'
a=rtable(file,3,head=1)
tkap0=reform(a(0,*))
kx=reform(a(1,*))
lam=-reform(a(2,*))
ell=1./(4e-4*tkap0)
oplot,kx*ell,3.*lam/(cgam*kx),ps=1,symsize=1.8
;
;  overplot various lines
;
xx=grange(xr(0),xr(1),100,/log)
oplot,xx,xx/(1.+xx^2),col=122
ss=sqrt(3.)
oplot,xx,(1.-atan(xx*ss)/(xx*ss))/(xx)
;
xyouts,.023,.013,siz=siz1,'opt thick'
xyouts,8.00,.013,siz=siz1,'opt thin'
;
print,"$mv idl.ps ~/tex/upasana/mixing/fig/pdecay_comp0.ps"
END
