print,"$sed.csh data/param2.nml"
;
@parameters
default,t1,1.
default,t2,1e2
pc_read_kf,kf
pc_read_param,o=param2,/param2
pc_read_param,o=param
pc_read_ts,o=ts,/double
tt=ts.t
ff=alog(ts.TTmax-ts.TTmin)
nt=n_elements(tt)
idt=nt/50
idt=nt-10
yr=[max(ff(nt-1-idt:nt-1)),max(ff(0:idt))]
lam=deriv(tt,ff)
good=where(tt ge t1 and tt le t2)
urmsm=mean(ts.urms(good))
lamm=mean(lam(good))
tgood=tt(good)
p=linfit(tgood,ff(good))
yr=minmax(ff)
cgam=3.874
;
!p.multi=[0,1,2]
plot,tt,ff,yr=yr
oplot,tgood,tgood*p[1]+p[0],col=122
;
plot,tt,lam;,yr=[-.5,0]
oplot,tgood,tgood*0+lamm,col=122
;
cwd,run
Re=urmsm/(param2.nu*kf)
fo='(e8.1,2f5.1,f7.1,2e11.2,2x,a)'
openw,1,'decay.tmp'
printf,1,param2.kappa_cst[0],param.kx_ss,kf,Re,lamm,p[1],run,fo=fo
close,1
;
spawn,'cat decay.tmp'
spawn,'cat decay.tmp >> ../idl/decay.dat'
!p.multi=0
END
