;$Id: pT_1D.pro,v 1.1 2020/10/03 09:30:55 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=11,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
  col=255
endif else begin
  col=255
endelse
;
;  mv idl.ps ~/tex/atefeh/radiation/fig/pT_B256b8_nu5_noT_100Gb.ps
;
!p.charsize=1.7
!x.margin=[8.8,.5]
!y.margin=[3.2,.5]
;
@data/pc_constants
pc_read_param,obj=param2,/param2
pc_read_param,obj=param
pc_read_grid,obj=grid
pc_read_dim,obj=dim
pc_read_var,obj=var,/trimall;,ivar=64
;
;tau=(var.z(dim.nz-1)-var.z)
;weight=4.*!pi/2.
;plot,var.z,var.qrad,xtit='!7s!6',ytit='!8Q!d!6rad!n',yr=[-1.3,.6]
cs0=param.cs0
rho0=param.rho0
gam=param.gamma
cp=param.cp
kappa_cst=param.kappa_cst
rho_const=param.rho_const
lnrho=alog(rho0)
cs2=cs0^2*exp((gam-1.)*(var.lnrho-lnrho0)+gam*var.ss/cp)
lnpp=gam*(var.lnrho-lnrho0+var.ss/cp)
cs=sqrt(cs2)
TT=cs2/((gam-1.)*cp)
rho=exp(var.lnrho)
xxx=var.x
plot,xxx,tt
cwd,run
;
;  compute effective K and effective Prandtl number
;
K=16.*sigmaSB*TT^3/(3.*var.kapparho)
cgamma=16.*sigmaSB*TT^3/(3.*rho*cp)
chi=K/(cp*rho)
nu=param2.nu
Pr=nu/chi
ell2=1./(3.*var.kapparho^2)
ell2=1./(var.kapparho^2)
ell=sqrt(ell2)
;
print,'ell=',mean(ell),mean(ell2)^.5
print,'ell*kappa_cst*rho_const=',mean(ell)*kappa_cst*rho_const
print,'chi*(kappa_cst*rho_const)=',mean(chi)*(kappa_cst*rho_const)
print,'chi=',mean(chi)
print,'cs,cgamma=',mean(cs),mean(cgamma)
print,run
END
