;$Id: pxz0.pro,v 1.12 2009/01/14 22:02:40 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=12,ysize=18,yoffset=3
  !p.charthick=1 & !p.thick=3 & !x.thick=3 & !y.thick=3
end
;
;  mv idl.ps ~/tex/andreas/testscalar/fig/pxz0_128d_Om01_k0.ps
;
pc_read_param,o=param1
pc_read_param,o=param,/param2
pc_read_ts,o=ts
print,'nt=',n_elements(ts.t)
li2=2
;
@parameters
default,kf,3.1
default,yr,[-1,1]
default,t1,100.
default,it1,0
;
urms0=mean(ts.urms(it1:*))
tt=ts.t*urms0*kf
kap0=urms0/(3.*kf)
kappat=ts.kap11/kap0
kappaO=-ts.kap21/kap0
kappaOO=(ts.kap33-ts.kap11)/kap0
good=where(tt gt t1)
ttt=tt(good)
;
;  set the first column to B_ext/Beq if we have a magnetic run
;
if param1.lmagnetic then begin
  Co=2.*param.Omega/(urms0*kf) > param.B_ext(2)/urms0
endif else begin
  Co=2.*param.Omega/(urms0*kf)
endelse
;
Pe=urms0/(param.kappatest*kf)
k=fix(param.ktestscalar)
;
!p.charsize=2.6
!p.multi=[0,1,3]
!y.margin=[3.3,.8]
;
!x.title='!6'
!y.title='!7j!6!dt!n!6/!7j!6!dt0!n!6'
plot,tt,kappat,yr=minmax(kappat(10:*)),yst=0
pc_fluct_stat,tt,kappat,kappatm,kappatrms,kappate,good=good
oplot,ttt,ttt*0.+kappatm,thick=3
oplot,ttt,ttt*0.+kappatm+kappate,li=li2
oplot,ttt,ttt*0.+kappatm-kappate,li=li2
;
!y.title='!7j!d!3B!n!6/!7j!6!dt0!n!6'
plot,tt,kappaO,yst=0
pc_fluct_stat,tt,kappaO,kappaOm,kappaOrms,kappaOe,good=good
oplot,ttt,ttt*0.+kappaOm,thick=3
oplot,ttt,ttt*0.+kappaOm+kappaOe,li=li2
oplot,ttt,ttt*0.+kappaOm-kappaOe,li=li2
;
!x.title='!8t u!6!drms!n !8k!6!df!n!6'
!y.title='!7j!d!3BB!n!6/!7j!6!dt0!n!6'
plot,tt,kappaOO,yst=0
pc_fluct_stat,tt,kappaOO,kappaOOm,kappaOOrms,kappaOOe,good=good
oplot,ttt,ttt*0.+kappaOOm,thick=3
oplot,ttt,ttt*0.+kappaOOm+kappaOOe,li=li2
oplot,ttt,ttt*0.+kappaOOm-kappaOOe,li=li2
;
fo='(f6.3,f6.1,6f8.4,i3,2x,a)'
openw,1,file+'.tmp'
print,Co,Pe,kappatm,kappate,kappaOm,kappaOe,kappaOOm,kappaOOe,k,run,fo=fo
printf,1,Co,Pe,kappatm,kappate,kappaOm,kappaOe,kappaOOm,kappaOOe,k,run,fo=fo
close,1
;
spawn,'cat '+file+'.tmp >>../idl/'+file+'.dat'
;
END
