
////////////////////////////////////////////////////////////////////////
//
//                 Cambridge Crystallographic Data Centre
//                                CCDC 
//
////////////////////////////////////////////////////////////////////////
//
// For information on free software for rendering this file to create very
// high quality bitmap images, please visit the POV-Ray website:
// www.povray.org.
//
// This POV-Ray output mechanism has been tested with POV-Ray version 3.7.
//
// The CCDC is keen to receive feedback on, and suggestions for improvements
// to, this POV-Ray output mechanism. Please visit www.ccdc.cam.ac.uk,
// or e-mail feedback to support@ccdc.cam.ac.uk. Thank you.
//
////////////////////////////////////////////////////////////////////////
//
// If this POVRay file has been generated from an entry in the Cambridge 
// Structural Database, then it will include bibliographic, chemical, crystal, 
// experimental, refinement or atomic coordinate data resulting from the CCDC's 
// data processing and validation procedures.
//
////////////////////////////////////////////////////////////////////////

#version 3.7;
global_settings {
    assumed_gamma 2.2
    max_trace_level 5
}

// -----------------------------------------------------------

#macro rotate_view_for_animation()
    // If using the [filename.pov].ini file, with animation enabled, this will produce
    // a cyclic animation of the scene rotating, otherwise this will not affect the image:
    rotate <0,clock*360,0>
#end

#macro ccdc_perspective_camera( camera_position, field_of_view )
    camera {
        perspective
        location camera_position
        up    <0,1,0>
        right  -x * (image_width/image_height)
        look_at <0,0,-100>
        // Convert the vertical field of view to the horizontal field of view
        angle degrees(2 * atan2(tan(radians(field_of_view / 2)) * image_width, image_height))

        rotate_view_for_animation()
    }
#end

#macro ccdc_directional_light_source( light_position, light_diffuse_colour, light_specular_colour )
    // The scalar multiplier applied to light_position seems to be needed for correct brightness
    light_source {
        5 * light_position
        light_diffuse_colour
        parallel
        shadowless
        rotate_view_for_animation()
    }
    light_source {
        5 * light_position
        light_specular_colour
        parallel
        rotate_view_for_animation()
    }
#end

#macro ccdc_ambient_light_source( light_colour )
    global_settings { ambient_light light_colour * 10 }
#end

#macro ccdc_background_colour( background_colour )
    background { background_colour }
#end

#macro ccdc_background_gradient( top_right_colour, top_left_colour, bottom_left_colour, bottom_right_colour )
    // TODO - adjust to use all four colours
    background { bottom_left_colour }
#end

#macro ccdc_orient_world( world_orientation )
    transform { world_orientation }
#end

#macro ccdc_orient_structure( structure_orientation )
    transform { structure_orientation }
#end

#macro ccdc_set_standard_mercury_solid_material_properties( object_color )
    no_shadow
    texture {
        pigment { object_color }
        finish {
            specular 0.2
            roughness 0.02
        }
    }
#end

#macro ccdc_set_shiny_solid_material_properties( object_color )
    no_shadow
    texture {
        pigment { object_color }
        finish {
            specular 0.8
            roughness 0.02
        }
    }
#end

#macro ccdc_set_matt_solid_material_properties( object_color )
    no_shadow
    texture {
        pigment { object_color }
        finish {
            specular 0.0
            roughness 0.02
        }
    }
#end

#macro ccdc_set_metallic_solid_material_properties( object_color )
    no_shadow
    texture {
        pigment { object_color }
        finish {
            ambient 0.2
            diffuse 0.2
            specular 1.0
            roughness 0.02 
            metallic
            reflection { 0.5, 1.0
               fresnel on
               metallic 0.8
            }
        }
    }
#end

#macro ccdc_set_iridescent_solid_material_properties( object_color )
    no_shadow
    texture {
        pigment { object_color }
        finish {
            ambient 0.1
            diffuse 0.1
            reflection 0.2
            specular 1
            roughness 0.02
            irid {
              0.35
              thickness 0.5
              turbulence 0.5
            }
        }
    }
#end

#macro ccdc_set_solid_material_properties( object_color )
    // change the method call here to select different properties settings
    ccdc_set_shiny_solid_material_properties( object_color )
#end

#macro ccdc_set_wireframe_material_properties( object_color )
    no_shadow
    pigment { object_color }
#end

#macro ccdc_set_point_size( point_size )
    // TODO
#end

#macro ccdc_draw_circle( centre, circle_radius, transformation, circle_color )
    torus {
        circle_radius, 0.03
        transform { transformation }
        translate centre
        ccdc_set_wireframe_material_properties( circle_color )
    }
#end

#macro ccdc_draw_wireframe_sphere( centre, sphere_radius, sphere_color )
    union {
        #local transformation = transform { matrix <
            0, -1, 0,
            1, 0, 0,
            0, 0, 1,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )
        #local transformation = transform { matrix <
            1, 0, 0,
            0, 1, 0,
            0, 0, 1,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )
        #local transformation = transform { matrix <
            1, 0, 0,
            0, 0, 1,
            0, -1, 0,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )
        #local transformation = transform { matrix <
            1, 0, 0,
            0, 0.707107, 0.707107,
            0, -0.707107, 0.707107,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )
        #local transformation = transform { matrix <
            0.5, -0.707107, -0.5,
            0.707107, 0, 0.707107,
            -0.5, -0.707107, 0.5,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )
        #local transformation = transform { matrix <
            0.707107, -0.707107, 0,
            0.707107, 0.707107, 0,
            0, 0, 1,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )
        #local transformation = transform { matrix <
            1, 0, 0,
            0, -0.707107, 0.707107,
            0, -0.707107, -0.707107,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )
        #local transformation = transform { matrix <
            0.5, 0.707107, 0.5,
            -0.707107, 0, 0.707107,
            0.5, -0.707107, 0.5,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )
        #local transformation = transform { matrix <
            0.707107, 0.707107, 0,
            -0.707107, 0.707107, 0,
            0, 0, 1,
            0, 0, 0 > };
        ccdc_draw_circle( centre, sphere_radius, transformation, sphere_color )

    }
#end

#macro ccdc_draw_solid_sphere( position, sphere_radius, sphere_color )
    sphere {
        position, sphere_radius
        ccdc_set_solid_material_properties( sphere_color )
    }
#end

#macro ccdc_draw_solid_polygon( vertices, origin, transformation, polygon_color )
    #local nvertices = dimension_size( vertices, 1 );
    polygon {
        nvertices + 1
        #local i = 0;
        #while ( i < nvertices )
            vertices[ i ]
            #local i = i + 1;
        #end
        // Repeat the first point, to close the polygon:
        vertices[ 0 ]
        translate origin
        transform { transformation inverse }
        ccdc_set_solid_material_properties( polygon_color )
    }
#end

#macro ccdc_draw_solid_torus( centre, ring_radius, torus_radius, transformation, torus_color )
    torus {
        ring_radius, torus_radius
        transform { transformation }
        translate centre
        ccdc_set_solid_material_properties( torus_color )
    }
#end

#macro ccdc_draw_disk( centre, disk_radius, disk_normal, disk_color )
    // TODO
#end

#macro ccdc_draw_line_segment( line_begin, line_end, line_color )
    cylinder {
        line_begin, line_end, 0.03
        ccdc_set_wireframe_material_properties( line_color )
    }
#end

#macro ccdc_draw_stippled_line_segment( line_begin, line_end, stipple, stipple_scale_factor, line_color )
    // TODO - adjust to use stipple and stipple_scale_factor
    /* For example:

        AACRUB delocalised bonds:
        61680 = F0F0
        
        AABHTZ contacts:
        43690 = AAAA
    */
    // The following is approximately correct when drawing contacts
    #declare nsteps = 20;
    #declare increment = 1 / nsteps;
    #declare scalar1 = 0.0;
    #while ( scalar1 < 1.0 )
        #declare point1 = ( scalar1 * line_begin ) + ( 1 - scalar1 ) * line_end;
        #declare scalar2 = scalar1 + ( increment / 2.0 );
        #declare point2 = ( scalar2 * line_begin ) + ( 1 - scalar2 ) * line_end;
        cylinder {
            point1, point2, 0.03
            ccdc_set_wireframe_material_properties( line_color )
        }
        #declare scalar1 = scalar1 + increment;
    #end
#end

#macro ccdc_draw_wireframe_arc( arc_centre, arc_end_1, arc_end_2,
                                stipple, stipple_scale_factor, line_color )
    // TODO
#end

#macro ccdc_draw_wireframe_ellipsoid( centre, axis1, axis2, axis3, ellipsoid_colour )
    union {
        #local circle_radius = 1.0;
        #local origin = < 0, 0, 0 >;

        #local transformation = transform { matrix <
            0, -1, 0,
            1, 0, 0,
            0, 0, 1,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )
        #local transformation = transform { matrix <
            1, 0, 0,
            0, 1, 0,
            0, 0, 1,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )
        #local transformation = transform { matrix <
            1, 0, 0,
            0, 0, 1,
            0, -1, 0,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )
        #local transformation = transform { matrix <
            1, 0, 0,
            0, 0.707107, 0.707107,
            0, -0.707107, 0.707107,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )
        #local transformation = transform { matrix <
            0.5, -0.707107, -0.5,
            0.707107, 0, 0.707107,
            -0.5, -0.707107, 0.5,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )
        #local transformation = transform { matrix <
            0.707107, -0.707107, 0,
            0.707107, 0.707107, 0,
            0, 0, 1,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )
        #local transformation = transform { matrix <
            1, 0, 0,
            0, -0.707107, 0.707107,
            0, -0.707107, -0.707107,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )
        #local transformation = transform { matrix <
            0.5, 0.707107, 0.5,
            -0.707107, 0, 0.707107,
            0.5, -0.707107, 0.5,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )
        #local transformation = transform { matrix <
            0.707107, 0.707107, 0,
            -0.707107, 0.707107, 0,
            0, 0, 1,
            0, 0, 0 > };
        ccdc_draw_circle( origin, circle_radius, transformation, ellipsoid_colour )

        scale < vlength( axis1 ), vlength( axis2 ), vlength( axis3 ) >
        #declare axis1_norm = vnormalize( axis1 );
        #declare axis2_norm = vnormalize( axis2 );
        #declare axis3_norm = vnormalize( axis3 );
        matrix < axis1_norm.x,  axis1_norm.y,  axis1_norm.z,
                 axis2_norm.x,  axis2_norm.y,  axis2_norm.z,
                 axis3_norm.x,  axis3_norm.y,  axis3_norm.z,
                 0, 0, 0 >

        translate centre
    }
#end

#macro ccdc_draw_open_cylinder( centre_line_begin, centre_line_end, cylinder_radius, cylinder_color )
    cylinder {
        centre_line_begin, centre_line_end, cylinder_radius
        open
        ccdc_set_solid_material_properties( cylinder_color )
    }
#end

#macro ccdc_draw_closed_cylinder( centre_line_begin, centre_line_end, cylinder_radius, cylinder_color )
    cylinder {
        centre_line_begin, centre_line_end, cylinder_radius
        ccdc_set_solid_material_properties( cylinder_color )
    }
#end

#macro ccdc_draw_solid_ellipsoid( centre, axis1, axis2, axis3, ellipsoid_color )
    sphere {
        < 0, 0, 0 >, 1
        scale < vlength( axis1 ), vlength( axis2 ), vlength( axis3 ) >
        #declare axis1_norm = vnormalize( axis1 );
        #declare axis2_norm = vnormalize( axis2 );
        #declare axis3_norm = vnormalize( axis3 );
        matrix < axis1_norm.x,  axis1_norm.y,  axis1_norm.z,
                 axis2_norm.x,  axis2_norm.y,  axis2_norm.z,
                 axis3_norm.x,  axis3_norm.y,  axis3_norm.z,
                 0, 0, 0 >
        translate centre
        ccdc_set_solid_material_properties( ellipsoid_color )
    }
#end

#macro ccdc_draw_ellipsoid_axes( centre, axis1, axis2, axis3, axes_color )
    union {
        cylinder {
            < 0.05, 0, 0 >, < -0.05, 0, 0 >, 1
        }
        cylinder {
            < 0, 0.05, 0 >, < 0, -0.05, 0 >, 1
        }
        cylinder {
            < 0, 0, 0.05 >, < 0, 0, -0.05 >, 1
        }
        #local axis_height = 0.01;
        scale < vlength( axis1 ) + axis_height, vlength( axis2 ) + axis_height, vlength( axis3 ) + axis_height >
        #declare axis1_norm = vnormalize( axis1 );
        #declare axis2_norm = vnormalize( axis2 );
        #declare axis3_norm = vnormalize( axis3 );
        matrix < axis1_norm.x,  axis1_norm.y,  axis1_norm.z,
                 axis2_norm.x,  axis2_norm.y,  axis2_norm.z,
                 axis3_norm.x,  axis3_norm.y,  axis3_norm.z,
                 0, 0, 0 >
        translate centre
        ccdc_set_solid_material_properties( axes_color )
    }
#end

#macro ccdc_draw_point( point_location, point_color )
    // TODO
#end

#macro ccdc_draw_solid_triangle( corner1, corner2, corner3,
                                 color1, color2, color3,
                                 normal1, normal2, normal3 )
   smooth_triangle {
        corner1, normal1,
        corner2, normal2,
        corner3, normal3
        ccdc_set_solid_material_properties( color1 )
        // TODO POVRay does not appear to support different colours for 
        //      different vertices in a smooth_triangle
        //      See section 3.5.8 of the POVRay help.
   }
#end

#macro ccdc_draw_solid_triangle_without_normals( corner1, corner2, corner3,
                                                 color1, color2, color3 )
   triangle {
        corner1,
        corner2,
        corner3
        ccdc_set_solid_material_properties( color1 )
        // TODO POVRay does not appear to support different colours for 
        //      different vertices in a smooth_triangle
        //      See section 3.5.8 of the POVRay help.
   }
#end

#macro ccdc_draw_text( position, message, text_color, text_offset )
    // TODO - Adjust so that the text orientation is correct
    text { ttf font_name, message, 0.1, 0
        ccdc_set_wireframe_material_properties( color text_color )
        /*
        finish {
            ambient 0.2
            diffuse 0.6
            phong 0.3
            phong_size 100
        }
        */
        scale < font_scale, font_scale, font_scale >
        // rotate so text always faces the camera when animated
        rotate <0,clock*360,0>
        translate text_offset
        transform { world_rotation inverse }
        transform { structure_rotation inverse }
        translate position
    }
#end

#macro ccdc_draw_static_text( message )
    // TODO
#end

// -----------------------------------------------------------

// You can edit the file "ccdc_macro_overrides.inc" in this directory
// to override the implementations of any or all the above POVRay macros:
#include "ccdc_macro_overrides.inc"

#declare font_scale = 0.221706;

#declare font_name = "arial.ttf";

ccdc_perspective_camera( < 0, 0, 12702.8 >, 0.05 )
ccdc_directional_light_source( < 1, 1, 1 >, rgb < 0.701961, 0.701961, 0.701961 >, rgb < 1, 1, 1 > )
ccdc_directional_light_source( < -1, 0.2, 1 >, rgb < 0.501961, 0.501961, 0.501961 >, rgb < 0.501961, 0.501961, 0.501961 > )
ccdc_ambient_light_source( rgb < 0.301961, 0.301961, 0.301961 > )
ccdc_background_colour( rgb < 1, 1, 1 > )
union {
    #declare world_orientation = transform { matrix <
        -0.263328, -0.35214, 0.89814,
        0.963438, -0.048277, 0.263545,
        -0.0494451, 0.934701, 0.351978,
        0, 0, 0 > };
    #declare world_rotation = transform { matrix <
        -0.263328, -0.35214, 0.89814,
        0.963438, -0.048277, 0.263545,
        -0.0494451, 0.934701, 0.351978,
        0, 0, 0 > };
    union {
        // jr267
        #declare structure_orientation = transform { matrix <
            -0.238025, -0.971259, 0,
            0, 0, -1,
            0.971259, -0.238025, 0,
            -8.55219, 6.08824, 6.11725 > };
        #declare structure_rotation = transform { matrix <
            -0.238025, -0.971259, 0,
            0, 0, -1,
            0.971259, -0.238025, 0,
            0, 0, 0 > };
        // jr267 atoms
        // atom Cr1
        ccdc_draw_solid_sphere( < 3.87762, 7.29382, 9.75554 >, 0.7, rgb < 1, 0.647059, 0 > )
        // atom Cl1
        ccdc_draw_solid_sphere( < 3.87762, 9.64965, 9.75554 >, 0.1, rgb < 0.266667, 1, 0.227451 > )
        // atom Cl2
        ccdc_draw_solid_sphere( < 6.13983, 7.33, 9.22016 >, 0.1, rgb < 0.266667, 1, 0.227451 > )
        // atom N1
        ccdc_draw_solid_sphere( < 3.45173, 7.18168, 7.72574 >, 0.1, rgb < 1, 0, 0 > )
        // atom N2
        ccdc_draw_solid_sphere( < 3.87762, 5.23511, 9.75554 >, 0.1, rgb < 1, 0, 1 > )
        // atom C1
        ccdc_draw_solid_sphere( < 3.88156, 8.15322, 6.92488 >, 0.1, rgb < 1, 0, 0 > )
        // atom C2
        ccdc_draw_solid_sphere( < 3.25016, 8.4882, 5.7239 >, 0.1, rgb < 1, 0, 0 > )
        // atom C3
        ccdc_draw_solid_sphere( < 2.1019, 7.83994, 5.37765 >, 0.1, rgb < 1, 0, 0 > )
        // atom C4
        ccdc_draw_solid_sphere( < 1.63162, 6.78038, 6.18957 >, 0.1, rgb < 1, 0, 0 > )
        // atom C5
        ccdc_draw_solid_sphere( < 2.39417, 6.41176, 7.32498 >, 0.1, rgb < 1, 0, 0 > )
        // atom C6
        ccdc_draw_solid_sphere( < 0.411491, 6.12007, 5.92786 >, 0.1, rgb < 1, 0, 0 > )
        // atom C7
        ccdc_draw_solid_sphere( < -0.00227495, 5.11175, 6.74811 >, 0.1, rgb < 1, 0, 0 > )
        // atom C8
        ccdc_draw_solid_sphere( < 0.837127, 4.6363, 7.7766 >, 0.1, rgb < 1, 0, 0 > )
        // atom C9
        ccdc_draw_solid_sphere( < 2.04567, 5.23873, 8.06003 >, 0.1, rgb < 1, 0, 0 > )
        // atom C10
        ccdc_draw_solid_sphere( < 2.99362, 4.55177, 8.98017 >, 0.1, rgb < 1, 0, 1 > )
        // atom C11
        ccdc_draw_solid_sphere( < 2.98548, 3.15445, 8.96834 >, 0.1, rgb < 1, 0, 1 > )
        // atom C12
        ccdc_draw_solid_sphere( < 3.87762, 2.45495, 9.75554 >, 0.1, rgb < 1, 0, 1 > )
        // atom N1
        ccdc_draw_solid_sphere( < 4.30352, 7.18168, 11.7853 >, 0.1, rgb < 1, 1, 0 > )
        // atom C1
        ccdc_draw_solid_sphere( < 3.87369, 8.15322, 12.5862 >, 0.1, rgb < 1, 1, 0 > )
        // atom C2
        ccdc_draw_solid_sphere( < 4.50509, 8.4882, 13.7872 >, 0.1, rgb < 1, 1, 0 > )
        // atom C3
        ccdc_draw_solid_sphere( < 5.65335, 7.83994, 14.1334 >, 0.1, rgb < 1, 1, 0 > )
        // atom C4
        ccdc_draw_solid_sphere( < 6.12362, 6.78038, 13.3215 >, 0.1, rgb < 1, 1, 0 > )
        // atom C5
        ccdc_draw_solid_sphere( < 5.36107, 6.41176, 12.1861 >, 0.1, rgb < 1, 1, 0 > )
        // atom C6
        ccdc_draw_solid_sphere( < 7.34376, 6.12007, 13.5832 >, 0.1, rgb < 1, 1, 0 > )
        // atom C7
        ccdc_draw_solid_sphere( < 7.75752, 5.11175, 12.763 >, 0.1, rgb < 1, 1, 0 > )
        // atom C8
        ccdc_draw_solid_sphere( < 6.91812, 4.6363, 11.7345 >, 0.1, rgb < 1, 1, 0 > )
        // atom C9
        ccdc_draw_solid_sphere( < 5.70958, 5.23873, 11.4511 >, 0.1, rgb < 1, 1, 0 > )
        // atom C10
        ccdc_draw_solid_sphere( < 4.76163, 4.55177, 10.5309 >, 0.1, rgb < 1, 0, 1 > )
        // atom C11
        ccdc_draw_solid_sphere( < 4.76976, 3.15445, 10.5428 >, 0.1, rgb < 1, 0, 1 > )
        // atom Cl2
        ccdc_draw_solid_sphere( < 1.61541, 7.33, 10.2909 >, 0.1, rgb < 0.266667, 1, 0.227451 > )
        // jr267 bonds
        // bond Cr1-Cl1
        ccdc_draw_closed_cylinder( < 3.87762, 7.29382, 9.75554 >, < 3.87762, 8.47174, 9.75554 >, 0.1, rgb < 1, 0.647059, 0 > )
        ccdc_draw_closed_cylinder( < 3.87762, 8.47174, 9.75554 >, < 3.87762, 9.64965, 9.75554 >, 0.1, rgb < 0.266667, 1, 0.227451 > )
        // bond Cr1-Cl2
        ccdc_draw_closed_cylinder( < 3.87762, 7.29382, 9.75554 >, < 5.00873, 7.31191, 9.48785 >, 0.1, rgb < 1, 0.647059, 0 > )
        ccdc_draw_closed_cylinder( < 5.00873, 7.31191, 9.48785 >, < 6.13983, 7.33, 9.22016 >, 0.1, rgb < 0.266667, 1, 0.227451 > )
        // bond Cr1-N1
        ccdc_draw_closed_cylinder( < 3.87762, 7.29382, 9.75554 >, < 3.66468, 7.23775, 8.74064 >, 0.1, rgb < 1, 0.647059, 0 > )
        ccdc_draw_closed_cylinder( < 3.66468, 7.23775, 8.74064 >, < 3.45173, 7.18168, 7.72574 >, 0.1, rgb < 1, 0, 0 > )
        // bond Cr1-N2
        ccdc_draw_closed_cylinder( < 3.87762, 7.29382, 9.75554 >, < 3.87762, 6.26447, 9.75554 >, 0.1, rgb < 1, 0.647059, 0 > )
        ccdc_draw_closed_cylinder( < 3.87762, 6.26447, 9.75554 >, < 3.87762, 5.23511, 9.75554 >, 0.1, rgb < 1, 0, 1 > )
        // bond Cr1-N1
        ccdc_draw_closed_cylinder( < 3.87762, 7.29382, 9.75554 >, < 4.09057, 7.23775, 10.7704 >, 0.1, rgb < 1, 0.647059, 0 > )
        ccdc_draw_closed_cylinder( < 4.09057, 7.23775, 10.7704 >, < 4.30352, 7.18168, 11.7853 >, 0.1, rgb < 1, 1, 0 > )
        // bond Cr1-Cl2
        ccdc_draw_closed_cylinder( < 3.87762, 7.29382, 9.75554 >, < 2.74652, 7.31191, 10.0232 >, 0.1, rgb < 1, 0.647059, 0 > )
        ccdc_draw_closed_cylinder( < 2.74652, 7.31191, 10.0232 >, < 1.61541, 7.33, 10.2909 >, 0.1, rgb < 0.266667, 1, 0.227451 > )
        // bond N1-C1
        ccdc_draw_closed_cylinder( < 3.45173, 7.18168, 7.72574 >, < 3.88156, 8.15322, 6.92488 >, 0.1, rgb < 1, 0, 0 > )
        // bond N1-C5
        ccdc_draw_closed_cylinder( < 3.45173, 7.18168, 7.72574 >, < 2.39417, 6.41176, 7.32498 >, 0.1, rgb < 1, 0, 0 > )
        // bond N2-C10
        ccdc_draw_closed_cylinder( < 3.87762, 5.23511, 9.75554 >, < 2.99362, 4.55177, 8.98017 >, 0.1, rgb < 1, 0, 1 > )
        // bond N2-C10
        ccdc_draw_closed_cylinder( < 3.87762, 5.23511, 9.75554 >, < 4.76163, 4.55177, 10.5309 >, 0.1, rgb < 1, 0, 1 > )
        // bond C1-C2
        ccdc_draw_closed_cylinder( < 3.88156, 8.15322, 6.92488 >, < 3.25016, 8.4882, 5.7239 >, 0.1, rgb < 1, 0, 0 > )
        // bond C2-C3
        ccdc_draw_closed_cylinder( < 3.25016, 8.4882, 5.7239 >, < 2.1019, 7.83994, 5.37765 >, 0.1, rgb < 1, 0, 0 > )
        // bond C3-C4
        ccdc_draw_closed_cylinder( < 2.1019, 7.83994, 5.37765 >, < 1.63162, 6.78038, 6.18957 >, 0.1, rgb < 1, 0, 0 > )
        // bond C4-C5
        ccdc_draw_closed_cylinder( < 1.63162, 6.78038, 6.18957 >, < 2.39417, 6.41176, 7.32498 >, 0.1, rgb < 1, 0, 0 > )
        // bond C4-C6
        ccdc_draw_closed_cylinder( < 1.63162, 6.78038, 6.18957 >, < 0.411491, 6.12007, 5.92786 >, 0.1, rgb < 1, 0, 0 > )
        // bond C5-C9
        ccdc_draw_closed_cylinder( < 2.39417, 6.41176, 7.32498 >, < 2.04567, 5.23873, 8.06003 >, 0.1, rgb < 1, 0, 0 > )
        // bond C6-C7
        ccdc_draw_closed_cylinder( < 0.411491, 6.12007, 5.92786 >, < -0.00227495, 5.11175, 6.74811 >, 0.1, rgb < 1, 0, 0 > )
        // bond C7-C8
        ccdc_draw_closed_cylinder( < -0.00227495, 5.11175, 6.74811 >, < 0.837127, 4.6363, 7.7766 >, 0.1, rgb < 1, 0, 0 > )
        // bond C8-C9
        ccdc_draw_closed_cylinder( < 0.837127, 4.6363, 7.7766 >, < 2.04567, 5.23873, 8.06003 >, 0.1, rgb < 1, 0, 0 > )
        // bond C9-C10
        ccdc_draw_closed_cylinder( < 2.04567, 5.23873, 8.06003 >, < 2.51964, 4.89525, 8.5201 >, 0.1, rgb < 1, 0, 0 > )
        ccdc_draw_closed_cylinder( < 2.51964, 4.89525, 8.5201 >, < 2.99362, 4.55177, 8.98017 >, 0.1, rgb < 1, 0, 1 > )
        // bond C10-C11
        ccdc_draw_closed_cylinder( < 2.99362, 4.55177, 8.98017 >, < 2.98548, 3.15445, 8.96834 >, 0.1, rgb < 1, 0, 1 > )
        // bond C11-C12
        ccdc_draw_closed_cylinder( < 2.98548, 3.15445, 8.96834 >, < 3.87762, 2.45495, 9.75554 >, 0.1, rgb < 1, 0, 1 > )
        // bond C12-C11
        ccdc_draw_closed_cylinder( < 3.87762, 2.45495, 9.75554 >, < 4.76976, 3.15445, 10.5428 >, 0.1, rgb < 1, 0, 1 > )
        // bond N1-C1
        ccdc_draw_closed_cylinder( < 4.30352, 7.18168, 11.7853 >, < 3.87369, 8.15322, 12.5862 >, 0.1, rgb < 1, 1, 0 > )
        // bond N1-C5
        ccdc_draw_closed_cylinder( < 4.30352, 7.18168, 11.7853 >, < 5.36107, 6.41176, 12.1861 >, 0.1, rgb < 1, 1, 0 > )
        // bond C1-C2
        ccdc_draw_closed_cylinder( < 3.87369, 8.15322, 12.5862 >, < 4.50509, 8.4882, 13.7872 >, 0.1, rgb < 1, 1, 0 > )
        // bond C2-C3
        ccdc_draw_closed_cylinder( < 4.50509, 8.4882, 13.7872 >, < 5.65335, 7.83994, 14.1334 >, 0.1, rgb < 1, 1, 0 > )
        // bond C3-C4
        ccdc_draw_closed_cylinder( < 5.65335, 7.83994, 14.1334 >, < 6.12362, 6.78038, 13.3215 >, 0.1, rgb < 1, 1, 0 > )
        // bond C4-C5
        ccdc_draw_closed_cylinder( < 6.12362, 6.78038, 13.3215 >, < 5.36107, 6.41176, 12.1861 >, 0.1, rgb < 1, 1, 0 > )
        // bond C4-C6
        ccdc_draw_closed_cylinder( < 6.12362, 6.78038, 13.3215 >, < 7.34376, 6.12007, 13.5832 >, 0.1, rgb < 1, 1, 0 > )
        // bond C5-C9
        ccdc_draw_closed_cylinder( < 5.36107, 6.41176, 12.1861 >, < 5.70958, 5.23873, 11.4511 >, 0.1, rgb < 1, 1, 0 > )
        // bond C6-C7
        ccdc_draw_closed_cylinder( < 7.34376, 6.12007, 13.5832 >, < 7.75752, 5.11175, 12.763 >, 0.1, rgb < 1, 1, 0 > )
        // bond C7-C8
        ccdc_draw_closed_cylinder( < 7.75752, 5.11175, 12.763 >, < 6.91812, 4.6363, 11.7345 >, 0.1, rgb < 1, 1, 0 > )
        // bond C8-C9
        ccdc_draw_closed_cylinder( < 6.91812, 4.6363, 11.7345 >, < 5.70958, 5.23873, 11.4511 >, 0.1, rgb < 1, 1, 0 > )
        // bond C9-C10
        ccdc_draw_closed_cylinder( < 5.70958, 5.23873, 11.4511 >, < 5.23561, 4.89525, 10.991 >, 0.1, rgb < 1, 1, 0 > )
        ccdc_draw_closed_cylinder( < 5.23561, 4.89525, 10.991 >, < 4.76163, 4.55177, 10.5309 >, 0.1, rgb < 1, 0, 1 > )
        // bond C10-C11
        ccdc_draw_closed_cylinder( < 4.76163, 4.55177, 10.5309 >, < 4.76976, 3.15445, 10.5428 >, 0.1, rgb < 1, 0, 1 > )
        ccdc_orient_structure( structure_orientation )
        #declare structure_orientation = transform { matrix <
            1, 0, 0,
            0, 1, 0,
            0, 0, 1,
            0, 0, 0 > };
        #declare structure_rotation = transform { matrix <
            1, 0, 0,
            0, 1, 0,
            0, 0, 1,
            0, 0, 0 > };
    }
    // jr267 finished
    ccdc_orient_world( world_orientation )
}
