% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdr_create_service_areas.R
\name{sdr_create_service_areas}
\alias{sdr_create_service_areas}
\title{Creates a distance or time based network service area around stations}
\usage{
sdr_create_service_areas(
  con,
  out_path,
  schema,
  df,
  identifier,
  sa,
  table,
  columns = TRUE,
  cost = "len",
  target = 0.9
)
}
\arguments{
\item{con}{An RPostgres database connection object.}

\item{out_path}{Path to the output folder for logging.}

\item{schema}{Character, the database schema name.}

\item{df}{A data frame with a column named "location"
which has the easting and northing of the station location.}

\item{identifier}{Character, uniquely identifies a station in both the
provided data frame \emph{and} in the target \code{table}.}

\item{sa}{Numeric vector of integer values for the required service areas.
Should be in metres when cost is distance and minutes when cost is time.}

\item{table}{Character, the target database table name.}

\item{columns}{Logical, whether service area columns need to be created in the
target database \code{table}. Default is FALSE.}

\item{cost}{Character, either "len" for a distance-based service area or
"time" for a time-based service area. Default is "len".}

\item{target}{Numeric, the target percent of area of convex hull that
ST_ConvexHull will try to approach before giving up or exiting. Default is 0.9.}
}
\description{
Creates a distance or time based network service area around stations in
the provided data frame using the pgRouting function \code{pgr_withpointsdd}.
The service area geometry is written to the specified database \code{table}
in the specified database \code{schema}. The supplied \code{identifier} links
the stations in the data frame and the database table. Uses parallel processing.
}
