% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdft_submit.R
\name{sdft_submit}
\alias{sdft_submit}
\title{Main function that runs the Station Demand Forecasting Tool}
\usage{
sdft_submit(
  dbhost = "localhost",
  dbport = 5432,
  dbname = "dafni",
  dbuser = "postgres",
  dirpath = getwd()
)
}
\arguments{
\item{dbhost}{Character. IP address or hostname of the machine with the PostgreSQL
database. Default is "localhost".}

\item{dbport}{Integer. Port number used by the PostgreSQL server.}

\item{dbname}{Character. Name of the PostgreSQL database. Default is "dafni".}

\item{dbuser}{Character. Name of the PostgreSQL database user. Default is "postgres". Note
that you need to set the password for this user using the \code{key_set()} function
from the keyring package before running \code{sdr_submit()}.}

\item{dirpath}{Character. Full path to the directory containing the input folder.
This folder will also be used for output and must be writable. Default is the
current working directory. On Windows you should use forward slashes in the path.}
}
\description{
Main function that runs the Station Demand Forecasting Tool
}
