---
jupytext:
  formats: ipynb,md:myst
  text_representation:
    extension: .md
    format_name: myst
    format_version: 0.12
    jupytext_version: 1.6.0
kernelspec:
  display_name: Python 3
  language: python
  name: python3
---

# Exercises

**After** completing the tutorial attempt the following exercises.

**If you are not sure how to do something, have a look at the "How To" section.**

1. Obtain the determinant and the inverses of the following matrices:
    1. $A = \begin{pmatrix} 1 / 5 & 1\\1 & 1\end{pmatrix}$
    2. $B = \begin{pmatrix} 1 / 5 & 1 & 5\\3 & 1 & 6 \\ 1 & 2 & 1\end{pmatrix}$
    3. $C = \begin{pmatrix} 1 / 5 & 5 & 5\\3 & 1 & 7 \\ a & b & c\end{pmatrix}$
2. Compute the following:
    1. $500\begin{pmatrix} 1 / 5 & 1\\1 & 1\end{pmatrix}$
    2. $\pi \begin{pmatrix} 1 / \pi & 2\pi\\3/\pi & 1\end{pmatrix}$
    3. $500\begin{pmatrix} 1 / 5 & 1\\1 & 1\end{pmatrix} + \pi \begin{pmatrix} 1 / \pi & 2\pi\\3/\pi & 1\end{pmatrix}$
    4. $500\begin{pmatrix} 1 / 5 & 1\\1 & 1\end{pmatrix}\begin{pmatrix} 1 / \pi & 2\pi\\3/\pi & 1\end{pmatrix}$
3. The matrix $A$ is given by $A=\begin{pmatrix}a & 4 & 2\\ 1 & a & 0\\ 1 & 2 & 1\end{pmatrix}$.
    1. Find the determinant of $A$
    2. Hence find the values of $a$ for which $A$ is singular.
    3. State, giving a brief reason in each case, whether the simultaneous equations

        $$
            \begin{array}
                a x + 4y + 2z= 3a\\
                x + a  = 1\\
                x + 2y + z = 3\\
            \end{array}
        $$

        have any solutions when:
          1. $a = 3$;
          2. $a = 2$
4. The matrix $D$ is given by $D = \begin{pmatrix} a & 2 & 0\\ 3 & 1 & 2\\ 0 & -1 & 1\end{pmatrix}$ where $a\ne 2$.
    1. Find $D^{-1}$.
    2. Hence of otherwise, solve the equations:

    $$
    \begin{array}
        a x + 2y = 3\\
        3x + y + 2z = 4\\
        - y + z = 1\\
    \end{array}
    $$
