---
jupytext:
  formats: ipynb,md:myst
  text_representation:
    extension: .md
    format_name: myst
    format_version: 0.12
    jupytext_version: 1.6.0
kernelspec:
  display_name: Python 3
  language: python
  name: python3
---

# Using notebooks

## Introduction

At the advent of Calculus two mathematicians are credited with its
formalisation/invention:

- Isaac Newton
- Gottfried Leibniz

One of the differences between the approaches taken by Newton and Leibniz is
their notation:

Newton denoted the derivative of a function $f$ as:

$$Df$$

and Leibniz denoted the derivative with the now more commonly used notation:

$$\frac{df}{dx}$$

The mathematics itself is unchanged: what changes is the language/notation used
to communicate it.

Similarly when giving instructions through code to a computer there are a number
of notations, more commonly called languages available.

We will be using a language called [**Python**](https://www.python.org).

Python was originally designed as a teaching language but it is now popular both
in academia and in industry.

```{important}
In this chapter we will cover:

- Installing the specific distribution of Python on your computer.
- Using something called a Jupyter notebook to write and run Python code.
- Writing descriptive notes using `markdown` and $\LaTeX$ (pronounced Lay-tech).
```
