---
jupytext:
  formats: ipynb,md:myst
  text_representation:
    extension: .md
    format_name: myst
    format_version: 0.12
    jupytext_version: 1.6.0
kernelspec:
  display_name: Python 3
  language: python
  name: python3
---

# How this book is structured

Most programming texts introduce readers to the building blocks of
programming and build up to using more sophisticated tools for a specific
purpose.

This is akin to teaching someone how to forge metal so as to make a nail and
then slowly work our way to using more sophisticated tools such as power tools
to build a house.

This book will do thing in a different way: we will start with using and
understanding tools that are helpful to mathematicians. In the later part of the
book we will cover the building blocks and you will be able to build your own
sophisticated tools.

The book is in two parts:

1. Tools for mathematics;
2. Building tools.

The first part of the book will not make use of any novel mathematics.
Instead we will consider a number of mathematics problem that are often covered
in secondary school.

- Algebraic manipulation
- Calculus (differentiation and integration)
- Permutations and combinations
- Probability
- Linear algebra

The questions we will tackle will be familiar in their presentation and
description. **What will be different** is that no **by hand** calculations will
be done. We will instead carry them all out using a programming language.

In the second part of the book you will be encouraged to build your own tools
to be able to tackle a problem type of your choice.

```{attention}
Every chapter will have 4 parts:

- A tutorial: you will be walked through solving a problem. You will be
  specifically told what to do and what to expect.
- A how to section: this will be a shorter more succinct section that will
  detail how to carry out specific things.
- A further information section: this will be a section with references to
  further resources as well as background information about specific things in
  the chapter and answers to common questions.
- An exercise section: this will be a number of exercises that you can work on.
```
