% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectivefun.R
\name{run_objective}
\alias{run_objective}
\title{Run user-specified objective function evaluations on a list of scenarios}
\usage{
run_objective(
  aScenarioList,
  years = NULL,
  landtypes = NULL,
  objectivefuns = c("bias", "rms", "centeredrms", "nrms", "centerednrms", "kge")
)
}
\arguments{
\item{aScenarioList}{List of ScenarioInfo structures}

\item{years}{Vector of years to filter observations to (default is to use all
available years)}

\item{landtypes}{Vector of land types to filter observations to (default is
to use all available land types). Currently, this is crop-type GCAM commodities
with observations from FAO via the \code{get_historical_land_data} function.
TODO: update to include choice of data sources and other land types, eg Forest.}

\item{objectivefuns}{User specified string of objective functions to calculate. Default
is to all supported objective functions:
c('bias', 'rms', 'centeredrms', 'nrms', 'centerednrms', 'kge')).}
}
\value{
Modified list of ScenarioInfo structures with the objective
function calculation tables populated as a new list entry in ScenarioInfo:
ScenarioInfo$mObjFunEval.
}
\description{
The assumption is that the scenarios have already been run.  The best way to
arrange this is to use the return value of \code{\link{run_ensemble}} as the
argument to this function
}
\details{
The \code{years} and \code{landtypes} arguments can be use to restrict the
observations that will be used in the analysis.  The regions are always
filtered to excatly the regions that are included in the ScenarioInfo
structures. The \code{objectivefuns} is vector of strings with the names of
objective functions to be evaluated. Currently, we support the following
objective functions:
\code{c('bias', 'rms', 'centeredrms', 'nrms', 'centerednrms', 'kge')}

\code{c('bias', 'rms', 'centeredrms', 'nrms', 'centerednrms'} are defined and
examined in Snyder et al 2017 (https://doi.org/10.5194/gmd-10-4307-2017),
among other places.

The definition for \code{'kge'} presented in Knoben et al 2019
(https://doi.org/10.5194/hess-23-4323-2019) is the one implemented here.
}
\author{
ACS May 2020
}
