% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{run_model}
\alias{run_model}
\title{Run the GCAM land model}
\usage{
run_model(aScenarioInfo, aPeriods = NULL, aVerbose = FALSE, agData = NULL)
}
\arguments{
\item{aScenarioInfo}{A structure containing scenario-related information,
created by \code{\link{ScenarioInfo}}.  There is a pre-built structure for the
default scenario called \code{\link{SCENARIO.INFO}}.}

\item{aPeriods}{Integer vector of periods to run.  Default is all periods
defined for the scenario type.}

\item{aVerbose}{If \code{TRUE}, output additional debugging information.}

\item{agData}{Ag data read by \code{\link{ReadData_AgProd}}.  The data must
be for the same region and scenario type as the \code{aScenarioInfo} object.}
}
\value{
Table of model results.
}
\description{
Loop through all years and run the land model.
}
\examples{
\dontrun{
run_model(SCENARIO.INFO, aVerbose=TRUE)
run_model(SCENARIO.INFO, aPeriods = 1:5)
}
}
\author{
KVC
}
