% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{run_ensemble}
\alias{run_ensemble}
\title{Run an ensemble of offline land models; by default, no analyis of
the runs is completed.}
\usage{
run_ensemble(
  N = 500,
  aOutputDir = "./outputs",
  skip = 0,
  aType = "Hindcast",
  aIncludeSubsidies = FALSE,
  aDifferentiateParamByCrop = FALSE,
  aSampleType = "LatinHyperCube",
  aTotalSamplesPlanned = 500,
  logparallel = NULL
)
}
\arguments{
\item{N}{Number of parameter sets to select}

\item{aOutputDir}{Output directory}

\item{skip}{Number of iterations to skip (i.e., if building on another run.)}

\item{aType}{Scenario type: either "Reference" or "Hindcast"}

\item{aIncludeSubsidies}{Boolean indicating subsidies should be added to profit}

\item{aDifferentiateParamByCrop}{Boolean indicating whether all crops should use the same expectation parameters}

\item{aSampleType}{String indicating what type of sampling, currently only "LatinHyperCube" and "Sobol" are supported}

\item{aTotalSamplesPlanned}{Number of samples planned. For Latin Hypercube, we need to know the total before we start.}

\item{logparallel}{Name of directory to use for parallel workers' log files.
If \code{NULL}, then don't write log files.}
}
\value{
List of ScenarioInfo objects for the ensemble members
}
\description{
Parameter combinations are selected by generating a quasi-random
sequence and mapping it to a specified range for each parameter.
Then, each parameter set is run through the offline land model in
each of the Perfect, Adaptive, HybridPerfectAdaptive, HybridLinearAdaptive, and Linear variants.
 (I.e., if N parameter sets are selected, then 5N scenarios are run.)
}
\details{
This function is strictly for running the ensemble of models. Analysis
must be completed after the fact.
}
\section{Output}{

The model results are written to a series of files in the specified output
directory.
The
list of \code{ScenarioInfo} objects is written to a file called
\code{scenario-info.rds} in the output directory.  This file can be loaded
with a command such as \code{scenaro_list <-
readRDS('output/scenario-info.rds')}.  These objects contain links to the
model output files.
}

\author{
KVC November 2017
}
