% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{run_bayes}
\alias{run_bayes}
\title{Run all the Bayesian analysis on a list of scenarios}
\usage{
run_bayes(
  aScenarioList,
  years = NULL,
  landtypes = NULL,
  lpdf = get_lpdf(1),
  lprior = uniform_prior
)
}
\arguments{
\item{aScenarioList}{List of ScenarioInfo structures}

\item{years}{Vector of years to filter observations to (default is to use all
available years)}

\item{landtypes}{Vector of land types to filter observations to (default is
to use all available land types)}

\item{lpdf}{Log probability density function (q.v. \code{\link{get_lpdf}})}

\item{lprior}{Log prior function (q.v. \code{\link{calc_prior}}).}
}
\value{
Modified list of ScenarioInfo structures with the Bayesian
calculation tables populated.
}
\description{
The assumption is that the scenarios have already been run.  The best way to
arrange this is to use the return value of \code{\link{run_ensemble}} as the
argument to this function
}
\details{
The \code{years} and \code{landtypes} arguments can be use to restrict the
observations that will be used in the analysis.  The regions are always
filtered to excatly the regions that are included in the ScenarioInfo
structures.

Typically log-probaility density functions are parameterized with a parameter
(conventionally called \eqn{\sigma}) that describes how quickly the
probability density falls off as the discrepancy between the model outputs
and observed data grows.  We use a slightly modified version of this
convention.  Because we look at a variety of different land use types, each
of which can have completely different scale.  Therefore, we let each land
use type have its own \eqn{\sigma} value.  We tie these values together using
a single parameter \eqn{\xi}, which represents the fraction of the total
variance of the observed values for a land use type that is allocated to that
land use's \eqn{\sigma}.  In other words, for a land type \eqn{i}, with
observations \eqn{O_i},
\deqn{\sigma^2_i = \xi \var(O_i).}
A single call to \code{run_bayes} will produce posteriors for a range of
\eqn{\xi} values, by default \eqn{\xi = 0.1 \ldots 1.0} in steps of 0.1.
}
\section{TODO}{


\itemize{
\item{Offer some more control over xi values,
etc.}
}
}

