% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waic.R
\name{pointwise_loglike}
\alias{pointwise_loglike}
\title{Return pointwise log likelihood density for all samples in a model}
\usage{
pointwise_loglike(aScenarioList, weighted)
}
\arguments{
\item{aScenarioList}{A list of ScenarioInfo structures.  They should all be
from the same model (i.e., the same expectation type).}

\item{weighted}{Flag indicating whether posterior probability weight factors
should also be produce}
}
\value{
A list with the matrix of log likelihood density values and, if
\code{weighted==TRUE}, a vector of log posterior probabilities for weighting.
}
\description{
Produce a matrix of log likelihood density for each observational data point in
each parameter sample for the model.  The result is a matrix with data points
in rows and model samples in columns.  If the samples are uniform (i.e.,
instead of MCMC), then the samples will need to be weighted by their
posterior probabilities.  In this case, a vector of log weight factors is
also produced.
}
\keyword{internal}
