% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions-analysis.R
\name{get_scenario_land_data}
\alias{get_scenario_land_data}
\title{Load land use results for a list of already-run scenarios}
\usage{
get_scenario_land_data(aScenarioList)
}
\arguments{
\item{aScenarioList}{List of ScenarioInfo structures for the runs.}
}
\value{
List of data frames containing land data.
}
\description{
Fetch land use results and aggregate to region, commodity, year, and
scenario.
}
\details{
The name of the input file is constructed from the ScenarioInfo structure's
\code{mOutputDir} and \code{mFileName} attributes.  It is permissible to have
multiple output directories and/or file names in the list of structures
passed as an argument.  Each file will be read only once.

The return value is a list of data frames, indexed by the scenario name.
The data frames
returned this way have columns for region, land-type, year, and area.
}
\section{TODO}{


Currently the land use results don't have a region column, so we can't
aggregate by region (we have to assume that the results are all for a single
region).  Once we add a region column to the model output, we will want to
add region to the grouping variables for this function.
}

