% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{get_lpdf}
\alias{get_lpdf}
\title{Select a log-probability density function}
\usage{
get_lpdf(df)
}
\arguments{
\item{df}{Degrees of freedom for the distribution.}
}
\value{
A function \code{lp(model-observation, sigma)}
}
\description{
Choose a log-probability density function from the family of Gossett's
t-distributions (including the normal distribution as a special case).
}
\details{
The t-distributions are parameterized by a parameter \eqn{\nu} called the
"degrees of freedom".  Despite the name, this parameter need not be an
integer; however, it must be positive.  The smaller \eqn{\nu} is, the heavier
the tails of the distribution.  In the limit that \eqn{\nu \rightarrow \infty},
the distribution becomes equivalent to the normal distribution.  Therefore,
as a special case, passing \code{df = Inf} will return a normal distribution.

The function returned from this generator should be called with a vector of
differences between the model data and observed data, and a vector of scale
factors \eqn{sigma}.  Together, these will be used to compute
t-scores; that is, scaled differences between the model data and observed
data: \eqn{t = (M-O)/\sigma}.

The scaling factor \eqn{\sigma} is a parameter of the probability model.
Since the scales of the observed and model values depend on the commodity
and/or region, this will be a vector of the same length as the difference
vector.
}
