% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility-functions-analysis.R
\name{get_historical_land_data}
\alias{get_historical_land_data}
\title{Get historical land use data}
\usage{
get_historical_land_data(regions = NULL, years = NULL, commodities = NULL)
}
\arguments{
\item{regions}{Regions to keep in filtered data. (Default is use all regions.)}

\item{years}{Years to keep in filtered data. (Default is use all years.). Note,
this function calculates the linear trend in historic data; therefore subsetting
to different years with this argument will result in different trend lines.}

\item{commodities}{GCAM commodities to keep in filtered data (Default is to
use all commodities.)}
}
\value{
Data frame containing the filtered data.
}
\description{
Fetch the historical land use data and filter to the desired regions, years,
and GCAM commodities.
}
\details{
All of the runs in a single ensemble should have the same regions, years, and
commodities, so generally it will only be necessary to run this function once
at the beginning of the analysis.  The resulting data can be matched to the
model results for each of the models run in order to calculate Bayesian
likelihoods and objective function evaluations.
}
