% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{gen_ensemble_member}
\alias{gen_ensemble_member}
\title{Generate the ensemble members for a single set of parameters}
\usage{
gen_ensemble_member(
  agFor,
  agForNonPast,
  crop,
  share1,
  share2,
  share3,
  linyears1,
  linyears2,
  linyears3,
  serialnum,
  aScenType,
  aIncludeSubsidies,
  suffix,
  aOutputDir
)
}
\arguments{
\item{agFor}{The logit exponent the ag/forest nest, which controls
competition between pasture and all other arable land.}

\item{agForNonPast}{The logit exponent for the non-pasture nest, which
controls competition between crops, grass/shrub, and forest.}

\item{crop}{The logit exponent for the crop nest}

\item{share1}{The share parameter for the lagged model for crop group 1 (see constants.R)}

\item{share2}{The share parameter for the lagged model for crop group 2 (see constants.R)}

\item{share3}{The share parameter for the lagged model for crop group 3 (see constants.R)}

\item{linyears1}{The number of years parameter for the linear model for crop group 1 (see constants.R)}

\item{linyears2}{The number of years parameter for the linear model for crop group 2 (see constants.R)}

\item{linyears3}{The number of years parameter for the linear model for crop group 3 (see constants.R)}

\item{serialnum}{Serial number for the run}

\item{aScenType}{Scenario type, either "Hindcast" or "Reference"}

\item{aIncludeSubsidies}{Boolean flag indicating whether subsidies should be included in profit}

\item{suffix}{Suffix for output filenames.}

\item{aOutputDir}{Name of the output directory.}
}
\value{
List of three ScenarioInfo objects
}
\description{
This generates one each of the Perfect, Adaptive, HybridLinearAdaptive, HybridPerfectAdaptive, and Linear scenario types
using the input parameters.  The return value is a list of the three
\code{ScenarioInfo} objects for the scenarios generated.
}
\keyword{internal}
