% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcamland.R
\docType{package}
\name{gcamland}
\alias{gcamland}
\title{gcamland: A stand-alone implementation of the GCAM land allocation subsystem.}
\description{
The \code{gcamland} package replicates the land allocation decisions made in
GCAM (\url{https:://github.com/jgcri/gcam-core}). The equations are documented in
Wise et al. (2014). \code{gcamland} takes in prices and agricultural productivity
growth and calculates land allocation. The model can operate in either
hindcast (1975-2015) or future mode (2010-2100), running either single
simulations or large ensembles.
}
\section{Usage}{


\strong{Basic Usage}

To run an individual scenario, first generate a structure to hold the
scenario parameters. The scenario structure can be passed directly to the
main model function.  Then the model can be run with the
\code{\link{run_model}} function.
\preformatted{
sceninfo <- ScenarioInfo(aExpectationType = "Perfect", aScenarioType = "Hindcast", aScenarioName = "Perfect_Hindcast", aFileName = "Perfect_Hindcast")
rslt <- run_model(sceninfo)
}
The results will be returned as a data frame.  If the \code{aVerbose}
argument is set to \code{TRUE}, the results also written as a series of rds
(compressed R binaries that can be loaded with \code{\link[base]{readRDS}}
function) and csv files in the directory specified.

\strong{Running Ensembles}

The \code{\link{run_ensemble_bayes}} function function will generate and run a
collection of scenarios with varying parameters. The parameters are sampled
quasi-randomly using a Sobol sequence. The arguments to \code{run_ensemble_bayes} are the
number of samples (for each expectation model, so 3 times that many will
actually be run), output directory, and (optionally) scenario type.

Ensembles can (and probably should) be run in parallel using the
\code{doParallel} package.  To do this, just specify the number of cores to
use in the parallel calculation, and \code{doParallel} will take care of the
rest.
\preformatted{
registerDoParallel(cores=6)
ensemble_scenarios <- run_ensemble_bayes(1000, './ensemble-output')
}
The return value from \code{run_ensemble_bayes} is a list of \code{ScenarioInfo}
structures for the scenarios that were run.

For very large ensembles ensembles you will probably want to run them in
parallel on a cluster. There is an example batch script (for the SLURM
cluster resource manager) in \code{scripts/jobrun.zsh}. You will want to
customize the output directory and number of iterations to your needs, then
submit it with sbatch.  For example, to run 10 batches, each with 960 samples
for each of the three models, submit this batch request:
\preformatted{
sbatch --array=0-9 jobrun.zsh
}
}

\section{Bayesian Inference}{


There are several functions to support Bayesian inference on the ensemble
results.  The \code{\link{run_bayes}} function compares the model outputs to
the historical data and computes posterior probability densities for the
samples.  The results of \code{run_bayes} are stored in the
\code{ScenarioInfo} structures.  You can use the \code{\link{grand_table_bayes}}
function to reorganize these results into a table for more convenient
analysis.

Other Bayesian analysis functions include:
\describe{
\item{\code{\link{MAP_bayes}}}{Maximum a posteriori parameter
estimate.}
\item{\code{\link{EV}}}{Expectation value for parameters.}
\item{\code{\link{HPDI}}}{Highest Posterior Density Interval (a type of
confidence interval for parameters)}
\item{\code{\link{waic}}}{Widely Applicable Information Criterion (WAIC), an
estimate of a model's out of sample performance.}
}
}

