% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{calc_prior}
\alias{calc_prior}
\title{Compute the log-prior for a paremeter set}
\usage{
calc_prior(aScenarioInfo, xi, lprior)
}
\arguments{
\item{aScenarioInfo}{ScenarioInfo structure for the scenario.}

\item{xi}{Vector of xi parameter values}

\item{lprior}{Function that calculates the log-prior (see details).  Default
applies a uniform prior.}
}
\value{
Vector of log-prior values
}
\description{
The land model parameters are extracted from the ScenarioInfo object
supplied.  The \code{xi} parameter isn't stored in the ScenarioInfo
structure, so it must be supplied separately.  Multiple \code{xi} values in a
vector are allowed.  The prior must also be supplied as a function.  It
should take a named list of parameter vectors and compute the log prior for
those parameters
}
\details{
The design of the prior function is trying to walk a tightrope between
convenience, flexibility, and extensibility.  Right now the parameters are
expectation.type (character), share.old and linear.years (double, only
defined for certain types), logit.agforest, logit.afnonpast, logit.crop, and
xi (all double, and all defined for all models).  The purpose of passing them
in a list is to ensure that we can easily add new parameters if we want to.

Also note that because a couple of the parameters are defined only for
certain expectation types, a prior function will have to handle those cases
correctly.

Finally, note that the list \emph{actually} passed to the prior function may
contain extra junk variables (to avoid having to waste time dropping columns
that aren't needed.)  The prior function should ignore these.
}
\keyword{internal}
