% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{calc_post}
\alias{calc_post}
\title{Compute the log-likelihood and log-posteriors for a set of parameters}
\usage{
calc_post(aScenarioInfo, obs, model, lpdf, lprior, varlvls = seq(0.1, 1, 0.1))
}
\arguments{
\item{aScenarioInfo}{ScenarioInfo structure for the scenario}

\item{obs}{Table of observational data (q.v. \code{\link{add_parameter_data}})}

\item{model}{Table of model results for the scenario.}

\item{lpdf}{Log probability density function (q.v. \code{\link{get_lpdf}})}

\item{lprior}{Log prior function (q.v. \code{\link{calc_prior}})}

\item{varlvls}{Variance levels to run (see description in
\code{\link{calc_loglikelihood}}).}
}
\value{
Modified ScenarioInfo with pointwise likelihood and model posterior
tables.
}
\description{
The log-posterior is just the sum over the pointwise likelihoods, plus the
prior for the given parameter set.
}
\keyword{internal}
