% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{calc_loglikelihood}
\alias{calc_loglikelihood}
\title{Compute the log-likelihoods for each data point}
\usage{
calc_loglikelihood(obs, model, lpdf, varlvls)
}
\arguments{
\item{obs}{Table of observational data (q.v. \code{\link{add_parameter_data}})}

\item{model}{Table of model outputs
(q.v. \code{\link{get_scenario_land_data}})}

\item{lpdf}{Log probability density function (q.v. \code{\link{get_lpdf}})}

\item{varlvls}{Variance levels to run (see details).}
}
\value{
Data frame containing xi and ll_
}
\description{
Match historical data to observations and compute the log-likelihood for each
data point.  This will be done for a variety of variance levels, so the
result will be a table with an extra parameter \code{xi} and an output column
\code{ll_} that gives the log pointwise probability density.
}
\details{
The variance levels \eqn{\xi} are used to calculate the scale parameter
required by the lpdf.  For each grouping of region, land type (i.e., GCAM
commodity), and variable (e.g., land area), we calculate a variance
\eqn{\varsigma^2_g} for the grouping.  Then, the scale factor for all of the
data points in the grouping is calculated as \eqn{\sigma_g = \sqrt{\xi
\varsigma^2_g}}.  If multiple \eqn{\xi} values are passed, this process is
repeated for each one, and the results are combined into a single table.
}
\keyword{internal}
