% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_expectation.R
\name{calc_adaptive_expectation}
\alias{calc_adaptive_expectation}
\title{Compute autoregressive model for expectation}
\usage{
calc_adaptive_expectation(t, alpha, datatbl, colname)
}
\arguments{
\item{t}{The current year, for which we wish to calculate the expected
price.}

\item{alpha}{Coefficient of previous year term in the autoregressive
series.}

\item{datatbl}{Table of price vs. year.  This series is assumed
not to have any gaps in it and to be in year order, but neither of
these conditions are checked.}

\item{colname}{Name of the column that has the data for which we are
computing the expectation (e.g. \code{'price'})}
}
\description{
This function computes expectation (generally for price or yield) as an autoregressive
function of the price time series.
\deqn{
y_i = \alpha y_{i-1} + (1-\alpha) x_i
}
}
\details{
There is some dispute over what the final term in this series
should be.  In this implementation the final term is just like
all the others; therefore, for \eqn{\alpha = 0} this formula
reduces to \eqn{y_i = x_i}, the equivalent of perfect expectation.

This function is not currently vectorized; a separate call is needed
for each value of \code{t}.
}
