% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_scenario_info.R
\name{ScenarioInfo}
\alias{ScenarioInfo}
\title{ScenarioInfo constructor}
\usage{
ScenarioInfo(
  aExpectationType = NULL,
  aLaggedShareOld1 = NA,
  aLaggedShareOld2 = NA,
  aLaggedShareOld3 = NA,
  aLinearYears1 = NA,
  aLinearYears2 = NA,
  aLinearYears3 = NA,
  aLogitUseDefault = TRUE,
  aLogitAgroForest = NA,
  aLogitAgroForest_NonPasture = NA,
  aLogitCropland = NA,
  aUseZeroCost = FALSE,
  aCalibrateShareWt = TRUE,
  aIncludeSubsidies = FALSE,
  aShareWeights = NULL,
  aScenarioType = DEFAULT.SCENARIO.TYPE,
  aScenarioName = NULL,
  aFileName = NULL,
  aOutputDir = "./outputs",
  aSerialNum = NA,
  aRegion = DEFAULT.REGION,
  aSubRegion = NULL
)
}
\arguments{
\item{aExpectationType}{Expectation type}

\item{aLaggedShareOld1}{Share of old expectations included in current expectation for crop group 1 (see constants.R)}

\item{aLaggedShareOld2}{Share of old expectations included in current expectation for crop group 2 (see constants.R)}

\item{aLaggedShareOld3}{Share of old expectations included in current expectation for crop group 3 (see constants.R)}

\item{aLinearYears1}{Years for linear expectations for crop group 1 (see constants.R)}

\item{aLinearYears2}{Years for linear expectations for crop group 2 (see constants.R)}

\item{aLinearYears3}{Years for linear expectations for crop group 3 (see constants.R)}

\item{aLogitUseDefault}{Boolean indicating whether to use default logits}

\item{aLogitAgroForest}{AgroForest logit exponent (assuming mLogitUseDefault == FALSE)}

\item{aLogitAgroForest_NonPasture}{AgroForest_NonPasture logit exponent (assuming mLogitUseDefault == FALSE)}

\item{aLogitCropland}{Cropland logit exponent (assuming mLogitUseDefault ==
FALSE)}

\item{aUseZeroCost}{Boolean indicating whether to set costs to zero (assuming mUseZeroCost == FALSE)}

\item{aCalibrateShareWt}{Boolean indicating that the model should calculate share weights during calibration}

\item{aIncludeSubsidies}{Boolean indicating whether subsidy information should modify profit}

\item{aShareWeights}{Named vector of share weights to use instead of calibrating.
The names should correspond to the names of the land leaf nodes.}

\item{aScenarioType}{Type of scenario to run: either "Reference" or "Hindcast".}

\item{aScenarioName}{Complete scenario name, with expectations & logit info}

\item{aFileName}{File name}

\item{aOutputDir}{Output directory}

\item{aSerialNum}{Serial number for a run that is part of a series.}

\item{aRegion}{Region to use in the calculation.  Right now we only run a
single region at a time.}

\item{aSubRegion}{Subregion name. Note we can only run a full region or a subregion not both}
}
\value{
New ScenarioInfo object
}
\description{
Create a structure that ontains all information needed to describe a
scenario.
}
\details{
Most of the parameters are self-explanatory.  The \code{Obsvar} parameter
is a little unusual, in that it plays no role in the model calculations; it
only enters into the likelihood function.  Fitting this parameter allows us
to estimate how much of the variation in the observed data isn't captured by
our model.  This variation could be because of irreducible uncertainty (e.g.,
measurement error in the observed data), or it could be an indicator that
there is some behavior that our model is failing to capture.
}
\author{
KVC November 2017
}
