% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{MAP_bayes}
\alias{MAP_bayes}
\title{Calculate MAP (maximum a posteriori) estimates for a collection of model runs
that have been analysed following a Bayesian approach.}
\usage{
MAP_bayes(
  samples,
  modelgroup = "expectation.type",
  reportvars = NULL,
  lp = "lp_"
)
}
\arguments{
\item{samples}{Monte Carlo samples, given either as a grand table or a list
of \code{ScenarioInfo} objects}

\item{modelgroup}{Vector of names of columns that define the model groupings.
The default is the single column \code{expectation.type}.}

\item{reportvars}{Vector of names of variables for which to report
expectations.  The default is all parameter values.}

\item{lp}{Name of the column containing the log posterior
probability.  Ignored if \code{weighted==FALSE}.}
}
\description{
The MAP estimate is the estimate in each model group with the highest
posterior probability density.  The results are reported in a data frame that
contains the MAP values of all of the parameters, for
all model groups, along with the in-sample deviance.
}
