% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{HPDI}
\alias{HPDI}
\title{Calculate highest posterior density interval (HPDI) for a set of samples}
\usage{
HPDI(
  samples,
  interval = 0.95,
  modelgroup = "expectation.type",
  reportvars = NULL,
  weighted = TRUE,
  lp = "lp_"
)
}
\arguments{
\item{samples}{Monte Carlo samples, given either as a grand table or a list
of \code{ScenarioInfo} objects}

\item{interval}{The fraction of samples to be contained in the interval}

\item{modelgroup}{Vector of names of columns that define the model groupings.
The default is the single column \code{expectation.type}.}

\item{reportvars}{Vector of names of variables for which to report
expectations.  The default is all parameter values.}

\item{weighted}{If \code{TRUE}, weight the samples by their posterior.}

\item{lp}{Name of the column containing the log posterior
probability.}
}
\value{
List of matrices, one element for each model. Each matrix has
parameters in rows and the upper/lower bounds of the interval in its two
columns.
}
\description{
The HPDI is the interval that contains a specified fraction of the sample
points, ordered by posterior probability density.
}
