% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesian.R
\name{EV}
\alias{EV}
\title{Calculate the parameter expectation values for a collection of model runs.}
\usage{
EV(
  samples,
  modelgroup = "expectation.type",
  reportvars = NULL,
  weighted = TRUE,
  lp = "lp_"
)
}
\arguments{
\item{samples}{Monte Carlo samples, given either as a grand table or a list
of \code{ScenarioInfo} objects}

\item{modelgroup}{Vector of names of columns that define the model groupings.
The default is the single column \code{expectation.type}.}

\item{reportvars}{Vector of names of variables for which to report
expectations.  The default is all parameter values.}

\item{weighted}{If \code{TRUE}, weight the samples by their posterior.}

\item{lp}{Name of the column containing the log posterior
probability.  Ignored if \code{weighted==FALSE}.}
}
\description{
Use the parameter sample values to compute expectation values for the
parameters.  The samples can be either MCMC samples or uniform samples.  In
the latter case, the values will be weighted by their posterior
probabilities.
}
\details{
The input to this function can be given either as a grand table
(q.v. \code{\link{grand_table_bayes}}) or as a list of \code{ScenarioInfo}
objects.  Generally this collection will have several model families
represented, so the table is split according to the model type.  The result
will be a table of expectation values by model
}
