# Offline version of the GCAM land allocation module
[![Travis-CI Build Status](https://travis-ci.org/JGCRI/gcamland.svg?branch=master)](https://travis-ci.org/JGCRI/gcamland)
[![Coverage Status](https://img.shields.io/codecov/c/github/JGCRI/gcamland/master.svg)](https://codecov.io/github/JGCRI/gcamland?branch=master)

[![DOI](https://zenodo.org/badge/103271769.svg)](https://zenodo.org/badge/latestdoi/103271769)


## Description

`gcamland` replicates the land allocation decisions made in GCAM (https:://github.com/jgcri/gcam-core). The equations are documented in Wise et al. (2014). `gcamland` takes in prices and agricultural productivity growth and calculates land allocation. The model can operate in either hindcast (1975-2010) or future mode (2010-2100), running either single simulations or large ensembles.


## Using `gcamland`
A wiki describing how to use and modify `gcamland` is provided at: https://github.com/JGCRI/gcamland/wiki

Please cite Wise et al. (2014) when using this package.


## References
Wise, M., K. Calvin, P. Kyle, P. Luckow and J. Edmonds (2014). "Economic and Physical Modeling of Land Use in GCAM 3.0 and an Application to Agricultural Productivity, Land, and Terrestrial Carbon." Climate Change Economics 5(2).
