'''
Created on Jul 30, 2015

potency review for:
- all individual sectors of a precursor and all sectors together
- all individual precursors of a sector and all precursors together

@author: degraba
'''

# imports
from netCDF4 import Dataset
from module2 import module2
from time import time
from sherpa_globals import alpha_potency, path_emission_cdf_test, path_nuts0_cdf_test, path_reduction_txt_test, \
    path_base_conc_cdf_test, path_model_cdf_test, path_result_cdf_test, path_nuts2_cdf_test
from numpy import zeros
from os import remove

# function definition of source receptor model
def module5(path_emission_cdf, path_nuts_cdf, path_reduction_txt, path_base_conc_cdf, path_model_cdf, path_result_cdf):
    
    # execute module 2
    mod2_res = module2(path_emission_cdf, path_nuts_cdf, path_reduction_txt, path_model_cdf, path_result_cdf)
    delta_conc_nuts = mod2_res['delta_conc_nuts']
    # delta_emission_precursor_nuts_dict[nuts][precursor]
    delta_emission_nuts_dict = mod2_res['delta_emis_precursor_nuts']
    n_nuts = mod2_res['n_nuts']
    n_lat = mod2_res['n_lat']
    n_lon = mod2_res['n_lon']
    
    # remove netcdf output of module 2
    remove(path_result_cdf + 'delta_concentration_nuts.nc')
    
    # read baseline concentrations
    rootgrp = Dataset(path_base_conc_cdf, 'r')
    conc = rootgrp.variables['conc'][:] 
    # close model netcdf
    rootgrp.close()

#     # only if only one precursor is reduced delta_emission is used for potency calculations
#     # check this
#     number_reduced_precursors = 0
#     for precursor in precursor_lst:
#         if sum(delta_emis_dict[precursor]) > 0:
#             number_reduced_precursors =+ 1
#             reduced_precursor = precursor
#             delta_emis = delta_emis_dict[precursor]
#             print('precusor %s was reduced' % precursor)
#     if number_reduced_precursors != 1:
#         reduced_precursor = ''
#     print(sum(delta_emis))
    
    # calculate different potencies
    #------------------------------
#     print('check delta conc')
#     print(sum(delta_conc_nuts))
    
    DC_alpha_nuts = zeros((n_nuts, n_lat, n_lon))
    DC_C_alpha_nuts = zeros((n_nuts, n_lat, n_lon))
    if delta_emission_nuts_dict.keys():
        DC_DE_nuts = zeros((n_nuts, n_lat, n_lon))
    
    for nuts in range(n_nuts):
        # Delta_C/alfa
        DC_alpha_nuts[nuts, :, :] = delta_conc_nuts[nuts] / (alpha_potency / 100.0)
        
        # Delta_C/C / Delta_E/E = Delta_C/C/alpha
        DC_C_alpha_nuts[nuts, :, :] = delta_conc_nuts[nuts] / conc / (alpha_potency / 100.0)
        
        # Delta_C / Delta_E
        # DE makes no sense when different precursors are reduced. In this case delta_emission_nuts_dict, generated by module 2, is empty
        if delta_emission_nuts_dict.keys():
            for i in range(n_lat):
                for j in range(n_lon):
                    if delta_emission_nuts_dict[nuts][i, j] > 0:
                        DC_DE_nuts[nuts, i, j] = delta_conc_nuts[nuts, i, j] / delta_emission_nuts_dict[nuts][i, j] # only the reduced precursor emissions have to be transfered from module 2 to module 5

    # create a result netcdf 
    # -----------------------
    filename_result_cdf = path_result_cdf + 'potencies_nuts.nc'
    rootgrp = Dataset(filename_result_cdf, 'w', format='NETCDF3_CLASSIC')
    
    # create dimensions in the netcdf file
    rootgrp.createDimension('nuts_id', n_nuts)
    rootgrp.createDimension('latitude', mod2_res['n_lat'])
    rootgrp.createDimension('longitude', mod2_res['n_lon'])
    nuts_ids = rootgrp.createVariable('nuts_id', 'f4', ('nuts_id',))
    nuts_ids[:] = mod2_res['nuts_vector']
    latitudes = rootgrp.createVariable('latitude', 'f4', ('latitude',))
    latitudes.units = "degrees_north"
    longitudes = rootgrp.createVariable('longitude', 'f4', ('longitude',))
    longitudes.units = "degrees_east"
    latitudes[:] = mod2_res['latitude_array']
    longitudes[:] = mod2_res['longitude_array']

    # create potency variables data
    DC_alpha_var = rootgrp.createVariable('DC_alpha_nuts', 'f4', ('nuts_id', 'latitude', 'longitude',))
    DC_alpha_var.units = "ug/m3"
    DC_alpha_var[:] = DC_alpha_nuts
    DC_C_alpha_var = rootgrp.createVariable('DC_C_alpha_nuts', 'f4', ('nuts_id', 'latitude', 'longitude',))
    DC_C_alpha_var.units = "-"
    DC_C_alpha_var[:] = DC_C_alpha_nuts
    if delta_emission_nuts_dict.keys():
        DC_DE_var = rootgrp.createVariable('DC_DE_nuts', 'f4', ('nuts_id', 'latitude', 'longitude',))
        DC_DE_var.units = "ug/m"
        DC_DE_var[:] = DC_DE_nuts
#     delta_conc_var = rootgrp.createVariable('delta_conc_var', 'f4', ('latitude', 'longitude',))
#     delta_conc_var[:] = delta_conc
#     delta_emis_var = rootgrp.createVariable('delta_emis_var', 'f4', ('latitude', 'longitude',))
#     delta_emis_var[:] = delta_emis
    
    rootgrp.close()
    


if __name__ == '__main__':
       
    start = time()
    module5(path_emission_cdf_test, path_nuts2_cdf_test, path_reduction_txt_test, path_base_conc_cdf_test, path_model_cdf_test, path_result_cdf_test)
    stop = time()
    print('\nModule 5 calculation time = %f' % (stop - start))
    
    
    pass