% G Constant
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
axis([-0.5 25 0 10])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{c,\bar{\sigma}}\bar{E}_1/(\bar{\sigma}_{1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');

set(gca,'XTick',0:5:25);
set(gca,'XTickLabel',{'0','5','10','15','20',''})
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =1;
plot(l_delam(4:end),G_tun_c(4:end,bflag,1)*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_c(:,bflag,2)*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_c(:,bflag,3)*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_c(:,bflag,4)*E1bar/(sigma_inf_c(bflag,4)^2*h1),':b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_c(:,bflag,5)*E1bar/(sigma_inf_c(bflag,5)^2*h1),':b','LineWidth', 3.5,'Color', [0 75 135]/255)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);


 tt = text(19.1,6.5,['$G_{c,\bar{\sigma}} = {G}_{ss,\bar{\sigma}}$'],'Interpreter','latex');
tt.FontSize = 15;
 x = [4.1/5 4.3/5 ];
y = [0.64 0.59];

annotation('textarrow',x,y,'String',' ')

% Steady state energy

plot(l_inf,G_ss_const(bflag,1)*[1 1]*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,2)*[1 1]*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,3)*[1 1]*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,4)*[1 1]*E1bar/(sigma_inf_c(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,5)*[1 1]*E1bar/(sigma_inf_c(bflag,5)^2*h1),':k','LineWidth', 3.5,'Color', [0 169 224]/255)
% 
export_fig(['G_tun_constant_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% G delam, constant part
 
l_inf = [4.5, 5];

figure
 axis([-0.1 5 0 10])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{d,\bar{\sigma}}\bar{E}_1/(\bar{\sigma}_{1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
set(gca,'XTick',0:1:5);
set(gca,'XTickLabel',{'0','1','2','3','4',''})
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =1;
% plot(l_delam,G_tun_c(:,bflag,1),'-k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,2),'--k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,3),'-.k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,4),':k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,5),'-ok','LineWidth', 2)
plot(l_delam(1:17),G_d_c(1:17,bflag,1)*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:17),G_d_c(1:17,bflag,2)*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:17),G_d_c(1:17,bflag,3)*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0 75 135]/255)
plot([0,l_delam(1:17)],[0;G_d_c(1:17,bflag,4)*E1bar/(sigma_inf_c(bflag,4)^2*h1)],':k','LineWidth', 2,'Color', [0 75 135]/255)
plot([0,l_delam(1:17)],[0;G_d_c(1:17,bflag,5)*E1bar/(sigma_inf_c(bflag,5)^2*h1)],':k','LineWidth', 3.5,'Color', [0 75 135]/255)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northwest', ...
 'FontSize', 15);

% plot(l_delam,G_d_c(:,bflag,1),'-r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,2),'--r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,3),'-.r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,4),':r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,5),'-or','LineWidth', 2)

 tt = text(3.75,6.5,['$G_{d,\bar{\sigma}} = {G}_{ss,\bar{\sigma}}$'],'Interpreter','latex');
tt.FontSize = 15;
    x = [4/5 4.2/5 ];
y = [0.64 0.59];

annotation('textarrow',x,y,'String',' ')

%set(tt,'Rotation',90)
% Steady state energy



plot(l_inf,G_ss_const(bflag,1)*[1 1]*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,2)*[1 1]*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,3)*[1 1]*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,4)*[1 1]*E1bar/(sigma_inf_c(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,5)*[1 1]*E1bar/(sigma_inf_c(bflag,5)^2*h1),':','LineWidth', 3.5,'Color', [0 169 224]/255)

% 
export_fig(['G_d_constant_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% G delam, constant part
 
l_inf = [1.125, 1.25];

figure
 axis([-0.1 1.25 0 10])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{d,\bar{\sigma}}\bar{E}_1/(\bar{\sigma}_{1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
set(gca,'XTick',0:0.25:1);
set(gca,'XTickLabel',{'0','0.25','0.5','0.75','1',''})
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =1;
% plot(l_delam,G_tun_c(:,bflag,1),'-k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,2),'--k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,3),'-.k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,4),':k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,5),'-ok','LineWidth', 2)
plot(l_delam(1:13),G_d_c(1:13,bflag,1)*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:13),G_d_c(1:13,bflag,2)*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:13),G_d_c(1:13,bflag,3)*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0 75 135]/255)
plot([0,l_delam(1:13)],[0;G_d_c(1:13,bflag,4)*E1bar/(sigma_inf_c(bflag,4)^2*h1)],':k','LineWidth', 2,'Color', [0 75 135]/255)
plot([0,l_delam(1:13)],[0;G_d_c(1:13,bflag,5)*E1bar/(sigma_inf_c(bflag,5)^2*h1)],':k','LineWidth', 3.5,'Color', [0 75 135]/255)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);

% plot(l_delam,G_d_c(:,bflag,1),'-r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,2),'--r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,3),'-.r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,4),':r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,5),'-or','LineWidth', 2)

 tt = text(0.9,4.3,['$G_{d,\bar{\sigma}} = {G}_{ss,\bar{\sigma}}$'],'Interpreter','latex');
tt.FontSize = 15;
    x = [4/5 4.2/5 ];
y = [0.51 0.57];

annotation('textarrow',x,y,'String',' ')

%set(tt,'Rotation',90)
% Steady state energy



plot(l_inf,G_ss_const(bflag,1)*[1 1]*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,2)*[1 1]*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,3)*[1 1]*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,4)*[1 1]*E1bar/(sigma_inf_c(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_const(bflag,5)*[1 1]*E1bar/(sigma_inf_c(bflag,5)^2*h1),':','LineWidth', 3.5,'Color', [0 169 224]/255)

% 
export_fig(['G_d_constant_',h_Fl],'-jpg','-eps', '-r300', '-transparent')


 %export_fig(['G_tun',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
%%
% G tunnelling, linear part
 
l_inf = [22.5, 25];

figure
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{c,\Sigma}\bar{E}_1/(\Sigma^2_1 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
set(gca,'XTick',0:5:25);
set(gca,'XTickLabel',{'0','5','10','15','20',''})



bflag =4;
if bflag ==1
    axis([-.50 25 0.1 1000])

    set(gca, 'YScale', 'log')

plot(l_delam,G_tun_l(:,bflag,1)*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-b','LineWidth', 2,'Color', [0 75 135]/255)
%plot(l_delam,G_tun_l(:,bflag,1)*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2)
plot(l_delam,G_tun_l(:,bflag,2)*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_l(:,bflag,3)*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_l(:,bflag,4)*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':b','LineWidth', 2,'Color', [0 75 135]/255)
%plot(l_delam,G_tun_l(:,bflag,5)*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5)
%plot(l_delam,f_tun_l(:,bflag,5)/(2*E1bar)*h1^2,':k','LineWidth', 3.5)
lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);
    
elseif bflag ==4
        axis([-.50 25 0 12])
set(gca,'YTick',0:2:12);

 %   plot(l_delam,G_tun_l(:,bflag,1)*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2)
%plot(l_delam,G_tun_l(:,bflag,1)*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2)
plot(l_delam,G_tun_l(:,bflag,2)*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_l(:,bflag,3)*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_l(:,bflag,4)*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam,G_tun_l(:,bflag,5)*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':b','LineWidth', 3.5,'Color', [0 75 135]/255)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);
end
% plot(l_delam,G_d_l(:,bflag,1)*E1bar/(SIGMA^2*h1),'-r','LineWidth', 2)
% plot(l_delam,G_d_l(:,bflag,2)*E1bar/(SIGMA^2*h1),'--r','LineWidth', 2)
% plot(l_delam,G_d_l(:,bflag,3)*E1bar/(SIGMA^2*h1),'-.r','LineWidth', 2)
% plot(l_delam,G_d_l(:,bflag,4)*E1bar/(SIGMA^2*h1),':r','LineWidth', 2)
% plot(l_delam,G_d_l(:,bflag,5)*E1bar/(SIGMA^2*h1),'--r','LineWidth', 2)


if bflag == 1
  x = [20.2/25 21.2/25 ];
y = [0.650 0.6];
 tt = text(18.5,44,['$G_{c,{\Sigma}} = {G}_{ss,\Sigma}$'],'Interpreter','latex');
tt.FontSize = 15;
annotation('textarrow',x,y,'String',' ')
elseif bflag == 4
    x = [20.1/25 21.1/25 ];
y = [0.595 0.545];
 tt = text(18.9,7,['$G_{c,{\Sigma}} = {G}_{ss,\Sigma}$'],'Interpreter','latex');

tt.FontSize = 15;
annotation('textarrow',x,y,'String',' ')
end

if bflag==1
    plot(l_inf,G_ss_lin(bflag,1)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,2)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,3)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,4)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':','LineWidth', 2,'Color', [0 169 224]/255)
% plot(l_inf,G_ss_lin(bflag,1)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
% plot(l_inf,G_ss_lin(bflag,2)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
% plot(l_inf,G_ss_lin(bflag,3)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
% plot(l_inf,G_ss_lin(bflag,4)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss_lin(bflag,5)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5,'Color', [0 75/255 135/255])
elseif bflag==4
%    plot(l_inf,G_ss_lin(bflag,1)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
    %plot(l_inf,G_ss_lin(bflag,1)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,2)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,3)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,4)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':','LineWidth', 2,'Color', [0 169 224]/255)

plot(l_inf,G_ss_lin(bflag,4)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':','LineWidth', 3.5,'Color', [0 169 224]/255)
%set(tt,'Rotation',90)
end
% Steady state energy



export_fig(['G_tun_purelylinear_beta',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
 
 %%
% G del, linear part
 
l_inf = [1.125, 1.25];

figure
 %axis([0 5 0 0.12])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{d,\Sigma}\bar{E}_1/(\Sigma^2_1 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.0:.025:0.075);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
set(gca,'XTick',0:.25:1.25);
set(gca,'XTickLabel',{'0','0.25','0.5','0.75','1',''})

bflag =4;
% plot(l_delam,G_tun_l(:,bflag,1)*E1bar/(SIGMA^2*h1),'-k','LineWidth', 2)
% plot(l_delam,G_tun_l(:,bflag,2)*E1bar/(SIGMA^2*h1),'--k','LineWidth', 2)
% plot(l_delam,G_tun_l(:,bflag,3)*E1bar/(SIGMA^2*h1),'-.k','LineWidth', 2)
% plot(l_delam,G_tun_l(:,bflag,4)*E1bar/(SIGMA^2*h1),':k','LineWidth', 2)
% plot(l_delam,G_tun_l(:,bflag,5)*E1bar/(SIGMA^2*h1),':k','LineWidth', 3.5)
if bflag ==1
    set(gca, 'YScale', 'log')

     axis([-.10 1.25 0.1 1000])

plot(l_delam(1:17),G_d_l(1:17,bflag,1)*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:17),G_d_l(1:17,bflag,2)*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:17),G_d_l(1:17,bflag,3)*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:17),G_d_l(1:17,bflag,4)*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':b','LineWidth', 2,'Color', [0 75 135]/255)
%plot(l_delam(1:17),G_d_l(1:17,bflag,5)*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);
elseif bflag ==4
         axis([-0.1 1.25 0 12])
set(gca,'YTick',0:2:12);

 %   plot(l_delam(1:17),G_d_l(1:17,bflag,1)*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2)
plot(l_delam(1:13),G_d_l(1:13,bflag,2)*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:13),G_d_l(1:13,bflag,3)*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:13),G_d_l(1:13,bflag,4)*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':b','LineWidth', 2,'Color', [0 75 135]/255)
plot(l_delam(1:13),G_d_l(1:13,bflag,5)*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':b','LineWidth', 3.5,'Color', [0 75 135]/255)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);
end

% Steady state energy

if bflag==1
plot(l_inf,G_ss_lin(bflag,1)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,2)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,3)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,4)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0 169 224]/255)
%plot(l_inf,G_ss_lin(bflag,5)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5,'Color', [0 169 224]/255)
elseif bflag==4
%    plot(l_inf,G_ss_lin(bflag,1)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,2)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,3)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,4)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss_lin(bflag,5)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5,'Color', [0 169 224]/255)
end

if bflag == 1
  x = [20.2/25 21.2/25 ];
y = [0.65 0.6];
 tt = text(3.7,44,['$G_{d,{\Sigma}} = {G}_{ss,\Sigma}$'],'Interpreter','latex');
tt.FontSize = 15;
annotation('textarrow',x,y,'String',' ')
elseif bflag == 4
    x = [20.1/25 21.1/25 ];
y = [0.595 0.545];
 tt = text(0.9,7,['$G_{d,{\Sigma}} = {G}_{ss,\Sigma}$'],'Interpreter','latex');
tt.FontSize = 15;
annotation('textarrow',x,y,'String',' ')
end

 export_fig(['G_del_purelylinear_beta',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
 
 %%
% G tunnelling, cross term
 
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{t,\bar{\sigma}\Sigma}\bar{E}_1/(\bar{\sigma}_{1}\Sigma_1 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =4;
plot(l_delam,G_tun_cl(:,bflag,1)*E1bar/(sigma_inf_c(bflag,1)*SIGMA*h1),'-k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,2)*E1bar/(sigma_inf_c(bflag,2)*SIGMA*h1),'--k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,3)*E1bar/(sigma_inf_c(bflag,3)*SIGMA*h1),'-.k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,4)*E1bar/(sigma_inf_c(bflag,4)*SIGMA*h1),':k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,5)*E1bar/(sigma_inf_c(bflag,5)*SIGMA*h1),':k','LineWidth', 3.5)


lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
 'FontSize', 15);


% plot(l_delam,G_d_cl(:,bflag,1)*E1bar/(sigma_inf_c(bflag,1)*SIGMA*h1),'-r','LineWidth', 2)
% plot(l_delam,G_d_cl(:,bflag,2)*E1bar/(sigma_inf_c(bflag,2)*SIGMA*h1),'--r','LineWidth', 2)
% plot(l_delam,G_d_cl(:,bflag,3)*E1bar/(sigma_inf_c(bflag,3)*SIGMA*h1),'-.r','LineWidth', 2)
% plot(l_delam,G_d_cl(:,bflag,4)*E1bar/(sigma_inf_c(bflag,4)*SIGMA*h1),':r','LineWidth', 2)
% plot(l_delam,G_d_cl(:,bflag,5)*E1bar/(sigma_inf_c(bflag,5)*SIGMA*h1),':r','LineWidth', 3.5)

 tt = text(4.6,2.6,['$G_{d,\bar{\sigma}} = {G}_{ss}$'],'Interpreter','latex');
tt.FontSize = 15;
set(tt,'Rotation',90)

plot(l_inf,(G_ss_constlin(bflag,1))*E1bar/(sigma_inf_c(bflag,1)*SIGMA*h1)*[1 1],'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,(G_ss_constlin(bflag,2))*E1bar/(sigma_inf_c(bflag,2)*SIGMA*h1)*[1 1],'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,(G_ss_constlin(bflag,3))*E1bar/(sigma_inf_c(bflag,3)*SIGMA*h1)*[1 1],'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,(G_ss_constlin(bflag,4))*E1bar/(sigma_inf_c(bflag,4)*SIGMA*h1)*[1 1],':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,(G_ss_constlin(bflag,5))*E1bar/(sigma_inf_c(bflag,5)*SIGMA*h1)*[1 1],':k','LineWidth', 3.5,'Color', [0 169 224]/255)


% export_fig(['G_cross_',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

 %export_fig(['G_cross_',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% G tunnelling, cross term
 
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{\sigma\Sigma}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =4;
plot(l_delam,G_tun_cl(:,bflag,1),'-k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,2),'--k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,3),'-.k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,4),':k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,5),':k','LineWidth', 3.5)


lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
 'FontSize', 15);


plot(l_delam,G_d_cl(:,bflag,1),'-r','LineWidth', 2)
plot(l_delam,G_d_cl(:,bflag,2),'--r','LineWidth', 2)
plot(l_delam,G_d_cl(:,bflag,3),'-.r','LineWidth', 2)
plot(l_delam,G_d_cl(:,bflag,4),':r','LineWidth', 2)
plot(l_delam,G_d_cl(:,bflag,5),':r','LineWidth', 3.5)



plot(l_inf,(G_ss_constlin(bflag,1))*[1 1],'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,(G_ss_constlin(bflag,2))*[1 1],'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,(G_ss_constlin(bflag,3))*[1 1],'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,(G_ss_constlin(bflag,4))*[1 1],':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,(G_ss_constlin(bflag,5))*[1 1],':k','LineWidth', 3.5,'Color', [0 169 224]/255)


 export_fig(['G_cross_nonnorm',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

 %export_fig(['G_cross_',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')
%%
% G tunnelling, total
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{tun}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =4;
plot(l_delam,G_tun(:,bflag,1),'-k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,2),'--k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,3),'-.k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,4),':k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,5),'-ok','LineWidth', 2)

plot(l_delam,G_d(:,bflag,1),'-r','LineWidth', 2)
plot(l_delam,G_d(:,bflag,2),'--r','LineWidth', 2)
plot(l_delam,G_d(:,bflag,3),'-.r','LineWidth', 2)
plot(l_delam,G_d(:,bflag,4),':r','LineWidth', 2)
plot(l_delam,G_d(:,bflag,5),'-or','LineWidth', 2)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);


% Steady state energy

plot(l_inf,G_ss(bflag,1)*[1 1],'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,2)*[1 1],'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,3)*[1 1],'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,4)*[1 1],':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,5)*[1 1],'-ok','LineWidth', 2,'Color', [0 169 224]/255)


 %export_fig(['G_tun',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
  %% 



l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{d}\bar{E}_1/(\sigma_{inf,1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag = 1;
% plot(l_delam,G_d(:,bflag,1)*E1bar/(sigma_inf(bflag,1)^2*h1),'-k','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,2)*E1bar/(sigma_inf(bflag,2)^2*h1),'--k','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,3)*E1bar/(sigma_inf(bflag,3)^2*h1),'-.k','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,4)*E1bar/(sigma_inf(bflag,4)^2*h1),':k','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,5)*E1bar/(sigma_inf(bflag,5)^2*h1),'-k','LineWidth', 2)

plot(l_delam,G_d(:,bflag,1),'-k','LineWidth', 2)
plot(l_delam,G_d(:,bflag,2),'--k','LineWidth', 2)
plot(l_delam,G_d(:,bflag,3),'-.k','LineWidth', 2)
plot(l_delam,G_d(:,bflag,4),':k','LineWidth', 2)
plot(l_delam,G_d(:,bflag,5),'-ok','LineWidth', 2)
% arrows(3.5,7.1,2,-135,[0.2,0.2,0.15,0.01])
% tt = text(3.8,7.3,'$\bar{E}_2/\bar{E}_1 = 0.1$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% arrows(2.7,3.7,2,-135,[0.2,0.2,0.15,0.01])
% tt = text(3,3.9,'$\bar{E}_2/\bar{E}_1 = 0.3$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% arrows(3.7,2.5,2,-135,[0.2,0.2,0.15,0.01])
% tt = text(4,2.7,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast');

% arrows(4.7,1.35,1,-135,[0.4,0.4,0.3,0.02])
% tt = text(5,1.35,'$\bar{E}_2/\bar{E}_1 = 3$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% 
% arrows(12.7,1.25,1,-135,[0.4,0.4,0.3,0.02])
% tt = text(13,1.35,'$\bar{E}_2/\bar{E}_1 = 10$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% % Steady state energy

 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
          '$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast',...
          'FontSize', 15)

plot(l_inf,G_ss(bflag,1)*E1bar/(sigma_inf(bflag,1)^2*h1)*[1 1],'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,2)*E1bar/(sigma_inf(bflag,2)^2*h1)*[1 1],'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,3)*E1bar/(sigma_inf(bflag,3)^2*h1)*[1 1],'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,4)*E1bar/(sigma_inf(bflag,4)^2*h1)*[1 1],':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,5)*E1bar/(sigma_inf(bflag,5)^2*h1)*[1 1],'-k','LineWidth', 2,'Color', [0 169 224]/255)

 %export_fig(['G_d',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%

% G tunnelling
 
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{tun}\bar{E}_1/(\sigma_{inf,1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =2;
plot(l_delam,G_tun(:,bflag,1)*E1bar/(sigma_inf_av(bflag,1)^2*h1),'-k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,2)*E1bar/(sigma_inf_av(bflag,2)^2*h1),'--k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,3)*E1bar/(sigma_inf_av(bflag,3)^2*h1),'-.k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,4)*E1bar/(sigma_inf_av(bflag,4)^2*h1),':k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,5)*E1bar/(sigma_inf_av(bflag,5)^2*h1),'-k','LineWidth', 2)



% arrows(3.6,7.5,2,-135,[0.2,0.2,0.15,0.015], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(3.9,7.6,'$\bar{E}_2/\bar{E}_1 = 0.1$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% arrows(2.9,4,2,-135,[0.2,0.2,0.15,0.015],'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(3.2,4.2,'$\bar{E}_2/\bar{E}_1 = 0.3$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% arrows(3.7,2.5,2,-135,[0.2,0.2,0.15,0.015],'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(4,2.7,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% %lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
% %'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast');
% 
% arrows(4.7,1.35,1,-135,[0.4,0.4,0.3,0.03], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(5,1.35,'$\bar{E}_2/\bar{E}_1 = 3$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% 
% arrows(12.7,1.25,1,-135,[0.4,0.4,0.3,0.03], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(13,1.35,'$\bar{E}_2/\bar{E}_1 = 10$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% % Steady state energy

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);

%arrows(4.7,1.35,1,-135,[0.4,0.4,0.3,0.03], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
%tt = text(5,1.35,'$\bar{E}_2/\bar{E}_1 = 3$','Interpreter','latex');
 % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
%tt.FontSize = 15;


%arrows(12.7,1.25,1,-135,[0.4,0.4,0.3,0.03], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
%tt = text(13,1.35,'$\bar{E}_2/\bar{E}_1 = 10$','Interpreter','latex');
 % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
%tt.FontSize = 15;
% Steady state energy

plot(l_inf,G_ss(bflag,1)*E1bar/(sigma_inf_av(bflag,1)^2*h1)*[1 1],'-k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,2)*E1bar/(sigma_inf_av(bflag,2)^2*h1)*[1 1],'--k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,3)*E1bar/(sigma_inf_av(bflag,3)^2*h1)*[1 1],'-.k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,4)*E1bar/(sigma_inf_av(bflag,4)^2*h1)*[1 1],':k','LineWidth', 2,'Color', [0 169 224]/255)
plot(l_inf,G_ss(bflag,5)*E1bar/(sigma_inf_av(bflag,5)^2*h1)*[1 1],'-k','LineWidth', 2,'Color', [0 169 224]/255)


 %export_fig(['G_tun',h_Fl],'-jpg','-eps', '-r300', '-transparent')