% Steady state delamination: total stress contribution
%--------------------------------------------------------------------------

clear all 
%close all
clc

cd 'C:\Users\EBosco\Documents\MATLAB\H_shape_crack\Linear_moisture_full'
addpath 'C:\Users\EBosco\Documents\MATLAB\export_fig'
%-------------------------------------------------------------------------
% Input parameters



b2b1 =  [0.1,10];% [.1, .3, 3, 10];
E2E1 =[0.1, 0.3, 1, 3, 10];%linspace(.1,10,1001); %[1, 3, 5, 10, 100, 1000]; %linspace(.1,10,1001);%[1, 3, 5, 10, 100, 1000]1;% 
%;
h1 = 1;
h2 = linspace(1,1000,10001);%[1, 3, 5, 10, 100, 1000];
h = h1+h2;

h_Fl ='h2_1';
E1 = 1;
E2 = E1*E2E1;
nu1 = 0.3;
nu2 = 0.3;
G1 = E1/(2*(1+nu1));
G2 = E2/(2*(1+nu2));
Gdc= 1;
b1 = 1;
b2 = b1*b2b1;

DChi_1 = 1;
DChi_2 = 0;

for lh = 1:length(h2)
DChi_c(lh) = (DChi_1*h2(lh)+DChi_2*h1)/(h1+h2(lh));
DChi_l(lh) = (DChi_1-DChi_2)/(h1+h2(lh));
end
% Plane strain quantities

E1bar = E1/(1-nu1^2);
E2bar = E2/(1-nu2^2);
b1bar = b1*(1+nu1);
b2bar = b2*(1+nu2);

for lh = 1:length(h2)
DChi_c(lh) = (DChi_1*h2(lh)+DChi_2*h1)/(h1+h2(lh));
DChi_l(lh) = (DChi_1-DChi_2)/(h1+h2(lh));
end

% remote stresses
for lh = 1:length(h2)
   for i = 1:length(b2b1)
     for j = 1 :length(E2E1)  
         sigma_inf_c(lh,i,j) = E1bar*E2bar(j)*(b2bar(i)-b1bar)* h2(lh)*(DChi_1*h2(lh) + DChi_2*h1)/...
             ((E1bar*h1 + E2bar(j)*h2(lh))*(h1+h2(lh)));
         eta1(lh,i,j) = (E1bar*h1^2-E2bar(j)*(h2(lh))^2*(b2bar(i)/b1bar))/(2*(h1+h2(lh))*(E1bar*h1 + E2bar(j)*h2(lh)));
         sigma_inf_l(lh,i,j) = E1bar*b1bar*eta1(lh,i,j)*(DChi_1-DChi_2);
          eta2(lh,i,j) =  eta1(lh,i,j)*b1bar/(b2bar(i));
         sigma_inf_TOT(lh,i,j) = sigma_inf_c(lh,i,j)+sigma_inf_l(lh,i,j)*(1-h1/(eta1(lh,i,j)*(h2(lh)+h1)));
   
         
    f_ss(lh,i,j) = (1+E1bar/E2bar(j)*h1/h2(lh));
    g_ss(lh,i,j) = 1 - h1/(eta1(lh,i,j)*h(lh)) + h1^2/(3*(eta1(lh,i,j))^2*h(lh)^2)+ ...
    E2bar(j)*h2(lh)/(E1bar*h1)*(1+ h2(lh)/(eta2(lh,i,j)*h(lh)) + h2(lh)^2/(4*eta2(lh,i,j)^2*h(lh)^2));
      k_ss(lh,i,j) = -1/(2*h(lh))* (h1/eta1(lh,i,j)+h2(lh)/eta2(lh,i,j));
         % steady state energy
         
         sigma_ss(lh,i,j) = sqrt(2*Gdc*E1bar/(h1*f_ss(lh,i,j)));
         SIGMA_ss(lh,i,j) = sqrt(2*Gdc*E1bar/(h1*g_ss(lh,i,j)));

     end
   end
end


alphavec = [ 0.5 ];

for lh = 1:length(h2)
   for i = 1:length(b2b1)
     for j = 1 :length(E2E1)
         for i_al = 1: length(alphavec)


      
       sigma1bar(lh,i,j,i_al) = alphavec(i_al)*sigma_ss(lh,i,j);
       
       % Calculate the two roots; take them in absolute value
    SIGMA_ss_al_plus(lh,i,j,i_al) = abs((-2*sigma1bar(lh,i,j,i_al)*h1*k_ss(lh,i,j) ...
     + (4*sigma1bar(lh,i,j,i_al)^2*h1^2*k_ss(lh,i,j)^2 - 4*h1* g_ss(lh,i,j)*...
         (sigma1bar(lh,i,j,i_al)^2*h1* f_ss(lh,i,j) - 2*Gdc*E1bar))^0.5)/(2*h1*g_ss(lh,i,j)));
     
      SIGMA_ss_al_minus(lh,i,j,i_al) = abs((-2*sigma1bar(lh,i,j,i_al)*h1*k_ss(lh,i,j) ...
     - (4*sigma1bar(lh,i,j,i_al)^2*h1^2*k_ss(lh,i,j)^2 - 4*h1* g_ss(lh,i,j)*...
         (sigma1bar(lh,i,j,i_al)^2*h1* f_ss(lh,i,j) - 2*Gdc*E1bar))^0.5)/(2*h1*g_ss(lh,i,j)));  

     % select the minimum root
     SIGMA_ss_al_1(lh,i,j,i_al) =  min([SIGMA_ss_al_plus(lh,i,j,i_al) SIGMA_ss_al_minus(lh,i,j,i_al)]);


     
%       if (alphavec(i_al)) >= 0
% 
%      % select the minimum root
%      SIGMA_ss_al_1(lh,i,j,i_al) =  min([SIGMA_ss_al_plus(lh,i,j,i_al) SIGMA_ss_al_minus(lh,i,j,i_al)]);
%      else
%      SIGMA_ss_al_1(lh,i,j,i_al) =  max([SIGMA_ss_al_plus(lh,i,j,i_al) SIGMA_ss_al_minus(lh,i,j,i_al)]);
% 
%      end
     
     
     
     sigma_cr1(lh,i,j,i_al) = sigma1bar(lh,i,j,i_al)+SIGMA_ss_al_1(lh,i,j,i_al);
 
     sigma_SS_PLOT(j) = sigma_cr1(lh,i,j,i_al);
     sigma_cr1TOP(lh,i,j,i_al) = sigma1bar(lh,i,j,i_al)+SIGMA_ss_al_1(lh,i,j,i_al)*(1-h1/(h(lh)*eta1(lh,i,j)));
  
     
         end
     end
   end
end



%%
%%
% sigma_inf_c_beta1 = zeros(length(E2E1),length(h2));
% sigma_inf_c_beta1(:,:)=sigma_inf_c(1,:,:);
% 
% %sigma_inf_TOP_beta1 = zeros(length(E2E1),length(h2));
% %sigma_inf_TOP_beta1(:,:) = sigma_1TOP(1,:,:);
%  sigma_inf_l_beta1 = zeros(length(E2E1),length(h2));
%  sigma_inf_l_beta1(:,:)=sigma_inf_l(1,:,:);
% % 
% % sigma_inf_l_beta1TOP = zeros(length(E2E1),length(h2));
% % sigma_inf_l_beta1TOP(:,:)=SIGMA_1TOP(1,:,:);
% 
% sigma_inf_c_beta2 = zeros(length(E2E1),length(h2));
% sigma_inf_c_beta2(:,:)=sigma_inf_c(2,:,:);
% %sigma_inf_TOP_beta2 = zeros(length(E2E1),length(h2));
% %sigma_inf_TOP_beta2(:,:) = sigma_1TOP(2,:,:);
% 
%  sigma_inf_l_beta2 = zeros(length(E2E1),length(h2));
%  sigma_inf_l_beta2(:,:)=sigma_inf_l(2,:,:);
% % 
% sigma_inf_l_beta2TOP = zeros(length(E2E1),length(h2));
% sigma_inf_l_beta2TOP(:,:)=SIGMA_1TOP(2,:,:);
% 
% sigma_inf_av_beta1 = 1/2*(sigma_inf_TOP_beta1+sigma_inf_c_beta1+sigma_inf_l_beta1);
% sigma_inf_av_beta2 = 1/2*(sigma_inf_TOP_beta2+sigma_inf_c_beta2+sigma_inf_l_beta2);

figure
bflag = 2;
if bflag ==1
    axis([0 1000 -1.2 .4])

    set(gca,'YTick',-1.2:.4:.4);

else
axis([0 1000 -8 12])
set(gca,'YTick',-8:4:12);

end
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
stry = ' ${{\sigma}}_{1}^\infty/(\bar{E}_1 \bar{\beta}_1\Delta {m}_1)$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-1.2:.4:.4);

set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

%SigmaDER(:) =SIGMA_1(1,2,:); 
%dSigma1 = (gradient(SigmaDER));

%sigma_DER(:) =sigmabar_1(1,1,:); 
%dsigma1 = (gradient(sigma_DER));
plot(h2,sigma_inf_c(:,bflag,1)/E1bar,'k-','LineWidth', 2,'Color', [0 75 135]/255)
%plot(h2,sigma_inf_c_beta1(2,:)/E1bar,'k:','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_inf_c(:,bflag,3)/E1bar,'k-.','LineWidth', 2,'Color', [0 75 135]/255)
%plot(h2,sigma_inf_c_beta1(4,:)/E1bar,'k--','LineWidth', 2,'Color', [0 75 135]/255)
plot(h2,sigma_inf_c(:,bflag,5)/E1bar,'k:','LineWidth', 3.5,'Color', [0 75 135]/255)

%plot(h2,0.2*sign(dSigma1),'r-','LineWidth', 2)
%plot(h2,0.2*sign(dsigma1),'r-','LineWidth', 2)

plot(h2,sigma_inf_l(:,bflag,1)/E1bar,'b-','LineWidth', 2,'Color', [0 169 224]/255)
%plot(h2,sigma_inf_l_beta1(2,:)/E1bar,'b:','LineWidth', 2,'Color', [0 169 224]/255)
plot(h2,sigma_inf_l(:,bflag,3)/E1bar,'b-.','LineWidth', 2,'Color', [0 169 224]/255)
%plot(h2,sigma_inf_l_beta1(4,:)/E1bar,'b--','LineWidth', 2,'Color', [0 169 224]/255)
plot(h2,sigma_inf_l(:,bflag,5)/E1bar,'b:','LineWidth', 3.5,'Color', [0 169 224]/255)
% 
% 
% plot(h2,sigma_inf_TOP_beta1(1,:)/E1bar,'r-','LineWidth', 2)
% plot(h2,sigma_inf_TOP_beta1(2,:)/E1bar,'r:','LineWidth', 2)
% plot(h2,sigma_inf_TOP_beta1(3,:)/E1bar,'r-.','LineWidth', 2)
% plot(h2,sigma_inf_TOP_beta1(4,:)/E1bar,'r--','LineWidth', 2)
% plot(h2,sigma_inf_TOP_beta1(5,:)/E1bar,'r:','LineWidth', 3.5)
% 
% plot(h2,sigma_inf_av_beta1(1,:)/E1bar,'k-','LineWidth', 2)
% plot(h2,sigma_inf_av_beta1(2,:)/E1bar,'k:','LineWidth', 2)
% plot(h2,sigma_inf_av_beta1(3,:)/E1bar,'k-.','LineWidth', 2)
% plot(h2,sigma_inf_av_beta1(4,:)/E1bar,'k--','LineWidth', 2)
% plot(h2,sigma_inf_av_beta1(5,:)/E1bar,'k:','LineWidth', 3.5)

% plot(h2,(sigma_inf_l_beta1(1,:)+sigma_inf_c_beta1(1,:))/E1bar,'b-','LineWidth', 2)
% plot(h2,(sigma_inf_l_beta1(2,:)+sigma_inf_c_beta1(2,:))/E1bar,'b:','LineWidth', 2)
% plot(h2,(sigma_inf_l_beta1(3,:)+sigma_inf_c_beta1(3,:))/E1bar,'b-.','LineWidth', 2)
% plot(h2,(sigma_inf_l_beta1(4,:)+sigma_inf_c_beta1(4,:))/E1bar,'b--','LineWidth', 2)
% plot(h2,(sigma_inf_l_beta1(5,:)+sigma_inf_c_beta1(5,:))/E1bar,'b:','LineWidth', 3.5)

% plot(h2,sigma_inf_c_beta1(1,:)/E1bar,'k-','LineWidth', 2)
% plot(h2,sigma_inf_c_beta1(2,:)/E1bar,'k:','LineWidth', 2)
% plot(h2,sigma_inf_c_beta1(3,:)/E1bar,'k-.','LineWidth', 2)
% plot(h2,sigma_inf_c_beta1(4,:)/E1bar,'k--','LineWidth', 2)
% plot(h2,sigma_inf_c_beta1(5,:)/E1bar,'k:','LineWidth', 3.5)

 lgd = legend({'$~\bar{\sigma}_{1}:\bar{E}_2/\bar{E}_1  = 0.1$','$\qquad \bar{E}_2/\bar{E}_1  = 1$', ...
 '$\qquad\bar{E}_2/\bar{E}_1  = 10$','$~{\Sigma}_{1}:\bar{E}_2/\bar{E}_1  = 0.1$','$\qquad~\bar{E}_2/\bar{E}_1  = 1$', ...
 '$\qquad~\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
  'FontSize', 14);
export_fig(['RemoteStress2'],'-eps', '-r300', '-transparent')


%%
% %%
% figure
% %axis([0 1000 0 3])
% width = 6;     % Width in inches
% height = 5;    % Height in inches
% posit = get(gcf, 'Position');
% set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
% set(gca, 'FontSize', 18); %<- Set properties
% %title(tit1, 'interpreter','latex');
% strx = '$h_{{2}}/h_{{1}}$';
% stry = ' ${\bar{\sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
% % subplot(1,2,1);
% % subplot(1,2,1);
% %axis equal
% %axis([0 1 -0.05 0.2])
% xlabel(strx, 'interpreter','latex');
% ylabel(stry, 'interpreter','latex');
% %set(gca,'XTick',0:25:100);
% %set(gca,'YTick',0.25:.25:1.25);
% set(gca, 'XScale', 'log')
% %set(gca,'ZTick',-0.25:.25:.25);
% hold on
% box on
% grid on
% ax = gca;
% ax.LineWidth = 1.25;
% 
% bflag = 2;
% % plot(h2,sigma_ss(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [0,191,255]/255)
% % plot(h2,sigma_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0,191,255]/255)
% % plot(h2,sigma_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0,191,255]/255)
% % plot(h2,sigma_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0,191,255]/255)
% % plot(h2,sigma_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0,191,255]/255)
% 
% 
% plot(h2,eta1(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [50,101,155]/255)
% plot(h2,eta1(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [50,101,155]/255)
% plot(h2,eta1(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [50,101,155]/255)
% plot(h2,eta1(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [50,101,155]/255)
% plot(h2,eta1(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [50,101,155]/255)
% 
% 
% 
% plot(h2,SIGMA_ss(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [0,151,25]/255)
% plot(h2,SIGMA_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0,151,25]/255)
% plot(h2,SIGMA_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0,151,25]/255)
% plot(h2,SIGMA_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0,151,25]/255)
% plot(h2,SIGMA_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0,151,25]/255)
%%

figure
%axis([0 1000 0 3])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
stry = ' ${\bar{\sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 \Gamma_{{d}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 1;

plot(h2,sigma_ss(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-k','LineWidth', 2)
%plot(h2,sigma_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0,191,255]/255)
%plot(h2,sigma_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0,191,255]/255)
%plot(h2,sigma_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0,191,255]/255)
%plot(h2,sigma_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0,191,255]/255)

plot(h2,SIGMA_ss(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),':k','LineWidth', 4)
%plot(h2,SIGMA_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0,151,25]/255)
%plot(h2,SIGMA_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0,151,25]/255)
%plot(h2,SIGMA_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0,151,25]/255)
%plot(h2,SIGMA_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0,151,25]/255)


plot(h2,sigma_cr1(:,bflag,1,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-.b','LineWidth', 2)
plot(h2,sigma_cr1(:,bflag,1,2)*(E1bar*Gdc(1)/h1)^(-0.5),'-.g','LineWidth', 2)
plot(h2,sigma_cr1(:,bflag,1,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.m','LineWidth', 2)
plot(h2,sigma_cr1(:,bflag,1,4)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2)
plot(h2,sigma_cr1(:,bflag,1,5)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2)
%plot(h2,sigma_cr1(:,bflag,1,4)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2)

% plot(h2,sigma_cr1(:,bflag,1,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-.b','LineWidth', 2)
% plot(h2,sigma_cr1(:,bflag,1,2)*(E1bar*Gdc(1)/h1)^(-0.5),'-.g','LineWidth', 2)
% plot(h2,sigma_cr1(:,bflag,1,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.m','LineWidth', 2)

%plot(h2,sigma_cr1TOP(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-.r','LineWidth', 2)

%plot(h2,sigma_cr1(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [50,101,155]/255)


%plot(h2,SIGMA_ss_al_1(:,bflag,1,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [50,101,155]/255)

%plot(h2,sigma_cr1(:,bflag,1,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.r','LineWidth', 2)
%plot(h2,SIGMA_ss_al_1(:,bflag,1,3)*(E1bar*Gdc(1)/h1)^(-0.5),'--m','LineWidth', 2)

%plot(h2,sigma_cr1TOP(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-.r','LineWidth', 2)

%plot(h2,sigma_cr1(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [50,101,155]/255)




%plot(h2,SIGMA_ss_al1(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,SIGMA_ss_al1(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 4,'Color', [50,101,155]/255)
%plot(h2,SIGMA_ss_al1(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,SIGMA_ss_al1(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 5.5,'Color', [50,101,155]/255)
%plot(h2,sigma1bar1(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-b','LineWidth', 2)

%plot(h2,sigma_cr2(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),':k','LineWidth', 2)
%plot(h2,sigma_cr2(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [255, 102, 255]/255)
%plot(h2,sigma_cr2(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [255, 102, 255]/255)
%plot(h2,sigma_cr2(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [255, 102, 255]/255)
%plot(h2,sigma_cr2(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [255, 102, 255]/255)

%plot(h2,sigma_cr3(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--k','LineWidth', 4)

%plot(h2,sigma_cr4(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-.k','LineWidth', 4)

%plot(h2,sigma_cr(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [255, 204, 0]/255)
%plot(h2,sigma_cr3(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [255, 204, 0]/255)
%plot(h2,sigma_cr3(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [255, 204, 0]/255)
%plot(h2,sigma_cr3(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [255, 204, 0]/255)

lgd = legend({'$\alpha = 1 ~( \bar{\sigma}_{ss})$','$\alpha = 0 ~ ( {\Sigma}_{ss} ) $','$\alpha = -.01$','$\alpha = -.05$', ...
'$\alpha =- 0.1 $','$\alpha =- 0.5 $','$\alpha =- 1 $'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);

%export_fig(['sigma_alpha-05_beta1'],'-jpg','-eps', '-r300', '-transparent')


%%
% Prepare for plotting as a function of E, when a single height is
% considered
bflag =2;

for kk = 1:length(E2E1)
sigma_ss_plot(kk) = sigma_ss(1,bflag,kk);
SIGMA_ss_plot(kk) = SIGMA_ss(1,bflag,kk);
sigma_cr_plot(kk,:) = sigma_cr1(1,bflag,kk,:);
%sigma_cr4_plot(kk) = sigma_cr4(1,bflag,kk);

end
figure
%axis([0 1000 0 3])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\bar{E}_{{2}}/\bar{E}_{{1}}$';
stry = ' ${{\sigma}}_{ss}^{\infty,\alpha}(0)\sqrt{h_1/(\bar{E}_1 \Gamma_{{d}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
axis([0. 10 0.0 1.5])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;



plot(E2E1,sigma_ss_plot*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [ 0 75 135]/255)
%plot(h2,sigma_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0,191,255]/255)
%plot(h2,sigma_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0,191,255]/255)
%plot(h2,sigma_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0,191,255]/255)
%plot(h2,sigma_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0,191,255]/255)


%plot(h2,SIGMA_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0,151,25]/255)
%plot(h2,SIGMA_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0,151,25]/255)
%plot(h2,SIGMA_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0,151,25]/255)
%plot(h2,SIGMA_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0,151,25]/255)


plot(E2E1,sigma_cr_plot(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [ 0 75 135]/255)
plot(E2E1,sigma_cr_plot(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [ 0 75 135]/255)
plot(E2E1,sigma_cr_plot(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [ 0 75 135]/255)
%plot(E2E1,sigma_cr_plot(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'-.r','LineWidth', 2)

%plot(h2,sigma_cr1(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,sigma_cr1(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [50,101,155]/255)


%plot(h2,SIGMA_ss_al1(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 4,'Color', [50,101,155]/255)
%plot(h2,SIGMA_ss_al1(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,SIGMA_ss_al1(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 4,'Color', [50,101,155]/255)
%plot(h2,SIGMA_ss_al1(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [50,101,155]/255)
%plot(h2,SIGMA_ss_al1(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 5.5,'Color', [50,101,155]/255)

%plot(h2,sigma_cr2(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [255, 102, 255]/255)
%plot(h2,sigma_cr2(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [255, 102, 255]/255)
%plot(h2,sigma_cr2(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [255, 102, 255]/255)
%plot(h2,sigma_cr2(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [255, 102, 255]/255)

%plot(h2,sigma_cr(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [255, 204, 0]/255)
%plot(h2,sigma_cr3(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [255, 204, 0]/255)
%plot(h2,sigma_cr3(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [255, 204, 0]/255)
%plot(h2,sigma_cr3(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [255, 204, 0]/255)
%plot(E2E1,sigma_cr4_plot*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 4,'Color', [ 0 75 135]/255)

plot(E2E1,SIGMA_ss_plot*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [ 0 75 135]/255)

% if bflag ==1
% 
%     x = [19.95/25 20.85/25 ];
% % % y = [0.17 0.60];
%  tt = text(1.9,0.85,['$\alpha$ increases'],'Interpreter','latex');
% else
%     
%     x = [14.95/25 13.85/25 ];
% y = [0.42 0.52];
%  tt = text(0.375,1.1,['$\alpha$ increases'],'Interpreter','latex');
% end
% tt.FontSize = 17;
% 
% annotation('textarrow',x,y,'String',' ') 
if bflag == 1
lgd = legend({'$\alpha = 1 ~( \bar{\sigma}_{ss})$','$\alpha = 0.9$','$\alpha = 0.7$', ...
'$\alpha = 0.5 $','$\alpha = 0 ~ ( {\Sigma}_{ss} ) $'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);

else
 lgd = legend({'$\alpha = 1 ~( \bar{\sigma}_{ss})$','$\alpha = 0.9$','$\alpha = 0.7$', ...
'$\alpha = 0.5 $','$\alpha = 0 ~ ( {\Sigma}_{ss} ) $'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);   
end


export_fig(['sigma_ss_tot_alpha_2'],'-jpg','-eps', '-r300', '-transparent')
%%

figure
axis([0 1000 0 1.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$h_{{2}}/h_{{1}}$';
%stry = ' $ {{\Sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
stry = ' $ {{\sigma}}_{ss}^{\infty,\alpha}(0)\sqrt{h_1/(\bar{E}_1 \Gamma_{{d}})}$';

% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag =2;
% plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
% plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
% plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
% plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
% plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)

% plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)
plot(h2,sigma_cr1(:,bflag,1,1)*(E1bar*Gdc/h1)^(-0.5),'-','LineWidth', 2,'Color', [ 0 75 135]/255)
plot(h2,sigma_cr1(:,bflag,2,1)*(E1bar*Gdc/h1)^(-0.5),'--','LineWidth', 2,'Color', [ 0 75 135]/255)
plot(h2,sigma_cr1(:,bflag,3,1)*(E1bar*Gdc/h1)^(-0.5),'-.','LineWidth', 2,'Color', [ 0 75 135]/255)
plot(h2,sigma_cr1(:,bflag,4,1)*(E1bar*Gdc/h1)^(-0.5),':','LineWidth', 2,'Color', [ 0 75 135]/255)
plot(h2,sigma_cr1(:,bflag,5,1)*(E1bar*Gdc/h1)^(-0.5),':','LineWidth', 3.5,'Color', [ 0 75 135]/255)

% bflag = 4;
% % plot(h2,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'k-','LineWidth', 2)
% % plot(h2,sigma_ss(:,2)*(E1bar*Gdc(1)/h1)^(-0.5),'k--','LineWidth', 2)
% % plot(h2,sigma_ss(:,3)*(E1bar*Gdc(1)/h1)^(-0.5),'k-.','LineWidth', 2)
% % plot(h2,sigma_ss(:,4)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 2)
% % plot(h2,sigma_ss(:,5)*(E1bar*Gdc(1)/h1)^(-0.5),'k:','LineWidth', 3.5)
% 
% plot(h2,SIGMA_delam_ss(:,bflag,1)*(E1bar*Gdc/h1)^(-0.5),'-k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,2)*(E1bar*Gdc/h1)^(-0.5),'--k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,3)*(E1bar*Gdc/h1)^(-0.5),'-.k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,4)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 2)
% plot(h2,SIGMA_delam_ss(:,bflag,5)*(E1bar*Gdc/h1)^(-0.5),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
 'FontSize', 15);

export_fig(['sigma_ss_tot_beta_h'],'-jpg','-eps', '-r300', '-transparent')


%%
% figure
% %axis([0 1000 0 3])
% width = 6;     % Width in inches
% height = 5;    % Height in inches
% posit = get(gcf, 'Position');
% set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
% set(gca, 'FontSize', 18); %<- Set properties
% %title(tit1, 'interpreter','latex');
% strx = '$h_{{2}}/h_{{1}}$';
% stry = ' ${\bar{\sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
% % subplot(1,2,1);
% % subplot(1,2,1);
% %axis equal
% %axis([0 1 -0.05 0.2])
% xlabel(strx, 'interpreter','latex');
% ylabel(stry, 'interpreter','latex');
% %set(gca,'XTick',0:25:100);
% %set(gca,'YTick',0.25:.25:1.25);
% set(gca, 'XScale', 'log')
% %set(gca,'ZTick',-0.25:.25:.25);
% hold on
% box on
% grid on
% ax = gca;
% ax.LineWidth = 1.25;
% 
% bflag = 2;
% plot(h2,SIGMA_ss_al1(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [50,101,155]/255)
% plot(h2,SIGMA_ss_al1(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [50,101,155]/255)
% plot(h2,SIGMA_ss_al1(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [50,101,155]/255)
% plot(h2,SIGMA_ss_al1(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [50,101,155]/255)
% plot(h2,SIGMA_ss_al1(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [50,101,155]/255)
% 
% plot(h2,sigma_ss(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [0,191,255]/255)
% plot(h2,sigma_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0,191,255]/255)
% plot(h2,sigma_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0,191,255]/255)
% plot(h2,sigma_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0,191,255]/255)
% plot(h2,sigma_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0,191,255]/255)
% 
% 
% plot(h2,SIGMA_ss(:,bflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2,'Color', [0,151,25]/255)
% plot(h2,SIGMA_ss(:,bflag,2)*(E1bar*Gdc(1)/h1)^(-0.5),'--','LineWidth', 2,'Color', [0,151,25]/255)
% plot(h2,SIGMA_ss(:,bflag,3)*(E1bar*Gdc(1)/h1)^(-0.5),'-.','LineWidth', 2,'Color', [0,151,25]/255)
% plot(h2,SIGMA_ss(:,bflag,4)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 2,'Color', [0,151,25]/255)
% plot(h2,SIGMA_ss(:,bflag,5)*(E1bar*Gdc(1)/h1)^(-0.5),':','LineWidth', 3.5,'Color', [0,151,25]/255)