clear all 
%close all
clc

addpath 'C:\Users\EBosco\Documents\MATLAB\H_shape_crack\Linear_moisture_full'
addpath 'C:\Users\EBosco\Documents\MATLAB\export_fig'


%--------------------------------------------------------------------------
% Load results

cd 'C:\Temp\H_shape\Simulations\Linear_moisture_full'

load ResultsFile_full_C1C205_h1.mat%ResultsFile_full_C1C205.mat 

%-------------------------------------------------------------------------
% Input parameters

l_delam = [0.013,0.015, 0.02, 0.05, 0.1, 0.15, 0.20, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 10.0, 20.0];

b2b1 = [ 0.1,0.3,3,10];
E2E1 = [0.1, 0.3, 1.0, 3.0, 10.0];

alpha1 = 0.5; % factor to calculate sigma tot
%b2b1 = [ 0.1, 0.3, 3,10];
%E2E1 = [0.1, 0.3, 1.0, 3.0, 10.0];

h1 = 1;
h2 = 1;
h = h1+h2;

h_Fl ='h2_1';
E1 = 1;
E2 = E1*E2E1;
nu1 = 0.3;
nu2 = 0.3;
G1 = E1/(2*(1+nu1));
G2 = E2/(2*(1+nu2));

b1 = 1;
b2 = b1*b2b1;

DChi_1 = 1;
DChi_2 = 0;

DChi_c = (DChi_1*h2+DChi_2*h1)/(h1+h2);
DChi_l = (DChi_1-DChi_2)/(h1+h2);

% Plane strain quantities

E1bar = E1/(1-nu1^2);
E2bar = E2/(1-nu2^2);
b1bar = b1*(1+nu1);
b2bar = b2*(1+nu2);

% Dundur_alpha = (E1bar -E2bar)/(E1bar+E2bar);
% Dundur_beta = 1/2*((1-2*nu2)/G2 - (1-2*nu1)/G1)/((1-nu2)/G2+(1-nu1)/G1);
% Estar = 2*(E1bar^(-1)+E2bar^(-1))^(-1);
% coefGD = (1-Dundur_beta^2)/Estar;

SIGMA = E1bar*b1bar*(DChi_1-DChi_2);

sigma_inf_c = zeros(length(b2b1),length(E2E1));
SIGMA_inf_c = zeros(length(b2b1),length(E2E1));
SIGMA_inf_c2 = zeros(length(b2b1),length(E2E1));

f_ss= zeros(length(b2b1),length(E2E1));
g_ss= zeros(length(b2b1),length(E2E1));
k_ss= zeros(length(b2b1),length(E2E1));

betastar_c = zeros(length(b2b1),length(E2E1));
betastar_l = zeros(length(b2b1),length(E2E1));
betastar_l2 = zeros(length(b2b1),length(E2E1));
gamma = zeros(length(b2b1),length(E2E1));

G_ss_const = zeros(length(b2b1),length(E2E1));
G_ss_constlin = zeros(length(b2b1),length(E2E1));
G_ss_lin = zeros(length(b2b1),length(E2E1));

kappa2 = zeros(length(b2b1),1);
kappa1 = b1bar*DChi_l;


% Normalization stresses
for i = 1:length(b2b1)
       kappa2(i) = b2bar(i)*DChi_l;
 
     for j = 1 :length(E2E1)
        betastar_c(i,j) = (E1bar*h1*b1bar+E2bar(j)*h2*b2bar(i))/((E1bar*h1+E2bar(j)*h2));
        betastar_l(i,j) = (E1bar*h1^2*b1bar-E2bar(j)*h2^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2)*(h1+h2)*b1bar);
        betastar_l2(i,j) = (E1bar*h1^2*b1bar-E2bar(j)*h2^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2)*(h1+h2)*b2bar(i));

        sigma_inf_c(i,j) = E1bar*(betastar_c(i,j) - b1bar)*DChi_c;
        SIGMA_inf_c(i,j) = SIGMA*betastar_l(i,j);  
        SIGMA_inf_c2(i,j) = E2bar(j)*(E1bar*h1^2*b1bar-E2bar(j)*h2^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2))*DChi_l;
        sigma_inf_linear1(i,j) =   SIGMA*(betastar_l(i,j)-1/2);
        G_ss_const(i,j) = 1/2* sigma_inf_c(i,j)^2*h1/E1bar*(1+E1bar/E2bar(j)*h1/h2);
        
        
          f_ss(i,j) = (1+E1bar/E2bar(j)*h1/h2);
        g_ss(i,j) = (h1^2/(3*h^2) + betastar_l(i,j)^2-betastar_l(i,j)*h1/h + ...
            E2bar(j)*b2bar(i)^2/(E1bar*b1bar^2*h1)*(h2^3/(4*h^2)+betastar_l2(i,j)^2*h2+betastar_l2(i,j)*h2^2/h))/betastar_l(i,j)^2;
      k_ss(i,j) = -1/(2*h)* (h1/betastar_l(i,j)+h2/betastar_l2(i,j));
      
        gamma(i,j) = h1^2/(3*h^2) + betastar_l(i,j)^2-betastar_l(i,j)*h1/h + ...
            E2bar(j)*b2bar(i)^2/(E1bar*b1bar^2*h1)*(h2^3/(4*h^2)+betastar_l2(i,j)^2*h2+betastar_l2(i,j)*h2^2/h);
       
        
        G_ss_lin(i,j) = 1/2*SIGMA^2/E1bar*h1*gamma(i,j);
        
        G_ss_0(i,j) = 1/(2*E1bar)*(SIGMA_inf_c(i,j)^2*h1-SIGMA_inf_c(i,j)*E1bar*kappa1*h1^2+E1bar^2*kappa1^2*h1^3/3) + ...
        1/(2*E2bar(j))*(SIGMA_inf_c2(i,j)^2*h2+E2bar(j)*kappa2(i)*h2^2*SIGMA_inf_c2(i,j)+E2bar(j)^2*kappa2(i)^2*h2^3/3) - ...
        1/24*E2bar(j)*b2bar(i)^2*DChi_l^2*h2^3;
        %coefficiente(i,j) =  G_ss_lin0(i,j)*2*E1bar/SIGMA^2/h1;
        G_ss_constlin(i,j) = SIGMA*sigma_inf_c(i,j)/E1bar* (-h1/(2*h)+betastar_l(i,j)- (betastar_l2(i,j) ...
            +h2/(2*h))*b2bar(i)/b1bar);
     end
end



G_ss = G_ss_const + G_ss_lin + G_ss_constlin ;

% Energy and stresses

G_d_c = Gd_const;        % Delamination energy constant part
G_d_l = Gd_linear;        % Delamination energy linear part
G_d_cl = Gd_linconst;        % Delamination energy cross term part

dbar_const = -2*deltabar_const;    % Mode I opening
Dbar_const = -2*DELTAbar_const;    % Mode I opening integrated 
dbar_linear = -2*deltabar_linear;    % Mode I opening
Dbar_linear = -2*DELTAbar_linear;


G_tun_c = zeros(length(l_delam),length(b2b1),length(E2E1));
G_tun_l = zeros(length(l_delam),length(b2b1),length(E2E1));
G_tun_cl = zeros(length(l_delam),length(b2b1),length(E2E1));


f_tun_c = zeros(length(l_delam),length(b2b1),length(E2E1));
f_tun_l = zeros(length(l_delam),length(b2b1),length(E2E1));
f_tun_cl = zeros(length(l_delam),length(b2b1),length(E2E1));

fprime_del = zeros(length(l_delam),length(b2b1),length(E2E1));
fprime_del_l = zeros(length(l_delam),length(b2b1),length(E2E1));
fprime_del_cl = zeros(length(l_delam),length(b2b1),length(E2E1));

PSI_l = zeros(length(l_delam),length(b2b1),length(E2E1));
PSI_c = zeros(length(l_delam),length(b2b1),length(E2E1));


for k = 1 :length(l_delam)
    for i = 1:length(b2b1)
        for j = 1 :length(E2E1)
            % Tunnelling energy
                 
                G_tun_c(k,i,j) = 1/2*sigma_inf_c(i,j)*dbar_const(k,i,j)*h1/(h1+2*l_delam(k));
                G_tun_l(k,i,j) = 1/2*SIGMA*h1*(-Dbar_linear(k,i,j)/(h1+h2))/(h1+2*l_delam(k)) + ...
                   1/2*SIGMA*h1*(dbar_linear(k,i,j)*betastar_l(i,j))/(h1+2*l_delam(k)) ;
                G_tun_cl(k,i,j) = sigma_inf_c(i,j)*dbar_linear(k,i,j)/(h1+2*l_delam(k));% ...
                 %   - 1/2*kappa1*Dbar_const(k,i,j)/(h1+2*l_delam(k));

                    
            % Function f
                
                f_tun_c(k,i,j) =dbar_const(k,i,j)*E1bar/(h1*sigma_inf_c(i,j));
                f_tun_l(k,i,j) =(-Dbar_linear(k,i,j)/((h1+h2)*betastar_l(i,j))+dbar_linear(k,i,j))*E1bar/(h1*SIGMA*betastar_l(i,j));
                 
                f_tun_cl(k,i,j) =(-Dbar_const(k,i,j)/((h1+h2)*betastar_l(i,j))+dbar_const(k,i,j))*E1bar/(h1*sigma_inf_c(i,j));


                
            % Function fprime
             fprime_del(k,i,j) = 4*G_d_c(k,i,j)*E1bar/(h1*sigma_inf_c(i,j)^2);

             fprime_del_l(k,i,j) = 4*G_d_l(k,i,j)*E1bar/(h1*SIGMA^2*betastar_l(i,j)^2);
               
             fprime_del_cl(k,i,j) = 2*G_d_cl(k,i,j)*E1bar/(h1*SIGMA*betastar_l(i,j)*sigma_inf_c(i,j));

                
              
              
            % Mode mixity parameter
               PSI_l(k,i,j) = atan(K2_linear(k,i,j)/K1_linear(k,i,j))*180/pi;
               PSI_c(k,i,j) = atan(K2_const(k,i,j)/K1_const(k,i,j))*180/pi;

        end
    end
end

G_tun = G_tun_c + G_tun_l + G_tun_cl;

G_d = G_d_c + G_d_l + G_d_cl;

% % Stresses
% 
 GIc = 1;
 
%Gdc = GIc*[0.4375 .45 .46 .491 .492 .493];
 Gdc = GIc*[0.05, 0.1, 0.2, .5, 1,10];

sigma_tun_l = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_tun_c = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma1bar1_tun = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_tun_al = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));

sigma_del_l = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_del_c = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));

sigma1bar1_del = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_del_al = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));

sigma_TOT_tun= zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_TOT_del= zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_ss_TOT= zeros(length(b2b1),length(E2E1),length(Gdc));
sigma1bar1 = zeros(length(E2E1),length(Gdc));
sigma_ss = zeros(length(E2E1),length(Gdc));
SIGMA_delam_ss = zeros(length(b2b1),length(E2E1),length(Gdc));
SIGMA_ss_al= zeros(length(b2b1),length(E2E1),length(Gdc));


for k = 1 :length(l_delam)
    for i = 1:length(b2b1)
        for j = 1 :length(E2E1)
            for nn = 1: length(Gdc)
            sigma_tun_c(k,i,j,nn) = sqrt(2*(GIc*h1+2*Gdc(nn)*l_delam(k))*E1bar/(h1^2*f_tun_c(k,i,j)));
            sigma_tun_l(k,i,j,nn) = sqrt(2*(GIc*h1+2*Gdc(nn)*l_delam(k))*E1bar/(h1^2*f_tun_l(k,i,j))); % now to be interpreted as Sigma*eta1

            sigma_del_l(k,i,j,nn) = sqrt(4*Gdc(nn)*E1bar/(h1*fprime_del_l(k,i,j))); % now to be interpreted as Sigma*eta1
            sigma_del_c(k,i,j,nn) = sqrt(4*Gdc(nn)*E1bar/(h1*fprime_del(k,i,j)));

            % Steady state stress
           SIGMA_delam_ss(i,j,nn) =  sqrt(2*Gdc(nn)*E1bar/(h1*(gamma(i,j)/betastar_l(i,j)^2)));

            sigma_ss(j,nn) = sqrt(2*Gdc(nn)*E1bar/(h1*(1+E1bar/E2bar(j)*h1/h2)));
            
            
            % Overall stress contributions for a given applied constant
            % moisture content

     if betastar_l(i,j) > 0
       sigma1bar1(j,nn) = -alpha1*sigma_ss(j,nn);

        SIGMA_ss_al(i,j,nn) = (-2*sigma1bar1(j,nn)*h1*k_ss(i,j) ...
        + (4*sigma1bar1(j,nn)^2*h1^2*k_ss(i,j)^2 - 4*h1* g_ss(i,j)*...
         (sigma1bar1(j,nn)^2*h1* f_ss(i,j) - 2*Gdc(nn)*E1bar))^0.5)/(2*h1*g_ss(i,j));
     sigma_ss_TOT(i,j,nn) = -sigma1bar1(j,nn)+SIGMA_ss_al(i,j,nn);
        
        sigma1bar1_tun(k,i,j,nn) = -alpha1*sigma_tun_c(k,i,j,nn);
        sigma_tun_al(k,i,j,nn) = (-2*sigma1bar1_tun(k,i,j,nn)*h1^2*f_tun_cl(k,i,j) ...
        + (4*sigma1bar1_tun(k,i,j,nn)^2*h1^4*f_tun_cl(k,i,j)^2 - 4*h1^2* f_tun_l(k,i,j)*...
         (sigma1bar1_tun(k,i,j,nn)^2*h1^2* f_tun_c(k,i,j) - 2*(GIc*h1+2*Gdc(nn)*l_delam(k))*E1bar))^0.5)/(2*h1^2*f_tun_l(k,i,j));
    
     
      sigma_TOT_tun(k,i,j,nn) = -sigma1bar1_tun(k,i,j,nn)+ sigma_tun_al(k,i,j,nn);
      
      
      sigma1bar1_del(k,i,j,nn) = -alpha1*sigma_del_c(k,i,j,nn);
        sigma_del_al(k,i,j,nn) = (-2*sigma1bar1_del(k,i,j,nn)*h1*fprime_del_cl(k,i,j) ...
        + (4*sigma1bar1_del(k,i,j,nn)^2*h1^2*fprime_del_cl(k,i,j)^2 - 4*h1* fprime_del_l(k,i,j)*...
         (sigma1bar1_del(k,i,j,nn)^2*h1* fprime_del(k,i,j) - 4*Gdc(nn)*E1bar))^0.5)/(2*h1*fprime_del_l(k,i,j));
    
     
      sigma_TOT_del(k,i,j,nn) = -sigma1bar1_del(k,i,j,nn)+ sigma_del_al(k,i,j,nn);

     
     % accept solution only with plus :-)
    else
      sigma1bar1(j,nn) = alpha1*sigma_ss(j,nn);
    
      SIGMA_ss_al(i,j,nn) = (-2*sigma1bar1(j,nn)*h1*k_ss(i,j) ...
      + (4*sigma1bar1(j,nn)^2*h1^2*k_ss(i,j)^2 - 4*h1* g_ss(i,j)*...
      (sigma1bar1(j,nn)^2*h1* f_ss(i,j) - 2*Gdc(nn)*E1bar))^0.5)/(2*h1*g_ss(i,j));
     sigma_ss_TOT(i,j,nn) = sigma1bar1(j,nn)+SIGMA_ss_al(i,j,nn);
     
       sigma1bar1_tun(k,i,j,nn) = alpha1*sigma_tun_c(k,i,j,nn);
        sigma_tun_al(k,i,j,nn) = (-2*sigma1bar1_tun(k,i,j,nn)*h1^2*f_tun_cl(k,i,j) ...
        + (4*sigma1bar1_tun(k,i,j,nn)^2*h1^4*f_tun_cl(k,i,j)^2 - 4*h1^2* f_tun_l(k,i,j)*...
         (sigma1bar1_tun(k,i,j,nn)^2*h1^2* f_tun_c(k,i,j) - 2*(GIc*h1+2*Gdc(nn)*l_delam(k))*E1bar))^0.5)/(2*h1^2*f_tun_l(k,i,j));
    
     
      sigma_TOT_tun(k,i,j,nn) = sigma1bar1_tun(k,i,j,nn)+ sigma_tun_al(k,i,j,nn);
      
      sigma1bar1_del(k,i,j,nn) = alpha1*sigma_del_c(k,i,j,nn);
        sigma_del_al(k,i,j,nn) = (-2*sigma1bar1_del(k,i,j,nn)*h1*fprime_del_cl(k,i,j) ...
        + (4*sigma1bar1_del(k,i,j,nn)^2*h1^2*fprime_del_cl(k,i,j)^2 - 4*h1* fprime_del_l(k,i,j)*...
         (sigma1bar1_del(k,i,j,nn)^2*h1* fprime_del(k,i,j) - 4*Gdc(nn)*E1bar))^0.5)/(2*h1*fprime_del_l(k,i,j));
    
     
      sigma_TOT_del(k,i,j,nn) =sigma1bar1_del(k,i,j,nn)+ sigma_del_al(k,i,j,nn);          
    end
            
            
            %sigma_ss_TOT(i,j,nn) = sigma_ss(j,nn)+ SIGMA_delam_ss(i,j,nn);
            
            
            end
        end
    end
end


% sigma_tun = sigma_tun_c + sigma_tun_l;




cd 'C:\Users\EBosco\Documents\MATLAB\H_shape_crack\Linear_moisture_full'

%% Construction of failure Mechanisms Graphs
%--------------------------------------------------------------------

FailureMechanisms

%-------------------------------------------------------------

%%

% Plot stress profiles
plot_Stress_h1


%%

plot_G_h1
% G tunnelling, constant part
 

 %%

 %%


 %%
 



 
 
 
 %%
 % Mode mixity parameter
 
 PSI_c(4,bflag,1) = -65;
  PSI_c(5,bflag,1) = -65.1;

 
figure
axis([0 1 30 90])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $\Psi_{\bar{\sigma}}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
set(gca,'XTick',0:.25:1);
set(gca,'YTick',30:(15):(90));
%set(gca,'ZTick',-0.25:.25:.25);
%yticks([-1 -0.8 -0.2 0 0.2 0.8 1])
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 4;
 %title(['Effective stiffness as a function of the coverage'])
  %title(['Effective stiffness as a function of the coverage'])
 plot(l_delam,-PSI_c(:,bflag,1),'-k','LineWidth', 2, 'MarkerSize',4,'Color', [0 75 135]/255 )
 plot(l_delam,-PSI_c(:,bflag,2),'--k','LineWidth', 2, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 plot(l_delam,-PSI_c(:,bflag,3),'-.k','LineWidth', 2, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 plot(l_delam,-PSI_c(:,bflag,4),':k','LineWidth', 2, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 plot(l_delam,-PSI_c(:,bflag,5),':k','LineWidth', 3.5, 'MarkerSize',4,'Color', [0 75 135]/255 )
 
 
 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
'FontSize', 15);


 
export_fig(['Psi_const',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
 %%
  %%
 % Mode mixity parameter
 figure
 

width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $\Psi_{\Sigma}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
set(gca,'XTick',0:.25:1);
%
%set(gca,'ZTick',-0.25:.25:.25);
%yticks([-1 -0.8 -0.2 0 0.2 0.8 1])
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 4;
if bflag == 1

axis([0 2 -20 40])
set(gca,'YTick',-20:(20):(40));
 %title(['Effective stiffness as a function of the coverage'])
  %title(['Effective stiffness as a function of the coverage'])
 plot(l_delam,-PSI_l(:,bflag,1),'-k','LineWidth', 2, 'MarkerSize',4,'Color', [0 75 135]/255 )
 plot(l_delam,-PSI_l(:,bflag,2),'--k','LineWidth', 2, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 plot(l_delam,-PSI_l(:,bflag,3),'-.k','LineWidth', 2, 'MarkerSize',4,'Color', [0 75 135]/255 )
 plot(l_delam,-PSI_l(:,bflag,4),':k','LineWidth', 2, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 plot(l_delam,-PSI_l(:,bflag,5),':k','LineWidth', 3.5, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
'FontSize', 15);


 
export_fig(['Psi_lin1',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 else
axis([0 1 30 90])
set(gca,'YTick',30:(15):(90));

 %title(['Effective stiffness as a function of the coverage'])
  %title(['Effective stiffness as a function of the coverage'])
 plot(l_delam,-PSI_l(:,bflag,1),'-k','LineWidth', 2, 'MarkerSize',4,'Color', [0 75 135]/255 )
 plot(l_delam,-PSI_l(:,bflag,2),'--k','LineWidth', 2, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 plot(l_delam,-PSI_l(:,bflag,3),'-.k','LineWidth', 2, 'MarkerSize',4,'Color', [0 75 135]/255 )
 plot(l_delam,-PSI_l(:,bflag,4),':k','LineWidth', 2, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 plot(l_delam,-PSI_l(:,bflag,5),':k','LineWidth', 3.5, 'MarkerSize',4 ,'Color', [0 75 135]/255)
 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'best', ...
'FontSize', 15);


 
export_fig(['Psi_lin10',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 end




%%
% Strength
figure
%axis([0 .6 0.25 1.25])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$E_{{2}}/E_{{1}}$';
stry = ' ${\bar{\sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}/ {{\Sigma}}_{ss}\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


plot(E2E1,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 3, 'Color',[0.6 0.6 0.6])

plot(E2E1,SIGMA_delam_ss(1,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-k','LineWidth', 3)
plot(E2E1,SIGMA_delam_ss(2,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--k','LineWidth', 3)
plot(E2E1,SIGMA_delam_ss(3,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-.k','LineWidth', 3)
plot(E2E1,SIGMA_delam_ss(4,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),':k','LineWidth', 3)

lgd = legend( {'$\bar{\sigma}_{ss} : \forall \bar{\beta}_{2}/\bar{\beta}_1 $','${\Sigma}_{ss}: \bar{\beta}_{2}/\bar{\beta}_1  = 0.1$','${\Sigma}_{ss}: \bar{\beta}_{2}/\bar{\beta}_1  = 0.3$','${\Sigma}_{ss}: \bar{\beta}_{2}/\bar{\beta}_1  = 3$', ...
         '${\Sigma}_{ss}: \bar{\beta}_{2}/\bar{\beta}_1  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
export_fig(['Sigma_ss',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
figure
%axis([0 .6 0.25 1.25])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\bar{E}_{{2}}/\bar{E}_{{1}}$';
stry = ' ${\sigma}_{1c,min}(0)\sqrt{h_1/(\bar{E}_1 G_{{dc}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


%plot(E2E1,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 3, 'Color',[0.6 0.6 0.6])

plot(E2E1,sigma_ss_TOT(1,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-k','LineWidth', 3,'Color', [0,0,128/255])
plot(E2E1,sigma_ss_TOT(2,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--k','LineWidth', 3,'Color', [0,0,128/255])
plot(E2E1,sigma_ss_TOT(3,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-.k','LineWidth', 3,'Color', [0,0,128/255])
plot(E2E1,sigma_ss_TOT(4,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),':k','LineWidth', 3,'Color', [0,0,128/255])

lgd = legend( {'Mech. 3, $ \bar{\beta}_{2}/\bar{\beta}_1  = 0.1$', ...
         'Mech. 3, $ \bar{\beta}_{2}/\bar{\beta}_1  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)

%lgd = legend( {'$ \bar{\beta}_{2}/\bar{\beta}_1  = 0.1$','$ \bar{\beta}_{2}/\bar{\beta}_1  = 0.3$','$ \bar{\beta}_{2}/\bar{\beta}_1  = 3$', ...
%         '$ \bar{\beta}_{2}/\bar{\beta}_1  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
%export_fig(['strength',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% Intersection point
Gdc1_STOT = 0.425; Sig1TOT =2.339;%0.4378;
Gd1S_plotTOT = linspace(0,Gdc1_STOT,51);

Sig1_plotTOT = Sig1TOT*sqrt(Gd1S_plotTOT/GIc);

Gd1S_plotTOT = [Gd1S_plotTOT, 1];
Sig1_plotTOT =[Sig1_plotTOT, Sig1_plotTOT(end)];

%
Gdc2_STOT = 0.45; Sig2TOT =2.029;%0.4378;
Gd2S_plotTOT = linspace(0,Gdc2_STOT,51);

Sig2_plotTOT = Sig2TOT*sqrt(Gd2S_plotTOT/GIc);

Gd2S_plotTOT = [Gd2S_plotTOT, 1];
Sig2_plotTOT =[Sig2_plotTOT, Sig2_plotTOT(end)];
%
Gdc3_STOT = 0.48; Sig3TOT =1.657;%0.4378;
Gd3S_plotTOT = linspace(0,Gdc3_STOT,21);

Sig3_plotTOT = Sig3TOT*sqrt(Gd3S_plotTOT/GIc);

Gd3S_plotTOT = [Gd3S_plotTOT, 1];
Sig3_plotTOT =[Sig3_plotTOT, Sig3_plotTOT(end)];
%

Gdc4_STOT = 0.495; Sig4TOT =1.447;%0.4378;
Gd4S_plotTOT = linspace(0,Gdc4_STOT,51);

Sig4_plotTOT = Sig4TOT*sqrt(Gd4S_plotTOT/GIc);

Gd4S_plotTOT = [Gd4S_plotTOT, 1];
Sig4_plotTOT =[Sig4_plotTOT, Sig4_plotTOT(end)];

%

Gdc5_STOT = 0.5; Sig5TOT =1.349;%0.4378;
Gd5S_plotTOT = linspace(0,Gdc5_STOT,51);

Sig5_plotTOT = Sig5TOT*sqrt(Gd5S_plotTOT/GIc);

Gd5S_plotTOT = [Gd5S_plotTOT, 1];
Sig5_plotTOT =[Sig5_plotTOT, Sig5_plotTOT(end)];

%
% Intersection point
Gdc1_S4TOT = 0.59; Sig14TOT =0.4387; % l/h = 0.45
%Gdc1_S4 = 0.484; Sig14 =1.764;%0.4378;

Gd1S_plot4TOT = linspace(0,Gdc1_S4TOT,101);
Sig1_plot4TOT = Sig14TOT*sqrt(Gd1S_plot4TOT/GIc);
% extra intersection points

G1_list = [ .62, .65, .67, 0.7, 0.8, 0.9, 1, 1.2, 1.5, 2 ];
sig1_list0 = [0.431, 0.4235, .4182, .411 .389 .37 .3535 0.3255 0.2941 .2569];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G1_list)
sig1_list(j) =sig1_list0(j)*sqrt(G1_list(j)/GIc);
end


Gd1S_plot4TOT = [Gd1S_plot4TOT,G1_list, 1];
Sig1_plot4TOT =[Sig1_plot4TOT, sig1_list, Sig1_plot4TOT(end)];




% Intersection point
Gdc2_S4TOT = 0.4885; Sig24TOT =1.141; % l/h = 0.4
%Gdc2_S4 = 0.45; Sig24 =1.126;

Gd2S_plot4TOT = linspace(0,Gdc2_S4TOT,101);

Sig2_plot4TOT = Sig24TOT*sqrt(Gd2S_plot4TOT/GIc);

% extra intersection points

G2_list = [  0.5, 0.55, .61, 0.65, .7, .8 ];
sig2_list0 = [1.131, 1.0845, 1.034, 1.0035, 0.9687, 0.9075];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G2_list)
sig2_list(j) =sig2_list0(j)*sqrt(G2_list(j)/GIc);
end

Gd2S_plot4TOT = [Gd2S_plot4TOT G2_list 1];
Sig2_plot4TOT =[Sig2_plot4TOT, sig2_list, Sig2_plot4TOT(end)];


% Intersection point
%Gdc3_S4 = 0.4085; Sig34 =0.7765;%0.4378;
Gdc3_S4TOT = 0.424; Sig34TOT =1.94;%0.4378; % l/h = 0.15

Gd3S_plot4TOT = linspace(0,Gdc3_S4TOT,101);

Sig3_plot4TOT = Sig34TOT*sqrt(Gd3S_plot4TOT/GIc);
% extra intersection points

G3_list = [.45, .46, .47];
sig3_list0 = [1.885, 1.865, 1.8455];
%G2_list = [0.15, 0.175, 0.2, 0.25, 0.3, .35, .4,  .5, .55, .6,  .65];
%sig2_list0 = [0.8326, 0.793, 0.76,0.706 , .659,0.6195, 0.5855, 0.53, 0.5075,0.487 ];
%0.5,, 0.785
for j =1:length(G3_list)
sig3_list(j) =sig3_list0(j)*sqrt(G3_list(j)/GIc);
end

Gd3S_plot4TOT = [Gd3S_plot4TOT G3_list 1];
Sig3_plot4TOT =[Sig3_plot4TOT, sig3_list, Sig3_plot4TOT(end)];

% Intersection point
%Gdc4_S4 = 0.4075; Sig44 =0.6239;%0.4378;
Gdc4_S4TOT = 0.415; Sig44TOT =2.424;%0.4378; % l/h = 0.15

Gd4S_plot4TOT = linspace(0,Gdc4_S4TOT,101);

Sig4_plot4TOT = Sig44TOT*sqrt(Gd4S_plot4TOT/GIc);


Gd4S_plot4TOT = [Gd4S_plot4TOT 1];
Sig4_plot4TOT =[Sig4_plot4TOT,  Sig4_plot4TOT(end)];

% Intersection point
%Gdc5_S4 = 0.419; Sig54 =0.5551;%0.4378;
Gdc5_S4TOT = 0.41; Sig54TOT =2.645;%0.4378; % l/h = 0.15

Gd5S_plot4TOT = linspace(0,Gdc5_S4TOT,101);

Sig5_plot4TOT = Sig54TOT*sqrt(Gd5S_plot4TOT/GIc);


Gd5S_plot4TOT = [Gd5S_plot4TOT 1];
Sig5_plot4TOT =[Sig5_plot4TOT,  Sig5_plot4TOT(end)];

SSS = [Sig1_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5)];
  SSS4 = [Sig1_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig3_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5)];
 %Strength


%%
 
figure
axis([0.1 10 0 1.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\bar{E}_{{2}}/\bar{E}_{{1}}$';
stry = ' ${\sigma}_{c,min}^{\infty,\alpha}(0)\sqrt{h_1/(\bar{E}_1 \Gamma_{{c}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


%plot(E2E1,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 3, 'Color',[0.6 0.6 0.6])
plot(E2E1,SSS/2,'--k','LineWidth', 2,'Color', [0 75 135]/255)
plot(E2E1(1:end),SSS4(1:end)/2,'--k','LineWidth', 2,'Color', [0 75 135]/255)

%plot(E2E1,sigma_ss_TOT(1,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--k','LineWidth', 2,'Color',  [0 169 224]/255)
%plot(E2E1,sigma_ss_TOT(2,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--k','LineWidth', 3,'Color', [0,0,128/255])
%plot(E2E1,sigma_ss_TOT(3,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-.k','LineWidth', 3,'Color', [0,0,128/255])
plot(E2E1,sigma_ss_TOT(4,:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-k','LineWidth', 2,'Color',  [0 75 135]/255)

lgd = legend( {'Mechanism 1', 'Mechanism 3'},'Interpreter','latex', 'location', 'best','FontSize', 15)

%export_fig(['strength_mech1',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
figure
axis([0.1 10 0 2.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 18); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\bar{E}_{{2}}/\bar{E}_{{1}}$';
stry = ' ${\sigma}_{1c,min}(0)\sqrt{h_1/(\bar{E}_1 G_{{c}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.25:.25:1.25);
set(gca, 'XScale', 'log')
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

 SSS = [Sig1_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plotTOT(end-1)*(E1bar*GIc/h1)^(-0.5)];
   SSS4 = [Sig1_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plot4TOT(end-1)*(E1bar*GIc/h1)^(-0.5)];
%plot(E2E1,sigma_ss(:,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 3, 'Color',[0.6 0.6 0.6])

plot(E2E1,SSS,'-k','LineWidth', 3)
plot(E2E1,SSS_beta03*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 3)
plot(E2E1(3:end),SSS_beta3*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 3)
plot(E2E1(3:end),SSS4(3:end),':k','LineWidth', 3)

lgd = legend( {'$ \bar{\beta}_{2}/\bar{\beta}_1  = 0.1$','$ \bar{\beta}_{2}/\bar{\beta}_1  = 0.3$','$ \bar{\beta}_{2}/\bar{\beta}_1  = 3$', ...
         '$ \bar{\beta}_{2}/\bar{\beta}_1  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
export_fig(['strength_mech1',h_Fl],'-jpg','-eps', '-r300', '-transparent')