clear all 
%close all
clc

addpath 'C:\Users\EBosco\Documents\MATLAB\H_shape_crack\Linear_moisture_full'
addpath 'C:\Users\EBosco\Documents\MATLAB\export_fig'

 
%--------------------------------------------------------------------------
% Load results

%cd 'C:\Temp\H_shape\Simulations\Linear_10_new' 
cd 'C:\Temp\H_shape\Simulations\Linear_moisture_full' 

%Linear_E1'

load ResultsFile_full_C1C205_h10_v2.mat % ResultsFile_h10_grad1.mat %ResultsFile_full_C1C205_h10_v2.mat %ResultsFile_h10_beta1.mat%ResultsFile_full_C1C205_h10_v2.mat
%ResultsFile_full_C1C205_h10_E1.mat%ResultsFile_full_C1C205_h10_E1.mat%ResultsFile_full_C1C205_h10_v2.mat
%ResultsFile_full_C1C205_h10.mat%ResultsFile_full_C1C205_h10_finer_3.mat%%ResultsFile_full_C1C205_h10_finer_2.mat%%

% ResultsFile_full_C1C205_h10_full4_6.mat E2E1 = 10, b2b1 = 10
% ResultsFile_full_C1C205_h10_v2.mat file complete with original mesh
%-------------------------------------------------------------------------
% Input parameters

l_delam = [0.05, 0.1, 0.15, 0.20, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 10.0, 20.0];

b2b1 =[ 0.1,0.3, 3, 10];
E2E1 =[0.1, 0.3, 1.0, 3.0, 10.0];


%b2b1 = [ 0.1, 0.3, 3,10];
%E2E1 = [0.1, 0.3, 1.0, 3.0, 10.0];

h1 = 1;
h2 = 10;
h = h1+h2;

h_Fl ='h2_10';
E1 = 1;
E2 = E1*E2E1;
nu1 = 0.3;
nu2 = 0.3;
G1 = E1/(2*(1+nu1));
G2 = E2/(2*(1+nu2));

b1 = 1;
b2 = b1*b2b1;

DChi_1 = 1;
DChi_2 = 0;

DChi_c = (DChi_1*h2+DChi_2*h1)/(h1+h2);
DChi_l = (DChi_1-DChi_2)/(h1+h2);

alpha1 = 0.5; % factor to calculate sigma tot


% Plane strain quantities

E1bar = E1/(1-nu1^2);
E2bar = E2/(1-nu2^2);
b1bar = b1*(1+nu1);
b2bar = b2*(1+nu2);

% Dundur_alpha = (E1bar -E2bar)/(E1bar+E2bar);
% Dundur_beta = 1/2*((1-2*nu2)/G2 - (1-2*nu1)/G1)/((1-nu2)/G2+(1-nu1)/G1);
% Estar = 2*(E1bar^(-1)+E2bar^(-1))^(-1);
% coefGD = (1-Dundur_beta^2)/Estar;

SIGMA = E1bar*b1bar*(DChi_1-DChi_2);

sigma_inf_c = zeros(length(b2b1),length(E2E1));
SIGMA_inf_c = zeros(length(b2b1),length(E2E1));
SIGMA_inf_c2 = zeros(length(b2b1),length(E2E1));

f_ss= zeros(length(b2b1),length(E2E1));
g_ss= zeros(length(b2b1),length(E2E1));
k_ss= zeros(length(b2b1),length(E2E1));

betastar_c = zeros(length(b2b1),length(E2E1));
betastar_l = zeros(length(b2b1),length(E2E1));
betastar_l2 = zeros(length(b2b1),length(E2E1));
gamma = zeros(length(b2b1),length(E2E1));

G_ss_const = zeros(length(b2b1),length(E2E1));
G_ss_constlin = zeros(length(b2b1),length(E2E1));
G_ss_lin = zeros(length(b2b1),length(E2E1));

kappa2 = zeros(length(b2b1),1);
kappa1 = b1bar*DChi_l;


% Normalization stresses
for i = 1:length(b2b1)
       kappa2(i) = b2bar(i)*DChi_l;
 
     for j = 1 :length(E2E1)
        betastar_c(i,j) = (E1bar*h1*b1bar+E2bar(j)*h2*b2bar(i))/((E1bar*h1+E2bar(j)*h2));
        betastar_l(i,j) = (E1bar*h1^2*b1bar-E2bar(j)*h2^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2)*(h1+h2)*b1bar);
        betastar_l2(i,j) = (E1bar*h1^2*b1bar-E2bar(j)*h2^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2)*(h1+h2)*b2bar(i));

        sigma_inf_c(i,j) = E1bar*(betastar_c(i,j) - b1bar)*DChi_c;
        SIGMA_inf_c(i,j) = SIGMA*betastar_l(i,j);  
        SIGMA_inf_c2(i,j) = E2bar(j)*(E1bar*h1^2*b1bar-E2bar(j)*h2^2*b2bar(i))/(2*(E1bar*h1+E2bar(j)*h2))*DChi_l;
        sigma_inf_linear1(i,j) =   SIGMA*(betastar_l(i,j)-1/2);
        G_ss_const(i,j) = 1/2* sigma_inf_c(i,j)^2*h1/E1bar*(1+E1bar/E2bar(j)*h1/h2);
        
        
          f_ss(i,j) = (1+E1bar/E2bar(j)*h1/h2);
        g_ss(i,j) = (h1^2/(3*h^2) + betastar_l(i,j)^2-betastar_l(i,j)*h1/h + ...
            E2bar(j)*b2bar(i)^2/(E1bar*b1bar^2*h1)*(h2^3/(4*h^2)+betastar_l2(i,j)^2*h2+betastar_l2(i,j)*h2^2/h))/betastar_l(i,j)^2;
      k_ss(i,j) = -1/(2*h)* (h1/betastar_l(i,j)+h2/betastar_l2(i,j));
      
        gamma(i,j) = h1^2/(3*h^2) + betastar_l(i,j)^2-betastar_l(i,j)*h1/h + ...
            E2bar(j)*b2bar(i)^2/(E1bar*b1bar^2*h1)*(h2^3/(4*h^2)+betastar_l2(i,j)^2*h2+betastar_l2(i,j)*h2^2/h);
       
        
        G_ss_lin(i,j) = 1/2*SIGMA^2/E1bar*h1*gamma(i,j);
        
        G_ss_0(i,j) = 1/(2*E1bar)*(SIGMA_inf_c(i,j)^2*h1-SIGMA_inf_c(i,j)*E1bar*kappa1*h1^2+E1bar^2*kappa1^2*h1^3/3) + ...
        1/(2*E2bar(j))*(SIGMA_inf_c2(i,j)^2*h2+E2bar(j)*kappa2(i)*h2^2*SIGMA_inf_c2(i,j)+E2bar(j)^2*kappa2(i)^2*h2^3/3) - ...
        1/24*E2bar(j)*b2bar(i)^2*DChi_l^2*h2^3;
        %coefficiente(i,j) =  G_ss_lin0(i,j)*2*E1bar/SIGMA^2/h1;
        G_ss_constlin(i,j) = SIGMA*sigma_inf_c(i,j)/E1bar* (-h1/(2*h)+betastar_l(i,j)- (betastar_l2(i,j) ...
            +h2/(2*h))*b2bar(i)/b1bar);
     end
end



G_ss = G_ss_const + G_ss_lin + G_ss_constlin ;

% Energy and stresses

G_d_c = Gd_const;        % Delamination energy constant part
G_d_l = Gd_linear;        % Delamination energy linear part
G_d_cl = Gd_linconst;        % Delamination energy cross term part

dbar_const = -2*deltabar_const;    % Mode I opening
Dbar_const = -2*DELTAbar_const;    % Mode I opening integrated 
dbar_linear = -2*deltabar_linear;    % Mode I opening
Dbar_linear = -2*DELTAbar_linear;


G_tun_c = zeros(length(l_delam),length(b2b1),length(E2E1));
G_tun_l = zeros(length(l_delam),length(b2b1),length(E2E1));
G_tun_cl = zeros(length(l_delam),length(b2b1),length(E2E1));


f_tun_c = zeros(length(l_delam),length(b2b1),length(E2E1));
f_tun_l = zeros(length(l_delam),length(b2b1),length(E2E1));
f_tun_cl = zeros(length(l_delam),length(b2b1),length(E2E1));

fprime_del = zeros(length(l_delam),length(b2b1),length(E2E1));
fprime_del_l = zeros(length(l_delam),length(b2b1),length(E2E1));
fprime_del_cl = zeros(length(l_delam),length(b2b1),length(E2E1));

PSI_l = zeros(length(l_delam),length(b2b1),length(E2E1));
PSI_c = zeros(length(l_delam),length(b2b1),length(E2E1));


for k = 1 :length(l_delam)
    for i = 1:length(b2b1)
        for j = 1 :length(E2E1)
            % Tunnelling energy
                 
                G_tun_c(k,i,j) = 1/2*sigma_inf_c(i,j)*dbar_const(k,i,j)*h1/(h1+2*l_delam(k));
                G_tun_l(k,i,j) = 1/2*SIGMA*h1*(-Dbar_linear(k,i,j)/(h1+h2))/(h1+2*l_delam(k)) + ...
                   1/2*SIGMA*h1*(dbar_linear(k,i,j)*betastar_l(i,j))/(h1+2*l_delam(k)) ;
                G_tun_cl(k,i,j) = sigma_inf_c(i,j)*dbar_linear(k,i,j)/(h1+2*l_delam(k));% ...
                 %   - 1/2*kappa1*Dbar_const(k,i,j)/(h1+2*l_delam(k));

                    
            % Function f
                
                f_tun_c(k,i,j) =dbar_const(k,i,j)*E1bar/(h1*sigma_inf_c(i,j));
                f_tun_l(k,i,j) =(-Dbar_linear(k,i,j)/((h1+h2)*betastar_l(i,j))+dbar_linear(k,i,j))*E1bar/(h1*SIGMA*betastar_l(i,j));
                 
                f_tun_cl(k,i,j) =(-Dbar_const(k,i,j)/((h1+h2)*betastar_l(i,j))+dbar_const(k,i,j))*E1bar/(h1*sigma_inf_c(i,j));


                
            % Function fprime
             fprime_del(k,i,j) = 4*G_d_c(k,i,j)*E1bar/(h1*sigma_inf_c(i,j)^2);

             fprime_del_l(k,i,j) = 4*G_d_l(k,i,j)*E1bar/(h1*SIGMA^2*betastar_l(i,j)^2);
               
             fprime_del_cl(k,i,j) = 2*G_d_cl(k,i,j)*E1bar/(h1*SIGMA*betastar_l(i,j)*sigma_inf_c(i,j));

                
              
              
            % Mode mixity parameter
               PSI_l(k,i,j) = atan(K2_linear(k,i,j)/K1_linear(k,i,j))*180/pi;
               PSI_c(k,i,j) = atan(K2_const(k,i,j)/K1_const(k,i,j))*180/pi;

        end
    end
end

G_tun = G_tun_c + G_tun_l + G_tun_cl;

G_d = G_d_c + G_d_l + G_d_cl;

% % Stresses
% 
 GIc = 1;
 
%Gdc = GIc*[0.096, 0.1, 0.11, 0.125 0.15 0.175];
  Gdc = GIc*[0.05, 0.1, 0.2, 0.5, 1, 10];
% Gdc = GIc*[0.05, 0.1, 0.2, 0.5, 1, 10];

sigma_tun_l = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_tun_c = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma1bar1_tun = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_tun_al = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));

sigma_del_l = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_del_c = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));

sigma1bar1_del = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_del_al = zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));

sigma_TOT_tun= zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_TOT_del= zeros(length(l_delam),length(b2b1),length(E2E1),length(Gdc));
sigma_ss_TOT= zeros(length(b2b1),length(E2E1),length(Gdc));
sigma1bar1 = zeros(length(E2E1),length(Gdc));
sigma_ss = zeros(length(E2E1),length(Gdc));
SIGMA_delam_ss = zeros(length(b2b1),length(E2E1),length(Gdc));
SIGMA_ss_al= zeros(length(b2b1),length(E2E1),length(Gdc));


for k = 1 :length(l_delam)
    for i = 1:length(b2b1)
        for j = 1 :length(E2E1)
            for nn = 1: length(Gdc)
            sigma_tun_c(k,i,j,nn) = sqrt(2*(GIc*h1+2*Gdc(nn)*l_delam(k))*E1bar/(h1^2*f_tun_c(k,i,j)));
            sigma_tun_l(k,i,j,nn) = sqrt(2*(GIc*h1+2*Gdc(nn)*l_delam(k))*E1bar/(h1^2*f_tun_l(k,i,j))); % now to be interpreted as Sigma*eta1

            sigma_del_l(k,i,j,nn) = sqrt(4*Gdc(nn)*E1bar/(h1*fprime_del_l(k,i,j))); % now to be interpreted as Sigma*eta1
            sigma_del_c(k,i,j,nn) = sqrt(4*Gdc(nn)*E1bar/(h1*fprime_del(k,i,j)));

            % Steady state stress
           SIGMA_delam_ss(i,j,nn) =  sqrt(2*Gdc(nn)*E1bar/(h1*(gamma(i,j)/betastar_l(i,j)^2)));

            sigma_ss(j,nn) = sqrt(2*Gdc(nn)*E1bar/(h1*(1+E1bar/E2bar(j)*h1/h2)));
            
            
            % Overall stress contributions for a given applied constant
            % moisture content

     if betastar_l(i,j) > 0
       sigma1bar1(j,nn) = -alpha1*sigma_ss(j,nn);

        SIGMA_ss_al(i,j,nn) = (-2*sigma1bar1(j,nn)*h1*k_ss(i,j) ...
        + (4*sigma1bar1(j,nn)^2*h1^2*k_ss(i,j)^2 - 4*h1* g_ss(i,j)*...
         (sigma1bar1(j,nn)^2*h1* f_ss(i,j) - 2*Gdc(nn)*E1bar))^0.5)/(2*h1*g_ss(i,j));
     sigma_ss_TOT(i,j,nn) = -sigma1bar1(j,nn)+SIGMA_ss_al(i,j,nn);
        
        sigma1bar1_tun(k,i,j,nn) = -alpha1*sigma_tun_c(k,i,j,nn);
        sigma_tun_al(k,i,j,nn) = (-2*sigma1bar1_tun(k,i,j,nn)*h1^2*f_tun_cl(k,i,j) ...
        + (4*sigma1bar1_tun(k,i,j,nn)^2*h1^4*f_tun_cl(k,i,j)^2 - 4*h1^2* f_tun_l(k,i,j)*...
         (sigma1bar1_tun(k,i,j,nn)^2*h1^2* f_tun_c(k,i,j) - 2*(GIc*h1+2*Gdc(nn)*l_delam(k))*E1bar))^0.5)/(2*h1^2*f_tun_l(k,i,j));
    
     
      sigma_TOT_tun(k,i,j,nn) = -sigma1bar1_tun(k,i,j,nn)+ sigma_tun_al(k,i,j,nn);
      
      
      sigma1bar1_del(k,i,j,nn) = -alpha1*sigma_del_c(k,i,j,nn);
        sigma_del_al(k,i,j,nn) = (-2*sigma1bar1_del(k,i,j,nn)*h1*fprime_del_cl(k,i,j) ...
        + (4*sigma1bar1_del(k,i,j,nn)^2*h1^2*fprime_del_cl(k,i,j)^2 - 4*h1* fprime_del_l(k,i,j)*...
         (sigma1bar1_del(k,i,j,nn)^2*h1* fprime_del(k,i,j) - 4*Gdc(nn)*E1bar))^0.5)/(2*h1*fprime_del_l(k,i,j));
    
     
      sigma_TOT_del(k,i,j,nn) = -sigma1bar1_del(k,i,j,nn)+ sigma_del_al(k,i,j,nn);

     
     % accept solution only with plus :-)
    else
      sigma1bar1(j,nn) = alpha1*sigma_ss(j,nn);
    
      SIGMA_ss_al(i,j,nn) = (-2*sigma1bar1(j,nn)*h1*k_ss(i,j) ...
      + (4*sigma1bar1(j,nn)^2*h1^2*k_ss(i,j)^2 - 4*h1* g_ss(i,j)*...
      (sigma1bar1(j,nn)^2*h1* f_ss(i,j) - 2*Gdc(nn)*E1bar))^0.5)/(2*h1*g_ss(i,j));
     sigma_ss_TOT(i,j,nn) = sigma1bar1(j,nn)+SIGMA_ss_al(i,j,nn);
     
       sigma1bar1_tun(k,i,j,nn) = alpha1*sigma_tun_c(k,i,j,nn);
        sigma_tun_al(k,i,j,nn) = (-2*sigma1bar1_tun(k,i,j,nn)*h1^2*f_tun_cl(k,i,j) ...
        + (4*sigma1bar1_tun(k,i,j,nn)^2*h1^4*f_tun_cl(k,i,j)^2 - 4*h1^2* f_tun_l(k,i,j)*...
         (sigma1bar1_tun(k,i,j,nn)^2*h1^2* f_tun_c(k,i,j) - 2*(GIc*h1+2*Gdc(nn)*l_delam(k))*E1bar))^0.5)/(2*h1^2*f_tun_l(k,i,j));
    
     
      sigma_TOT_tun(k,i,j,nn) = sigma1bar1_tun(k,i,j,nn)+ sigma_tun_al(k,i,j,nn);
      
      sigma1bar1_del(k,i,j,nn) = alpha1*sigma_del_c(k,i,j,nn);
        sigma_del_al(k,i,j,nn) = (-2*sigma1bar1_del(k,i,j,nn)*h1*fprime_del_cl(k,i,j) ...
        + (4*sigma1bar1_del(k,i,j,nn)^2*h1^2*fprime_del_cl(k,i,j)^2 - 4*h1* fprime_del_l(k,i,j)*...
         (sigma1bar1_del(k,i,j,nn)^2*h1* fprime_del(k,i,j) - 4*Gdc(nn)*E1bar))^0.5)/(2*h1*fprime_del_l(k,i,j));
    
     
      sigma_TOT_del(k,i,j,nn) =sigma1bar1_del(k,i,j,nn)+ sigma_del_al(k,i,j,nn);          
    end
            
            
            %sigma_ss_TOT(i,j,nn) = sigma_ss(j,nn)+ SIGMA_delam_ss(i,j,nn);
            
            
            end
        end
    end
end






cd 'C:\Users\EBosco\Documents\MATLAB\H_shape_crack\Linear_moisture_full'

%%
%% Construction of failure Mechanisms Graphs
%--------------------------------------------------------------------

FailureMechanisms_h10

%-------------------------------------------------------------
%%

% Plot results
%cd 'C:\Users\EBosco\Documents\MATLAB\H_shape_crack'

% prepare plotting variables
bflag = 1; Eflag= 1;

l_inf= [22.5,25];
if bflag == 1
figure

axis([0 10 7 8])

width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $\Sigma_1\sqrt{h_1/(\bar{E}_1 G_{dc})}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);

set(gca,'YTick',0:7.5:22.5);

%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

 %title(['Effective stiffness as a function of the coverage'])
 %plot(l_delam,sigma_tun(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-k','LineWidth', 2)
%  plot(l_delam,sigma_tun_c(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-m','LineWidth', 2)

  plot(l_delam,sigma_del_l(:,bflag, Eflag,5)*(E1bar*Gdc(5)/h1)^(-0.5),'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])


 plot(l_delam,sigma_tun_l(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--k','LineWidth', 3)

 plot(l_delam,sigma_tun_l(:,bflag, Eflag,2)*(E1bar*Gdc(2)/h1)^(-0.5),':k','LineWidth', 3.5)
 plot(l_delam,sigma_tun_l(:,bflag, Eflag,3)*(E1bar*Gdc(3)/h1)^(-0.5),'-.k','LineWidth', 2)
 plot(l_delam,sigma_tun_l(:,bflag, Eflag,4)*(E1bar*Gdc(4)/h1)^(-0.5),':k','LineWidth', 2)
 plot(l_delam,sigma_tun_l(:,bflag, Eflag,5)*(E1bar*Gdc(5)/h1)^(-0.5),'-k','LineWidth', 2)
 plot(l_delam,sigma_tun_l(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'--k','LineWidth', 2)
%  plot(l_delam,sigma_tun_c(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'-m','LineWidth', 2)
 %plot(l_delam,sigma_tun_l(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'-b','LineWidth', 2)
 % lgd = legend({'$G_{dC}/G_{IC}  = 0.05$','$G_{dC}/G_{IC}  = 0.1$','$G_{dC}/G_{IC}  = 0.2$', ...
  %        '$G_{dC}/G_{IC}  = 0.5$','$G_{dC}/G_{IC}  = 1$','$G_{dC}/G_{IC}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
 
      

 if Eflag==1
lgd = legend({ '${\Sigma}_{d}$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
 elseif Eflag ==3
    lgd = legend({ '${\Sigma}_{d}$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
elseif Eflag==5
 lgd = legend({ '${\Sigma}_{d}$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
 end
 
  plot(l_delam,sigma_del_l(:,bflag, Eflag,5)*(E1bar*Gdc(5)/h1)^(-0.5),'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])

     set(lgd,'location','best')

 % Sigma_steady state
if Eflag==1
  x = [20.85/25 20.85/25 ];
y = [0.50 0.45];
 tt = text(20.5,SIGMA_delam_ss(bflag,Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+1.75,['${\Sigma}_1 = {\Sigma}_{ss}$'],'Interpreter','latex');
elseif Eflag==3
  x = [20.85/25 20.85/25 ];
y = [0.41 0.36];
 tt = text(20.5,SIGMA_delam_ss(bflag,Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+1.75,['${\Sigma}_1 = {\Sigma}_{ss}$'],'Interpreter','latex');
elseif Eflag==5
  x = [20.85/25 20.85/25 ];
y = [0.37 0.32];
 tt = text(20.5,SIGMA_delam_ss(bflag,Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+1.75,['${\Sigma}_1 = {\Sigma}_{ss}$'],'Interpreter','latex');
end
tt.FontSize = 15;

annotation('textarrow',x,y,'String',' ')
  % arrows(21.5,sigma_ss(Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+0.1,.2,180,[0.5,0.5,0.2,0.1])
 % Sigma_steady state
  plot(l_inf,SIGMA_delam_ss(bflag,Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)*[1 1],'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])

elseif bflag == 4
   
    
    figure

axis([0 25 0 3])

width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $\Sigma_1\sqrt{h_1/(\bar{E}_1 G_{dc})}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);

%set(gca,'YTick',0:7.5:22.5);

%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
%grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 %plot(l_delam,sigma_tun(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-k','LineWidth', 2)
%  plot(l_delam,sigma_tun_c(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-m','LineWidth', 2)

  plot(l_delam,sigma_del_l(:,bflag, Eflag,5)*(E1bar*Gdc(5)/h1)^(-0.5),'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])


 plot(l_delam,sigma_tun_l(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--k','LineWidth', 3)

 plot(l_delam,sigma_tun_l(:,bflag, Eflag,2)*(E1bar*Gdc(2)/h1)^(-0.5),':k','LineWidth', 3.5)
 plot(l_delam,sigma_tun_l(:,bflag, Eflag,3)*(E1bar*Gdc(3)/h1)^(-0.5),'-.k','LineWidth', 2)
 plot(l_delam,sigma_tun_l(:,bflag, Eflag,4)*(E1bar*Gdc(4)/h1)^(-0.5),':k','LineWidth', 2)
 plot(l_delam,sigma_tun_l(:,bflag, Eflag,5)*(E1bar*Gdc(5)/h1)^(-0.5),'-k','LineWidth', 2)
 plot(l_delam,sigma_tun_l(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'--k','LineWidth', 2)
%  plot(l_delam,sigma_tun_c(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'-m','LineWidth', 2)
 %plot(l_delam,sigma_tun_l(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'-b','LineWidth', 2)
 % lgd = legend({'$G_{dC}/G_{IC}  = 0.05$','$G_{dC}/G_{IC}  = 0.1$','$G_{dC}/G_{IC}  = 0.2$', ...
  %        '$G_{dC}/G_{IC}  = 0.5$','$G_{dC}/G_{IC}  = 1$','$G_{dC}/G_{IC}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
 
      

 if Eflag==1
lgd = legend({ '${\Sigma}_{d}$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'southeast','FontSize', 15)
 elseif Eflag ==3
    lgd = legend({ '${\Sigma}_{d}$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
elseif Eflag==5
 lgd = legend({ '${\Sigma}_{d}$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '${\Sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 1$','${\Sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
 end
 %legend boxoff                   % Hides the legend's axes (legend border and background)
  plot(l_delam,sigma_del_l(:,bflag, Eflag,5)*(E1bar*Gdc(5)/h1)^(-0.5),'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])

 
 % Sigma_steady state
if Eflag==1
  x = [20.85/25 20.85/25 ];
y = [0.65 0.6];
 tt = text(20.5,SIGMA_delam_ss(bflag,Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+0.275,['${\Sigma}_1 = {\Sigma}_{ss}$'],'Interpreter','latex');
elseif Eflag==3
  x = [20.85/25 20.85/25 ];
y = [0.40 0.35];
 tt = text(20.5,SIGMA_delam_ss(bflag,Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+0.275,['${\Sigma}_1 = {\Sigma}_{ss}$'],'Interpreter','latex');
elseif Eflag==5
  x = [20.85/25 20.85/25 ];
y = [0.355 0.305];
 tt = text(20.5,SIGMA_delam_ss(bflag,Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+0.275,['${\Sigma}_1 = {\Sigma}_{ss}$'],'Interpreter','latex');
end
tt.FontSize = 15;

annotation('textarrow',x,y,'String',' ')
  % arrows(21.5,sigma_ss(Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+0.1,.2,180,[0.5,0.5,0.2,0.1])
 % Sigma_steady state
  plot(l_inf,SIGMA_delam_ss(bflag,Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)*[1 1],'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])
    
    set(lgd,'location','best')

end
 % tt = text(12,0.25,['$\bar{E}_2/\bar{E}_1 = $',num2str(E2E1(Eflag))],'Interpreter','latex');
%tt.FontSize = 18;
 %export_fig(['SIGMA_dtun_E',num2str(E2E1(Eflag)),'b',num2str(b2b1(bflag)),h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% G tunnelling, constant part
 
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{t,\bar{\sigma}}\bar{E}_1/(\bar{\sigma}_{1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);

hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =1;
plot(l_delam,G_tun_c(:,bflag,1)*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2)
plot(l_delam,G_tun_c(:,bflag,2)*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2)
plot(l_delam,G_tun_c(:,bflag,3)*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2)
%plot(l_delam,G_tun_c(:,bflag,4)*E1bar/(sigma_inf_c(bflag,4)^2*h1),':k','LineWidth', 2)
%plot(l_delam,G_tun_c(:,bflag,5)*E1bar/(sigma_inf_c(bflag,5)^2*h1),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);


 tt = text(19.3,1.75,['$G_{t,\bar{\sigma}} = {G}_{ss,\bar{\sigma}}$'],'Interpreter','latex');
tt.FontSize = 15;
 x = [4.1/5 4.3/5 ];
y = [0.31 0.26];

annotation('textarrow',x,y,'String',' ')

% Steady state energy

plot(l_inf,G_ss_const(bflag,1)*[1 1]*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_const(bflag,2)*[1 1]*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_const(bflag,3)*[1 1]*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss_const(bflag,4)*[1 1]*E1bar/(sigma_inf_c(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss_const(bflag,5)*[1 1]*E1bar/(sigma_inf_c(bflag,5)^2*h1),':k','LineWidth', 3.5,'Color', [0.4 0.4 0.4])
% 
% export_fig(['G_tun_constant_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% G delam, constant part
 
l_inf = [4.5, 5];

figure
% axis([0 5 0 8])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{d,\bar{\sigma}}\bar{E}_1/(\bar{\sigma}_{1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =1;
 plot(l_delam,G_tun_c(:,bflag,1),'-k','LineWidth', 2)
 plot(l_delam,G_tun_c(:,bflag,2),'--k','LineWidth', 2)
 plot(l_delam,G_tun_c(:,bflag,3),'-.k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,4),':k','LineWidth', 2)
% plot(l_delam,G_tun_c(:,bflag,5),':k','LineWidth', 3)
%plot(l_delam(1:14),G_d_c(1:14,bflag,1)*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2)
%plot(l_delam(1:14),G_d_c(1:14,bflag,2)*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2)
%plot(l_delam(1:14),G_d_c(1:14,bflag,3)*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2)
%plot(l_delam(1:14),G_d_c(1:14,bflag,4)*E1bar/(sigma_inf_c(bflag,4)^2*h1),':k','LineWidth', 2)
%plot(l_delam(1:14),G_d_c(1:14,bflag,5)*E1bar/(sigma_inf_c(bflag,5)^2*h1),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);

  plot(l_delam,G_d_c(:,bflag,1),'-r','LineWidth', 2)
  plot(l_delam,G_d_c(:,bflag,2),'--r','LineWidth', 2)
  plot(l_delam,G_d_c(:,bflag,3),'-.r','LineWidth', 2)
% plot(l_delam,G_d_c(:,bflag,4),':r','LineWidth', 2)
%  plot(l_delam,G_d_c(:,bflag,5),':r','LineWidth', 3)

tt = text(3.85,1.75,['$G_{d,\bar{\sigma}} = {G}_{ss,\bar{\sigma}}$'],'Interpreter','latex');
tt.FontSize = 15;
 x = [4.1/5 4.3/5 ];
y = [0.31 0.26];

annotation('textarrow',x,y,'String',' ')

%set(tt,'Rotation',90)
% Steady state energy

% plot(l_inf,G_ss_const(bflag,1)*[1 1],'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
% plot(l_inf,G_ss_const(bflag,2)*[1 1],'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
% plot(l_inf,G_ss_const(bflag,3)*[1 1],'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
% plot(l_inf,G_ss_const(bflag,4)*[1 1],':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
% plot(l_inf,G_ss_const(bflag,5)*[1 1],':','LineWidth', 3.5,'Color', [0.4 0.4 0.4])



%plot(l_inf,G_ss_const(bflag,1)*[1 1]*E1bar/(sigma_inf_c(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss_const(bflag,2)*[1 1]*E1bar/(sigma_inf_c(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss_const(bflag,3)*[1 1]*E1bar/(sigma_inf_c(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss_const(bflag,4)*[1 1]*E1bar/(sigma_inf_c(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss_const(bflag,5)*[1 1]*E1bar/(sigma_inf_c(bflag,5)^2*h1),':','LineWidth', 3.5,'Color', [0.4 0.4 0.4])

% 
%export_fig(['G_d_constant_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

 %export_fig(['G_tun',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
%%
% G tunnelling, linear part
 
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{t,\Sigma}\bar{E}_1/(\Sigma^2_1 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =4;
plot(l_delam,G_tun_l(:,bflag,1)*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2)
plot(l_delam,G_tun_l(:,bflag,2)*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--k','LineWidth', 2)
plot(l_delam,G_tun_l(:,bflag,3)*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.k','LineWidth', 2)
plot(l_delam,G_tun_l(:,bflag,4)*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':k','LineWidth', 2)
plot(l_delam,G_tun_l(:,bflag,5)*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5)

% plot(l_delam,G_d_l(:,bflag,1)*E1bar/(SIGMA^2*h1),'-r','LineWidth', 2)
% plot(l_delam,G_d_l(:,bflag,2)*E1bar/(SIGMA^2*h1),'--r','LineWidth', 2)
% plot(l_delam,G_d_l(:,bflag,3)*E1bar/(SIGMA^2*h1),'-.r','LineWidth', 2)
% plot(l_delam,G_d_l(:,bflag,4)*E1bar/(SIGMA^2*h1),':r','LineWidth', 2)
% plot(l_delam,G_d_l(:,bflag,5)*E1bar/(SIGMA^2*h1),'--r','LineWidth', 2)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);
if bflag == 1
  x = [20.2/25 21.2/25 ];
y = [0.5 0.45];
 tt = text(18.9,0.055,['$G_{t,{\Sigma}} = {G}_{ss,\Sigma}$'],'Interpreter','latex');
tt.FontSize = 15;
annotation('textarrow',x,y,'String',' ')
elseif bflag == 4
    x = [20.1/25 21.1/25 ];
y = [0.55 0.5];
 tt = text(18.9,4.2,['$G_{t,{\Sigma}} = {G}_{ss,\Sigma}$'],'Interpreter','latex');
tt.FontSize = 15;
annotation('textarrow',x,y,'String',' ')
end


%set(tt,'Rotation',90)
% Steady state energy

plot(l_inf,G_ss_lin(bflag,1)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_lin(bflag,2)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_lin(bflag,3)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_lin(bflag,4)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_lin(bflag,5)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5,'Color', [0.4 0.4 0.4])


 %export_fig(['G_tun_purelylinear_beta',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
 
 %%
% G del, linear part
 
l_inf = [4.5, 5];

figure
% axis([0 5 0 0.12])
 %axis([0 5 0 8])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{d,\Sigma}\bar{E}_1/(\Sigma^2_1 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',0.0:.025:0.075);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =4;
% plot(l_delam,G_tun_l(:,bflag,1)*E1bar/(SIGMA^2*h1),'-k','LineWidth', 2)
% plot(l_delam,G_tun_l(:,bflag,2)*E1bar/(SIGMA^2*h1),'--k','LineWidth', 2)
% plot(l_delam,G_tun_l(:,bflag,3)*E1bar/(SIGMA^2*h1),'-.k','LineWidth', 2)
% plot(l_delam,G_tun_l(:,bflag,4)*E1bar/(SIGMA^2*h1),':k','LineWidth', 2)
% plot(l_delam,G_tun_l(:,bflag,5)*E1bar/(SIGMA^2*h1),':k','LineWidth', 3.5)

plot(l_delam(1:14),G_d_l(1:14,bflag,1)*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2)
plot(l_delam(1:14),G_d_l(1:14,bflag,2)*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--k','LineWidth', 2)
plot(l_delam(1:14),G_d_l(1:14,bflag,3)*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.k','LineWidth', 2)
plot(l_delam(1:14),G_d_l(1:14,bflag,4)*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':k','LineWidth', 2)
plot(l_delam(1:14),G_d_l(1:14,bflag,5)*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);


% Steady state energy

plot(l_inf,G_ss_lin(bflag,1)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,1)^2*h1),'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_lin(bflag,2)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,2)^2*h1),'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_lin(bflag,3)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,3)^2*h1),'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_lin(bflag,4)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,4)^2*h1),':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss_lin(bflag,5)*[1 1]*E1bar/(SIGMA^2*betastar_l(bflag,5)^2*h1),':k','LineWidth', 3.5,'Color', [0.4 0.4 0.4])


if bflag == 1
  x = [20.2/25 21.2/25 ];
y = [0.5 0.45];
 tt = text(3.75,0.056,['$G_{d,{\Sigma}} = {G}_{ss,\Sigma}$'],'Interpreter','latex');
tt.FontSize = 15;
annotation('textarrow',x,y,'String',' ')
elseif bflag == 4
    x = [20.1/25 21.1/25 ];
y = [0.55 0.5];
 tt = text(3.75,4.25,['$G_{d,{\Sigma}} = {G}_{ss,\Sigma}$'],'Interpreter','latex');
tt.FontSize = 15;
annotation('textarrow',x,y,'String',' ')
end

% export_fig(['G_del_purelylinear_beta',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
 
 %%
% G tunnelling, cross term
 
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{t,\bar{\sigma}\Sigma}\bar{E}_1/(\bar{\sigma}_{1}\Sigma_1 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =4;
plot(l_delam,G_tun_cl(:,bflag,1)*E1bar/(sigma_inf_c(bflag,1)*SIGMA*h1),'-k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,2)*E1bar/(sigma_inf_c(bflag,2)*SIGMA*h1),'--k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,3)*E1bar/(sigma_inf_c(bflag,3)*SIGMA*h1),'-.k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,4)*E1bar/(sigma_inf_c(bflag,4)*SIGMA*h1),':k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,5)*E1bar/(sigma_inf_c(bflag,5)*SIGMA*h1),':k','LineWidth', 3.5)


lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
 'FontSize', 15);


% plot(l_delam,G_d_cl(:,bflag,1)*E1bar/(sigma_inf_c(bflag,1)*SIGMA*h1),'-r','LineWidth', 2)
% plot(l_delam,G_d_cl(:,bflag,2)*E1bar/(sigma_inf_c(bflag,2)*SIGMA*h1),'--r','LineWidth', 2)
% plot(l_delam,G_d_cl(:,bflag,3)*E1bar/(sigma_inf_c(bflag,3)*SIGMA*h1),'-.r','LineWidth', 2)
% plot(l_delam,G_d_cl(:,bflag,4)*E1bar/(sigma_inf_c(bflag,4)*SIGMA*h1),':r','LineWidth', 2)
% plot(l_delam,G_d_cl(:,bflag,5)*E1bar/(sigma_inf_c(bflag,5)*SIGMA*h1),':r','LineWidth', 3.5)

 tt = text(4.6,2.6,['$G_{d,\bar{\sigma}} = {G}_{ss}$'],'Interpreter','latex');
tt.FontSize = 15;
set(tt,'Rotation',90)

plot(l_inf,(G_ss_constlin(bflag,1))*E1bar/(sigma_inf_c(bflag,1)*SIGMA*h1)*[1 1],'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,(G_ss_constlin(bflag,2))*E1bar/(sigma_inf_c(bflag,2)*SIGMA*h1)*[1 1],'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,(G_ss_constlin(bflag,3))*E1bar/(sigma_inf_c(bflag,3)*SIGMA*h1)*[1 1],'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,(G_ss_constlin(bflag,4))*E1bar/(sigma_inf_c(bflag,4)*SIGMA*h1)*[1 1],':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,(G_ss_constlin(bflag,5))*E1bar/(sigma_inf_c(bflag,5)*SIGMA*h1)*[1 1],':k','LineWidth', 3.5,'Color', [0.4 0.4 0.4])


% export_fig(['G_cross_',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

 %export_fig(['G_cross_',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% G tunnelling, cross term
 
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{\sigma\Sigma}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =4;
plot(l_delam,G_tun_cl(:,bflag,1),'-k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,2),'--k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,3),'-.k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,4),':k','LineWidth', 2)
plot(l_delam,G_tun_cl(:,bflag,5),':k','LineWidth', 3.5)


lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
 'FontSize', 15);


plot(l_delam,G_d_cl(:,bflag,1),'-r','LineWidth', 2)
plot(l_delam,G_d_cl(:,bflag,2),'--r','LineWidth', 2)
plot(l_delam,G_d_cl(:,bflag,3),'-.r','LineWidth', 2)
plot(l_delam,G_d_cl(:,bflag,4),':r','LineWidth', 2)
plot(l_delam,G_d_cl(:,bflag,5),':r','LineWidth', 3.5)



plot(l_inf,(G_ss_constlin(bflag,1))*[1 1],'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,(G_ss_constlin(bflag,2))*[1 1],'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,(G_ss_constlin(bflag,3))*[1 1],'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,(G_ss_constlin(bflag,4))*[1 1],':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,(G_ss_constlin(bflag,5))*[1 1],':k','LineWidth', 3.5,'Color', [0.4 0.4 0.4])


 export_fig(['G_cross_nonnorm',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')

 %export_fig(['G_cross_',num2str(bflag),'_',h_Fl],'-jpg','-eps', '-r300', '-transparent')
%%
% G tunnelling, total
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{tun}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =4;
plot(l_delam,G_tun(:,bflag,1),'-r','LineWidth', 2)
%plot(l_delam,G_tun(:,bflag,2),'--r','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,3),'-.r','LineWidth', 2)
%plot(l_delam,G_tun(:,bflag,4),':r','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,5),':r','LineWidth', 3.5)

plot(l_delam,RESULTS_J(:,bflag,1),'-k','LineWidth', 2)
%plot(l_delam,RESULTS_J(:,bflag,2),'--k','LineWidth', 2)
plot(l_delam,RESULTS_J(:,bflag,3),'-.k','LineWidth', 2)
%plot(l_delam,RESULTS_J(:,bflag,4),':k','LineWidth', 2)
plot(l_delam,RESULTS_J(:,bflag,5),':k','LineWidth', 3.5)
% 
% plot(l_delam,G_d(:,bflag,1),'-r','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,2),'--r','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,3),'-.r','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,4),':r','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,5),'-or','LineWidth', 2)

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);


% Steady state energy

plot(l_inf,G_ss(bflag,1)*[1 1],'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,2)*[1 1],'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,3)*[1 1],'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss(bflag,4)*[1 1],':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
%plot(l_inf,G_ss(bflag,5)*[1 1],'-ok','LineWidth', 2,'Color', [0.4 0.4 0.4])


 export_fig(['G_tun',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 
 %%
 % Plot results
%cd 'C:\Users\EBosco\Documents\MATLAB\H_shape_crack'

% prepare plotting variables
bflag = 4;
l_inf= [22.5,25];
%sigma_tun_plot = zeros(length(l_delam),length(E2E1),length(Gdc));
%sigma_tun_plot = sigma_tun(:,bflag,:,:);

%sigma_del_plot = zeros(length(l_delam),length(E2E1),length(Gdc));
%sigma_del_plot(:,:,:) = sigma_del(:,bflag,:,:);

figure
axis([0 25 0 2.5])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties

%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $\bar{\sigma}_{1}\sqrt{h_1/(\bar{E}_1 G_{dc})}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
Eflag= 5;

 %title(['Effective stiffness as a function of the coverage'])
 %plot(l_delam,sigma_tun(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-k','LineWidth', 2)
%  plot(l_delam,sigma_tun_c(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-m','LineWidth', 2)
 plot(l_delam,sigma_del_c(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])


 plot(l_delam,sigma_tun_c(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'--k','LineWidth', 3)

 plot(l_delam,sigma_tun_c(:,bflag, Eflag,2)*(E1bar*Gdc(2)/h1)^(-0.5),':k','LineWidth', 3.5)
 plot(l_delam,sigma_tun_c(:,bflag, Eflag,3)*(E1bar*Gdc(3)/h1)^(-0.5),'-.k','LineWidth', 2)
 plot(l_delam,sigma_tun_c(:,bflag, Eflag,4)*(E1bar*Gdc(4)/h1)^(-0.5),':k','LineWidth', 2)
 plot(l_delam,sigma_tun_c(:,bflag, Eflag,5)*(E1bar*Gdc(5)/h1)^(-0.5),'-k','LineWidth', 2)
 plot(l_delam,sigma_tun_c(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'--k','LineWidth', 2)
%  plot(l_delam,sigma_tun_c(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'-m','LineWidth', 2)
 %plot(l_delam,sigma_tun_l(:,bflag, Eflag,6)*(E1bar*Gdc(6)/h1)^(-0.5),'-b','LineWidth', 2)
  
 
      
 plot(l_delam,sigma_del_c(:,bflag, Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5),'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])

 if Eflag==1
 lgd = legend({ '$\bar{\sigma}_{d}$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 1$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
 elseif Eflag ==3
      lgd = legend({ '$\bar{\sigma}_{d}$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 1$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'northeast','FontSize', 15)
elseif Eflag==5
 lgd = legend({ '$\bar{\sigma}_{d}$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.05$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.1$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.2$', ...
          '$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 0.5$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 1$','$\bar{\sigma}_{t}: G_{dc}/G_{Ic}  = 10$'},'Interpreter','latex', 'location', 'southeast','FontSize', 15)
end
 
      set(lgd,'location','best')

 % Sigma_steady state
  plot(l_inf,sigma_ss(Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)*[1 1],'-','LineWidth', 2.5,'Color',[0.6 0.6 0.6])
if Eflag==1
  x = [21/25 21/25 ];
y = [0.35 0.30];
 tt = text(21,sigma_ss(Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+0.25,['$\bar{\sigma}_1 = \bar{\sigma}_{ss}$'],'Interpreter','latex');
elseif Eflag==3
      x = [21/25 21/25 ];
y = [0.41 0.46];

 tt = text(21,sigma_ss(Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)-0.225,['$\bar{\sigma}_1 = \bar{\sigma}_{ss}$'],'Interpreter','latex');
elseif Eflag==5
  x = [21/25 21/25 ];
  y = [0.635 0.585];
 tt = text(21,sigma_ss(Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+0.25,['$\bar{\sigma}_1 = \bar{\sigma}_{ss}$'],'Interpreter','latex');
end
tt.FontSize = 15;

annotation('textarrow',x,y,'String',' ')
  % arrows(21.5,sigma_ss(Eflag,1)*(E1bar*Gdc(1)/h1)^(-0.5)+0.1,.2,180,[0.5,0.5,0.2,0.1])


   export_fig(['sigma_dtun_E',num2str(E2E1(Eflag)),h_Fl],'-jpg','-eps', '-r300', '-transparent')

 %%

 %% 



l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{d}\bar{E}_1/(\sigma_{inf,1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag = 4;
% plot(l_delam,G_d(:,bflag,1)*E1bar/(sigma_inf(bflag,1)^2*h1),'-k','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,2)*E1bar/(sigma_inf(bflag,2)^2*h1),'--k','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,3)*E1bar/(sigma_inf(bflag,3)^2*h1),'-.k','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,4)*E1bar/(sigma_inf(bflag,4)^2*h1),':k','LineWidth', 2)
% plot(l_delam,G_d(:,bflag,5)*E1bar/(sigma_inf(bflag,5)^2*h1),'-k','LineWidth', 2)

plot(l_delam,G_d(:,bflag,1),'-k','LineWidth', 2)
plot(l_delam,G_d(:,bflag,2),'--k','LineWidth', 2)
plot(l_delam,G_d(:,bflag,3),'-.k','LineWidth', 2)
plot(l_delam,G_d(:,bflag,4),':k','LineWidth', 2)
plot(l_delam,G_d(:,bflag,5),'-ok','LineWidth', 2)
% arrows(3.5,7.1,2,-135,[0.2,0.2,0.15,0.01])
% tt = text(3.8,7.3,'$\bar{E}_2/\bar{E}_1 = 0.1$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% arrows(2.7,3.7,2,-135,[0.2,0.2,0.15,0.01])
% tt = text(3,3.9,'$\bar{E}_2/\bar{E}_1 = 0.3$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% arrows(3.7,2.5,2,-135,[0.2,0.2,0.15,0.01])
% tt = text(4,2.7,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast');

% arrows(4.7,1.35,1,-135,[0.4,0.4,0.3,0.02])
% tt = text(5,1.35,'$\bar{E}_2/\bar{E}_1 = 3$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% 
% arrows(12.7,1.25,1,-135,[0.4,0.4,0.3,0.02])
% tt = text(13,1.35,'$\bar{E}_2/\bar{E}_1 = 10$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% % Steady state energy

 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
          '$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast',...
          'FontSize', 15)

plot(l_inf,G_ss(bflag,1)*E1bar/(sigma_inf(bflag,1)^2*h1)*[1 1],'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,2)*E1bar/(sigma_inf(bflag,2)^2*h1)*[1 1],'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,3)*E1bar/(sigma_inf(bflag,3)^2*h1)*[1 1],'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,4)*E1bar/(sigma_inf(bflag,4)^2*h1)*[1 1],':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,5)*E1bar/(sigma_inf(bflag,5)^2*h1)*[1 1],'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])

 export_fig(['G_d',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%

% G tunnelling
 
l_inf = [22.5, 25];

figure
% axis([0 1 -pi/2*180/pi 0])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $G_{tun}\bar{E}_1/(\sigma_{inf,1}^2 h_1)$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
%set(gca,'YTick',-0.05:.05:0.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;
% 
bflag =2;
plot(l_delam,G_tun(:,bflag,1)*E1bar/(sigma_inf_av(bflag,1)^2*h1),'-k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,2)*E1bar/(sigma_inf_av(bflag,2)^2*h1),'--k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,3)*E1bar/(sigma_inf_av(bflag,3)^2*h1),'-.k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,4)*E1bar/(sigma_inf_av(bflag,4)^2*h1),':k','LineWidth', 2)
plot(l_delam,G_tun(:,bflag,5)*E1bar/(sigma_inf_av(bflag,5)^2*h1),'-k','LineWidth', 2)



% arrows(3.6,7.5,2,-135,[0.2,0.2,0.15,0.015], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(3.9,7.6,'$\bar{E}_2/\bar{E}_1 = 0.1$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% arrows(2.9,4,2,-135,[0.2,0.2,0.15,0.015],'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(3.2,4.2,'$\bar{E}_2/\bar{E}_1 = 0.3$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% arrows(3.7,2.5,2,-135,[0.2,0.2,0.15,0.015],'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(4,2.7,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% %lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
% %'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast');
% 
% arrows(4.7,1.35,1,-135,[0.4,0.4,0.3,0.03], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(5,1.35,'$\bar{E}_2/\bar{E}_1 = 3$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% 
% 
% arrows(12.7,1.25,1,-135,[0.4,0.4,0.3,0.03], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
% tt = text(13,1.35,'$\bar{E}_2/\bar{E}_1 = 10$','Interpreter','latex');
%  % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
% tt.FontSize = 15;
% % Steady state energy

lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northeast', ...
 'FontSize', 15);

%arrows(4.7,1.35,1,-135,[0.4,0.4,0.3,0.03], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
%tt = text(5,1.35,'$\bar{E}_2/\bar{E}_1 = 3$','Interpreter','latex');
 % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
%tt.FontSize = 15;


%arrows(12.7,1.25,1,-135,[0.4,0.4,0.3,0.03], 'EdgeColor',[0.35, 0.35, 0.35],'FaceColor',[0.35, 0.35, 0.35])
%tt = text(13,1.35,'$\bar{E}_2/\bar{E}_1 = 10$','Interpreter','latex');
 % tt = text(12,0.075,'$\bar{E}_2/\bar{E}_1 = 1$','Interpreter','latex');
%tt.FontSize = 15;
% Steady state energy

plot(l_inf,G_ss(bflag,1)*E1bar/(sigma_inf_av(bflag,1)^2*h1)*[1 1],'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,2)*E1bar/(sigma_inf_av(bflag,2)^2*h1)*[1 1],'--k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,3)*E1bar/(sigma_inf_av(bflag,3)^2*h1)*[1 1],'-.k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,4)*E1bar/(sigma_inf_av(bflag,4)^2*h1)*[1 1],':k','LineWidth', 2,'Color', [0.4 0.4 0.4])
plot(l_inf,G_ss(bflag,5)*E1bar/(sigma_inf_av(bflag,5)^2*h1)*[1 1],'-k','LineWidth', 2,'Color', [0.4 0.4 0.4])


 %export_fig(['G_tun',h_Fl],'-jpg','-eps', '-r300', '-transparent')
 %%
 


 %%
 % Mode mixity parameter
 figure
axis([0 1 -90 -30])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$\ell/h_1$';
stry = ' $\Psi_{\bar{\sigma}}$';
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',-90:(15):(-30));
%set(gca,'ZTick',-0.25:.25:.25);
%yticks([-1 -0.8 -0.2 0 0.2 0.8 1])
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;

bflag = 1;
 %title(['Effective stiffness as a function of the coverage'])
  %title(['Effective stiffness as a function of the coverage'])
 plot(l_delam,PSI_c(:,bflag,1),'-k','LineWidth', 2, 'MarkerSize',4 )
 plot(l_delam,PSI_c(:,bflag,2),'--k','LineWidth', 2, 'MarkerSize',4 )
 plot(l_delam,PSI_c(:,bflag,3),'-.k','LineWidth', 2, 'MarkerSize',4 )
 plot(l_delam,PSI_c(:,bflag,4),':k','LineWidth', 2, 'MarkerSize',4 )
 plot(l_delam,PSI_c(:,bflag,5),':k','LineWidth', 3.5, 'MarkerSize',4 )
 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
'FontSize', 15);


 
 export_fig(['Psi_const',h_Fl],'-jpg','-eps', '-r300', '-transparent')

%%
% Failure map graph

figure
axis([0 .6 0.1 0.9])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$G_{{dc}}/G_{{Ic}}$';
stry = ' $\bar{\sigma}_{t,min}\sqrt{h_1/(\bar{E}_1 G_{{Ic}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',.1:.2:.9);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1_plot,sig1_plot*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2)
 plot(Gd2_plot,sig2_plot*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2)
 plot(Gd3_plot,sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2)
 plot(Gd4_plot,sig4_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2)
 plot(Gd5_plot,sig5_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3)
 % Transition Points
 GGG = [Gdc1, Gdc2, Gdc3, Gdc4, Gdc5, G4_list(end),G5_list(end)];
 SIG = [sig1, sig2, sig3, sig4, sig5, sig4_list0(end),sig5_list0(end)];
 for j = 1:7
     SSS(j) = SIG(j)*sqrt(GGG(j))*(E1bar*GIc/h1)^(-0.5);
 end

  plot(GGG,SSS,'o','MarkerFaceColor', 'k', 'MarkerEdgeColor', 'k')

 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(0.025,0.6,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.48,0.83,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.48,0.58,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;

 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
 'FontSize', 15);

%export_fig(['Fail_mech',h_Fl],'-jpg','-eps', '-r300', '-transparent')
%%
 % Failure map graph
bflag =1;
figure
axis([0 .6 1.2 5.2])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$G_{{dc}}/G_{{Ic}}$';
stry = ' ${\Sigma}_{t,min}\sqrt{h_1/(\bar{E}_1 G_{{Ic}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',1.2:1:5.2);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1S_plot,Sig1_plot*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2)
 plot(Gd2S_plot,Sig2_plot*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2)
plot(Gd3S_plot,Sig3_plot*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2)
 plot(Gd4S_plot,Sig4_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2)
 plot(Gd5S_plot,Sig5_plot*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5)

  GGG = [Gd1S_plot(end-1), Gd2S_plot(end-1), Gd3S_plot(end-1), Gd4S_plot(end-1), Gd5S_plot(end-1)];
  SSS = [Sig1_plot(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plot(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plot(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig5_plot(end-1)*(E1bar*GIc/h1)^(-0.5)];
  plot(GGG,SSS,'o','MarkerFaceColor', 'k', 'MarkerEdgeColor', 'k')
% fit_curve = polyfit(GGG,SSS, 4);
 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(0.05,3.7,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.45,4.6,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;



 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'southeast', ...
 'FontSize', 15);

export_fig(['Fail_mech_lin_beta',num2str(bflag),h_Fl],'-jpg','-eps', '-r300', '-transparent')
%%

 % Failure map graph
bflag =4;
figure
axis([0 .6 0.25 1.25])
width = 6;     % Width in inches
height = 5;    % Height in inches
posit = get(gcf, 'Position');
set(gcf, 'Position', [posit(1) posit(2) width*100, height*100]);
set(gca, 'FontSize', 20); %<- Set properties
%title(tit1, 'interpreter','latex');
strx = '$G_{{dc}}/G_{{Ic}}$';
stry = ' ${\Sigma}_{t,min}\sqrt{h_1/(\bar{E}_1 G_{{Ic}})}$';
% subplot(1,2,1);
% subplot(1,2,1);
%axis equal
%axis([0 1 -0.05 0.2])
xlabel(strx, 'interpreter','latex');
ylabel(stry, 'interpreter','latex');
%set(gca,'XTick',0:25:100);
set(gca,'YTick',0.25:.25:1.25);
%set(gca,'ZTick',-0.25:.25:.25);
hold on
box on
grid on
ax = gca;
ax.LineWidth = 1.25;


 %title(['Effective stiffness as a function of the coverage'])
 plot(Gd1S_plot4,Sig1_plot4*(E1bar*GIc/h1)^(-0.5),'-k','LineWidth', 2)
 plot(Gd2S_plot4,Sig2_plot4*(E1bar*GIc/h1)^(-0.5),'--k','LineWidth', 2)
plot(Gd3S_plot4,Sig3_plot4*(E1bar*GIc/h1)^(-0.5),'-.k','LineWidth', 2)
 plot(Gd4S_plot4,Sig4_plot4*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 2)
 plot(Gd5S_plot4,Sig5_plot4*(E1bar*GIc/h1)^(-0.5),':k','LineWidth', 3.5)

  GGG = [Gd1S_plot4(end-1), Gd2S_plot4(end-1), Gd3S_plot4(end-1), Gd4S_plot4(end-1), Gd5S_plot4(end-1)];
  SSS = [Sig1_plot4(end-1)*(E1bar*GIc/h1)^(-0.5),Sig2_plot4(end-1)*(E1bar*GIc/h1)^(-0.5), ...
      Sig3_plot4(end-1)*(E1bar*GIc/h1)^(-0.5),Sig4_plot4(end-1)*(E1bar*GIc/h1)^(-0.5), ...
     Sig5_plot4(end-1)*(E1bar*GIc/h1)^(-0.5)];
  plot(GGG,SSS,'o','MarkerFaceColor', 'k', 'MarkerEdgeColor', 'k')
% fit_curve = polyfit(GGG,SSS, 4);
 
%x1 = linspace(0,0.6);
%y1 = polyval(fit_curve,x1);
% plot(x1,y1,'--k')


%xx = 0:.05:0.6;
%yy = spline(GGG,SSS,xx);

%plot(GGG,SSS,'o',xx,yy)
%C = (GGG(:)'.^(1:4))\SSS(:)';
%xint = linspace(0,0.6,100)';
%plot(GGG',SSS,'o',xint,(xint.^(1:4))*C,'r-')

tt = text(0.39,0.54,['Mech. 1'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.18,0.6,['Mech. 3'],'Interpreter','latex');
tt.FontSize = 17;

 tt = text(0.41,0.825,['Mech. 2'],'Interpreter','latex');
tt.FontSize = 17;


 lgd = legend({'$\bar{E}_2/\bar{E}_1  = 0.1$','$\bar{E}_2/\bar{E}_1  = 0.3$','$\bar{E}_2/\bar{E}_1  = 1$', ...
'$\bar{E}_2/\bar{E}_1  = 3$','$\bar{E}_2/\bar{E}_1  = 10$'},'Interpreter','latex', 'location', 'northwest', ...
 'FontSize', 15);

export_fig(['Fail_mech_lin_beta',num2str(bflag),h_Fl],'-jpg','-eps', '-r300', '-transparent')